/**
 * GUI Commands
 * Copyright 2005 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: DefaultGroupContainerManager.java,v 1.3 2006/02/26 00:59:05 pietschy Exp $
 */
package org.pietschy.command;

import javax.swing.*;
import java.awt.*;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/**
 * Provides a default implementation of {@link GroupContainerManager} that removes all elemnents and rebuilds
 * from scratch.  Before rebulding, the existing buttons are cached so they can be re-used by the new members
 * if possible.
 *
 * @author andrewp
 * @version $Revision: 1.3 $
 */
public class
DefaultGroupContainerManager
extends GroupContainerManager
{
   private static final String _ID_ = "$Id: DefaultGroupContainerManager.java,v 1.3 2006/02/26 00:59:05 pietschy Exp $";

   private WeakSet buttonHistory = new WeakSet();

   public void
   rebuildPopupUsing(Collection members)
   {
      log.enter("rebuildPopupUsing");
      Component[] components = getItemContainer().getComponents();
      for (int i = 0; i < components.length; i++)
      {
         Component comp = components[i];
         if (comp instanceof AbstractButton)
            buttonHistory.add(components[i]);
      }

      List previousButtons = buttonHistory.asList();

      clearContainer();

      int index = 0;
      for (Iterator iterator = members.iterator(); iterator.hasNext();)
      {
         GroupMember member = ((GroupMember) iterator.next());
         member.addComponentTo(getItemContainer(), getFactory(), getFaceId(), previousButtons, index++);
      }

      getItemContainer().invalidate();
      getItemContainer().repaint();
      log.exit("rebuildPopupUsing");
   }

   protected void
   clearContainer()
   {
      getItemContainer().removeAll();
   }
}
