/* $Id: move.c,v 1.4 2005/05/21 20:40:36 cegger Exp $
******************************************************************************

   Graphics library for GGI. WMH stuff.

   Copyright (C) 2004 Peter Ekberg	[peda@lysator.liu.se]
   Copyright (C) 1998 Andreas Beck	[becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "config.h"
#include "quartzwmh.h"
#include <ggi/internal/wmh_debug.h>


int GGIwmh_quartz_move(ggi_visual *vis,int x,int y)
{
	ggi_quartz_priv *priv;                                                   
	priv = QUARTZ_PRIV(vis);

	if (priv->fullscreen)
		return GGI_ENOMATCH;

	/* Use MoveWindowStructure later here to
	 * move the window with x,y include
	 * the window decoration */
	MoveWindow(priv->theWindow, x, y, FALSE);

	return GGI_OK;
}

int GGIwmh_quartz_moveicon(ggi_visual *vis,int x,int y)
{
	return GGI_ENOFUNC;
}
