/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 36 "./parser.y"

#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <libgda/sql-parser/gda-sql-parser-private.h>
#include <libgda/sql-parser/gda-statement-struct-util.h>
#include <libgda/sql-parser/gda-statement-struct-trans.h>
#include <libgda/sql-parser/gda-statement-struct-insert.h>
#include <libgda/sql-parser/gda-statement-struct-update.h>
#include <libgda/sql-parser/gda-statement-struct-delete.h>
#include <libgda/sql-parser/gda-statement-struct-select.h>
#include <libgda/sql-parser/gda-statement-struct-compound.h>
#include <libgda/sql-parser/gda-statement-struct-parts.h>
#include <assert.h>

typedef struct {
	GValue *fname;
	GdaSqlExpr *expr;
} UpdateSet;

typedef struct {
	gboolean    distinct;
	GdaSqlExpr *expr;
} Distinct;

typedef struct {
	GdaSqlExpr *count;
	GdaSqlExpr *offset;
} Limit;

typedef struct {
	GSList *when_list;
	GSList *then_list;
} CaseBody;

static GdaSqlOperatorType
sql_operation_string_to_operator (const gchar *op)
{
	switch (g_ascii_toupper (*op)) {
	case 'A':
		return GDA_SQL_OPERATOR_TYPE_AND;
	case 'O':
		return GDA_SQL_OPERATOR_TYPE_OR;
	case 'N':
		return GDA_SQL_OPERATOR_TYPE_NOT;
	case '=':
		return GDA_SQL_OPERATOR_TYPE_EQ;
	case 'I':
		if (op[1] == 'S')
			return GDA_SQL_OPERATOR_TYPE_IS;
		else if (op[1] == 'N')
			return GDA_SQL_OPERATOR_TYPE_IN;
		break;
	case 'L':
		return GDA_SQL_OPERATOR_TYPE_LIKE;
	case 'B':
		return GDA_SQL_OPERATOR_TYPE_BETWEEN;
	case '>':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_TYPE_GEQ;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_TYPE_GT;
		break;
	case '<':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_TYPE_LEQ;
		else if (op[1] == '>')
			return GDA_SQL_OPERATOR_TYPE_DIFF;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_TYPE_LT;
		break;
	case '!':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_TYPE_DIFF;
		else if (op[1] == '~') {
			if (op[2] == 0)
				return GDA_SQL_OPERATOR_TYPE_NOT_REGEXP;
			else if (op[2] == '*')
				return GDA_SQL_OPERATOR_TYPE_NOT_REGEXP_CI;
		}
		break;
	case '~':
		if (op[1] == '*')
			return GDA_SQL_OPERATOR_TYPE_REGEXP_CI;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_TYPE_REGEXP;
		break;
	case 'S':
		return GDA_SQL_OPERATOR_TYPE_SIMILAR;
	case '|':
		if (op[1] == '|')
			return GDA_SQL_OPERATOR_TYPE_CONCAT;
		else
			return GDA_SQL_OPERATOR_TYPE_BITOR;
	case '+':
		return GDA_SQL_OPERATOR_TYPE_PLUS;
	case '-':
		return GDA_SQL_OPERATOR_TYPE_MINUS;
	case '*':
		return GDA_SQL_OPERATOR_TYPE_STAR;
	case '/':
		return GDA_SQL_OPERATOR_TYPE_DIV;
	case '%':
		return GDA_SQL_OPERATOR_TYPE_REM;
	case '&':
		return GDA_SQL_OPERATOR_TYPE_BITAND;
	}
	g_error ("Unhandled operator named '%s'\n", op);
	return 0;
}

static GdaSqlOperatorType
string_to_op_type (GValue *value)
{
	GdaSqlOperatorType op;
	op = sql_operation_string_to_operator (g_value_get_string (value));
	g_value_reset (value);
	g_free (value);
	return op;
}

static GdaSqlExpr *
compose_multiple_expr (GdaSqlOperatorType op, GdaSqlExpr *left, GdaSqlExpr *right) {
	GdaSqlExpr *ret;
	if (left->cond && (left->cond->operator_type == op)) {
		ret = left;
		ret->cond->operands = g_slist_append (ret->cond->operands, right);
	}
	else {
		GdaSqlOperation *cond;
		ret = gda_sql_expr_new (NULL);
		cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
		ret->cond = cond;
		cond->operator_type = op;
		cond->operands = g_slist_prepend (NULL, right);
		GDA_SQL_ANY_PART (right)->parent = GDA_SQL_ANY_PART (cond);
		cond->operands = g_slist_prepend (cond->operands, left);
		GDA_SQL_ANY_PART (left)->parent = GDA_SQL_ANY_PART (cond);
	}
	return ret;
}

static GdaSqlExpr *
create_two_expr (GdaSqlOperatorType op, GdaSqlExpr *left, GdaSqlExpr *right) {
	GdaSqlExpr *ret;
	GdaSqlOperation *cond;
	ret = gda_sql_expr_new (NULL);
	cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
	ret->cond = cond;
	cond->operator_type = op;
	cond->operands = g_slist_prepend (NULL, right);
	GDA_SQL_ANY_PART (right)->parent = GDA_SQL_ANY_PART (cond);
	cond->operands = g_slist_prepend (cond->operands, left);
	GDA_SQL_ANY_PART (left)->parent = GDA_SQL_ANY_PART (cond);
	return ret;
}

static GdaSqlExpr *
create_uni_expr (GdaSqlOperatorType op, GdaSqlExpr *expr) {
	GdaSqlExpr *ret;
	GdaSqlOperation *cond;
	ret = gda_sql_expr_new (NULL);
	cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
	ret->cond = cond;
	cond->operator_type = op;
	cond->operands = g_slist_prepend (NULL, expr);
	GDA_SQL_ANY_PART (expr)->parent = GDA_SQL_ANY_PART (cond);
	return ret;
}

static GdaSqlStatement *
compose_multiple_compounds (GdaSqlStatementCompoundType ctype, GdaSqlStatement *left, GdaSqlStatement *right) {
	GdaSqlStatement *ret;
	GdaSqlStatementCompound *lc = (GdaSqlStatementCompound*) left->contents;
	if (lc->compound_type == ctype) {
		GdaSqlStatementCompound *rc = (GdaSqlStatementCompound*) right->contents;
		if (!rc->stmt_list->next || rc->compound_type == ctype) {
			GSList *list;
			for (list = rc->stmt_list; list; list = list->next)
				GDA_SQL_ANY_PART (((GdaSqlStatement*)list->data)->contents)->parent = GDA_SQL_ANY_PART (lc);

			ret = left;
			lc->stmt_list = g_slist_concat (lc->stmt_list, rc->stmt_list);
			rc->stmt_list = NULL;
			gda_sql_statement_free (right);
		}
	}
	else {
		ret = gda_sql_statement_new (GDA_SQL_STATEMENT_COMPOUND);
		gda_sql_statement_compound_set_type (ret, ctype);
		gda_sql_statement_compound_take_stmt (ret, left);
		gda_sql_statement_compound_take_stmt (ret, right);
	}
	return ret;
}

#line 207 "parser.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    gda_sql_parserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is gda_sql_parserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    gda_sql_parserARG_SDECL     A static variable declaration for the %extra_argument
**    gda_sql_parserARG_PDECL     A parameter declaration for the %extra_argument
**    gda_sql_parserARG_STORE     Code to store %extra_argument into yypParser
**    gda_sql_parserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 208
#define YYACTIONTYPE unsigned short int
#define gda_sql_parserTOKENTYPE GValue *
typedef union {
  gda_sql_parserTOKENTYPE yy0;
  Limit yy20;
  GdaSqlSelectFrom * yy59;
  GdaSqlExpr* yy122;
  Distinct * yy189;
  gboolean yy216;
  GdaSqlSelectTarget * yy224;
  GSList * yy247;
  CaseBody yy263;
  GdaTransactionIsolation yy307;
  GdaSqlStatement * yy308;
  GdaSqlSelectJoinType yy317;
  GdaSqlExpr * yy328;
  GValue * yy361;
  GdaSqlOperatorType yy381;
  GSList* yy393;
  GdaSqlParamSpec * yy405;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define gda_sql_parserARG_SDECL GdaSqlParserIface *pdata;
#define gda_sql_parserARG_PDECL ,GdaSqlParserIface *pdata
#define gda_sql_parserARG_FETCH GdaSqlParserIface *pdata = yypParser->pdata
#define gda_sql_parserARG_STORE yypParser->pdata = pdata
#define YYNSTATE 359
#define YYNRULE 195
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   285,   63,   15,   15,   16,   18,   18,   23,  182,  286,
 /*    10 */   160,   28,   24,   24,   24,   24,   27,   27,   27,   27,
 /*    20 */    27,   26,   20,   20,   65,  246,   15,   15,   16,   18,
 /*    30 */    18,   23,  266,  290,  219,  220,  187,  188,  189,  218,
 /*    40 */   309,   54,  162,  288,  142,  143,  144,   82,   65,  289,
 /*    50 */   243,  244,  131,  127,  201,  336,  204,  201,  195,  249,
 /*    60 */   346,  329,   92,   22,   21,  184,   13,  209,  269,  284,
 /*    70 */    25,   25,   28,   24,   24,   24,   24,   27,   27,   27,
 /*    80 */    27,   27,  266,   20,   20,  203,  254,   15,   15,   16,
 /*    90 */    18,   18,   23,   26,   77,   52,  201,  305,  306,   42,
 /*   100 */    27,   27,   27,   27,   27,  287,   20,   20,  395,   65,
 /*   110 */    15,   15,   16,   18,   18,   23,  163,  331,  266,  239,
 /*   120 */   159,  312,  167,  329,  134,  134,  201,  307,  204,  201,
 /*   130 */   196,  208,   65,  225,   92,   22,   21,  184,   13,  209,
 /*   140 */   269,  200,   25,   25,   28,   24,   24,   24,   24,   27,
 /*   150 */    27,   27,   27,   27,  206,   20,   20,  203,  254,   15,
 /*   160 */    15,   16,   18,   18,   23,   26,   27,  253,   20,   20,
 /*   170 */    55,  124,   15,   15,   16,   18,   18,   23,  323,  555,
 /*   180 */   133,   65,  118,   16,   18,   18,   23,   43,  255,  135,
 /*   190 */   256,  257,  258,  259,   65,  316,  140,  122,  201,  246,
 /*   200 */   204,  329,  197,   65,  123,    6,   92,   22,   21,  184,
 /*   210 */    13,  209,  269,  251,   25,   25,   28,   24,   24,   24,
 /*   220 */    24,   27,   27,   27,   27,   27,  314,   20,   20,  203,
 /*   230 */   254,   15,   15,   16,   18,   18,   23,  226,   53,  172,
 /*   240 */   201,   26,  139,  246,   24,   24,   24,   24,   27,   27,
 /*   250 */    27,   27,   27,   65,   20,   20,  246,  317,   15,   15,
 /*   260 */    16,   18,   18,   23,  155,  318,  201,  125,  303,  180,
 /*   270 */   320,  310,  190,  232,  229,  319,  266,  201,  252,  301,
 /*   280 */    65,   53,  333,   22,   21,  184,   13,  209,  269,  348,
 /*   290 */    25,   25,   28,   24,   24,   24,   24,   27,   27,   27,
 /*   300 */    27,   27,  352,   20,   20,  191,  370,   15,   15,   16,
 /*   310 */    18,   18,   23,   26,  202,  175,  250,  205,  260,  204,
 /*   320 */   370,  370,  205,  323,  204,   62,  183,  369,  349,   65,
 /*   330 */    92,   70,  246,  201,  275,  164,  256,  257,  258,  259,
 /*   340 */   347,  369,  369,  201,  323,  166,  329,  311,  203,  254,
 /*   350 */   251,  251,  213,  203,  254,   22,   21,  184,   13,  209,
 /*   360 */   269,  172,   25,   25,   28,   24,   24,   24,   24,   27,
 /*   370 */    27,   27,   27,   27,  350,   20,   20,  351,  246,   15,
 /*   380 */    15,   16,   18,   18,   23,  176,  210,  247,  177,   26,
 /*   390 */   199,  201,  201,  240,  204,  201,  185,  204,  245,  186,
 /*   400 */    92,   65,  246,   92,  246,  246,  142,  143,  144,  130,
 /*   410 */   174,  201,  201,  303,  242,  252,  252,  198,  142,  143,
 /*   420 */   144,  141,  330,  203,  254,  212,  203,  254,  329,   66,
 /*   430 */    30,   22,   21,  184,   13,  209,  269,   81,   25,   25,
 /*   440 */    28,   24,   24,   24,   24,   27,   27,   27,   27,   27,
 /*   450 */   193,   20,   20,  250,  250,   15,   15,   16,   18,   18,
 /*   460 */    23,   26,  334,  178,   36,  201,   38,  204,  329,  251,
 /*   470 */   201,  126,  204,   93,  362,  337,  145,   65,   84,  261,
 /*   480 */   246,  329,  362,  362,  362,  267,  304,  142,  143,  144,
 /*   490 */   344,  345,  194,  142,  143,  144,  203,  254,  158,  150,
 /*   500 */   358,  203,  254,   22,   21,  184,   13,  209,  269,   37,
 /*   510 */    25,   25,   28,   24,   24,   24,   24,   27,   27,   27,
 /*   520 */    27,   27,  313,   20,   20,   76,  248,   15,   15,   16,
 /*   530 */    18,   18,   23,   26,  252,  173,  201,  201,  241,  204,
 /*   540 */    23,  179,  201,  246,  204,   61,  116,   56,   14,   65,
 /*   550 */    84,  278,  246,  243,  244,  282,  215,   65,  246,  142,
 /*   560 */   143,  144,  294,  142,  143,  144,  251,   78,  203,  254,
 /*   570 */    80,  296,  250,  203,  254,   22,   21,  184,   13,  209,
 /*   580 */   269,   40,   25,   25,   28,   24,   24,   24,   24,   27,
 /*   590 */    27,   27,   27,   27,   79,   20,   20,  298,  221,   15,
 /*   600 */    15,   16,   18,   18,   23,   26,  201,  222,  204,  201,
 /*   610 */   151,  204,   77,   65,  101,   75,  157,  112,  325,  192,
 /*   620 */    39,   65,  228,   14,  142,  143,  144,  217,  142,  143,
 /*   630 */   144,  252,  136,  223,  216,  234,  280,  203,  254,  251,
 /*   640 */   203,  254,  134,  321,  322,  327,  328,   22,   29,  184,
 /*   650 */    13,  209,  269,   17,   25,   25,   28,   24,   24,   24,
 /*   660 */    24,   27,   27,   27,   27,   27,  152,   20,   20,  250,
 /*   670 */   268,   15,   15,   16,   18,   18,   23,   26,  201,  279,
 /*   680 */   204,  201,   45,  204,  302,  153,   88,   17,  395,  119,
 /*   690 */   340,  341,  214,   65,  342,  343,   17,  165,  283,  353,
 /*   700 */   354,   67,  154,   41,  252,   53,  227,   47,  355,  203,
 /*   710 */   254,  251,  203,  254,   17,  156,   17,   17,  224,   22,
 /*   720 */    31,  184,   13,  209,  269,   67,   25,   25,   28,   24,
 /*   730 */    24,   24,   24,   27,   27,   27,   27,   27,  300,   20,
 /*   740 */    20,  308,  250,   15,   15,   16,   18,   18,   23,   26,
 /*   750 */   318,  201,  324,  204,  201,  320,  204,   68,  323,  138,
 /*   760 */   319,  335,   89,  332,  180,   65,   69,  238,  339,  132,
 /*   770 */    64,  233,   58,  359,   72,  237,  252,   74,  235,  170,
 /*   780 */   171,  360,  203,  254,  357,  203,  254,  227,  128,  129,
 /*   790 */   191,  168,   21,  184,   13,  209,  269,  251,   25,   25,
 /*   800 */    28,   24,   24,   24,   24,   27,   27,   27,   27,   27,
 /*   810 */     1,   20,   20,  120,  250,   15,   15,   16,   18,   18,
 /*   820 */    23,   26,  201,  121,  204,  265,  201,   19,  204,    2,
 /*   830 */   137,  270,  169,    3,   85,  281,    8,   65,   44,  251,
 /*   840 */     9,   46,  291,  292,  293,  295,  297,  299,  207,   57,
 /*   850 */    48,  315,  181,  203,  254,  326,   51,  203,  254,  230,
 /*   860 */   161,   10,  252,  272,  231,  184,   13,  209,  269,   71,
 /*   870 */    25,   25,   28,   24,   24,   24,   24,   27,   27,   27,
 /*   880 */    27,   27,  338,   20,   20,  236,  251,   15,   15,   16,
 /*   890 */    18,   18,   23,  201,  356,  204,   11,   73,   59,   12,
 /*   900 */   250,  117,   49,   50,  252,  272,  251,  556,   34,   65,
 /*   910 */   556,  251,  556,  556,  556,  207,  556,  273,  201,  556,
 /*   920 */   204,  556,  556,  318,  203,  254,  107,  556,  320,  556,
 /*   930 */    33,   32,  262,  319,  556,  201,  556,  204,  556,   35,
 /*   940 */     5,  556,  250,  106,  271,  274,  556,  556,  556,  203,
 /*   950 */   254,  252,  556,  201,  556,  204,  556,  556,  556,  273,
 /*   960 */   227,  146,  556,  191,  556,  556,  203,  254,  556,  556,
 /*   970 */   134,  252,  272,  556,  251,   34,  252,  556,  556,  263,
 /*   980 */   556,  556,    7,  207,  203,  254,  271,  274,  211,  250,
 /*   990 */   556,  276,  201,  556,  204,  556,  556,   33,   32,  556,
 /*  1000 */   114,  556,  556,  556,  556,  556,   35,    5,  556,  250,
 /*  1010 */   556,  556,  556,  556,  250,  556,  556,  556,  556,  556,
 /*  1020 */   556,  556,  556,  203,  254,  556,  273,  556,  201,  556,
 /*  1030 */   204,  556,  556,  556,  556,  556,  110,  134,  556,  252,
 /*  1040 */   272,  251,  556,   34,  556,  556,  556,  556,  556,    7,
 /*  1050 */   207,  556,  556,  271,  274,  211,  556,  556,  276,  203,
 /*  1060 */   254,  201,  251,  204,  556,   33,   32,  262,  556,  111,
 /*  1070 */   201,  556,  204,  556,   35,    4,  556,  250,  115,  556,
 /*  1080 */   556,  201,  556,  204,  556,  556,  556,  556,  201,   90,
 /*  1090 */   204,  556,  203,  254,  273,  556,  113,  556,  556,  556,
 /*  1100 */   556,  203,  254,  201,  556,  204,  252,  272,  556,  251,
 /*  1110 */    34,   91,  203,  254,  277,  556,  556,    7,  207,  203,
 /*  1120 */   254,  271,  274,  211,  556,  556,  276,  252,  556,  556,
 /*  1130 */   556,  556,   33,   32,  203,  254,  556,  201,  556,  204,
 /*  1140 */   556,   35,    4,  556,  250,  108,  556,  556,  556,  556,
 /*  1150 */   556,  556,  556,  556,  201,  264,  204,  556,  556,  556,
 /*  1160 */   556,  273,  147,  556,  201,  250,  204,  556,  203,  254,
 /*  1170 */   556,  556,  148,  556,  252,  272,  556,  556,   34,  556,
 /*  1180 */   556,  556,  556,  556,    7,  203,  254,  556,  271,  274,
 /*  1190 */   211,  556,  556,  276,  556,  203,  254,  556,  556,  556,
 /*  1200 */    33,   32,  556,  556,  556,  556,  201,  556,  204,   35,
 /*  1210 */     4,  201,  250,  204,  109,  556,  556,  556,  556,  149,
 /*  1220 */   556,  556,  556,  201,  556,  204,  556,  556,  201,  273,
 /*  1230 */   204,   86,  556,  201,  556,  204,   94,  203,  254,  556,
 /*  1240 */   556,   95,  203,  254,  556,  201,  556,  204,  556,  556,
 /*  1250 */   556,  556,    7,   87,  203,  254,  271,  274,  211,  203,
 /*  1260 */   254,  276,  556,  556,  203,  254,  201,  556,  204,  556,
 /*  1270 */   556,  201,  556,  204,   96,  556,  203,  254,  556,   83,
 /*  1280 */   201,  556,  204,  201,  556,  204,  556,  201,   97,  204,
 /*  1290 */   556,   98,  201,  556,  204,   60,  556,  203,  254,  556,
 /*  1300 */    99,  556,  203,  254,  556,  201,  556,  204,  556,  556,
 /*  1310 */   556,  203,  254,  100,  203,  254,  556,  556,  203,  254,
 /*  1320 */   556,  556,  556,  203,  254,  556,  201,  556,  204,  556,
 /*  1330 */   556,  201,  556,  204,  102,  556,  203,  254,  201,  103,
 /*  1340 */   204,  556,  201,  556,  204,  556,  104,  556,  556,  556,
 /*  1350 */   105,  556,  556,  556,  556,  556,  556,  203,  254,  556,
 /*  1360 */   556,  556,  203,  254,  556,  556,  556,  556,  556,  203,
 /*  1370 */   254,  556,  556,  203,  254,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     5,    8,   92,   93,   94,   95,   96,   97,  162,   14,
 /*    10 */    17,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*    20 */    86,   26,   88,   89,  114,  179,   92,   93,   94,   95,
 /*    30 */    96,   97,  202,  104,  105,  106,  107,  108,  109,  110,
 /*    40 */   120,   48,   49,  196,  111,  112,  113,  127,  114,  120,
 /*    50 */   117,  118,   59,   60,  169,  163,  171,  169,  173,  171,
 /*    60 */   168,  169,  177,   68,   69,   70,   71,   72,   73,  189,
 /*    70 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*    80 */    85,   86,  202,   88,   89,  200,  201,   92,   93,   94,
 /*    90 */    95,   96,   97,   26,  102,  102,  169,    1,  171,   32,
 /*   100 */    82,   83,   84,   85,   86,  189,   88,   89,   50,  114,
 /*   110 */    92,   93,   94,   95,   96,   97,  123,  163,  202,  126,
 /*   120 */   166,  131,  129,  169,  132,  132,  169,  200,  171,  169,
 /*   130 */   173,  171,  114,  143,  177,   68,   69,   70,   71,   72,
 /*   140 */    73,  161,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   150 */    83,   84,   85,   86,  169,   88,   89,  200,  201,   92,
 /*   160 */    93,   94,   95,   96,   97,   26,   86,  169,   88,   89,
 /*   170 */   164,  165,   92,   93,   94,   95,   96,   97,  120,  159,
 /*   180 */   160,  114,  162,   94,   95,   96,   97,  120,  152,  182,
 /*   190 */   154,  155,  156,  157,  114,  163,  164,  165,  169,  179,
 /*   200 */   171,  169,  173,  114,  166,  198,  177,   68,   69,   70,
 /*   210 */    71,   72,   73,    1,   75,   76,   77,   78,   79,   80,
 /*   220 */    81,   82,   83,   84,   85,   86,  162,   88,   89,  200,
 /*   230 */   201,   92,   93,   94,   95,   96,   97,  160,  142,  162,
 /*   240 */   169,   26,  171,  179,   78,   79,   80,   81,   82,   83,
 /*   250 */    84,   85,   86,  114,   88,   89,  179,  164,   92,   93,
 /*   260 */    94,   95,   96,   97,  193,   13,  169,  166,  171,   57,
 /*   270 */    18,  197,  175,   61,   62,   23,  202,  169,   66,  171,
 /*   280 */   114,  142,  164,   68,   69,   70,   71,   72,   73,  169,
 /*   290 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   300 */    85,   86,  169,   88,   89,   53,  103,   92,   93,   94,
 /*   310 */    95,   96,   97,   26,  169,  162,  104,  169,  103,  171,
 /*   320 */   117,  118,  169,  120,  171,  177,  173,  103,  169,  114,
 /*   330 */   177,  119,  179,  169,  152,  171,  154,  155,  156,  157,
 /*   340 */   163,  117,  118,  169,  120,  171,  169,  199,  200,  201,
 /*   350 */     1,    1,  199,  200,  201,   68,   69,   70,   71,   72,
 /*   360 */    73,  162,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   370 */    83,   84,   85,   86,  169,   88,   89,  169,  179,   92,
 /*   380 */    93,   94,   95,   96,   97,  162,  205,  162,  162,   26,
 /*   390 */   161,  169,  169,  171,  171,  169,  173,  171,  103,  173,
 /*   400 */   177,  114,  179,  177,  179,  179,  111,  112,  113,   59,
 /*   410 */   103,  169,  169,  171,  171,   66,   66,  175,  111,  112,
 /*   420 */   113,  178,  163,  200,  201,   72,  200,  201,  169,  142,
 /*   430 */    77,   68,   69,   70,   71,   72,   73,  181,   75,   76,
 /*   440 */    77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   450 */    23,   88,   89,  104,  104,   92,   93,   94,   95,   96,
 /*   460 */    97,   26,  163,  162,  145,  169,  147,  171,  169,    1,
 /*   470 */   169,  122,  171,  177,  103,  163,  183,  114,  177,  103,
 /*   480 */   179,  169,  111,  112,  113,  103,  197,  111,  112,  113,
 /*   490 */    63,   64,   65,  111,  112,  113,  200,  201,  166,  203,
 /*   500 */   176,  200,  201,   68,   69,   70,   71,   72,   73,  146,
 /*   510 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   520 */    85,   86,  131,   88,   89,  180,  162,   92,   93,   94,
 /*   530 */    95,   96,   97,   26,   66,  162,  169,  169,  171,  171,
 /*   540 */    97,  162,  169,  179,  171,  177,  191,  192,  128,  114,
 /*   550 */   177,  103,  179,  117,  118,  103,  188,  114,  179,  111,
 /*   560 */   112,  113,  104,  111,  112,  113,    1,  180,  200,  201,
 /*   570 */   102,  104,  104,  200,  201,   68,   69,   70,   71,   72,
 /*   580 */    73,  146,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   590 */    83,   84,   85,   86,  180,   88,   89,  104,  140,   92,
 /*   600 */    93,   94,   95,   96,   97,   26,  169,  140,  171,  169,
 /*   610 */   176,  171,  102,  114,  177,  120,  103,  177,   52,   53,
 /*   620 */   145,  114,   56,  128,  111,  112,  113,  190,  111,  112,
 /*   630 */   113,   66,  204,  140,  137,  125,  103,  200,  201,    1,
 /*   640 */   200,  201,  132,   57,   58,   54,   55,   68,   69,   70,
 /*   650 */    71,   72,   73,  120,   75,   76,   77,   78,   79,   80,
 /*   660 */    81,   82,   83,   84,   85,   86,  184,   88,   89,  104,
 /*   670 */   103,   92,   93,   94,   95,   96,   97,   26,  169,  103,
 /*   680 */   171,  169,  136,  171,  103,  185,  177,  120,   50,  177,
 /*   690 */    63,   64,  134,  114,   63,   64,  120,  103,  187,  103,
 /*   700 */   103,  120,  186,  133,   66,  142,   50,  139,  103,  200,
 /*   710 */   201,    1,  200,  201,  120,  194,  120,  120,  138,   68,
 /*   720 */    69,   70,   71,   72,   73,  120,   75,   76,   77,   78,
 /*   730 */    79,   80,   81,   82,   83,   84,   85,   86,  195,   88,
 /*   740 */    89,  197,  104,   92,   93,   94,   95,   96,   97,   26,
 /*   750 */    13,  169,  165,  171,  169,   18,  171,  119,  120,  177,
 /*   760 */    23,  119,  177,  165,   57,  114,  167,   68,  168,   59,
 /*   770 */   167,  170,  102,    0,  172,  120,   66,  170,  174,  206,
 /*   780 */   206,    0,  200,  201,  176,  200,  201,   50,  141,  141,
 /*   790 */    53,  151,   69,   70,   71,   72,   73,    1,   75,   76,
 /*   800 */    77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   810 */   102,   88,   89,  141,  104,   92,   93,   94,   95,   96,
 /*   820 */    97,   26,  169,  141,  171,  103,  169,  102,  171,  102,
 /*   830 */   177,   17,  151,  102,  177,  103,  135,  114,  120,    1,
 /*   840 */   135,  120,  104,  104,  104,  104,  104,  104,   10,  102,
 /*   850 */   139,  103,   51,  200,  201,   53,  119,  200,  201,   67,
 /*   860 */    67,  102,   66,   67,  120,   70,   71,   72,   73,  124,
 /*   870 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   880 */    85,   86,  121,   88,   89,  120,    1,   92,   93,   94,
 /*   890 */    95,   96,   97,  169,    1,  171,  102,  127,  130,  102,
 /*   900 */   104,  177,   76,   76,   66,   67,    1,  207,   70,  114,
 /*   910 */   207,    1,  207,  207,  207,   10,  207,  121,  169,  207,
 /*   920 */   171,  207,  207,   13,  200,  201,  177,  207,   18,  207,
 /*   930 */    92,   93,   94,   23,  207,  169,  207,  171,  207,  101,
 /*   940 */   102,  207,  104,  177,  148,  149,  207,  207,  207,  200,
 /*   950 */   201,   66,  207,  169,  207,  171,  207,  207,  207,  121,
 /*   960 */    50,  177,  207,   53,  207,  207,  200,  201,  207,  207,
 /*   970 */   132,   66,   67,  207,    1,   70,   66,  207,  207,   94,
 /*   980 */   207,  207,  144,   10,  200,  201,  148,  149,  150,  104,
 /*   990 */   207,  153,  169,  207,  171,  207,  207,   92,   93,  207,
 /*  1000 */   177,  207,  207,  207,  207,  207,  101,  102,  207,  104,
 /*  1010 */   207,  207,  207,  207,  104,  207,  207,  207,  207,  207,
 /*  1020 */   207,  207,  207,  200,  201,  207,  121,  207,  169,  207,
 /*  1030 */   171,  207,  207,  207,  207,  207,  177,  132,  207,   66,
 /*  1040 */    67,    1,  207,   70,  207,  207,  207,  207,  207,  144,
 /*  1050 */    10,  207,  207,  148,  149,  150,  207,  207,  153,  200,
 /*  1060 */   201,  169,    1,  171,  207,   92,   93,   94,  207,  177,
 /*  1070 */   169,  207,  171,  207,  101,  102,  207,  104,  177,  207,
 /*  1080 */   207,  169,  207,  171,  207,  207,  207,  207,  169,  177,
 /*  1090 */   171,  207,  200,  201,  121,  207,  177,  207,  207,  207,
 /*  1100 */   207,  200,  201,  169,  207,  171,   66,   67,  207,    1,
 /*  1110 */    70,  177,  200,  201,   74,  207,  207,  144,   10,  200,
 /*  1120 */   201,  148,  149,  150,  207,  207,  153,   66,  207,  207,
 /*  1130 */   207,  207,   92,   93,  200,  201,  207,  169,  207,  171,
 /*  1140 */   207,  101,  102,  207,  104,  177,  207,  207,  207,  207,
 /*  1150 */   207,  207,  207,  207,  169,   94,  171,  207,  207,  207,
 /*  1160 */   207,  121,  177,  207,  169,  104,  171,  207,  200,  201,
 /*  1170 */   207,  207,  177,  207,   66,   67,  207,  207,   70,  207,
 /*  1180 */   207,  207,  207,  207,  144,  200,  201,  207,  148,  149,
 /*  1190 */   150,  207,  207,  153,  207,  200,  201,  207,  207,  207,
 /*  1200 */    92,   93,  207,  207,  207,  207,  169,  207,  171,  101,
 /*  1210 */   102,  169,  104,  171,  177,  207,  207,  207,  207,  177,
 /*  1220 */   207,  207,  207,  169,  207,  171,  207,  207,  169,  121,
 /*  1230 */   171,  177,  207,  169,  207,  171,  177,  200,  201,  207,
 /*  1240 */   207,  177,  200,  201,  207,  169,  207,  171,  207,  207,
 /*  1250 */   207,  207,  144,  177,  200,  201,  148,  149,  150,  200,
 /*  1260 */   201,  153,  207,  207,  200,  201,  169,  207,  171,  207,
 /*  1270 */   207,  169,  207,  171,  177,  207,  200,  201,  207,  177,
 /*  1280 */   169,  207,  171,  169,  207,  171,  207,  169,  177,  171,
 /*  1290 */   207,  177,  169,  207,  171,  177,  207,  200,  201,  207,
 /*  1300 */   177,  207,  200,  201,  207,  169,  207,  171,  207,  207,
 /*  1310 */   207,  200,  201,  177,  200,  201,  207,  207,  200,  201,
 /*  1320 */   207,  207,  207,  200,  201,  207,  169,  207,  171,  207,
 /*  1330 */   207,  169,  207,  171,  177,  207,  200,  201,  169,  177,
 /*  1340 */   171,  207,  169,  207,  171,  207,  177,  207,  207,  207,
 /*  1350 */   177,  207,  207,  207,  207,  207,  207,  200,  201,  207,
 /*  1360 */   207,  207,  200,  201,  207,  207,  207,  207,  207,  200,
 /*  1370 */   201,  207,  207,  200,  201,
};
#define YY_SHIFT_USE_DFLT (-91)
#define YY_SHIFT_MAX 242
static const short yy_shift_ofst[] = {
 /*     0 */    -7,  838,  905,  905,  905,  905,  973, 1108, 1108, 1108,
 /*    10 */  1108, 1108, 1108, 1040, 1108, 1108, 1108, 1108, 1108, 1108,
 /*    20 */  1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108,
 /*    30 */  1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108,
 /*    40 */  1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108,
 /*    50 */  1108,  910,   -7,  796,  212,  638,  468,  565,  565,  565,
 /*    60 */    -5,   -5,  139,  737,  349,  565,  565,  565,  565,  565,
 /*    70 */   565,  565,  510,  565,  565,  565,   -8,   -8,   -8,   -8,
 /*    80 */    -8,  -91,  -91,   67,  215,  287,  363,  435,  507,  507,
 /*    90 */   579,  651,  507,  507,  507,  507,  507,  507,  507,  507,
 /*   100 */   507,  507,  507,  507,  507,  507,  723,  795,  795,  795,
 /*   110 */   -66,  -66,  -66,  166,   18,   80,  -71,  -90,  -67,   89,
 /*   120 */   885, 1061,  203,  252,  224,  252,  350,  710,  565,  565,
 /*   130 */   565,  565,  565,  436,  -10,  -80,  319,  443,  443,   96,
 /*   140 */    58,  495,  391,  391,  391,  420,  499,  499,  499,  499,
 /*   150 */   475,  497,  546,  558,  570,  568,  580,  563,  656,  656,
 /*   160 */   642,  707,  642,  699,  670,  655,  420,  699,  -91,  -91,
 /*   170 */    36,  182,  295,  307,  371,  376,  382,  448,  452,  513,
 /*   180 */   427,  566,  517,  533,  353,  567,  576,  458,  467,  493,
 /*   190 */   581,  586,  591,  627,  631,  594,  596,  597,  605,  773,
 /*   200 */   781,  647,  648,  640,  708,  672,  682,  725,  722,  727,
 /*   210 */   814,  681,  731,  732,  701,  718,  705,  721,  738,  739,
 /*   220 */   740,  741,  742,  743,  747,  711,  748,  801,  802,  792,
 /*   230 */   744,  761,  793,  745,  759,  765,  794,  797,  893,  770,
 /*   240 */   768,  826,  827,
};
#define YY_REDUCE_USE_DFLT (-171)
#define YY_REDUCE_MAX 169
static const short yy_reduce_ofst[] = {
 /*     0 */    20,  153,  223,  226,  301,  373,  148,  296,  368,  437,
 /*    10 */  -115,  -43,   29,  440,  509,  512,  582,  585,  653,  657,
 /*    20 */   724,  749,  766,  784,  823,  859,  892,  901,  912,  919,
 /*    30 */   934,  968,  985,  995, 1037, 1042, 1054, 1059, 1064, 1076,
 /*    40 */  1097, 1102, 1111, 1114, 1118, 1123, 1136, 1157, 1162, 1169,
 /*    50 */  1173,   32,   77,  -73, -108,  -46,   71,   97,  242,  243,
 /*    60 */  -120,  -84,   74,    6,  177, -112,  -40,  108,  259,  299,
 /*    70 */   312,  164, -154,  174,  222,  367,   64,  199,  225,  364,
 /*    80 */   379,    7,  355, -170, -170, -170, -170, -170, -170, -170,
 /*    90 */  -170, -170, -170, -170, -170, -170, -170, -170, -170, -170,
 /*   100 */  -170, -170, -170, -170, -170, -170, -170, -170, -170, -170,
 /*   110 */  -170, -170, -170, -170, -170, -170, -153, -170,  -20, -170,
 /*   120 */   -15,   -2,   38,   93,  101,  118,  120,  133,  145,   -2,
 /*   130 */   159,  205,  208,  229,  256,  293,  181, -170, -170,  289,
 /*   140 */   332,  324,  345,  387,  414,  434, -170, -170, -170, -170,
 /*   150 */   428,  482,  500,  516,  511,  521,  543,  544,  587,  598,
 /*   160 */   599,  600,  603,  601,  602,  604,  608,  607,  573,  574,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   554,  491,  491,  491,  554,  554,  554,  529,  554,  554,
 /*    10 */   491,  491,  491,  554,  554,  554,  554,  554,  554,  554,
 /*    20 */   554,  554,  554,  554,  554,  554,  554,  554,  554,  554,
 /*    30 */   554,  554,  554,  554,  554,  554,  554,  554,  554,  554,
 /*    40 */   554,  554,  554,  554,  554,  554,  554,  554,  554,  554,
 /*    50 */   554,  401,  554,  554,  401,  401,  554,  554,  554,  554,
 /*    60 */   447,  447,  484,  365,  401,  554,  554,  554,  401,  401,
 /*    70 */   401,  554,  554,  554,  554,  554,  554,  554,  554,  554,
 /*    80 */   554,  476,  457,  438,  554,  554,  554,  554,  426,  492,
 /*    90 */   554,  554,  493,  528,  530,  532,  531,  439,  440,  449,
 /*   100 */   489,  490,  459,  488,  428,  429,  510,  509,  517,  518,
 /*   110 */   513,  514,  521,  516,  512,  515,  453,  506,  554,  503,
 /*   120 */   554,  554,  395,  554,  395,  554,  554,  554,  554,  554,
 /*   130 */   554,  554,  554,  554,  485,  452,  533,  505,  504,  484,
 /*   140 */   371,  425,  434,  434,  434,  425,  511,  507,  508,  519,
 /*   150 */   554,  450,  448,  441,  437,  460,  456,  484,  554,  554,
 /*   160 */   393,  381,  393,  416,  420,  413,  425,  416,  543,  543,
 /*   170 */   554,  554,  554,  554,  522,  554,  554,  554,  554,  554,
 /*   180 */   554,  554,  415,  554,  554,  554,  554,  554,  554,  554,
 /*   190 */   554,  554,  554,  385,  386,  554,  554,  554,  554,  554,
 /*   200 */   554,  551,  552,  495,  497,  551,  552,  554,  554,  554,
 /*   210 */   554,  554,  554,  554,  554,  442,  554,  451,  554,  554,
 /*   220 */   554,  554,  554,  554,  554,  487,  554,  554,  554,  554,
 /*   230 */   379,  554,  554,  554,  554,  414,  554,  554,  554,  554,
 /*   240 */   554,  554,  554,  363,  364,  362,  430,  432,  433,  502,
 /*   250 */   548,  549,  550,  553,  494,  541,  544,  545,  546,  547,
 /*   260 */   496,  499,  479,  480,  481,  501,  520,  524,  523,  534,
 /*   270 */   527,  536,  537,  538,  539,  540,  542,  535,  526,  525,
 /*   280 */   498,  500,  522,  436,  443,  445,  446,  444,  458,  461,
 /*   290 */   462,  463,  464,  465,  466,  467,  468,  469,  470,  471,
 /*   300 */   454,  422,  455,  423,  472,  473,  482,  483,  474,  475,
 /*   310 */   477,  478,  486,  435,  431,  361,  366,  373,  403,  404,
 /*   320 */   405,  406,  407,  396,  372,  397,  398,  399,  400,  402,
 /*   330 */   367,  368,  374,  375,  376,  394,  377,  378,  380,  382,
 /*   340 */   389,  390,  391,  392,  387,  388,  383,  384,  411,  412,
 /*   350 */   408,  409,  410,  418,  419,  421,  417,  424,  427,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         ID => nothing */
    1,  /*      ABORT => ID */
    1,  /*      AFTER => ID */
    1,  /*    ANALYZE => ID */
    1,  /*        ASC => ID */
    1,  /*     ATTACH => ID */
    1,  /*     BEFORE => ID */
    1,  /*      BEGIN => ID */
    1,  /*    CASCADE => ID */
    1,  /*       CAST => ID */
    1,  /*   CONFLICT => ID */
    1,  /*   DATABASE => ID */
    1,  /*   DEFERRED => ID */
    1,  /*       DESC => ID */
    1,  /*     DETACH => ID */
    1,  /*       EACH => ID */
    1,  /*        END => ID */
    1,  /*  EXCLUSIVE => ID */
    1,  /*    EXPLAIN => ID */
    1,  /*       FAIL => ID */
    1,  /*        FOR => ID */
    1,  /*     IGNORE => ID */
    1,  /*  IMMEDIATE => ID */
    1,  /*  INITIALLY => ID */
    1,  /*    INSTEAD => ID */
    1,  /*       LIKE => ID */
    1,  /*      MATCH => ID */
    1,  /*       PLAN => ID */
    1,  /*      QUERY => ID */
    1,  /*        KEY => ID */
    1,  /*         OF => ID */
    1,  /*     OFFSET => ID */
    1,  /*     PRAGMA => ID */
    1,  /*      RAISE => ID */
    1,  /*    REPLACE => ID */
    1,  /*   RESTRICT => ID */
    1,  /*        ROW => ID */
    1,  /*       TEMP => ID */
    1,  /*    TRIGGER => ID */
    1,  /*     VACUUM => ID */
    1,  /*       VIEW => ID */
    1,  /*    VIRTUAL => ID */
    1,  /*    REINDEX => ID */
    1,  /*     RENAME => ID */
    1,  /*   CTIME_KW => ID */
    1,  /*         IF => ID */
    1,  /*  DELIMITER => ID */
    1,  /*     COMMIT => ID */
    1,  /*   ROLLBACK => ID */
    1,  /*  ISOLATION => ID */
    1,  /*      LEVEL => ID */
    1,  /* SERIALIZABLE => ID */
    1,  /*       READ => ID */
    1,  /*  COMMITTED => ID */
    1,  /* UNCOMMITTED => ID */
    1,  /* REPEATABLE => ID */
    1,  /*      WRITE => ID */
    1,  /*       ONLY => ID */
    1,  /*  SAVEPOINT => ID */
    1,  /*    RELEASE => ID */
    1,  /*    COMMENT => ID */
    1,  /*      FORCE => ID */
    1,  /*       WAIT => ID */
    1,  /*     NOWAIT => ID */
    1,  /*      BATCH => ID */
    0,  /*    TEXTUAL => nothing */
   66,  /*     STRING => TEXTUAL */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*        NOT => nothing */
    0,  /*         IS => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*       DIFF => nothing */
    0,  /*         EQ => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         GT => nothing */
    0,  /*        LEQ => nothing */
    0,  /*         LT => nothing */
    0,  /*        GEQ => nothing */
    0,  /*     REGEXP => nothing */
    0,  /*  REGEXP_CI => nothing */
    0,  /* NOT_REGEXP => nothing */
    0,  /* NOT_REGEXP_CI => nothing */
    0,  /*    SIMILAR => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*    NATURAL => nothing */
    0,  /*       LEFT => nothing */
    0,  /*      RIGHT => nothing */
    0,  /*       FULL => nothing */
    0,  /*      CROSS => nothing */
    0,  /*      UNION => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     PGCAST => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /* SQLCOMMENT => nothing */
    0,  /*       SEMI => nothing */
    0,  /* END_OF_FILE => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*      COMMA => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*         TO => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*     DELETE => nothing */
    0,  /*       FROM => nothing */
    0,  /*      WHERE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*        SET => nothing */
    0,  /*        ALL => nothing */
    0,  /*     SELECT => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      GROUP => nothing */
    0,  /*      USING => nothing */
    0,  /*         ON => nothing */
    0,  /*      OUTER => nothing */
    0,  /*        DOT => nothing */
    0,  /*         AS => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*       NULL => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*  UNSPECVAL => nothing */
    0,  /*  LSBRACKET => nothing */
    0,  /*  RSBRACKET => nothing */
    0,  /* SIMPLEPARAM => nothing */
    0,  /*      PNAME => nothing */
    0,  /*     PDESCR => nothing */
    0,  /*      PTYPE => nothing */
    0,  /*    PNULLOK => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  gda_sql_parserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void gda_sql_parserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "ID",            "ABORT",         "AFTER",       
  "ANALYZE",       "ASC",           "ATTACH",        "BEFORE",      
  "BEGIN",         "CASCADE",       "CAST",          "CONFLICT",    
  "DATABASE",      "DEFERRED",      "DESC",          "DETACH",      
  "EACH",          "END",           "EXCLUSIVE",     "EXPLAIN",     
  "FAIL",          "FOR",           "IGNORE",        "IMMEDIATE",   
  "INITIALLY",     "INSTEAD",       "LIKE",          "MATCH",       
  "PLAN",          "QUERY",         "KEY",           "OF",          
  "OFFSET",        "PRAGMA",        "RAISE",         "REPLACE",     
  "RESTRICT",      "ROW",           "TEMP",          "TRIGGER",     
  "VACUUM",        "VIEW",          "VIRTUAL",       "REINDEX",     
  "RENAME",        "CTIME_KW",      "IF",            "DELIMITER",   
  "COMMIT",        "ROLLBACK",      "ISOLATION",     "LEVEL",       
  "SERIALIZABLE",  "READ",          "COMMITTED",     "UNCOMMITTED", 
  "REPEATABLE",    "WRITE",         "ONLY",          "SAVEPOINT",   
  "RELEASE",       "COMMENT",       "FORCE",         "WAIT",        
  "NOWAIT",        "BATCH",         "TEXTUAL",       "STRING",      
  "OR",            "AND",           "NOT",           "IS",          
  "IN",            "ISNULL",        "NOTNULL",       "DIFF",        
  "EQ",            "BETWEEN",       "GT",            "LEQ",         
  "LT",            "GEQ",           "REGEXP",        "REGEXP_CI",   
  "NOT_REGEXP",    "NOT_REGEXP_CI",  "SIMILAR",       "ESCAPE",      
  "BITAND",        "BITOR",         "LSHIFT",        "RSHIFT",      
  "PLUS",          "MINUS",         "STAR",          "SLASH",       
  "REM",           "CONCAT",        "COLLATE",       "UMINUS",      
  "UPLUS",         "BITNOT",        "LP",            "RP",          
  "JOIN",          "INNER",         "NATURAL",       "LEFT",        
  "RIGHT",         "FULL",          "CROSS",         "UNION",       
  "EXCEPT",        "INTERSECT",     "PGCAST",        "ILLEGAL",     
  "SQLCOMMENT",    "SEMI",          "END_OF_FILE",   "TRANSACTION", 
  "COMMA",         "INTEGER",       "TO",            "INSERT",      
  "INTO",          "VALUES",        "DELETE",        "FROM",        
  "WHERE",         "UPDATE",        "SET",           "ALL",         
  "SELECT",        "LIMIT",         "ORDER",         "BY",          
  "HAVING",        "GROUP",         "USING",         "ON",          
  "OUTER",         "DOT",           "AS",            "DISTINCT",    
  "CASE",          "WHEN",          "THEN",          "ELSE",        
  "NULL",          "FLOAT",         "UNSPECVAL",     "LSBRACKET",   
  "RSBRACKET",     "SIMPLEPARAM",   "PNAME",         "PDESCR",      
  "PTYPE",         "PNULLOK",       "error",         "stmt",        
  "cmd",           "eos",           "compound",      "nm_opt",      
  "transtype",     "transilev",     "opt_comma",     "trans_opt_kw",
  "ora_commit_write",  "nm",            "opt_on_conflict",  "fullname",    
  "inscollist_opt",  "exprlist",      "ins_extra_values",  "inscollist",  
  "where_opt",     "expr",          "setlist",       "selectcmd",   
  "opt_compound_all",  "distinct",      "selcollist",    "from",        
  "groupby_opt",   "having_opt",    "orderby_opt",   "limit_opt",   
  "sortlist",      "sortorder",     "nexprlist",     "seltablist",  
  "stl_prefix",    "seltarget",     "on_cond",       "using_opt",   
  "jointype",      "as",            "sclp",          "starname",    
  "value",         "pvalue",        "uni_op",        "case_operand",
  "case_exprlist",  "case_else",     "paramspec",   
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "stmt ::= cmd eos",
 /*   1 */ "stmt ::= compound eos",
 /*   2 */ "cmd ::= LP cmd RP",
 /*   3 */ "compound ::= LP compound RP",
 /*   4 */ "eos ::= SEMI",
 /*   5 */ "eos ::= END_OF_FILE",
 /*   6 */ "cmd ::= BEGIN",
 /*   7 */ "cmd ::= BEGIN TRANSACTION nm_opt",
 /*   8 */ "cmd ::= BEGIN transtype TRANSACTION nm_opt",
 /*   9 */ "cmd ::= BEGIN transtype nm_opt",
 /*  10 */ "cmd ::= BEGIN transilev",
 /*  11 */ "cmd ::= BEGIN TRANSACTION transilev",
 /*  12 */ "cmd ::= BEGIN TRANSACTION transtype",
 /*  13 */ "cmd ::= BEGIN TRANSACTION transtype opt_comma transilev",
 /*  14 */ "cmd ::= BEGIN TRANSACTION transilev opt_comma transtype",
 /*  15 */ "cmd ::= BEGIN transtype opt_comma transilev",
 /*  16 */ "cmd ::= BEGIN transilev opt_comma transtype",
 /*  17 */ "cmd ::= END trans_opt_kw nm_opt",
 /*  18 */ "cmd ::= COMMIT nm_opt",
 /*  19 */ "cmd ::= COMMIT TRANSACTION nm_opt",
 /*  20 */ "cmd ::= COMMIT FORCE STRING",
 /*  21 */ "cmd ::= COMMIT FORCE STRING COMMA INTEGER",
 /*  22 */ "cmd ::= COMMIT COMMENT STRING",
 /*  23 */ "cmd ::= COMMIT COMMENT STRING ora_commit_write",
 /*  24 */ "cmd ::= COMMIT ora_commit_write",
 /*  25 */ "cmd ::= ROLLBACK trans_opt_kw nm_opt",
 /*  26 */ "ora_commit_write ::= WRITE IMMEDIATE",
 /*  27 */ "ora_commit_write ::= WRITE BATCH",
 /*  28 */ "ora_commit_write ::= WRITE WAIT",
 /*  29 */ "ora_commit_write ::= WRITE NOWAIT",
 /*  30 */ "ora_commit_write ::= WRITE IMMEDIATE WAIT",
 /*  31 */ "ora_commit_write ::= WRITE IMMEDIATE NOWAIT",
 /*  32 */ "ora_commit_write ::= WRITE BATCH WAIT",
 /*  33 */ "ora_commit_write ::= WRITE BATCH NOWAIT",
 /*  34 */ "trans_opt_kw ::=",
 /*  35 */ "trans_opt_kw ::= TRANSACTION",
 /*  36 */ "opt_comma ::=",
 /*  37 */ "opt_comma ::= COMMA",
 /*  38 */ "transilev ::= ISOLATION LEVEL SERIALIZABLE",
 /*  39 */ "transilev ::= ISOLATION LEVEL REPEATABLE READ",
 /*  40 */ "transilev ::= ISOLATION LEVEL READ COMMITTED",
 /*  41 */ "transilev ::= ISOLATION LEVEL READ UNCOMMITTED",
 /*  42 */ "nm_opt ::=",
 /*  43 */ "nm_opt ::= nm",
 /*  44 */ "transtype ::= DEFERRED",
 /*  45 */ "transtype ::= IMMEDIATE",
 /*  46 */ "transtype ::= EXCLUSIVE",
 /*  47 */ "transtype ::= READ WRITE",
 /*  48 */ "transtype ::= READ ONLY",
 /*  49 */ "cmd ::= SAVEPOINT nm",
 /*  50 */ "cmd ::= RELEASE SAVEPOINT nm",
 /*  51 */ "cmd ::= RELEASE nm",
 /*  52 */ "cmd ::= ROLLBACK trans_opt_kw TO nm",
 /*  53 */ "cmd ::= ROLLBACK trans_opt_kw TO SAVEPOINT nm",
 /*  54 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP",
 /*  55 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP ins_extra_values",
 /*  56 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt compound",
 /*  57 */ "opt_on_conflict ::=",
 /*  58 */ "opt_on_conflict ::= OR ID",
 /*  59 */ "ins_extra_values ::= ins_extra_values COMMA LP exprlist RP",
 /*  60 */ "ins_extra_values ::= COMMA LP exprlist RP",
 /*  61 */ "inscollist_opt ::=",
 /*  62 */ "inscollist_opt ::= LP inscollist RP",
 /*  63 */ "inscollist ::= inscollist COMMA fullname",
 /*  64 */ "inscollist ::= fullname",
 /*  65 */ "cmd ::= DELETE FROM fullname where_opt",
 /*  66 */ "where_opt ::=",
 /*  67 */ "where_opt ::= WHERE expr",
 /*  68 */ "cmd ::= UPDATE opt_on_conflict fullname SET setlist where_opt",
 /*  69 */ "setlist ::= setlist COMMA fullname EQ expr",
 /*  70 */ "setlist ::= fullname EQ expr",
 /*  71 */ "compound ::= selectcmd",
 /*  72 */ "compound ::= compound UNION opt_compound_all compound",
 /*  73 */ "compound ::= compound EXCEPT opt_compound_all compound",
 /*  74 */ "compound ::= compound INTERSECT opt_compound_all compound",
 /*  75 */ "opt_compound_all ::=",
 /*  76 */ "opt_compound_all ::= ALL",
 /*  77 */ "selectcmd ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /*  78 */ "limit_opt ::=",
 /*  79 */ "limit_opt ::= LIMIT expr",
 /*  80 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /*  81 */ "limit_opt ::= LIMIT expr COMMA expr",
 /*  82 */ "orderby_opt ::=",
 /*  83 */ "orderby_opt ::= ORDER BY sortlist",
 /*  84 */ "sortlist ::= sortlist COMMA expr sortorder",
 /*  85 */ "sortlist ::= expr sortorder",
 /*  86 */ "sortorder ::= ASC",
 /*  87 */ "sortorder ::= DESC",
 /*  88 */ "sortorder ::=",
 /*  89 */ "having_opt ::=",
 /*  90 */ "having_opt ::= HAVING expr",
 /*  91 */ "groupby_opt ::=",
 /*  92 */ "groupby_opt ::= GROUP BY nexprlist",
 /*  93 */ "from ::=",
 /*  94 */ "from ::= FROM seltablist",
 /*  95 */ "seltablist ::= stl_prefix seltarget on_cond using_opt",
 /*  96 */ "using_opt ::= USING LP inscollist RP",
 /*  97 */ "using_opt ::=",
 /*  98 */ "stl_prefix ::=",
 /*  99 */ "stl_prefix ::= seltablist jointype",
 /* 100 */ "on_cond ::= ON expr",
 /* 101 */ "on_cond ::=",
 /* 102 */ "jointype ::= COMMA",
 /* 103 */ "jointype ::= JOIN",
 /* 104 */ "jointype ::= CROSS JOIN",
 /* 105 */ "jointype ::= INNER JOIN",
 /* 106 */ "jointype ::= NATURAL JOIN",
 /* 107 */ "jointype ::= LEFT JOIN",
 /* 108 */ "jointype ::= LEFT OUTER JOIN",
 /* 109 */ "jointype ::= RIGHT JOIN",
 /* 110 */ "jointype ::= RIGHT OUTER JOIN",
 /* 111 */ "jointype ::= FULL JOIN",
 /* 112 */ "jointype ::= FULL OUTER JOIN",
 /* 113 */ "seltarget ::= fullname as",
 /* 114 */ "seltarget ::= fullname ID",
 /* 115 */ "seltarget ::= LP compound RP as",
 /* 116 */ "sclp ::= selcollist COMMA",
 /* 117 */ "sclp ::=",
 /* 118 */ "selcollist ::= sclp expr as",
 /* 119 */ "selcollist ::= sclp starname",
 /* 120 */ "starname ::= STAR",
 /* 121 */ "starname ::= nm DOT STAR",
 /* 122 */ "starname ::= nm DOT nm DOT STAR",
 /* 123 */ "as ::= AS fullname",
 /* 124 */ "as ::= AS value",
 /* 125 */ "as ::=",
 /* 126 */ "distinct ::=",
 /* 127 */ "distinct ::= ALL",
 /* 128 */ "distinct ::= DISTINCT",
 /* 129 */ "distinct ::= DISTINCT ON expr",
 /* 130 */ "nexprlist ::= nexprlist COMMA expr",
 /* 131 */ "nexprlist ::= expr",
 /* 132 */ "exprlist ::=",
 /* 133 */ "exprlist ::= exprlist COMMA expr",
 /* 134 */ "exprlist ::= expr",
 /* 135 */ "expr ::= pvalue",
 /* 136 */ "expr ::= value",
 /* 137 */ "expr ::= LP expr RP",
 /* 138 */ "expr ::= fullname",
 /* 139 */ "expr ::= fullname LP exprlist RP",
 /* 140 */ "expr ::= fullname LP compound RP",
 /* 141 */ "expr ::= fullname LP starname RP",
 /* 142 */ "expr ::= CAST LP expr AS fullname RP",
 /* 143 */ "expr ::= expr PGCAST fullname",
 /* 144 */ "expr ::= expr PLUS|MINUS expr",
 /* 145 */ "expr ::= expr STAR expr",
 /* 146 */ "expr ::= expr SLASH|REM expr",
 /* 147 */ "expr ::= expr BITAND|BITOR expr",
 /* 148 */ "expr ::= MINUS expr",
 /* 149 */ "expr ::= PLUS expr",
 /* 150 */ "expr ::= expr AND expr",
 /* 151 */ "expr ::= expr OR expr",
 /* 152 */ "expr ::= expr CONCAT expr",
 /* 153 */ "expr ::= expr GT|LEQ|GEQ|LT expr",
 /* 154 */ "expr ::= expr DIFF|EQ expr",
 /* 155 */ "expr ::= expr LIKE expr",
 /* 156 */ "expr ::= expr REGEXP|REGEXP_CI|NOT_REGEXP|NOT_REGEXP_CI|SIMILAR expr",
 /* 157 */ "expr ::= expr BETWEEN expr AND expr",
 /* 158 */ "expr ::= expr NOT BETWEEN expr AND expr",
 /* 159 */ "expr ::= NOT expr",
 /* 160 */ "expr ::= BITNOT expr",
 /* 161 */ "expr ::= expr uni_op",
 /* 162 */ "expr ::= expr IS expr",
 /* 163 */ "expr ::= LP compound RP",
 /* 164 */ "expr ::= expr IN LP exprlist RP",
 /* 165 */ "expr ::= expr IN LP compound RP",
 /* 166 */ "expr ::= expr NOT IN LP exprlist RP",
 /* 167 */ "expr ::= expr NOT IN LP compound RP",
 /* 168 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 169 */ "case_operand ::= expr",
 /* 170 */ "case_operand ::=",
 /* 171 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 172 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 173 */ "case_else ::= ELSE expr",
 /* 174 */ "case_else ::=",
 /* 175 */ "uni_op ::= ISNULL",
 /* 176 */ "uni_op ::= IS NOTNULL",
 /* 177 */ "value ::= NULL",
 /* 178 */ "value ::= STRING",
 /* 179 */ "value ::= INTEGER",
 /* 180 */ "value ::= FLOAT",
 /* 181 */ "pvalue ::= UNSPECVAL LSBRACKET paramspec RSBRACKET",
 /* 182 */ "pvalue ::= value LSBRACKET paramspec RSBRACKET",
 /* 183 */ "pvalue ::= SIMPLEPARAM",
 /* 184 */ "paramspec ::=",
 /* 185 */ "paramspec ::= paramspec PNAME",
 /* 186 */ "paramspec ::= paramspec PDESCR",
 /* 187 */ "paramspec ::= paramspec PTYPE",
 /* 188 */ "paramspec ::= paramspec PNULLOK",
 /* 189 */ "nm ::= JOIN",
 /* 190 */ "nm ::= ID",
 /* 191 */ "nm ::= TEXTUAL",
 /* 192 */ "fullname ::= nm",
 /* 193 */ "fullname ::= nm DOT nm",
 /* 194 */ "fullname ::= nm DOT nm DOT nm",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to gda_sql_parser and gda_sql_parserFree.
*/
void *gda_sql_parserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#if YYSTACKDEPTH<=0
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 1: /* ID */
    case 2: /* ABORT */
    case 3: /* AFTER */
    case 4: /* ANALYZE */
    case 5: /* ASC */
    case 6: /* ATTACH */
    case 7: /* BEFORE */
    case 8: /* BEGIN */
    case 9: /* CASCADE */
    case 10: /* CAST */
    case 11: /* CONFLICT */
    case 12: /* DATABASE */
    case 13: /* DEFERRED */
    case 14: /* DESC */
    case 15: /* DETACH */
    case 16: /* EACH */
    case 17: /* END */
    case 18: /* EXCLUSIVE */
    case 19: /* EXPLAIN */
    case 20: /* FAIL */
    case 21: /* FOR */
    case 22: /* IGNORE */
    case 23: /* IMMEDIATE */
    case 24: /* INITIALLY */
    case 25: /* INSTEAD */
    case 26: /* LIKE */
    case 27: /* MATCH */
    case 28: /* PLAN */
    case 29: /* QUERY */
    case 30: /* KEY */
    case 31: /* OF */
    case 32: /* OFFSET */
    case 33: /* PRAGMA */
    case 34: /* RAISE */
    case 35: /* REPLACE */
    case 36: /* RESTRICT */
    case 37: /* ROW */
    case 38: /* TEMP */
    case 39: /* TRIGGER */
    case 40: /* VACUUM */
    case 41: /* VIEW */
    case 42: /* VIRTUAL */
    case 43: /* REINDEX */
    case 44: /* RENAME */
    case 45: /* CTIME_KW */
    case 46: /* IF */
    case 47: /* DELIMITER */
    case 48: /* COMMIT */
    case 49: /* ROLLBACK */
    case 50: /* ISOLATION */
    case 51: /* LEVEL */
    case 52: /* SERIALIZABLE */
    case 53: /* READ */
    case 54: /* COMMITTED */
    case 55: /* UNCOMMITTED */
    case 56: /* REPEATABLE */
    case 57: /* WRITE */
    case 58: /* ONLY */
    case 59: /* SAVEPOINT */
    case 60: /* RELEASE */
    case 61: /* COMMENT */
    case 62: /* FORCE */
    case 63: /* WAIT */
    case 64: /* NOWAIT */
    case 65: /* BATCH */
    case 66: /* TEXTUAL */
    case 67: /* STRING */
    case 68: /* OR */
    case 69: /* AND */
    case 70: /* NOT */
    case 71: /* IS */
    case 72: /* IN */
    case 73: /* ISNULL */
    case 74: /* NOTNULL */
    case 75: /* DIFF */
    case 76: /* EQ */
    case 77: /* BETWEEN */
    case 78: /* GT */
    case 79: /* LEQ */
    case 80: /* LT */
    case 81: /* GEQ */
    case 82: /* REGEXP */
    case 83: /* REGEXP_CI */
    case 84: /* NOT_REGEXP */
    case 85: /* NOT_REGEXP_CI */
    case 86: /* SIMILAR */
    case 87: /* ESCAPE */
    case 88: /* BITAND */
    case 89: /* BITOR */
    case 90: /* LSHIFT */
    case 91: /* RSHIFT */
    case 92: /* PLUS */
    case 93: /* MINUS */
    case 94: /* STAR */
    case 95: /* SLASH */
    case 96: /* REM */
    case 97: /* CONCAT */
    case 98: /* COLLATE */
    case 99: /* UMINUS */
    case 100: /* UPLUS */
    case 101: /* BITNOT */
    case 102: /* LP */
    case 103: /* RP */
    case 104: /* JOIN */
    case 105: /* INNER */
    case 106: /* NATURAL */
    case 107: /* LEFT */
    case 108: /* RIGHT */
    case 109: /* FULL */
    case 110: /* CROSS */
    case 111: /* UNION */
    case 112: /* EXCEPT */
    case 113: /* INTERSECT */
    case 114: /* PGCAST */
    case 115: /* ILLEGAL */
    case 116: /* SQLCOMMENT */
    case 117: /* SEMI */
    case 118: /* END_OF_FILE */
    case 119: /* TRANSACTION */
    case 120: /* COMMA */
    case 121: /* INTEGER */
    case 122: /* TO */
    case 123: /* INSERT */
    case 124: /* INTO */
    case 125: /* VALUES */
    case 126: /* DELETE */
    case 127: /* FROM */
    case 128: /* WHERE */
    case 129: /* UPDATE */
    case 130: /* SET */
    case 131: /* ALL */
    case 132: /* SELECT */
    case 133: /* LIMIT */
    case 134: /* ORDER */
    case 135: /* BY */
    case 136: /* HAVING */
    case 137: /* GROUP */
    case 138: /* USING */
    case 139: /* ON */
    case 140: /* OUTER */
    case 141: /* DOT */
    case 142: /* AS */
    case 143: /* DISTINCT */
    case 144: /* CASE */
    case 145: /* WHEN */
    case 146: /* THEN */
    case 147: /* ELSE */
    case 148: /* NULL */
    case 149: /* FLOAT */
    case 150: /* UNSPECVAL */
    case 151: /* LSBRACKET */
    case 152: /* RSBRACKET */
    case 153: /* SIMPLEPARAM */
    case 154: /* PNAME */
    case 155: /* PDESCR */
    case 156: /* PTYPE */
    case 157: /* PNULLOK */
#line 9 "./parser.y"
{if ((yypminor->yy0)) {
#ifdef GDA_DEBUG_NO
		 gchar *str = gda_sql_value_stringify ((yypminor->yy0));
		 g_print ("___ token destructor /%s/\n", str)
		 g_free (str);
#endif
		 g_value_unset ((yypminor->yy0)); g_free ((yypminor->yy0));}}
#line 1443 "parser.c"
      break;
    case 159: /* stmt */
#line 278 "./parser.y"
{g_print ("Statement destroyed by parser: %p\n", (yypminor->yy308)); gda_sql_statement_free ((yypminor->yy308));}
#line 1448 "parser.c"
      break;
    case 160: /* cmd */
    case 162: /* compound */
    case 179: /* selectcmd */
#line 301 "./parser.y"
{gda_sql_statement_free ((yypminor->yy308));}
#line 1455 "parser.c"
      break;
    case 172: /* inscollist_opt */
    case 175: /* inscollist */
    case 195: /* using_opt */
#line 478 "./parser.y"
{if ((yypminor->yy393)) {g_slist_foreach ((yypminor->yy393), (GFunc) gda_sql_field_free, NULL); g_slist_free ((yypminor->yy393));}}
#line 1462 "parser.c"
      break;
    case 173: /* exprlist */
    case 190: /* nexprlist */
#line 764 "./parser.y"
{if ((yypminor->yy247)) {g_slist_foreach ((yypminor->yy247), (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy247));}}
#line 1468 "parser.c"
      break;
    case 174: /* ins_extra_values */
#line 467 "./parser.y"
{GSList *list;
		for (list = (yypminor->yy393); list; list = list->next) {
			g_slist_foreach ((GSList*) list->data, (GFunc) gda_sql_field_free, NULL); 
			g_slist_free ((GSList*) list->data);
		}
		g_slist_free ((yypminor->yy393));
}
#line 1479 "parser.c"
      break;
    case 176: /* where_opt */
    case 177: /* expr */
    case 185: /* having_opt */
    case 194: /* on_cond */
    case 201: /* pvalue */
#line 500 "./parser.y"
{gda_sql_expr_free ((yypminor->yy328));}
#line 1488 "parser.c"
      break;
    case 178: /* setlist */
#line 520 "./parser.y"
{GSList *list;
	for (list = (yypminor->yy393); list; list = list->next) {
		UpdateSet *set = (UpdateSet*) list->data;
		g_value_reset (set->fname); g_free (set->fname);
		gda_sql_expr_free (set->expr);
		g_free (set);
	}
	g_slist_free ((yypminor->yy393));
}
#line 1501 "parser.c"
      break;
    case 181: /* distinct */
#line 750 "./parser.y"
{if ((yypminor->yy189)) {if ((yypminor->yy189)->expr) gda_sql_expr_free ((yypminor->yy189)->expr); g_free ((yypminor->yy189));}}
#line 1506 "parser.c"
      break;
    case 182: /* selcollist */
    case 198: /* sclp */
#line 707 "./parser.y"
{g_slist_foreach ((yypminor->yy247), (GFunc) gda_sql_select_field_free, NULL); g_slist_free ((yypminor->yy247));}
#line 1512 "parser.c"
      break;
    case 183: /* from */
    case 191: /* seltablist */
    case 192: /* stl_prefix */
#line 633 "./parser.y"
{gda_sql_select_from_free ((yypminor->yy59));}
#line 1519 "parser.c"
      break;
    case 184: /* groupby_opt */
#line 628 "./parser.y"
{if ((yypminor->yy393)) {g_slist_foreach ((yypminor->yy393), (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy393));}}
#line 1524 "parser.c"
      break;
    case 186: /* orderby_opt */
    case 188: /* sortlist */
#line 597 "./parser.y"
{if ((yypminor->yy247)) {g_slist_foreach ((yypminor->yy247), (GFunc) gda_sql_select_order_free, NULL); g_slist_free ((yypminor->yy247));}}
#line 1530 "parser.c"
      break;
    case 187: /* limit_opt */
#line 590 "./parser.y"
{gda_sql_expr_free ((yypminor->yy20).count); gda_sql_expr_free ((yypminor->yy20).offset);}
#line 1535 "parser.c"
      break;
    case 193: /* seltarget */
#line 692 "./parser.y"
{gda_sql_select_target_free ((yypminor->yy224));}
#line 1540 "parser.c"
      break;
    case 203: /* case_operand */
    case 205: /* case_else */
#line 928 "./parser.y"
{gda_sql_expr_free ((yypminor->yy122));}
#line 1546 "parser.c"
      break;
    case 204: /* case_exprlist */
#line 933 "./parser.y"
{g_slist_foreach ((yypminor->yy263).when_list, (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy263).when_list);
	g_slist_foreach ((yypminor->yy263).then_list, (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy263).then_list);}
#line 1552 "parser.c"
      break;
    case 206: /* paramspec */
#line 971 "./parser.y"
{gda_sql_param_spec_free ((yypminor->yy405));}
#line 1557 "parser.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from gda_sql_parserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void gda_sql_parserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  assert( stateno<=YY_REDUCE_MAX );
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  assert( i>=0 && i<YY_SZ_ACTTAB );
  assert( yy_lookahead[i]==iLookAhead );
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   gda_sql_parserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 25 "./parser.y"

	gda_sql_parser_set_overflow_error (pdata->parser);
#line 1711 "parser.c"
   gda_sql_parserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 159, 2 },
  { 159, 2 },
  { 160, 3 },
  { 162, 3 },
  { 161, 1 },
  { 161, 1 },
  { 160, 1 },
  { 160, 3 },
  { 160, 4 },
  { 160, 3 },
  { 160, 2 },
  { 160, 3 },
  { 160, 3 },
  { 160, 5 },
  { 160, 5 },
  { 160, 4 },
  { 160, 4 },
  { 160, 3 },
  { 160, 2 },
  { 160, 3 },
  { 160, 3 },
  { 160, 5 },
  { 160, 3 },
  { 160, 4 },
  { 160, 2 },
  { 160, 3 },
  { 168, 2 },
  { 168, 2 },
  { 168, 2 },
  { 168, 2 },
  { 168, 3 },
  { 168, 3 },
  { 168, 3 },
  { 168, 3 },
  { 167, 0 },
  { 167, 1 },
  { 166, 0 },
  { 166, 1 },
  { 165, 3 },
  { 165, 4 },
  { 165, 4 },
  { 165, 4 },
  { 163, 0 },
  { 163, 1 },
  { 164, 1 },
  { 164, 1 },
  { 164, 1 },
  { 164, 2 },
  { 164, 2 },
  { 160, 2 },
  { 160, 3 },
  { 160, 2 },
  { 160, 4 },
  { 160, 5 },
  { 160, 9 },
  { 160, 10 },
  { 160, 6 },
  { 170, 0 },
  { 170, 2 },
  { 174, 5 },
  { 174, 4 },
  { 172, 0 },
  { 172, 3 },
  { 175, 3 },
  { 175, 1 },
  { 160, 4 },
  { 176, 0 },
  { 176, 2 },
  { 160, 6 },
  { 178, 5 },
  { 178, 3 },
  { 162, 1 },
  { 162, 4 },
  { 162, 4 },
  { 162, 4 },
  { 180, 0 },
  { 180, 1 },
  { 179, 9 },
  { 187, 0 },
  { 187, 2 },
  { 187, 4 },
  { 187, 4 },
  { 186, 0 },
  { 186, 3 },
  { 188, 4 },
  { 188, 2 },
  { 189, 1 },
  { 189, 1 },
  { 189, 0 },
  { 185, 0 },
  { 185, 2 },
  { 184, 0 },
  { 184, 3 },
  { 183, 0 },
  { 183, 2 },
  { 191, 4 },
  { 195, 4 },
  { 195, 0 },
  { 192, 0 },
  { 192, 2 },
  { 194, 2 },
  { 194, 0 },
  { 196, 1 },
  { 196, 1 },
  { 196, 2 },
  { 196, 2 },
  { 196, 2 },
  { 196, 2 },
  { 196, 3 },
  { 196, 2 },
  { 196, 3 },
  { 196, 2 },
  { 196, 3 },
  { 193, 2 },
  { 193, 2 },
  { 193, 4 },
  { 198, 2 },
  { 198, 0 },
  { 182, 3 },
  { 182, 2 },
  { 199, 1 },
  { 199, 3 },
  { 199, 5 },
  { 197, 2 },
  { 197, 2 },
  { 197, 0 },
  { 181, 0 },
  { 181, 1 },
  { 181, 1 },
  { 181, 3 },
  { 190, 3 },
  { 190, 1 },
  { 173, 0 },
  { 173, 3 },
  { 173, 1 },
  { 177, 1 },
  { 177, 1 },
  { 177, 3 },
  { 177, 1 },
  { 177, 4 },
  { 177, 4 },
  { 177, 4 },
  { 177, 6 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 2 },
  { 177, 2 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 5 },
  { 177, 6 },
  { 177, 2 },
  { 177, 2 },
  { 177, 2 },
  { 177, 3 },
  { 177, 3 },
  { 177, 5 },
  { 177, 5 },
  { 177, 6 },
  { 177, 6 },
  { 177, 5 },
  { 203, 1 },
  { 203, 0 },
  { 204, 5 },
  { 204, 4 },
  { 205, 2 },
  { 205, 0 },
  { 202, 1 },
  { 202, 2 },
  { 200, 1 },
  { 200, 1 },
  { 200, 1 },
  { 200, 1 },
  { 201, 4 },
  { 201, 4 },
  { 201, 1 },
  { 206, 0 },
  { 206, 2 },
  { 206, 2 },
  { 206, 2 },
  { 206, 2 },
  { 169, 1 },
  { 169, 1 },
  { 169, 1 },
  { 171, 1 },
  { 171, 3 },
  { 171, 5 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  gda_sql_parserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  memset(&yygotominor, 0, sizeof(yygotominor));


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0: /* stmt ::= cmd eos */
#line 279 "./parser.y"
{pdata->parsed_statement = yymsp[-1].minor.yy308;}
#line 2014 "parser.c"
        break;
      case 1: /* stmt ::= compound eos */
#line 280 "./parser.y"
{
	GdaSqlStatementCompound *scompound = (GdaSqlStatementCompound *) yymsp[-1].minor.yy308->contents;
	if (scompound->stmt_list->next)
		/* real compound (multiple statements) */
		pdata->parsed_statement = yymsp[-1].minor.yy308;
	else {
		/* false compound (only 1 select) */
		pdata->parsed_statement = (GdaSqlStatement*) scompound->stmt_list->data;
		GDA_SQL_ANY_PART (pdata->parsed_statement->contents)->parent = NULL;
		g_slist_free (scompound->stmt_list);
		scompound->stmt_list = NULL;
		gda_sql_statement_free (yymsp[-1].minor.yy308);
	}
}
#line 2032 "parser.c"
        break;
      case 2: /* cmd ::= LP cmd RP */
      case 3: /* compound ::= LP compound RP */
#line 294 "./parser.y"
{yygotominor.yy308 = yymsp[-1].minor.yy308;  yy_destructor(102,&yymsp[-2].minor);
  yy_destructor(103,&yymsp[0].minor);
}
#line 2040 "parser.c"
        break;
      case 4: /* eos ::= SEMI */
#line 297 "./parser.y"
{
  yy_destructor(117,&yymsp[0].minor);
}
#line 2047 "parser.c"
        break;
      case 5: /* eos ::= END_OF_FILE */
#line 298 "./parser.y"
{
  yy_destructor(118,&yymsp[0].minor);
}
#line 2054 "parser.c"
        break;
      case 6: /* cmd ::= BEGIN */
#line 306 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);  yy_destructor(8,&yymsp[0].minor);
}
#line 2060 "parser.c"
        break;
      case 7: /* cmd ::= BEGIN TRANSACTION nm_opt */
#line 307 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					 gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(8,&yymsp[-2].minor);
  yy_destructor(119,&yymsp[-1].minor);
}
#line 2069 "parser.c"
        break;
      case 8: /* cmd ::= BEGIN transtype TRANSACTION nm_opt */
#line 311 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						      gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[-2].minor.yy361);
						      gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(8,&yymsp[-3].minor);
  yy_destructor(119,&yymsp[-1].minor);
}
#line 2079 "parser.c"
        break;
      case 9: /* cmd ::= BEGIN transtype nm_opt */
#line 316 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					  gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[-1].minor.yy361);
					  gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(8,&yymsp[-2].minor);
}
#line 2088 "parser.c"
        break;
      case 10: /* cmd ::= BEGIN transilev */
#line 321 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
				gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[0].minor.yy307);
  yy_destructor(8,&yymsp[-1].minor);
}
#line 2096 "parser.c"
        break;
      case 11: /* cmd ::= BEGIN TRANSACTION transilev */
#line 325 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					    gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[0].minor.yy307);
  yy_destructor(8,&yymsp[-2].minor);
  yy_destructor(119,&yymsp[-1].minor);
}
#line 2105 "parser.c"
        break;
      case 12: /* cmd ::= BEGIN TRANSACTION transtype */
#line 329 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					    gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(8,&yymsp[-2].minor);
  yy_destructor(119,&yymsp[-1].minor);
}
#line 2114 "parser.c"
        break;
      case 13: /* cmd ::= BEGIN TRANSACTION transtype opt_comma transilev */
#line 333 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
								   gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[-2].minor.yy361);
								   gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[0].minor.yy307);
  yy_destructor(8,&yymsp[-4].minor);
  yy_destructor(119,&yymsp[-3].minor);
}
#line 2124 "parser.c"
        break;
      case 14: /* cmd ::= BEGIN TRANSACTION transilev opt_comma transtype */
#line 338 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
								   gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[0].minor.yy361);
								   gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[-2].minor.yy307);
  yy_destructor(8,&yymsp[-4].minor);
  yy_destructor(119,&yymsp[-3].minor);
}
#line 2134 "parser.c"
        break;
      case 15: /* cmd ::= BEGIN transtype opt_comma transilev */
#line 343 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						       gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[-2].minor.yy361);
						       gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[0].minor.yy307);
  yy_destructor(8,&yymsp[-3].minor);
}
#line 2143 "parser.c"
        break;
      case 16: /* cmd ::= BEGIN transilev opt_comma transtype */
#line 348 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						       gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[0].minor.yy361);
						       gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[-2].minor.yy307);
  yy_destructor(8,&yymsp[-3].minor);
}
#line 2152 "parser.c"
        break;
      case 17: /* cmd ::= END trans_opt_kw nm_opt */
#line 353 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
					gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(17,&yymsp[-2].minor);
}
#line 2160 "parser.c"
        break;
      case 18: /* cmd ::= COMMIT nm_opt */
#line 357 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
			      gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(48,&yymsp[-1].minor);
}
#line 2168 "parser.c"
        break;
      case 19: /* cmd ::= COMMIT TRANSACTION nm_opt */
#line 361 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
					  gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(48,&yymsp[-2].minor);
  yy_destructor(119,&yymsp[-1].minor);
}
#line 2177 "parser.c"
        break;
      case 20: /* cmd ::= COMMIT FORCE STRING */
#line 365 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(48,&yymsp[-2].minor);
  yy_destructor(62,&yymsp[-1].minor);
  yy_destructor(67,&yymsp[0].minor);
}
#line 2185 "parser.c"
        break;
      case 21: /* cmd ::= COMMIT FORCE STRING COMMA INTEGER */
#line 366 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(48,&yymsp[-4].minor);
  yy_destructor(62,&yymsp[-3].minor);
  yy_destructor(67,&yymsp[-2].minor);
  yy_destructor(120,&yymsp[-1].minor);
  yy_destructor(121,&yymsp[0].minor);
}
#line 2195 "parser.c"
        break;
      case 22: /* cmd ::= COMMIT COMMENT STRING */
#line 367 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(48,&yymsp[-2].minor);
  yy_destructor(61,&yymsp[-1].minor);
  yy_destructor(67,&yymsp[0].minor);
}
#line 2203 "parser.c"
        break;
      case 23: /* cmd ::= COMMIT COMMENT STRING ora_commit_write */
#line 368 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(48,&yymsp[-3].minor);
  yy_destructor(61,&yymsp[-2].minor);
  yy_destructor(67,&yymsp[-1].minor);
}
#line 2211 "parser.c"
        break;
      case 24: /* cmd ::= COMMIT ora_commit_write */
#line 369 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(48,&yymsp[-1].minor);
}
#line 2217 "parser.c"
        break;
      case 25: /* cmd ::= ROLLBACK trans_opt_kw nm_opt */
#line 371 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK);
					     gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(49,&yymsp[-2].minor);
}
#line 2225 "parser.c"
        break;
      case 26: /* ora_commit_write ::= WRITE IMMEDIATE */
#line 375 "./parser.y"
{
  yy_destructor(57,&yymsp[-1].minor);
  yy_destructor(23,&yymsp[0].minor);
}
#line 2233 "parser.c"
        break;
      case 27: /* ora_commit_write ::= WRITE BATCH */
#line 376 "./parser.y"
{
  yy_destructor(57,&yymsp[-1].minor);
  yy_destructor(65,&yymsp[0].minor);
}
#line 2241 "parser.c"
        break;
      case 28: /* ora_commit_write ::= WRITE WAIT */
#line 377 "./parser.y"
{
  yy_destructor(57,&yymsp[-1].minor);
  yy_destructor(63,&yymsp[0].minor);
}
#line 2249 "parser.c"
        break;
      case 29: /* ora_commit_write ::= WRITE NOWAIT */
#line 378 "./parser.y"
{
  yy_destructor(57,&yymsp[-1].minor);
  yy_destructor(64,&yymsp[0].minor);
}
#line 2257 "parser.c"
        break;
      case 30: /* ora_commit_write ::= WRITE IMMEDIATE WAIT */
#line 379 "./parser.y"
{
  yy_destructor(57,&yymsp[-2].minor);
  yy_destructor(23,&yymsp[-1].minor);
  yy_destructor(63,&yymsp[0].minor);
}
#line 2266 "parser.c"
        break;
      case 31: /* ora_commit_write ::= WRITE IMMEDIATE NOWAIT */
#line 380 "./parser.y"
{
  yy_destructor(57,&yymsp[-2].minor);
  yy_destructor(23,&yymsp[-1].minor);
  yy_destructor(64,&yymsp[0].minor);
}
#line 2275 "parser.c"
        break;
      case 32: /* ora_commit_write ::= WRITE BATCH WAIT */
#line 381 "./parser.y"
{
  yy_destructor(57,&yymsp[-2].minor);
  yy_destructor(65,&yymsp[-1].minor);
  yy_destructor(63,&yymsp[0].minor);
}
#line 2284 "parser.c"
        break;
      case 33: /* ora_commit_write ::= WRITE BATCH NOWAIT */
#line 382 "./parser.y"
{
  yy_destructor(57,&yymsp[-2].minor);
  yy_destructor(65,&yymsp[-1].minor);
  yy_destructor(64,&yymsp[0].minor);
}
#line 2293 "parser.c"
        break;
      case 34: /* trans_opt_kw ::= */
      case 36: /* opt_comma ::= */
#line 384 "./parser.y"
{
}
#line 2300 "parser.c"
        break;
      case 35: /* trans_opt_kw ::= TRANSACTION */
#line 385 "./parser.y"
{
  yy_destructor(119,&yymsp[0].minor);
}
#line 2307 "parser.c"
        break;
      case 37: /* opt_comma ::= COMMA */
#line 388 "./parser.y"
{
  yy_destructor(120,&yymsp[0].minor);
}
#line 2314 "parser.c"
        break;
      case 38: /* transilev ::= ISOLATION LEVEL SERIALIZABLE */
#line 391 "./parser.y"
{yygotominor.yy307 = GDA_TRANSACTION_ISOLATION_SERIALIZABLE;  yy_destructor(50,&yymsp[-2].minor);
  yy_destructor(51,&yymsp[-1].minor);
  yy_destructor(52,&yymsp[0].minor);
}
#line 2322 "parser.c"
        break;
      case 39: /* transilev ::= ISOLATION LEVEL REPEATABLE READ */
#line 392 "./parser.y"
{yygotominor.yy307 = GDA_TRANSACTION_ISOLATION_REPEATABLE_READ;  yy_destructor(50,&yymsp[-3].minor);
  yy_destructor(51,&yymsp[-2].minor);
  yy_destructor(56,&yymsp[-1].minor);
  yy_destructor(53,&yymsp[0].minor);
}
#line 2331 "parser.c"
        break;
      case 40: /* transilev ::= ISOLATION LEVEL READ COMMITTED */
#line 393 "./parser.y"
{yygotominor.yy307 = GDA_TRANSACTION_ISOLATION_READ_COMMITTED;  yy_destructor(50,&yymsp[-3].minor);
  yy_destructor(51,&yymsp[-2].minor);
  yy_destructor(53,&yymsp[-1].minor);
  yy_destructor(54,&yymsp[0].minor);
}
#line 2340 "parser.c"
        break;
      case 41: /* transilev ::= ISOLATION LEVEL READ UNCOMMITTED */
#line 394 "./parser.y"
{yygotominor.yy307 = GDA_TRANSACTION_ISOLATION_READ_UNCOMMITTED;  yy_destructor(50,&yymsp[-3].minor);
  yy_destructor(51,&yymsp[-2].minor);
  yy_destructor(53,&yymsp[-1].minor);
  yy_destructor(55,&yymsp[0].minor);
}
#line 2349 "parser.c"
        break;
      case 42: /* nm_opt ::= */
      case 57: /* opt_on_conflict ::= */
      case 125: /* as ::= */
#line 396 "./parser.y"
{yygotominor.yy361 = NULL;}
#line 2356 "parser.c"
        break;
      case 43: /* nm_opt ::= nm */
      case 192: /* fullname ::= nm */
#line 397 "./parser.y"
{yygotominor.yy361 = yymsp[0].minor.yy361;}
#line 2362 "parser.c"
        break;
      case 44: /* transtype ::= DEFERRED */
      case 45: /* transtype ::= IMMEDIATE */
      case 46: /* transtype ::= EXCLUSIVE */
      case 120: /* starname ::= STAR */
      case 178: /* value ::= STRING */
      case 179: /* value ::= INTEGER */
      case 180: /* value ::= FLOAT */
      case 189: /* nm ::= JOIN */
      case 190: /* nm ::= ID */
      case 191: /* nm ::= TEXTUAL */
#line 399 "./parser.y"
{yygotominor.yy361 = yymsp[0].minor.yy0;}
#line 2376 "parser.c"
        break;
      case 47: /* transtype ::= READ WRITE */
#line 402 "./parser.y"
{yygotominor.yy361 = g_new0 (GValue, 1);
			      g_value_init (yygotominor.yy361, G_TYPE_STRING);
			      g_value_set_string (yygotominor.yy361, "READ_WRITE");
  yy_destructor(53,&yymsp[-1].minor);
  yy_destructor(57,&yymsp[0].minor);
}
#line 2386 "parser.c"
        break;
      case 48: /* transtype ::= READ ONLY */
#line 406 "./parser.y"
{yygotominor.yy361 = g_new0 (GValue, 1);
			     g_value_init (yygotominor.yy361, G_TYPE_STRING);
			     g_value_set_string (yygotominor.yy361, "READ_ONLY");
  yy_destructor(53,&yymsp[-1].minor);
  yy_destructor(58,&yymsp[0].minor);
}
#line 2396 "parser.c"
        break;
      case 49: /* cmd ::= SAVEPOINT nm */
#line 414 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_SAVEPOINT);
				    gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(59,&yymsp[-1].minor);
}
#line 2404 "parser.c"
        break;
      case 50: /* cmd ::= RELEASE SAVEPOINT nm */
#line 418 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE_SAVEPOINT);
				     gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(60,&yymsp[-2].minor);
  yy_destructor(59,&yymsp[-1].minor);
}
#line 2413 "parser.c"
        break;
      case 51: /* cmd ::= RELEASE nm */
#line 422 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE_SAVEPOINT);
			   gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(60,&yymsp[-1].minor);
}
#line 2421 "parser.c"
        break;
      case 52: /* cmd ::= ROLLBACK trans_opt_kw TO nm */
#line 426 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK_SAVEPOINT);
					    gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(49,&yymsp[-3].minor);
  yy_destructor(122,&yymsp[-1].minor);
}
#line 2430 "parser.c"
        break;
      case 53: /* cmd ::= ROLLBACK trans_opt_kw TO SAVEPOINT nm */
#line 430 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK_SAVEPOINT);
						      gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(49,&yymsp[-4].minor);
  yy_destructor(122,&yymsp[-2].minor);
  yy_destructor(59,&yymsp[-1].minor);
}
#line 2440 "parser.c"
        break;
      case 54: /* cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP */
#line 437 "./parser.y"
{
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
	gda_sql_statement_insert_take_table_name (yygotominor.yy308, yymsp[-5].minor.yy361);
	gda_sql_statement_insert_take_fields_list (yygotominor.yy308, yymsp[-4].minor.yy393);
	gda_sql_statement_insert_take_1_values_list (yygotominor.yy308, yymsp[-1].minor.yy247);
	gda_sql_statement_insert_take_on_conflict (yygotominor.yy308, yymsp[-7].minor.yy361);
  yy_destructor(123,&yymsp[-8].minor);
  yy_destructor(124,&yymsp[-6].minor);
  yy_destructor(125,&yymsp[-3].minor);
  yy_destructor(102,&yymsp[-2].minor);
  yy_destructor(103,&yymsp[0].minor);
}
#line 2456 "parser.c"
        break;
      case 55: /* cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP ins_extra_values */
#line 445 "./parser.y"
{
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
	gda_sql_statement_insert_take_table_name (yygotominor.yy308, yymsp[-6].minor.yy361);
	gda_sql_statement_insert_take_fields_list (yygotominor.yy308, yymsp[-5].minor.yy393);
	gda_sql_statement_insert_take_1_values_list (yygotominor.yy308, yymsp[-2].minor.yy247);
	gda_sql_statement_insert_take_extra_values_list (yygotominor.yy308, yymsp[0].minor.yy393);
	gda_sql_statement_insert_take_on_conflict (yygotominor.yy308, yymsp[-8].minor.yy361);
  yy_destructor(123,&yymsp[-9].minor);
  yy_destructor(124,&yymsp[-7].minor);
  yy_destructor(125,&yymsp[-4].minor);
  yy_destructor(102,&yymsp[-3].minor);
  yy_destructor(103,&yymsp[-1].minor);
}
#line 2473 "parser.c"
        break;
      case 56: /* cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt compound */
#line 454 "./parser.y"
{
        yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
        gda_sql_statement_insert_take_table_name (yygotominor.yy308, yymsp[-2].minor.yy361);
        gda_sql_statement_insert_take_fields_list (yygotominor.yy308, yymsp[-1].minor.yy393);
        gda_sql_statement_insert_take_select (yygotominor.yy308, yymsp[0].minor.yy308);
        gda_sql_statement_insert_take_on_conflict (yygotominor.yy308, yymsp[-4].minor.yy361);
  yy_destructor(123,&yymsp[-5].minor);
  yy_destructor(124,&yymsp[-3].minor);
}
#line 2486 "parser.c"
        break;
      case 58: /* opt_on_conflict ::= OR ID */
#line 464 "./parser.y"
{yygotominor.yy361 = yymsp[0].minor.yy0;  yy_destructor(68,&yymsp[-1].minor);
}
#line 2492 "parser.c"
        break;
      case 59: /* ins_extra_values ::= ins_extra_values COMMA LP exprlist RP */
#line 474 "./parser.y"
{yygotominor.yy393 = g_slist_append (yymsp[-4].minor.yy393, yymsp[-1].minor.yy247);  yy_destructor(120,&yymsp[-3].minor);
  yy_destructor(102,&yymsp[-2].minor);
  yy_destructor(103,&yymsp[0].minor);
}
#line 2500 "parser.c"
        break;
      case 60: /* ins_extra_values ::= COMMA LP exprlist RP */
#line 475 "./parser.y"
{yygotominor.yy393 = g_slist_append (NULL, yymsp[-1].minor.yy247);  yy_destructor(120,&yymsp[-3].minor);
  yy_destructor(102,&yymsp[-2].minor);
  yy_destructor(103,&yymsp[0].minor);
}
#line 2508 "parser.c"
        break;
      case 61: /* inscollist_opt ::= */
      case 97: /* using_opt ::= */
#line 479 "./parser.y"
{yygotominor.yy393 = NULL;}
#line 2514 "parser.c"
        break;
      case 62: /* inscollist_opt ::= LP inscollist RP */
#line 480 "./parser.y"
{yygotominor.yy393 = yymsp[-1].minor.yy393;  yy_destructor(102,&yymsp[-2].minor);
  yy_destructor(103,&yymsp[0].minor);
}
#line 2521 "parser.c"
        break;
      case 63: /* inscollist ::= inscollist COMMA fullname */
#line 484 "./parser.y"
{GdaSqlField *field;
						    field = gda_sql_field_new (NULL);
						    gda_sql_field_take_name (field, yymsp[0].minor.yy361);
						    yygotominor.yy393 = g_slist_append (yymsp[-2].minor.yy393, field);
  yy_destructor(120,&yymsp[-1].minor);
}
#line 2531 "parser.c"
        break;
      case 64: /* inscollist ::= fullname */
#line 489 "./parser.y"
{GdaSqlField *field = gda_sql_field_new (NULL);
				gda_sql_field_take_name (field, yymsp[0].minor.yy361);
				yygotominor.yy393 = g_slist_prepend (NULL, field);
}
#line 2539 "parser.c"
        break;
      case 65: /* cmd ::= DELETE FROM fullname where_opt */
#line 495 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE); 
						  gda_sql_statement_delete_take_table_name (yygotominor.yy308, yymsp[-1].minor.yy361);
						  gda_sql_statement_delete_take_condition (yygotominor.yy308, yymsp[0].minor.yy328);  yy_destructor(126,&yymsp[-3].minor);
  yy_destructor(127,&yymsp[-2].minor);
}
#line 2548 "parser.c"
        break;
      case 66: /* where_opt ::= */
      case 89: /* having_opt ::= */
      case 101: /* on_cond ::= */
#line 501 "./parser.y"
{yygotominor.yy328 = NULL;}
#line 2555 "parser.c"
        break;
      case 67: /* where_opt ::= WHERE expr */
#line 502 "./parser.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;  yy_destructor(128,&yymsp[-1].minor);
}
#line 2561 "parser.c"
        break;
      case 68: /* cmd ::= UPDATE opt_on_conflict fullname SET setlist where_opt */
#line 505 "./parser.y"
{
	GSList *list;
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_UPDATE);
	gda_sql_statement_update_take_table_name (yygotominor.yy308, yymsp[-3].minor.yy361);
	gda_sql_statement_update_take_on_conflict (yygotominor.yy308, yymsp[-4].minor.yy361);
	gda_sql_statement_update_take_condition (yygotominor.yy308, yymsp[0].minor.yy328);
	for (list = yymsp[-1].minor.yy393; list; list = list->next) {
		UpdateSet *set = (UpdateSet*) list->data;
		gda_sql_statement_update_take_set_value (yygotominor.yy308, set->fname, set->expr);
		g_free (set);
	}
	g_slist_free (yymsp[-1].minor.yy393);
  yy_destructor(129,&yymsp[-5].minor);
  yy_destructor(130,&yymsp[-2].minor);
}
#line 2580 "parser.c"
        break;
      case 69: /* setlist ::= setlist COMMA fullname EQ expr */
#line 529 "./parser.y"
{UpdateSet *set;
							 set = g_new (UpdateSet, 1);
							 set->fname = yymsp[-2].minor.yy361;
							 set->expr = yymsp[0].minor.yy328;
							 yygotominor.yy393 = g_slist_append (yymsp[-4].minor.yy393, set);
  yy_destructor(120,&yymsp[-3].minor);
  yy_destructor(76,&yymsp[-1].minor);
}
#line 2592 "parser.c"
        break;
      case 70: /* setlist ::= fullname EQ expr */
#line 535 "./parser.y"
{UpdateSet *set;
					set = g_new (UpdateSet, 1);
					set->fname = yymsp[-2].minor.yy361;
					set->expr = yymsp[0].minor.yy328;
					yygotominor.yy393 = g_slist_append (NULL, set);
  yy_destructor(76,&yymsp[-1].minor);
}
#line 2603 "parser.c"
        break;
      case 71: /* compound ::= selectcmd */
#line 546 "./parser.y"
{
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMPOUND);
	gda_sql_statement_compound_take_stmt (yygotominor.yy308, yymsp[0].minor.yy308);
}
#line 2611 "parser.c"
        break;
      case 72: /* compound ::= compound UNION opt_compound_all compound */
#line 550 "./parser.y"
{
	yygotominor.yy308 = compose_multiple_compounds (yymsp[-1].minor.yy216 ? GDA_SQL_STATEMENT_COMPOUND_UNION_ALL : GDA_SQL_STATEMENT_COMPOUND_UNION,
					yymsp[-3].minor.yy308, yymsp[0].minor.yy308);
  yy_destructor(111,&yymsp[-2].minor);
}
#line 2620 "parser.c"
        break;
      case 73: /* compound ::= compound EXCEPT opt_compound_all compound */
#line 555 "./parser.y"
{
	yygotominor.yy308 = compose_multiple_compounds (yymsp[-1].minor.yy216 ? GDA_SQL_STATEMENT_COMPOUND_EXCEPT_ALL : GDA_SQL_STATEMENT_COMPOUND_EXCEPT,
					yymsp[-3].minor.yy308, yymsp[0].minor.yy308);
  yy_destructor(112,&yymsp[-2].minor);
}
#line 2629 "parser.c"
        break;
      case 74: /* compound ::= compound INTERSECT opt_compound_all compound */
#line 560 "./parser.y"
{
	yygotominor.yy308 = compose_multiple_compounds (yymsp[-1].minor.yy216 ? GDA_SQL_STATEMENT_COMPOUND_INTERSECT_ALL : GDA_SQL_STATEMENT_COMPOUND_INTERSECT,
					yymsp[-3].minor.yy308, yymsp[0].minor.yy308);
  yy_destructor(113,&yymsp[-2].minor);
}
#line 2638 "parser.c"
        break;
      case 75: /* opt_compound_all ::= */
#line 566 "./parser.y"
{yygotominor.yy216 = FALSE;}
#line 2643 "parser.c"
        break;
      case 76: /* opt_compound_all ::= ALL */
#line 567 "./parser.y"
{yygotominor.yy216 = TRUE;  yy_destructor(131,&yymsp[0].minor);
}
#line 2649 "parser.c"
        break;
      case 77: /* selectcmd ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
#line 574 "./parser.y"
{
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_SELECT);
	if (yymsp[-7].minor.yy189) {
		gda_sql_statement_select_take_distinct (yygotominor.yy308, yymsp[-7].minor.yy189->distinct, yymsp[-7].minor.yy189->expr);
		g_free (yymsp[-7].minor.yy189);
	}
	gda_sql_statement_select_take_expr_list (yygotominor.yy308, yymsp[-6].minor.yy247);
	gda_sql_statement_select_take_from (yygotominor.yy308, yymsp[-5].minor.yy59);
	gda_sql_statement_select_take_where_cond (yygotominor.yy308, yymsp[-4].minor.yy328);
	gda_sql_statement_select_take_group_by (yygotominor.yy308, yymsp[-3].minor.yy393);
	gda_sql_statement_select_take_having_cond (yygotominor.yy308, yymsp[-2].minor.yy328);
	gda_sql_statement_select_take_order_by (yygotominor.yy308, yymsp[-1].minor.yy247);
	gda_sql_statement_select_take_limits (yygotominor.yy308, yymsp[0].minor.yy20.count, yymsp[0].minor.yy20.offset);
  yy_destructor(132,&yymsp[-8].minor);
}
#line 2668 "parser.c"
        break;
      case 78: /* limit_opt ::= */
#line 591 "./parser.y"
{yygotominor.yy20.count = NULL; yygotominor.yy20.offset = NULL;}
#line 2673 "parser.c"
        break;
      case 79: /* limit_opt ::= LIMIT expr */
#line 592 "./parser.y"
{yygotominor.yy20.count = yymsp[0].minor.yy328; yygotominor.yy20.offset = NULL;  yy_destructor(133,&yymsp[-1].minor);
}
#line 2679 "parser.c"
        break;
      case 80: /* limit_opt ::= LIMIT expr OFFSET expr */
#line 593 "./parser.y"
{yygotominor.yy20.count = yymsp[-2].minor.yy328; yygotominor.yy20.offset = yymsp[0].minor.yy328;  yy_destructor(133,&yymsp[-3].minor);
  yy_destructor(32,&yymsp[-1].minor);
}
#line 2686 "parser.c"
        break;
      case 81: /* limit_opt ::= LIMIT expr COMMA expr */
#line 594 "./parser.y"
{yygotominor.yy20.count = yymsp[-2].minor.yy328; yygotominor.yy20.offset = yymsp[0].minor.yy328;  yy_destructor(133,&yymsp[-3].minor);
  yy_destructor(120,&yymsp[-1].minor);
}
#line 2693 "parser.c"
        break;
      case 82: /* orderby_opt ::= */
#line 598 "./parser.y"
{yygotominor.yy247 = 0;}
#line 2698 "parser.c"
        break;
      case 83: /* orderby_opt ::= ORDER BY sortlist */
#line 599 "./parser.y"
{yygotominor.yy247 = yymsp[0].minor.yy247;  yy_destructor(134,&yymsp[-2].minor);
  yy_destructor(135,&yymsp[-1].minor);
}
#line 2705 "parser.c"
        break;
      case 84: /* sortlist ::= sortlist COMMA expr sortorder */
#line 603 "./parser.y"
{GdaSqlSelectOrder *order;
							 order = gda_sql_select_order_new (NULL);
							 order->expr = yymsp[-1].minor.yy328;
							 order->asc = yymsp[0].minor.yy216;
							 yygotominor.yy247 = g_slist_append (yymsp[-3].minor.yy247, order);
  yy_destructor(120,&yymsp[-2].minor);
}
#line 2716 "parser.c"
        break;
      case 85: /* sortlist ::= expr sortorder */
#line 609 "./parser.y"
{GdaSqlSelectOrder *order;
				       order = gda_sql_select_order_new (NULL);
				       order->expr = yymsp[-1].minor.yy328;
				       order->asc = yymsp[0].minor.yy216;
				       yygotominor.yy247 = g_slist_prepend (NULL, order);
}
#line 2726 "parser.c"
        break;
      case 86: /* sortorder ::= ASC */
#line 617 "./parser.y"
{yygotominor.yy216 = TRUE;  yy_destructor(5,&yymsp[0].minor);
}
#line 2732 "parser.c"
        break;
      case 87: /* sortorder ::= DESC */
#line 618 "./parser.y"
{yygotominor.yy216 = FALSE;  yy_destructor(14,&yymsp[0].minor);
}
#line 2738 "parser.c"
        break;
      case 88: /* sortorder ::= */
#line 619 "./parser.y"
{yygotominor.yy216 = TRUE;}
#line 2743 "parser.c"
        break;
      case 90: /* having_opt ::= HAVING expr */
#line 625 "./parser.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;  yy_destructor(136,&yymsp[-1].minor);
}
#line 2749 "parser.c"
        break;
      case 91: /* groupby_opt ::= */
#line 629 "./parser.y"
{yygotominor.yy393 = 0;}
#line 2754 "parser.c"
        break;
      case 92: /* groupby_opt ::= GROUP BY nexprlist */
#line 630 "./parser.y"
{yygotominor.yy393 = yymsp[0].minor.yy247;  yy_destructor(137,&yymsp[-2].minor);
  yy_destructor(135,&yymsp[-1].minor);
}
#line 2761 "parser.c"
        break;
      case 93: /* from ::= */
      case 98: /* stl_prefix ::= */
#line 634 "./parser.y"
{yygotominor.yy59 = NULL;}
#line 2767 "parser.c"
        break;
      case 94: /* from ::= FROM seltablist */
#line 635 "./parser.y"
{yygotominor.yy59 = yymsp[0].minor.yy59;  yy_destructor(127,&yymsp[-1].minor);
}
#line 2773 "parser.c"
        break;
      case 95: /* seltablist ::= stl_prefix seltarget on_cond using_opt */
#line 642 "./parser.y"
{
	GSList *last;
	if (yymsp[-3].minor.yy59)
		yygotominor.yy59 = yymsp[-3].minor.yy59;
	else 
		yygotominor.yy59 = gda_sql_select_from_new (NULL);
	gda_sql_select_from_take_new_target (yygotominor.yy59, yymsp[-2].minor.yy224);
	last = g_slist_last (yygotominor.yy59->joins);
	if (last) {
		GdaSqlSelectJoin *join = (GdaSqlSelectJoin *) (last->data);
		join->expr = yymsp[-1].minor.yy328;
		join->position = g_slist_length (yygotominor.yy59->targets) - 1;
		join->use = yymsp[0].minor.yy393;
	}
}
#line 2792 "parser.c"
        break;
      case 96: /* using_opt ::= USING LP inscollist RP */
#line 660 "./parser.y"
{yygotominor.yy393 = yymsp[-1].minor.yy393;  yy_destructor(138,&yymsp[-3].minor);
  yy_destructor(102,&yymsp[-2].minor);
  yy_destructor(103,&yymsp[0].minor);
}
#line 2800 "parser.c"
        break;
      case 99: /* stl_prefix ::= seltablist jointype */
#line 664 "./parser.y"
{GdaSqlSelectJoin *join;
					      yygotominor.yy59 = yymsp[-1].minor.yy59;
					      join = gda_sql_select_join_new (GDA_SQL_ANY_PART (yygotominor.yy59));
					      join->type = yymsp[0].minor.yy317;
					      gda_sql_select_from_take_new_join (yygotominor.yy59, join);
}
#line 2810 "parser.c"
        break;
      case 100: /* on_cond ::= ON expr */
#line 674 "./parser.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;  yy_destructor(139,&yymsp[-1].minor);
}
#line 2816 "parser.c"
        break;
      case 102: /* jointype ::= COMMA */
#line 678 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_CROSS;  yy_destructor(120,&yymsp[0].minor);
}
#line 2822 "parser.c"
        break;
      case 103: /* jointype ::= JOIN */
#line 679 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_INNER;  yy_destructor(104,&yymsp[0].minor);
}
#line 2828 "parser.c"
        break;
      case 104: /* jointype ::= CROSS JOIN */
#line 680 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_CROSS;  yy_destructor(110,&yymsp[-1].minor);
  yy_destructor(104,&yymsp[0].minor);
}
#line 2835 "parser.c"
        break;
      case 105: /* jointype ::= INNER JOIN */
#line 681 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_INNER;  yy_destructor(105,&yymsp[-1].minor);
  yy_destructor(104,&yymsp[0].minor);
}
#line 2842 "parser.c"
        break;
      case 106: /* jointype ::= NATURAL JOIN */
#line 682 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_NATURAL;  yy_destructor(106,&yymsp[-1].minor);
  yy_destructor(104,&yymsp[0].minor);
}
#line 2849 "parser.c"
        break;
      case 107: /* jointype ::= LEFT JOIN */
#line 683 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_LEFT;  yy_destructor(107,&yymsp[-1].minor);
  yy_destructor(104,&yymsp[0].minor);
}
#line 2856 "parser.c"
        break;
      case 108: /* jointype ::= LEFT OUTER JOIN */
#line 684 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_LEFT;  yy_destructor(107,&yymsp[-2].minor);
  yy_destructor(140,&yymsp[-1].minor);
  yy_destructor(104,&yymsp[0].minor);
}
#line 2864 "parser.c"
        break;
      case 109: /* jointype ::= RIGHT JOIN */
#line 685 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_RIGHT;  yy_destructor(108,&yymsp[-1].minor);
  yy_destructor(104,&yymsp[0].minor);
}
#line 2871 "parser.c"
        break;
      case 110: /* jointype ::= RIGHT OUTER JOIN */
#line 686 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_RIGHT;  yy_destructor(108,&yymsp[-2].minor);
  yy_destructor(140,&yymsp[-1].minor);
  yy_destructor(104,&yymsp[0].minor);
}
#line 2879 "parser.c"
        break;
      case 111: /* jointype ::= FULL JOIN */
#line 687 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_FULL;  yy_destructor(109,&yymsp[-1].minor);
  yy_destructor(104,&yymsp[0].minor);
}
#line 2886 "parser.c"
        break;
      case 112: /* jointype ::= FULL OUTER JOIN */
#line 688 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_FULL;  yy_destructor(109,&yymsp[-2].minor);
  yy_destructor(140,&yymsp[-1].minor);
  yy_destructor(104,&yymsp[0].minor);
}
#line 2894 "parser.c"
        break;
      case 113: /* seltarget ::= fullname as */
#line 693 "./parser.y"
{yygotominor.yy224 = gda_sql_select_target_new (NULL);
				     gda_sql_select_target_take_alias (yygotominor.yy224, yymsp[0].minor.yy361);
				     gda_sql_select_target_take_table_name (yygotominor.yy224, yymsp[-1].minor.yy361);
}
#line 2902 "parser.c"
        break;
      case 114: /* seltarget ::= fullname ID */
#line 697 "./parser.y"
{yygotominor.yy224 = gda_sql_select_target_new (NULL);
                                     gda_sql_select_target_take_alias (yygotominor.yy224, yymsp[0].minor.yy0);
                                     gda_sql_select_target_take_table_name (yygotominor.yy224, yymsp[-1].minor.yy361);
}
#line 2910 "parser.c"
        break;
      case 115: /* seltarget ::= LP compound RP as */
#line 701 "./parser.y"
{yygotominor.yy224 = gda_sql_select_target_new (NULL);
					     gda_sql_select_target_take_alias (yygotominor.yy224, yymsp[0].minor.yy361);
					     gda_sql_select_target_take_select (yygotominor.yy224, yymsp[-2].minor.yy308);
  yy_destructor(102,&yymsp[-3].minor);
  yy_destructor(103,&yymsp[-1].minor);
}
#line 2920 "parser.c"
        break;
      case 116: /* sclp ::= selcollist COMMA */
#line 711 "./parser.y"
{yygotominor.yy247 = yymsp[-1].minor.yy247;  yy_destructor(120,&yymsp[0].minor);
}
#line 2926 "parser.c"
        break;
      case 117: /* sclp ::= */
      case 132: /* exprlist ::= */
#line 712 "./parser.y"
{yygotominor.yy247 = NULL;}
#line 2932 "parser.c"
        break;
      case 118: /* selcollist ::= sclp expr as */
#line 714 "./parser.y"
{GdaSqlSelectField *field;
					  field = gda_sql_select_field_new (NULL);
					  gda_sql_select_field_take_expr (field, yymsp[-1].minor.yy328);
					  gda_sql_select_field_take_alias (field, yymsp[0].minor.yy361); 
					  yygotominor.yy247 = g_slist_append (yymsp[-2].minor.yy247, field);}
#line 2941 "parser.c"
        break;
      case 119: /* selcollist ::= sclp starname */
#line 719 "./parser.y"
{GdaSqlSelectField *field;
					field = gda_sql_select_field_new (NULL);
					gda_sql_select_field_take_star_value (field, yymsp[0].minor.yy361);
					yygotominor.yy247 = g_slist_append (yymsp[-1].minor.yy247, field);}
#line 2949 "parser.c"
        break;
      case 121: /* starname ::= nm DOT STAR */
#line 725 "./parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s", g_value_get_string (yymsp[-2].minor.yy361), g_value_get_string (yymsp[0].minor.yy0));
				  yygotominor.yy361 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy361, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy361, str);
				  g_value_reset (yymsp[-2].minor.yy361); g_free (yymsp[-2].minor.yy361);
				  g_value_reset (yymsp[0].minor.yy0); g_free (yymsp[0].minor.yy0);
  yy_destructor(141,&yymsp[-1].minor);
}
#line 2962 "parser.c"
        break;
      case 122: /* starname ::= nm DOT nm DOT STAR */
#line 734 "./parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s.%s", g_value_get_string (yymsp[-4].minor.yy361), 
							 g_value_get_string (yymsp[-2].minor.yy361), g_value_get_string (yymsp[0].minor.yy0));
				  yygotominor.yy361 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy361, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy361, str);
				  g_value_reset (yymsp[-4].minor.yy361); g_free (yymsp[-4].minor.yy361);
				  g_value_reset (yymsp[-2].minor.yy361); g_free (yymsp[-2].minor.yy361);
				  g_value_reset (yymsp[0].minor.yy0); g_free (yymsp[0].minor.yy0);
  yy_destructor(141,&yymsp[-3].minor);
  yy_destructor(141,&yymsp[-1].minor);
}
#line 2978 "parser.c"
        break;
      case 123: /* as ::= AS fullname */
      case 124: /* as ::= AS value */
#line 745 "./parser.y"
{yygotominor.yy361 = yymsp[0].minor.yy361;  yy_destructor(142,&yymsp[-1].minor);
}
#line 2985 "parser.c"
        break;
      case 126: /* distinct ::= */
#line 751 "./parser.y"
{yygotominor.yy189 = NULL;}
#line 2990 "parser.c"
        break;
      case 127: /* distinct ::= ALL */
#line 752 "./parser.y"
{yygotominor.yy189 = NULL;  yy_destructor(131,&yymsp[0].minor);
}
#line 2996 "parser.c"
        break;
      case 128: /* distinct ::= DISTINCT */
#line 753 "./parser.y"
{yygotominor.yy189 = g_new0 (Distinct, 1); yygotominor.yy189->distinct = TRUE;  yy_destructor(143,&yymsp[0].minor);
}
#line 3002 "parser.c"
        break;
      case 129: /* distinct ::= DISTINCT ON expr */
#line 754 "./parser.y"
{yygotominor.yy189 = g_new0 (Distinct, 1); yygotominor.yy189->distinct = TRUE; yygotominor.yy189->expr = yymsp[0].minor.yy328;  yy_destructor(143,&yymsp[-2].minor);
  yy_destructor(139,&yymsp[-1].minor);
}
#line 3009 "parser.c"
        break;
      case 130: /* nexprlist ::= nexprlist COMMA expr */
      case 133: /* exprlist ::= exprlist COMMA expr */
#line 759 "./parser.y"
{yygotominor.yy247 = g_slist_append (yymsp[-2].minor.yy247, yymsp[0].minor.yy328);  yy_destructor(120,&yymsp[-1].minor);
}
#line 3016 "parser.c"
        break;
      case 131: /* nexprlist ::= expr */
      case 134: /* exprlist ::= expr */
#line 760 "./parser.y"
{yygotominor.yy247 = g_slist_append (NULL, yymsp[0].minor.yy328);}
#line 3022 "parser.c"
        break;
      case 135: /* expr ::= pvalue */
#line 772 "./parser.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;}
#line 3027 "parser.c"
        break;
      case 136: /* expr ::= value */
      case 138: /* expr ::= fullname */
#line 773 "./parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); yygotominor.yy328->value = yymsp[0].minor.yy361;}
#line 3033 "parser.c"
        break;
      case 137: /* expr ::= LP expr RP */
#line 774 "./parser.y"
{yygotominor.yy328 = yymsp[-1].minor.yy328;  yy_destructor(102,&yymsp[-2].minor);
  yy_destructor(103,&yymsp[0].minor);
}
#line 3040 "parser.c"
        break;
      case 139: /* expr ::= fullname LP exprlist RP */
#line 776 "./parser.y"
{GdaSqlFunction *func;
					    yygotominor.yy328 = gda_sql_expr_new (NULL); 
					    func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy328)); 
					    gda_sql_function_take_name (func, yymsp[-3].minor.yy361);
					    gda_sql_function_take_args_list (func, yymsp[-1].minor.yy247);
					    yygotominor.yy328->func = func;  yy_destructor(102,&yymsp[-2].minor);
  yy_destructor(103,&yymsp[0].minor);
}
#line 3052 "parser.c"
        break;
      case 140: /* expr ::= fullname LP compound RP */
#line 782 "./parser.y"
{GdaSqlFunction *func;
					     GdaSqlExpr *expr;
					     yygotominor.yy328 = gda_sql_expr_new (NULL); 
					     func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy328)); 
					     gda_sql_function_take_name (func, yymsp[-3].minor.yy361);
					     expr = gda_sql_expr_new (GDA_SQL_ANY_PART (func)); 
					     gda_sql_expr_take_select (expr, yymsp[-1].minor.yy308);
					     gda_sql_function_take_args_list (func, g_slist_prepend (NULL, expr));
					     yygotominor.yy328->func = func;  yy_destructor(102,&yymsp[-2].minor);
  yy_destructor(103,&yymsp[0].minor);
}
#line 3067 "parser.c"
        break;
      case 141: /* expr ::= fullname LP starname RP */
#line 791 "./parser.y"
{GdaSqlFunction *func;
					    GdaSqlExpr *expr;
					    yygotominor.yy328 = gda_sql_expr_new (NULL); 
					    func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					    gda_sql_function_take_name (func, yymsp[-3].minor.yy361);
					    expr = gda_sql_expr_new (GDA_SQL_ANY_PART (func)); 
					    expr->value = yymsp[-1].minor.yy361;
					    gda_sql_function_take_args_list (func, g_slist_prepend (NULL, expr));
					    yygotominor.yy328->func = func;  yy_destructor(102,&yymsp[-2].minor);
  yy_destructor(103,&yymsp[0].minor);
}
#line 3082 "parser.c"
        break;
      case 142: /* expr ::= CAST LP expr AS fullname RP */
#line 800 "./parser.y"
{yygotominor.yy328 = yymsp[-3].minor.yy328;
						yymsp[-3].minor.yy328->cast_as = g_value_dup_string (yymsp[-1].minor.yy361);
						g_value_reset (yymsp[-1].minor.yy361);
						g_free (yymsp[-1].minor.yy361);  yy_destructor(10,&yymsp[-5].minor);
  yy_destructor(102,&yymsp[-4].minor);
  yy_destructor(142,&yymsp[-2].minor);
  yy_destructor(103,&yymsp[0].minor);
}
#line 3094 "parser.c"
        break;
      case 143: /* expr ::= expr PGCAST fullname */
#line 804 "./parser.y"
{yygotominor.yy328 = yymsp[-2].minor.yy328;
					 yymsp[-2].minor.yy328->cast_as = g_value_dup_string (yymsp[0].minor.yy361);
					 g_value_reset (yymsp[0].minor.yy361);
					 g_free (yymsp[0].minor.yy361);  yy_destructor(114,&yymsp[-1].minor);
}
#line 3103 "parser.c"
        break;
      case 144: /* expr ::= expr PLUS|MINUS expr */
#line 809 "./parser.y"
{yygotominor.yy328 = compose_multiple_expr (string_to_op_type (yymsp[-1].minor.yy0), yymsp[-2].minor.yy328, yymsp[0].minor.yy328);}
#line 3108 "parser.c"
        break;
      case 145: /* expr ::= expr STAR expr */
#line 810 "./parser.y"
{yygotominor.yy328 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_STAR, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(94,&yymsp[-1].minor);
}
#line 3114 "parser.c"
        break;
      case 146: /* expr ::= expr SLASH|REM expr */
      case 147: /* expr ::= expr BITAND|BITOR expr */
      case 153: /* expr ::= expr GT|LEQ|GEQ|LT expr */
      case 154: /* expr ::= expr DIFF|EQ expr */
      case 156: /* expr ::= expr REGEXP|REGEXP_CI|NOT_REGEXP|NOT_REGEXP_CI|SIMILAR expr */
#line 811 "./parser.y"
{yygotominor.yy328 = create_two_expr (string_to_op_type (yymsp[-1].minor.yy0), yymsp[-2].minor.yy328, yymsp[0].minor.yy328);}
#line 3123 "parser.c"
        break;
      case 148: /* expr ::= MINUS expr */
#line 814 "./parser.y"
{yygotominor.yy328 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_MINUS, yymsp[0].minor.yy328);  yy_destructor(93,&yymsp[-1].minor);
}
#line 3129 "parser.c"
        break;
      case 149: /* expr ::= PLUS expr */
#line 815 "./parser.y"
{yygotominor.yy328 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_PLUS, yymsp[0].minor.yy328);  yy_destructor(92,&yymsp[-1].minor);
}
#line 3135 "parser.c"
        break;
      case 150: /* expr ::= expr AND expr */
#line 817 "./parser.y"
{yygotominor.yy328 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_AND, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(69,&yymsp[-1].minor);
}
#line 3141 "parser.c"
        break;
      case 151: /* expr ::= expr OR expr */
#line 818 "./parser.y"
{yygotominor.yy328 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_OR, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(68,&yymsp[-1].minor);
}
#line 3147 "parser.c"
        break;
      case 152: /* expr ::= expr CONCAT expr */
#line 819 "./parser.y"
{yygotominor.yy328 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_CONCAT, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(97,&yymsp[-1].minor);
}
#line 3153 "parser.c"
        break;
      case 155: /* expr ::= expr LIKE expr */
#line 823 "./parser.y"
{yygotominor.yy328 = create_two_expr (GDA_SQL_OPERATOR_TYPE_LIKE, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(26,&yymsp[-1].minor);
}
#line 3159 "parser.c"
        break;
      case 157: /* expr ::= expr BETWEEN expr AND expr */
#line 825 "./parser.y"
{GdaSqlOperation *cond;
						  yygotominor.yy328 = gda_sql_expr_new (NULL);
						  cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
						  yygotominor.yy328->cond = cond;
						  cond->operator_type = GDA_SQL_OPERATOR_TYPE_BETWEEN;
						  cond->operands = g_slist_append (NULL, yymsp[-4].minor.yy328);
						  GDA_SQL_ANY_PART (yymsp[-4].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
						  cond->operands = g_slist_append (cond->operands, yymsp[-2].minor.yy328);
						  GDA_SQL_ANY_PART (yymsp[-2].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
						  cond->operands = g_slist_append (cond->operands, yymsp[0].minor.yy328);
						  GDA_SQL_ANY_PART (yymsp[0].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(77,&yymsp[-3].minor);
  yy_destructor(69,&yymsp[-1].minor);
}
#line 3177 "parser.c"
        break;
      case 158: /* expr ::= expr NOT BETWEEN expr AND expr */
#line 838 "./parser.y"
{GdaSqlOperation *cond;
						      GdaSqlExpr *expr;
						      expr = gda_sql_expr_new (NULL);
						      cond = gda_sql_operation_new (GDA_SQL_ANY_PART (expr));
						      expr->cond = cond;
						      cond->operator_type = GDA_SQL_OPERATOR_TYPE_BETWEEN;
						      cond->operands = g_slist_append (NULL, yymsp[-5].minor.yy328);
						      GDA_SQL_ANY_PART (yymsp[-5].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
						      cond->operands = g_slist_append (cond->operands, yymsp[-2].minor.yy328);
						      GDA_SQL_ANY_PART (yymsp[-2].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
						      cond->operands = g_slist_append (cond->operands, yymsp[0].minor.yy328);
						      GDA_SQL_ANY_PART (yymsp[0].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);

						      yygotominor.yy328 = gda_sql_expr_new (NULL);
						      cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
						      yygotominor.yy328->cond = cond;
						      cond->operator_type = GDA_SQL_OPERATOR_TYPE_NOT;
						      cond->operands = g_slist_prepend (NULL, expr);
						      GDA_SQL_ANY_PART (expr)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(70,&yymsp[-4].minor);
  yy_destructor(77,&yymsp[-3].minor);
  yy_destructor(69,&yymsp[-1].minor);
}
#line 3204 "parser.c"
        break;
      case 159: /* expr ::= NOT expr */
#line 859 "./parser.y"
{yygotominor.yy328 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_NOT, yymsp[0].minor.yy328);  yy_destructor(70,&yymsp[-1].minor);
}
#line 3210 "parser.c"
        break;
      case 160: /* expr ::= BITNOT expr */
#line 860 "./parser.y"
{yygotominor.yy328 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_BITNOT, yymsp[0].minor.yy328);  yy_destructor(101,&yymsp[-1].minor);
}
#line 3216 "parser.c"
        break;
      case 161: /* expr ::= expr uni_op */
#line 861 "./parser.y"
{yygotominor.yy328 = create_uni_expr (yymsp[0].minor.yy381, yymsp[-1].minor.yy328);}
#line 3221 "parser.c"
        break;
      case 162: /* expr ::= expr IS expr */
#line 863 "./parser.y"
{yygotominor.yy328 = create_two_expr (GDA_SQL_OPERATOR_TYPE_IS, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(71,&yymsp[-1].minor);
}
#line 3227 "parser.c"
        break;
      case 163: /* expr ::= LP compound RP */
#line 864 "./parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); gda_sql_expr_take_select (yygotominor.yy328, yymsp[-1].minor.yy308);  yy_destructor(102,&yymsp[-2].minor);
  yy_destructor(103,&yymsp[0].minor);
}
#line 3234 "parser.c"
        break;
      case 164: /* expr ::= expr IN LP exprlist RP */
#line 865 "./parser.y"
{GdaSqlOperation *cond;
					   GSList *list;
					   yygotominor.yy328 = gda_sql_expr_new (NULL);
					   cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					   yygotominor.yy328->cond = cond;
					   cond->operator_type = GDA_SQL_OPERATOR_TYPE_IN;
					   cond->operands = g_slist_prepend (yymsp[-1].minor.yy247, yymsp[-4].minor.yy328);
					   for (list = cond->operands; list; list = list->next)
						   GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(72,&yymsp[-3].minor);
  yy_destructor(102,&yymsp[-2].minor);
  yy_destructor(103,&yymsp[0].minor);
}
#line 3251 "parser.c"
        break;
      case 165: /* expr ::= expr IN LP compound RP */
#line 875 "./parser.y"
{GdaSqlOperation *cond;
					    GdaSqlExpr *expr;
					    yygotominor.yy328 = gda_sql_expr_new (NULL);
					    cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					    yygotominor.yy328->cond = cond;
					    cond->operator_type = GDA_SQL_OPERATOR_TYPE_IN;
					    
					    expr = gda_sql_expr_new (GDA_SQL_ANY_PART (cond));
					    gda_sql_expr_take_select (expr, yymsp[-1].minor.yy308);
					    cond->operands = g_slist_prepend (NULL, expr);
					    cond->operands = g_slist_prepend (cond->operands, yymsp[-4].minor.yy328);
					    GDA_SQL_ANY_PART (yymsp[-4].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(72,&yymsp[-3].minor);
  yy_destructor(102,&yymsp[-2].minor);
  yy_destructor(103,&yymsp[0].minor);
}
#line 3271 "parser.c"
        break;
      case 166: /* expr ::= expr NOT IN LP exprlist RP */
#line 888 "./parser.y"
{GdaSqlOperation *cond;
					       GSList *list;
					       yygotominor.yy328 = gda_sql_expr_new (NULL);
					       cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					       yygotominor.yy328->cond = cond;
					       cond->operator_type = GDA_SQL_OPERATOR_TYPE_NOTIN;
					       cond->operands = g_slist_prepend (yymsp[-1].minor.yy247, yymsp[-5].minor.yy328);
					       for (list = cond->operands; list; list = list->next)
						       GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(70,&yymsp[-4].minor);
  yy_destructor(72,&yymsp[-3].minor);
  yy_destructor(102,&yymsp[-2].minor);
  yy_destructor(103,&yymsp[0].minor);
}
#line 3289 "parser.c"
        break;
      case 167: /* expr ::= expr NOT IN LP compound RP */
#line 898 "./parser.y"
{GdaSqlOperation *cond;
					       GdaSqlExpr *expr;
					       yygotominor.yy328 = gda_sql_expr_new (NULL);
					       cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					       yygotominor.yy328->cond = cond;
					       cond->operator_type = GDA_SQL_OPERATOR_TYPE_NOTIN;
					       
					       expr = gda_sql_expr_new (GDA_SQL_ANY_PART (cond));
					       gda_sql_expr_take_select (expr, yymsp[-1].minor.yy308);
					       cond->operands = g_slist_prepend (NULL, expr);
					       cond->operands = g_slist_prepend (cond->operands, yymsp[-5].minor.yy328);
					       GDA_SQL_ANY_PART (yymsp[-5].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(70,&yymsp[-4].minor);
  yy_destructor(72,&yymsp[-3].minor);
  yy_destructor(102,&yymsp[-2].minor);
  yy_destructor(103,&yymsp[0].minor);
}
#line 3310 "parser.c"
        break;
      case 168: /* expr ::= CASE case_operand case_exprlist case_else END */
#line 911 "./parser.y"
{
	GdaSqlCase *sc;
	GSList *list;
	yygotominor.yy328 = gda_sql_expr_new (NULL);
	sc = gda_sql_case_new (GDA_SQL_ANY_PART (yygotominor.yy328));
	sc->base_expr = yymsp[-3].minor.yy122;
	sc->else_expr = yymsp[-1].minor.yy122;
	sc->when_expr_list = yymsp[-2].minor.yy263.when_list;
	sc->then_expr_list = yymsp[-2].minor.yy263.then_list;
	yygotominor.yy328->case_s = sc;
	for (list = sc->when_expr_list; list; list = list->next)
		GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (sc);
	for (list = sc->then_expr_list; list; list = list->next)
		GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (sc);
  yy_destructor(144,&yymsp[-4].minor);
  yy_destructor(17,&yymsp[0].minor);
}
#line 3331 "parser.c"
        break;
      case 169: /* case_operand ::= expr */
#line 929 "./parser.y"
{yygotominor.yy122 = yymsp[0].minor.yy328;}
#line 3336 "parser.c"
        break;
      case 170: /* case_operand ::= */
      case 174: /* case_else ::= */
#line 930 "./parser.y"
{yygotominor.yy122 = NULL;}
#line 3342 "parser.c"
        break;
      case 171: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
#line 936 "./parser.y"
{
	yygotominor.yy263.when_list = g_slist_append (yymsp[-4].minor.yy263.when_list, yymsp[-2].minor.yy328);
	yygotominor.yy263.then_list = g_slist_append (yymsp[-4].minor.yy263.then_list, yymsp[0].minor.yy328);
  yy_destructor(145,&yymsp[-3].minor);
  yy_destructor(146,&yymsp[-1].minor);
}
#line 3352 "parser.c"
        break;
      case 172: /* case_exprlist ::= WHEN expr THEN expr */
#line 940 "./parser.y"
{
	yygotominor.yy263.when_list = g_slist_prepend (NULL, yymsp[-2].minor.yy328);
	yygotominor.yy263.then_list = g_slist_prepend (NULL, yymsp[0].minor.yy328);
  yy_destructor(145,&yymsp[-3].minor);
  yy_destructor(146,&yymsp[-1].minor);
}
#line 3362 "parser.c"
        break;
      case 173: /* case_else ::= ELSE expr */
#line 947 "./parser.y"
{yygotominor.yy122 = yymsp[0].minor.yy328;  yy_destructor(147,&yymsp[-1].minor);
}
#line 3368 "parser.c"
        break;
      case 175: /* uni_op ::= ISNULL */
#line 951 "./parser.y"
{yygotominor.yy381 = GDA_SQL_OPERATOR_TYPE_ISNULL;  yy_destructor(73,&yymsp[0].minor);
}
#line 3374 "parser.c"
        break;
      case 176: /* uni_op ::= IS NOTNULL */
#line 952 "./parser.y"
{yygotominor.yy381 = GDA_SQL_OPERATOR_TYPE_ISNOTNULL;  yy_destructor(71,&yymsp[-1].minor);
  yy_destructor(74,&yymsp[0].minor);
}
#line 3381 "parser.c"
        break;
      case 177: /* value ::= NULL */
#line 956 "./parser.y"
{yygotominor.yy361 = NULL;  yy_destructor(148,&yymsp[0].minor);
}
#line 3387 "parser.c"
        break;
      case 181: /* pvalue ::= UNSPECVAL LSBRACKET paramspec RSBRACKET */
#line 965 "./parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); yygotominor.yy328->param_spec = yymsp[-1].minor.yy405;  yy_destructor(150,&yymsp[-3].minor);
  yy_destructor(151,&yymsp[-2].minor);
  yy_destructor(152,&yymsp[0].minor);
}
#line 3395 "parser.c"
        break;
      case 182: /* pvalue ::= value LSBRACKET paramspec RSBRACKET */
#line 966 "./parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); yygotominor.yy328->value = yymsp[-3].minor.yy361; yygotominor.yy328->param_spec = yymsp[-1].minor.yy405;  yy_destructor(151,&yymsp[-2].minor);
  yy_destructor(152,&yymsp[0].minor);
}
#line 3402 "parser.c"
        break;
      case 183: /* pvalue ::= SIMPLEPARAM */
#line 967 "./parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); yygotominor.yy328->param_spec = gda_sql_param_spec_new (yymsp[0].minor.yy0);}
#line 3407 "parser.c"
        break;
      case 184: /* paramspec ::= */
#line 972 "./parser.y"
{yygotominor.yy405 = NULL;}
#line 3412 "parser.c"
        break;
      case 185: /* paramspec ::= paramspec PNAME */
#line 973 "./parser.y"
{if (!yymsp[-1].minor.yy405) yygotominor.yy405 = gda_sql_param_spec_new (NULL); else yygotominor.yy405 = yymsp[-1].minor.yy405; 
					 gda_sql_param_spec_take_name (yygotominor.yy405, yymsp[0].minor.yy0);}
#line 3418 "parser.c"
        break;
      case 186: /* paramspec ::= paramspec PDESCR */
#line 975 "./parser.y"
{if (!yymsp[-1].minor.yy405) yygotominor.yy405 = gda_sql_param_spec_new (NULL); else yygotominor.yy405 = yymsp[-1].minor.yy405; 
					 gda_sql_param_spec_take_descr (yygotominor.yy405, yymsp[0].minor.yy0);}
#line 3424 "parser.c"
        break;
      case 187: /* paramspec ::= paramspec PTYPE */
#line 977 "./parser.y"
{if (!yymsp[-1].minor.yy405) yygotominor.yy405 = gda_sql_param_spec_new (NULL); else yygotominor.yy405 = yymsp[-1].minor.yy405; 
					 gda_sql_param_spec_take_type (yygotominor.yy405, yymsp[0].minor.yy0);}
#line 3430 "parser.c"
        break;
      case 188: /* paramspec ::= paramspec PNULLOK */
#line 979 "./parser.y"
{if (!yymsp[-1].minor.yy405) yygotominor.yy405 = gda_sql_param_spec_new (NULL); else yygotominor.yy405 = yymsp[-1].minor.yy405; 
					   gda_sql_param_spec_take_nullok (yygotominor.yy405, yymsp[0].minor.yy0);}
#line 3436 "parser.c"
        break;
      case 193: /* fullname ::= nm DOT nm */
#line 990 "./parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s", g_value_get_string (yymsp[-2].minor.yy361), g_value_get_string (yymsp[0].minor.yy361));
				  yygotominor.yy361 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy361, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy361, str);
				  g_value_reset (yymsp[-2].minor.yy361); g_free (yymsp[-2].minor.yy361);
				  g_value_reset (yymsp[0].minor.yy361); g_free (yymsp[0].minor.yy361);
  yy_destructor(141,&yymsp[-1].minor);
}
#line 3449 "parser.c"
        break;
      case 194: /* fullname ::= nm DOT nm DOT nm */
#line 999 "./parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s.%s", g_value_get_string (yymsp[-4].minor.yy361), 
							 g_value_get_string (yymsp[-2].minor.yy361), g_value_get_string (yymsp[0].minor.yy361));
				  yygotominor.yy361 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy361, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy361, str);
				  g_value_reset (yymsp[-4].minor.yy361); g_free (yymsp[-4].minor.yy361);
				  g_value_reset (yymsp[-2].minor.yy361); g_free (yymsp[-2].minor.yy361);
				  g_value_reset (yymsp[0].minor.yy361); g_free (yymsp[0].minor.yy361);
  yy_destructor(141,&yymsp[-3].minor);
  yy_destructor(141,&yymsp[-1].minor);
}
#line 3465 "parser.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  gda_sql_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  gda_sql_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  gda_sql_parserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 22 "./parser.y"

	gda_sql_parser_set_syntax_error (pdata->parser);
#line 3527 "parser.c"
  gda_sql_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  gda_sql_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  gda_sql_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "gda_sql_parserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void gda_sql_parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  gda_sql_parserTOKENTYPE yyminor       /* The value for the token */
  gda_sql_parserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      memset(&yyminorunion, 0, sizeof(yyminorunion));
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  gda_sql_parserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      assert( !yyendofinput );  /* Impossible to shift the $ token */
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
