/**
 * @file libgalago-gtk/galago-gtk-contact-chooser.c
 *       Contact chooser interface
 *
 * @Copyright (C) 2005-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <libgalago-gtk/galago-gtk-contact-chooser.h>

static void galago_gtk_contact_chooser_base_init(GalagoGtkContactChooserIface *klass);

GType
galago_gtk_contact_chooser_get_type(void)
{
	static GType type = 0;

	if (!type)
	{
		static const GTypeInfo info =
		{
			sizeof(GalagoGtkContactChooserIface),
			(GBaseInitFunc)galago_gtk_contact_chooser_base_init,
			NULL,
		};

		type = g_type_register_static(G_TYPE_INTERFACE,
									  "GalagoGtkContactChooser", &info, 0);
	}

	return type;
}

static void
galago_gtk_contact_chooser_base_init(GalagoGtkContactChooserIface *iface)
{
	static gboolean initialized = FALSE;

	if (!initialized)
	{
		g_signal_new("selection-changed",
					 G_TYPE_FROM_INTERFACE(iface),
					 G_SIGNAL_RUN_LAST,
					 G_STRUCT_OFFSET(GalagoGtkContactChooserIface,
									 selection_changed),
					 NULL, NULL,
					 g_cclosure_marshal_VOID__VOID,
					 G_TYPE_NONE, 0);

		g_signal_new("activated",
					 G_TYPE_FROM_INTERFACE(iface),
					 G_SIGNAL_RUN_LAST,
					 G_STRUCT_OFFSET(GalagoGtkContactChooserIface, activated),
					 NULL, NULL,
					 g_cclosure_marshal_VOID__VOID,
					 G_TYPE_NONE, 0);

		initialized = TRUE;
	}
}

void
galago_gtk_contact_chooser_set_service_type(GalagoGtkContactChooser *chooser,
											GalagoGtkServiceListItemType type)
{
	g_return_if_fail(chooser != NULL);
	g_return_if_fail(GALAGO_GTK_IS_CONTACT_CHOOSER(chooser));

	GALAGO_GTK_CONTACT_CHOOSER_GET_IFACE(chooser)->set_service_type(chooser,
																	type);
}

void
galago_gtk_contact_chooser_set_service(GalagoGtkContactChooser *chooser,
									   GalagoService *service)
{
	g_return_if_fail(chooser != NULL);
	g_return_if_fail(GALAGO_GTK_IS_CONTACT_CHOOSER(chooser));

	galago_gtk_contact_chooser_set_service_type(chooser,
		(service == NULL
		 ? GALAGO_GTK_SERVICE_LIST_ITEM_ALL_CONTACTS
		 : GALAGO_GTK_SERVICE_LIST_ITEM_SERVICE));

	GALAGO_GTK_CONTACT_CHOOSER_GET_IFACE(chooser)->set_service(chooser,
															   service);
}

void
galago_gtk_contact_chooser_set_contact(GalagoGtkContactChooser *chooser,
									   GalagoAccount *contact)
{
	g_return_if_fail(chooser != NULL);
	g_return_if_fail(GALAGO_GTK_IS_CONTACT_CHOOSER(chooser));
	g_return_if_fail(contact != NULL);
	g_return_if_fail(GALAGO_IS_ACCOUNT(contact));

	galago_gtk_contact_chooser_set_service(chooser,
		galago_account_get_service(contact));

	GALAGO_GTK_CONTACT_CHOOSER_GET_IFACE(chooser)->set_contact(chooser,
															   contact);
}

void
galago_gtk_contact_chooser_set_person(GalagoGtkContactChooser *chooser,
									  GalagoPerson *person)
{
	g_return_if_fail(chooser != NULL);
	g_return_if_fail(GALAGO_GTK_IS_CONTACT_CHOOSER(chooser));
	g_return_if_fail(person != NULL);
	g_return_if_fail(GALAGO_IS_PERSON(person));

	galago_gtk_contact_chooser_set_service_type(chooser,
		GALAGO_GTK_SERVICE_LIST_ITEM_PEOPLE);

	GALAGO_GTK_CONTACT_CHOOSER_GET_IFACE(chooser)->set_person(chooser,
															  person);
}

GalagoAccount *
galago_gtk_contact_chooser_get_contact(const GalagoGtkContactChooser *chooser)
{
	g_return_val_if_fail(chooser != NULL,                     NULL);
	g_return_val_if_fail(GALAGO_GTK_CONTACT_CHOOSER(chooser), NULL);

	return GALAGO_GTK_CONTACT_CHOOSER_GET_IFACE(chooser)->get_contact(chooser);
}

GalagoPerson *
galago_gtk_contact_chooser_get_person(const GalagoGtkContactChooser *chooser)
{
	g_return_val_if_fail(chooser != NULL,                     NULL);
	g_return_val_if_fail(GALAGO_GTK_CONTACT_CHOOSER(chooser), NULL);

	return GALAGO_GTK_CONTACT_CHOOSER_GET_IFACE(chooser)->get_person(chooser);
}
