/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc.example;

/**
 * This is thrown on various errors.  This exception may contain a
 * wrapped Throwable object.
 * <p>
 * @author Elias Ross
 * @version 1.0
 */
public class ProvException 
	extends Exception 
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 7811246520895540002L;
	/**
	 * Root cause.
	 */
	Throwable cause;
    
	/**
	 * Construct an XmlRpcException with a message.
	 * @param message message to display.
	 */
    public ProvException(String message) 
	{
		super(message);
		this.cause = this;
	}

	/**
	 * Construct an ProvException with a wrapped Throwable.
	 * @param cause reason for this XmlRpcException
	 */
    public ProvException(Throwable cause) 
	{
		this("ProvException -- ", cause);
    }

	/**
	 * Construct an ProvException with a message and code and wrapped
	 * Throwable.
	 * @param message message to display.
	 * @param cause reason for this XmlRpcException
	 */
    public ProvException(String message, Throwable cause) 
	{
		super(message + " -- " + cause);
		this.cause = cause;
    }

	/**
	 * Gets the root cause of the exception, if any.  May return
	 * <code>this</code> if no cause.
	 * @return the root cause
	 */
	public Throwable getCause() { 
		return cause; 
	}
}
