/* test-vfs-file-monitor.c generated by valac, the Vala compiler
 * generated from test-vfs-file-monitor.vala, do not modify */

/*
 * Desktop Agnostic Library: Test for the file monitor implementations.
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libdesktop-agnostic/vfs.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_TEST_FILE_MONITOR (test_file_monitor_get_type ())
#define TEST_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_FILE_MONITOR, TestFileMonitor))
#define TEST_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_FILE_MONITOR, TestFileMonitorClass))
#define IS_TEST_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_FILE_MONITOR))
#define IS_TEST_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_FILE_MONITOR))
#define TEST_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_FILE_MONITOR, TestFileMonitorClass))

typedef struct _TestFileMonitor TestFileMonitor;
typedef struct _TestFileMonitorClass TestFileMonitorClass;
typedef struct _TestFileMonitorPrivate TestFileMonitorPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ParamSpecTestFileMonitor ParamSpecTestFileMonitor;

struct _TestFileMonitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TestFileMonitorPrivate * priv;
};

struct _TestFileMonitorClass {
	GTypeClass parent_class;
	void (*finalize) (TestFileMonitor *self);
};

struct _ParamSpecTestFileMonitor {
	GParamSpec parent_instance;
};


static DesktopAgnosticVFSFile* test_file_monitor_file;
static DesktopAgnosticVFSFile* test_file_monitor_file = NULL;
static DesktopAgnosticVFSFileMonitor* test_file_monitor_monitor;
static DesktopAgnosticVFSFileMonitor* test_file_monitor_monitor = NULL;
static gpointer test_file_monitor_parent_class = NULL;

gpointer test_file_monitor_ref (gpointer instance);
void test_file_monitor_unref (gpointer instance);
GParamSpec* param_spec_test_file_monitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_test_file_monitor (GValue* value, gpointer v_object);
gpointer value_get_test_file_monitor (const GValue* value);
GType test_file_monitor_get_type (void);
enum  {
	TEST_FILE_MONITOR_DUMMY_PROPERTY
};
static void test_file_monitor_on_change (DesktopAgnosticVFSFileMonitor* monitor, DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* other, DesktopAgnosticVFSFileMonitorEvent event);
static gboolean test_file_monitor_do_emit (void);
static void _test_file_monitor_on_change_desktop_agnostic_vfs_file_monitor_changed (DesktopAgnosticVFSFileMonitor* _sender, DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* other, DesktopAgnosticVFSFileMonitorEvent event, gpointer self);
static gboolean _test_file_monitor_do_emit_gsource_func (gpointer self);
gint test_file_monitor_main (char** args, int args_length1);
TestFileMonitor* test_file_monitor_new (void);
TestFileMonitor* test_file_monitor_construct (GType object_type);
static void test_file_monitor_finalize (TestFileMonitor* obj);



static void test_file_monitor_on_change (DesktopAgnosticVFSFileMonitor* monitor, DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* other, DesktopAgnosticVFSFileMonitorEvent event) {
	char* evt_str;
	char* _tmp5_;
	g_return_if_fail (monitor != NULL);
	g_return_if_fail (file != NULL);
	evt_str = g_strdup ("?");
	switch (event) {
		case DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_CHANGED:
		{
			char* _tmp0_;
			evt_str = (_tmp0_ = g_strdup ("Changed"), _g_free0 (evt_str), _tmp0_);
			break;
		}
		case DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_CREATED:
		{
			char* _tmp1_;
			evt_str = (_tmp1_ = g_strdup ("Created"), _g_free0 (evt_str), _tmp1_);
			break;
		}
		case DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_DELETED:
		{
			char* _tmp2_;
			evt_str = (_tmp2_ = g_strdup ("Deleted"), _g_free0 (evt_str), _tmp2_);
			break;
		}
		case DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED:
		{
			char* _tmp3_;
			evt_str = (_tmp3_ = g_strdup ("Attribute Changed"), _g_free0 (evt_str), _tmp3_);
			break;
		}
		case DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_UNKNOWN:
		{
			char* _tmp4_;
			evt_str = (_tmp4_ = g_strdup ("Unknown"), _g_free0 (evt_str), _tmp4_);
			break;
		}
	}
	g_message ("test-vfs-file-monitor.vala:53: %s: %s", evt_str, _tmp5_ = desktop_agnostic_vfs_file_get_uri (file));
	_g_free0 (_tmp5_);
	if (other != NULL) {
		char* _tmp6_;
		g_message ("test-vfs-file-monitor.vala:56:  * other: %s", _tmp6_ = desktop_agnostic_vfs_file_get_uri (other));
		_g_free0 (_tmp6_);
	}
	_g_free0 (evt_str);
}


static gboolean test_file_monitor_do_emit (void) {
	gboolean result;
	GError * _inner_error_;
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		char* _tmp1_;
		char* filename;
		DesktopAgnosticVFSFile* other;
		filename = (_tmp1_ = g_build_filename (_tmp0_ = desktop_agnostic_vfs_file_get_path (test_file_monitor_file), "test-vfs-file.txt", NULL), _g_free0 (_tmp0_), _tmp1_);
		other = desktop_agnostic_vfs_file_new_for_path (filename, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (filename);
			goto __catch0_g_error;
		}
		desktop_agnostic_vfs_file_monitor_emit (test_file_monitor_monitor, other, DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_CREATED);
		_g_free0 (filename);
		_g_object_unref0 (other);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("test-vfs-file-monitor.vala:70: Error: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static void _test_file_monitor_on_change_desktop_agnostic_vfs_file_monitor_changed (DesktopAgnosticVFSFileMonitor* _sender, DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* other, DesktopAgnosticVFSFileMonitorEvent event, gpointer self) {
	test_file_monitor_on_change (_sender, file, other, event);
}


static gboolean _test_file_monitor_do_emit_gsource_func (gpointer self) {
	return test_file_monitor_do_emit ();
}


gint test_file_monitor_main (char** args, int args_length1) {
	gint result;
	GError * _inner_error_;
	_inner_error_ = NULL;
	if (args_length1 < 2) {
		fprintf (stderr, "Usage: %s [FILE | DIRECTORY FILE] \n", args[0]);
		result = 1;
		return result;
	}
	{
		const char* path;
		DesktopAgnosticVFSFile* _tmp0_;
		DesktopAgnosticVFSFile* _tmp1_;
		DesktopAgnosticVFSFileMonitor* _tmp2_;
		GMainLoop* mainloop;
		gboolean _tmp3_ = FALSE;
		desktop_agnostic_vfs_init (&_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		path = args[1];
		_tmp0_ = desktop_agnostic_vfs_file_new_for_path (path, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		test_file_monitor_file = (_tmp1_ = _tmp0_, _g_object_unref0 (test_file_monitor_file), _tmp1_);
		test_file_monitor_monitor = (_tmp2_ = desktop_agnostic_vfs_file_monitor (test_file_monitor_file), _g_object_unref0 (test_file_monitor_monitor), _tmp2_);
		g_signal_connect (test_file_monitor_monitor, "changed", (GCallback) _test_file_monitor_on_change_desktop_agnostic_vfs_file_monitor_changed, NULL);
		mainloop = g_main_loop_new (NULL, FALSE);
		if (args_length1 == 3) {
			_tmp3_ = desktop_agnostic_vfs_file_get_file_type (test_file_monitor_file) == DESKTOP_AGNOSTIC_VFS_FILE_TYPE_DIRECTORY;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, _test_file_monitor_do_emit_gsource_func, NULL, NULL);
		}
		g_main_loop_run (mainloop);
		desktop_agnostic_vfs_file_monitor_cancel (test_file_monitor_monitor);
		g_assert (desktop_agnostic_vfs_file_monitor_get_cancelled (test_file_monitor_monitor));
		desktop_agnostic_vfs_shutdown (&_inner_error_);
		if (_inner_error_ != NULL) {
			_g_main_loop_unref0 (mainloop);
			goto __catch1_g_error;
		}
		_g_main_loop_unref0 (mainloop);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("test-vfs-file-monitor.vala:102: VFS Error: %s", err->message);
			result = 1;
			_g_error_free0 (err);
			return result;
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return test_file_monitor_main (argv, argc);
}


TestFileMonitor* test_file_monitor_construct (GType object_type) {
	TestFileMonitor* self;
	self = (TestFileMonitor*) g_type_create_instance (object_type);
	return self;
}


TestFileMonitor* test_file_monitor_new (void) {
	return test_file_monitor_construct (TYPE_TEST_FILE_MONITOR);
}


static void value_test_file_monitor_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_test_file_monitor_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		test_file_monitor_unref (value->data[0].v_pointer);
	}
}


static void value_test_file_monitor_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = test_file_monitor_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_test_file_monitor_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_test_file_monitor_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TestFileMonitor* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = test_file_monitor_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_test_file_monitor_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TestFileMonitor** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = test_file_monitor_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_test_file_monitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTestFileMonitor* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TEST_FILE_MONITOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_test_file_monitor (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_FILE_MONITOR), NULL);
	return value->data[0].v_pointer;
}


void value_set_test_file_monitor (GValue* value, gpointer v_object) {
	TestFileMonitor* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_FILE_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEST_FILE_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		test_file_monitor_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		test_file_monitor_unref (old);
	}
}


static void test_file_monitor_class_init (TestFileMonitorClass * klass) {
	test_file_monitor_parent_class = g_type_class_peek_parent (klass);
	TEST_FILE_MONITOR_CLASS (klass)->finalize = test_file_monitor_finalize;
}


static void test_file_monitor_instance_init (TestFileMonitor * self) {
	self->ref_count = 1;
}


static void test_file_monitor_finalize (TestFileMonitor* obj) {
	TestFileMonitor * self;
	self = TEST_FILE_MONITOR (obj);
}


GType test_file_monitor_get_type (void) {
	static GType test_file_monitor_type_id = 0;
	if (test_file_monitor_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { value_test_file_monitor_init, value_test_file_monitor_free_value, value_test_file_monitor_copy_value, value_test_file_monitor_peek_pointer, "p", value_test_file_monitor_collect_value, "p", value_test_file_monitor_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TestFileMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_file_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestFileMonitor), 0, (GInstanceInitFunc) test_file_monitor_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		test_file_monitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TestFileMonitor", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return test_file_monitor_type_id;
}


gpointer test_file_monitor_ref (gpointer instance) {
	TestFileMonitor* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void test_file_monitor_unref (gpointer instance) {
	TestFileMonitor* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TEST_FILE_MONITOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}




