/* test-config.c generated by valac, the Vala compiler
 * generated from test-config.vala, do not modify */

/*
 * Desktop Agnostic Library: Test for the config backend implementations.
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libdesktop-agnostic/config.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_TEST_CASE (test_case_get_type ())
#define TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_CASE, TestCase))
#define TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_CASE, TestCaseClass))
#define IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_CASE))
#define IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_CASE))
#define TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_CASE, TestCaseClass))

typedef struct _TestCase TestCase;
typedef struct _TestCaseClass TestCaseClass;
typedef struct _TestCasePrivate TestCasePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _test_case_unref0(var) ((var == NULL) ? NULL : (var = (test_case_unref (var), NULL)))
typedef struct _ParamSpecTestCase ParamSpecTestCase;

typedef enum  {
	ASSERTION_ERROR_NOT_EQUAL,
	ASSERTION_ERROR_INVALID_TYPE,
	ASSERTION_ERROR_NOT_REACHED
} AssertionError;
#define ASSERTION_ERROR assertion_error_quark ()
struct _TestCase {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TestCasePrivate * priv;
};

struct _TestCaseClass {
	GTypeClass parent_class;
	void (*finalize) (TestCase *self);
};

struct _TestCasePrivate {
	DesktopAgnosticConfigBackend* cfg;
	guint notify_counter;
	GMainLoop* ml;
	gint retval;
};

typedef void (*TestCaseGetCfgFunc) (DesktopAgnosticConfigBackend* cfg, const char* group, const char* key, GError** error);
struct _ParamSpecTestCase {
	GParamSpec parent_instance;
};


static gpointer test_case_parent_class = NULL;

GQuark assertion_error_quark (void);
#define EXIT_SUCCESS 0
#define EXIT_ASSERTION 1
#define EXIT_EXCEPTION 2
gpointer test_case_ref (gpointer instance);
void test_case_unref (gpointer instance);
GParamSpec* param_spec_test_case (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_test_case (GValue* value, gpointer v_object);
gpointer value_get_test_case (const GValue* value);
GType test_case_get_type (void);
#define TEST_CASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEST_CASE, TestCasePrivate))
enum  {
	TEST_CASE_DUMMY_PROPERTY
};
TestCase* test_case_new (GError** error);
TestCase* test_case_construct (GType object_type, GError** error);
static void test_case_on_string_changed (TestCase* self, const char* group, const char* key, GValue* value);
static void test_case_on_string_changed2 (TestCase* self, const char* group, const char* key, GValue* value);
static void test_case_assert_equals (TestCase* self, GValue* expected, GValue* actual, GError** error);
static gboolean test_case_array_equals (TestCase* self, GValueArray* expected, GValueArray* actual, GError** error);
static void test_case_test_default_empty_list (TestCase* self, const char* suffix, GError** error);
static void test_case_test_defaults (TestCase* self, GError** error);
static void test_case_test_set_empty_list (TestCase* self, const char* key, GError** error);
static void test_case_test_set (TestCase* self, GError** error);
static void test_case_update_notify_value (TestCase* self, GMainContext* ctx, const char* value, guint counter_expected, GError** error);
static void _test_case_on_string_changed_desktop_agnostic_config_notify_func (const char* group, const char* key, GValue* value, gpointer self);
static void _test_case_on_string_changed2_desktop_agnostic_config_notify_func (const char* group, const char* key, GValue* value, gpointer self);
static void test_case_test_notify (TestCase* self, GError** error);
static void test_case_test_invalid_func (TestCase* self, TestCaseGetCfgFunc func, GError** error);
static void test_case_test_invalid (TestCase* self, GError** error);
gint test_case_main (char** args, int args_length1);
static void test_case_finalize (TestCase* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark assertion_error_quark (void) {
	return g_quark_from_static_string ("assertion_error-quark");
}


TestCase* test_case_construct (GType object_type, GError** error) {
	GError * _inner_error_;
	TestCase* self;
	DesktopAgnosticConfigSchema* schema;
	DesktopAgnosticConfigSchema* _tmp1_;
	DesktopAgnosticConfigSchema* _tmp0_;
	DesktopAgnosticConfigBackend* _tmp2_;
	DesktopAgnosticConfigBackend* _tmp3_;
	DesktopAgnosticConfigBackend* _tmp4_;
	GMainLoop* _tmp5_;
	_inner_error_ = NULL;
	self = (TestCase*) g_type_create_instance (object_type);
	schema = desktop_agnostic_config_schema_new ("test-config.schema-ini", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		test_case_unref (self);
		return NULL;
	}
	_tmp3_ = (_tmp2_ = desktop_agnostic_config_new (_tmp1_ = (_tmp0_ = schema, schema = NULL, _tmp0_), &_inner_error_), _g_object_unref0 (_tmp1_), _tmp2_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (schema);
		test_case_unref (self);
		return NULL;
	}
	self->priv->cfg = (_tmp4_ = _tmp3_, _g_object_unref0 (self->priv->cfg), _tmp4_);
	self->priv->notify_counter = (guint) 0;
	self->priv->ml = (_tmp5_ = g_main_loop_new (NULL, FALSE), _g_main_loop_unref0 (self->priv->ml), _tmp5_);
	self->priv->retval = 0;
	_g_object_unref0 (schema);
	return self;
}


TestCase* test_case_new (GError** error) {
	return test_case_construct (TYPE_TEST_CASE, error);
}


static void test_case_on_string_changed (TestCase* self, const char* group, const char* key, GValue* value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	self->priv->notify_counter++;
}


static gboolean string_contains (const char* self, const char* needle) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	result = strstr (self, needle) != NULL;
	return result;
}


static void test_case_on_string_changed2 (TestCase* self, const char* group, const char* key, GValue* value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	if (string_contains (g_value_get_string (value), "quux")) {
		self->priv->notify_counter = self->priv->notify_counter + ((guint) 3);
	}
}


static gboolean test_case_array_equals (TestCase* self, GValueArray* expected, GValueArray* actual, GError** error) {
	gboolean result;
	GError * _inner_error_;
	gboolean equal;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (expected != NULL, FALSE);
	g_return_val_if_fail (actual != NULL, FALSE);
	_inner_error_ = NULL;
	equal = TRUE;
	if (expected->n_values == actual->n_values) {
		{
			guint i;
			i = (guint) 0;
			{
				gboolean _tmp0_;
				_tmp0_ = TRUE;
				while (TRUE) {
					if (!_tmp0_) {
						i++;
					}
					_tmp0_ = FALSE;
					if (!(i < actual->n_values)) {
						break;
					}
					test_case_assert_equals (self, g_value_array_get_nth (expected, i), g_value_array_get_nth (actual, i), &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ASSERTION_ERROR) {
							g_propagate_error (error, _inner_error_);
							return FALSE;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
				}
			}
		}
	} else {
		equal = FALSE;
	}
	result = equal;
	return result;
}


static void test_case_assert_equals (TestCase* self, GValue* expected, GValue* actual, GError** error) {
	GError * _inner_error_;
	gboolean equal;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	equal = TRUE;
	if (G_VALUE_HOLDS (actual, G_TYPE_BOOLEAN)) {
		equal = g_value_get_boolean (expected) == g_value_get_boolean (actual);
	} else {
		if (G_VALUE_HOLDS (actual, G_TYPE_INT)) {
			equal = g_value_get_int (expected) == g_value_get_int (actual);
		} else {
			if (G_VALUE_HOLDS (actual, G_TYPE_FLOAT)) {
				equal = g_value_get_float (expected) == g_value_get_float (actual);
			} else {
				if (G_VALUE_HOLDS (actual, G_TYPE_STRING)) {
					equal = _vala_strcmp0 (g_value_get_string (expected), g_value_get_string (actual)) == 0;
				} else {
					if (G_VALUE_HOLDS (actual, G_TYPE_VALUE_ARRAY)) {
						gboolean _tmp0_;
						_tmp0_ = test_case_array_equals (self, g_value_get_boxed (expected), g_value_get_boxed (actual), &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == ASSERTION_ERROR) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						equal = _tmp0_;
					} else {
						_inner_error_ = g_error_new (ASSERTION_ERROR, ASSERTION_ERROR_INVALID_TYPE, "Invalid value type (%s).", g_type_name (G_VALUE_TYPE (actual)));
						{
							if (_inner_error_->domain == ASSERTION_ERROR) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					}
				}
			}
		}
	}
	if (!equal) {
		char* _tmp2_;
		char* _tmp1_;
		GError* _tmp3_;
		_inner_error_ = (_tmp3_ = g_error_new (ASSERTION_ERROR, ASSERTION_ERROR_NOT_EQUAL, "%s != %s", _tmp1_ = g_strdup_value_contents (expected), _tmp2_ = g_strdup_value_contents (actual)), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _tmp3_);
		{
			if (_inner_error_->domain == ASSERTION_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


static void test_case_test_default_empty_list (TestCase* self, const char* suffix, GError** error) {
	GError * _inner_error_;
	GValueArray* expected_array;
	GValue expected = {0};
	char* key;
	GValueArray* _tmp0_;
	GValue _tmp2_;
	GValue _tmp1_ = {0};
	char* _tmp3_;
	GValue _tmp4_ = {0};
	GValue _tmp5_;
	GValue _tmp7_;
	GValue _tmp6_;
	GValueArray* _tmp8_;
	GValueArray* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (suffix != NULL);
	_inner_error_ = NULL;
	expected_array = NULL;
	key = NULL;
	expected_array = (_tmp0_ = g_value_array_new ((guint) 0), _g_value_array_free0 (expected_array), _tmp0_);
	expected = (_tmp2_ = (g_value_init (&_tmp1_, G_TYPE_VALUE_ARRAY), g_value_set_boxed (&_tmp1_, expected_array), _tmp1_), G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL, _tmp2_);
	key = (_tmp3_ = g_strdup_printf ("list-%s", suffix), _g_free0 (key), _tmp3_);
	_tmp5_ = (desktop_agnostic_config_backend_get_value (self->priv->cfg, "empty", key, &_tmp4_, &_inner_error_), _tmp4_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (expected_array);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		_g_free0 (key);
		return;
	}
	test_case_assert_equals (self, &expected, (_tmp7_ = _tmp6_ = _tmp5_, &_tmp7_), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (expected_array);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		_g_free0 (key);
		return;
	}
	G_IS_VALUE (&_tmp6_) ? (g_value_unset (&_tmp6_), NULL) : NULL;
	_tmp8_ = desktop_agnostic_config_backend_get_list (self->priv->cfg, "empty", key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (expected_array);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		_g_free0 (key);
		return;
	}
	_tmp11_ = (_tmp10_ = test_case_array_equals (self, expected_array, _tmp9_ = _tmp8_, &_inner_error_), _g_value_array_free0 (_tmp9_), _tmp10_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (expected_array);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		_g_free0 (key);
		return;
	}
	g_assert (_tmp11_);
	_g_value_array_free0 (expected_array);
	G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
	_g_free0 (key);
}


static void test_case_test_defaults (TestCase* self, GError** error) {
	GError * _inner_error_;
	GValue expected = {0};
	GValue item_1 = {0};
	GValue item_2 = {0};
	GValue item_3 = {0};
	GValueArray* expected_array;
	GValue _tmp1_;
	GValue _tmp0_ = {0};
	GValue _tmp2_ = {0};
	GValue _tmp3_;
	GValue _tmp5_;
	GValue _tmp4_;
	gboolean _tmp6_;
	GValue _tmp8_;
	GValue _tmp7_ = {0};
	GValue _tmp9_ = {0};
	GValue _tmp10_;
	GValue _tmp12_;
	GValue _tmp11_;
	gint _tmp13_;
	GValue _tmp15_;
	GValue _tmp14_ = {0};
	GValue _tmp16_ = {0};
	GValue _tmp17_;
	GValue _tmp19_;
	GValue _tmp18_;
	float _tmp20_;
	GValue _tmp22_;
	GValue _tmp21_ = {0};
	GValue _tmp23_ = {0};
	GValue _tmp24_;
	GValue _tmp26_;
	GValue _tmp25_;
	char* _tmp27_;
	char* _tmp28_;
	GValue _tmp30_;
	GValue _tmp29_ = {0};
	GValue _tmp31_ = {0};
	GValue _tmp32_;
	GValue _tmp34_;
	GValue _tmp33_;
	char* _tmp35_;
	char* _tmp36_;
	GValueArray* _tmp37_;
	GValue _tmp39_;
	GValue _tmp38_ = {0};
	GValue _tmp41_;
	GValue _tmp40_ = {0};
	GValue _tmp43_;
	GValue _tmp42_ = {0};
	GValue _tmp44_ = {0};
	GValue _tmp45_;
	GValue _tmp47_;
	GValue _tmp46_;
	GValueArray* _tmp48_;
	GValueArray* _tmp49_;
	gboolean _tmp50_;
	gboolean _tmp51_;
	GValueArray* _tmp52_;
	GValue _tmp54_;
	GValue _tmp53_ = {0};
	GValue _tmp56_;
	GValue _tmp55_ = {0};
	GValue _tmp58_;
	GValue _tmp57_ = {0};
	GValue _tmp60_;
	GValue _tmp59_ = {0};
	GValue _tmp61_ = {0};
	GValue _tmp62_;
	GValue _tmp64_;
	GValue _tmp63_;
	GValueArray* _tmp65_;
	GValueArray* _tmp66_;
	gboolean _tmp67_;
	gboolean _tmp68_;
	GValueArray* _tmp69_;
	GValue _tmp71_;
	GValue _tmp70_ = {0};
	GValue _tmp73_;
	GValue _tmp72_ = {0};
	GValue _tmp75_;
	GValue _tmp74_ = {0};
	GValue _tmp77_;
	GValue _tmp76_ = {0};
	GValue _tmp78_ = {0};
	GValue _tmp79_;
	GValue _tmp81_;
	GValue _tmp80_;
	GValueArray* _tmp82_;
	GValueArray* _tmp83_;
	gboolean _tmp84_;
	gboolean _tmp85_;
	GValueArray* _tmp86_;
	GValue _tmp88_;
	GValue _tmp87_ = {0};
	GValue _tmp90_;
	GValue _tmp89_ = {0};
	GValue _tmp92_;
	GValue _tmp91_ = {0};
	GValue _tmp93_ = {0};
	GValue _tmp94_;
	GValue _tmp96_;
	GValue _tmp95_;
	GValueArray* _tmp97_;
	GValueArray* _tmp98_;
	gboolean _tmp99_;
	gboolean _tmp100_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	expected_array = NULL;
	desktop_agnostic_config_backend_reset (self->priv->cfg, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	expected = (_tmp1_ = (g_value_init (&_tmp0_, G_TYPE_BOOLEAN), g_value_set_boolean (&_tmp0_, TRUE), _tmp0_), G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL, _tmp1_);
	_tmp3_ = (desktop_agnostic_config_backend_get_value (self->priv->cfg, "numeric", "boolean", &_tmp2_, &_inner_error_), _tmp2_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_assert_equals (self, &expected, (_tmp5_ = _tmp4_ = _tmp3_, &_tmp5_), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	G_IS_VALUE (&_tmp4_) ? (g_value_unset (&_tmp4_), NULL) : NULL;
	_tmp6_ = desktop_agnostic_config_backend_get_bool (self->priv->cfg, "numeric", "boolean", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	g_assert (g_value_get_boolean (&expected) == _tmp6_);
	expected = (_tmp8_ = (g_value_init (&_tmp7_, G_TYPE_INT), g_value_set_int (&_tmp7_, 3), _tmp7_), G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL, _tmp8_);
	_tmp10_ = (desktop_agnostic_config_backend_get_value (self->priv->cfg, "numeric", "integer", &_tmp9_, &_inner_error_), _tmp9_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_assert_equals (self, &expected, (_tmp12_ = _tmp11_ = _tmp10_, &_tmp12_), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	G_IS_VALUE (&_tmp11_) ? (g_value_unset (&_tmp11_), NULL) : NULL;
	_tmp13_ = desktop_agnostic_config_backend_get_int (self->priv->cfg, "numeric", "integer", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	g_assert (g_value_get_int (&expected) == _tmp13_);
	expected = (_tmp15_ = (g_value_init (&_tmp14_, G_TYPE_FLOAT), g_value_set_float (&_tmp14_, 3.14f), _tmp14_), G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL, _tmp15_);
	_tmp17_ = (desktop_agnostic_config_backend_get_value (self->priv->cfg, "numeric", "float", &_tmp16_, &_inner_error_), _tmp16_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_assert_equals (self, &expected, (_tmp19_ = _tmp18_ = _tmp17_, &_tmp19_), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	G_IS_VALUE (&_tmp18_) ? (g_value_unset (&_tmp18_), NULL) : NULL;
	_tmp20_ = desktop_agnostic_config_backend_get_float (self->priv->cfg, "numeric", "float", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	g_assert (g_value_get_float (&expected) == _tmp20_);
	expected = (_tmp22_ = (g_value_init (&_tmp21_, G_TYPE_STRING), g_value_set_string (&_tmp21_, "Foo bar"), _tmp21_), G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL, _tmp22_);
	_tmp24_ = (desktop_agnostic_config_backend_get_value (self->priv->cfg, "misc", "string", &_tmp23_, &_inner_error_), _tmp23_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_assert_equals (self, &expected, (_tmp26_ = _tmp25_ = _tmp24_, &_tmp26_), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	G_IS_VALUE (&_tmp25_) ? (g_value_unset (&_tmp25_), NULL) : NULL;
	_tmp27_ = desktop_agnostic_config_backend_get_string (self->priv->cfg, "misc", "string", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	g_assert (_vala_strcmp0 (g_value_get_string (&expected), _tmp28_ = _tmp27_) == 0);
	_g_free0 (_tmp28_);
	expected = (_tmp30_ = (g_value_init (&_tmp29_, G_TYPE_STRING), g_value_set_string (&_tmp29_, ""), _tmp29_), G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL, _tmp30_);
	_tmp32_ = (desktop_agnostic_config_backend_get_value (self->priv->cfg, "empty", "string", &_tmp31_, &_inner_error_), _tmp31_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_assert_equals (self, &expected, (_tmp34_ = _tmp33_ = _tmp32_, &_tmp34_), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	G_IS_VALUE (&_tmp33_) ? (g_value_unset (&_tmp33_), NULL) : NULL;
	_tmp35_ = desktop_agnostic_config_backend_get_string (self->priv->cfg, "empty", "string", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	g_assert (_vala_strcmp0 (g_value_get_string (&expected), _tmp36_ = _tmp35_) == 0);
	_g_free0 (_tmp36_);
	expected_array = (_tmp37_ = g_value_array_new ((guint) 2), _g_value_array_free0 (expected_array), _tmp37_);
	item_1 = (_tmp39_ = (g_value_init (&_tmp38_, G_TYPE_BOOLEAN), g_value_set_boolean (&_tmp38_, TRUE), _tmp38_), G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL, _tmp39_);
	item_2 = (_tmp41_ = (g_value_init (&_tmp40_, G_TYPE_BOOLEAN), g_value_set_boolean (&_tmp40_, FALSE), _tmp40_), G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL, _tmp41_);
	g_value_array_append (expected_array, &item_1);
	g_value_array_append (expected_array, &item_2);
	expected = (_tmp43_ = (g_value_init (&_tmp42_, G_TYPE_VALUE_ARRAY), g_value_set_boxed (&_tmp42_, expected_array), _tmp42_), G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL, _tmp43_);
	_tmp45_ = (desktop_agnostic_config_backend_get_value (self->priv->cfg, "list", "boolean", &_tmp44_, &_inner_error_), _tmp44_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_assert_equals (self, &expected, (_tmp47_ = _tmp46_ = _tmp45_, &_tmp47_), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	G_IS_VALUE (&_tmp46_) ? (g_value_unset (&_tmp46_), NULL) : NULL;
	_tmp48_ = desktop_agnostic_config_backend_get_list (self->priv->cfg, "list", "boolean", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	_tmp51_ = (_tmp50_ = test_case_array_equals (self, g_value_get_boxed (&expected), _tmp49_ = _tmp48_, &_inner_error_), _g_value_array_free0 (_tmp49_), _tmp50_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	g_assert (_tmp51_);
	expected_array = (_tmp52_ = g_value_array_new ((guint) 3), _g_value_array_free0 (expected_array), _tmp52_);
	item_1 = (_tmp54_ = (g_value_init (&_tmp53_, G_TYPE_INT), g_value_set_int (&_tmp53_, 1), _tmp53_), G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL, _tmp54_);
	item_2 = (_tmp56_ = (g_value_init (&_tmp55_, G_TYPE_INT), g_value_set_int (&_tmp55_, 2), _tmp55_), G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL, _tmp56_);
	item_3 = (_tmp58_ = (g_value_init (&_tmp57_, G_TYPE_INT), g_value_set_int (&_tmp57_, 3), _tmp57_), G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL, _tmp58_);
	g_value_array_append (expected_array, &item_1);
	g_value_array_append (expected_array, &item_2);
	g_value_array_append (expected_array, &item_3);
	expected = (_tmp60_ = (g_value_init (&_tmp59_, G_TYPE_VALUE_ARRAY), g_value_set_boxed (&_tmp59_, expected_array), _tmp59_), G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL, _tmp60_);
	_tmp62_ = (desktop_agnostic_config_backend_get_value (self->priv->cfg, "list", "integer", &_tmp61_, &_inner_error_), _tmp61_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_assert_equals (self, &expected, (_tmp64_ = _tmp63_ = _tmp62_, &_tmp64_), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	G_IS_VALUE (&_tmp63_) ? (g_value_unset (&_tmp63_), NULL) : NULL;
	_tmp65_ = desktop_agnostic_config_backend_get_list (self->priv->cfg, "list", "integer", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	_tmp68_ = (_tmp67_ = test_case_array_equals (self, g_value_get_boxed (&expected), _tmp66_ = _tmp65_, &_inner_error_), _g_value_array_free0 (_tmp66_), _tmp67_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	g_assert (_tmp68_);
	expected_array = (_tmp69_ = g_value_array_new ((guint) 3), _g_value_array_free0 (expected_array), _tmp69_);
	item_1 = (_tmp71_ = (g_value_init (&_tmp70_, G_TYPE_FLOAT), g_value_set_float (&_tmp70_, 1.618f), _tmp70_), G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL, _tmp71_);
	item_2 = (_tmp73_ = (g_value_init (&_tmp72_, G_TYPE_FLOAT), g_value_set_float (&_tmp72_, 2.718f), _tmp72_), G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL, _tmp73_);
	item_3 = (_tmp75_ = (g_value_init (&_tmp74_, G_TYPE_FLOAT), g_value_set_float (&_tmp74_, 3.141f), _tmp74_), G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL, _tmp75_);
	g_value_array_append (expected_array, &item_1);
	g_value_array_append (expected_array, &item_2);
	g_value_array_append (expected_array, &item_3);
	expected = (_tmp77_ = (g_value_init (&_tmp76_, G_TYPE_VALUE_ARRAY), g_value_set_boxed (&_tmp76_, expected_array), _tmp76_), G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL, _tmp77_);
	_tmp79_ = (desktop_agnostic_config_backend_get_value (self->priv->cfg, "list", "float", &_tmp78_, &_inner_error_), _tmp78_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_assert_equals (self, &expected, (_tmp81_ = _tmp80_ = _tmp79_, &_tmp81_), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	G_IS_VALUE (&_tmp80_) ? (g_value_unset (&_tmp80_), NULL) : NULL;
	_tmp82_ = desktop_agnostic_config_backend_get_list (self->priv->cfg, "list", "float", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	_tmp85_ = (_tmp84_ = test_case_array_equals (self, g_value_get_boxed (&expected), _tmp83_ = _tmp82_, &_inner_error_), _g_value_array_free0 (_tmp83_), _tmp84_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	g_assert (_tmp85_);
	expected_array = (_tmp86_ = g_value_array_new ((guint) 2), _g_value_array_free0 (expected_array), _tmp86_);
	item_1 = (_tmp88_ = (g_value_init (&_tmp87_, G_TYPE_STRING), g_value_set_string (&_tmp87_, "foo"), _tmp87_), G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL, _tmp88_);
	item_2 = (_tmp90_ = (g_value_init (&_tmp89_, G_TYPE_STRING), g_value_set_string (&_tmp89_, "bar"), _tmp89_), G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL, _tmp90_);
	g_value_array_append (expected_array, &item_1);
	g_value_array_append (expected_array, &item_2);
	expected = (_tmp92_ = (g_value_init (&_tmp91_, G_TYPE_VALUE_ARRAY), g_value_set_boxed (&_tmp91_, expected_array), _tmp91_), G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL, _tmp92_);
	_tmp94_ = (desktop_agnostic_config_backend_get_value (self->priv->cfg, "list", "string", &_tmp93_, &_inner_error_), _tmp93_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_assert_equals (self, &expected, (_tmp96_ = _tmp95_ = _tmp94_, &_tmp96_), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	G_IS_VALUE (&_tmp95_) ? (g_value_unset (&_tmp95_), NULL) : NULL;
	_tmp97_ = desktop_agnostic_config_backend_get_list (self->priv->cfg, "list", "string", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	_tmp100_ = (_tmp99_ = test_case_array_equals (self, g_value_get_boxed (&expected), _tmp98_ = _tmp97_, &_inner_error_), _g_value_array_free0 (_tmp98_), _tmp99_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	g_assert (_tmp100_);
	test_case_test_default_empty_list (self, "boolean", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_test_default_empty_list (self, "integer", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_test_default_empty_list (self, "float", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_test_default_empty_list (self, "string", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
	G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
	G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
	G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
	_g_value_array_free0 (expected_array);
}


static void test_case_test_set_empty_list (TestCase* self, const char* key, GError** error) {
	GError * _inner_error_;
	GValueArray* old_value;
	GValueArray* expected_array;
	GValue expected = {0};
	GValueArray* _tmp0_;
	GValueArray* _tmp1_;
	GValueArray* _tmp2_;
	GValue _tmp4_;
	GValue _tmp3_ = {0};
	GValue _tmp5_ = {0};
	GValue _tmp6_;
	GValue _tmp8_;
	GValue _tmp7_;
	GValueArray* _tmp9_;
	GValueArray* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GValueArray* _tmp13_;
	GValueArray* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	GValue _tmp17_ = {0};
	GValue _tmp18_;
	GValue _tmp20_;
	GValue _tmp19_;
	GValueArray* _tmp21_;
	GValueArray* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_inner_error_ = NULL;
	old_value = NULL;
	expected_array = NULL;
	_tmp0_ = desktop_agnostic_config_backend_get_list (self->priv->cfg, "list", key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (old_value);
		_g_value_array_free0 (expected_array);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		return;
	}
	old_value = (_tmp1_ = _tmp0_, _g_value_array_free0 (old_value), _tmp1_);
	expected_array = (_tmp2_ = g_value_array_new ((guint) 0), _g_value_array_free0 (expected_array), _tmp2_);
	expected = (_tmp4_ = (g_value_init (&_tmp3_, G_TYPE_VALUE_ARRAY), g_value_set_boxed (&_tmp3_, expected_array), _tmp3_), G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL, _tmp4_);
	desktop_agnostic_config_backend_set_list (self->priv->cfg, "list", key, expected_array, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (old_value);
		_g_value_array_free0 (expected_array);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		return;
	}
	_tmp6_ = (desktop_agnostic_config_backend_get_value (self->priv->cfg, "list", key, &_tmp5_, &_inner_error_), _tmp5_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (old_value);
		_g_value_array_free0 (expected_array);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		return;
	}
	test_case_assert_equals (self, &expected, (_tmp8_ = _tmp7_ = _tmp6_, &_tmp8_), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (old_value);
		_g_value_array_free0 (expected_array);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		return;
	}
	G_IS_VALUE (&_tmp7_) ? (g_value_unset (&_tmp7_), NULL) : NULL;
	_tmp9_ = desktop_agnostic_config_backend_get_list (self->priv->cfg, "list", key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (old_value);
		_g_value_array_free0 (expected_array);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		return;
	}
	_tmp12_ = (_tmp11_ = test_case_array_equals (self, expected_array, _tmp10_ = _tmp9_, &_inner_error_), _g_value_array_free0 (_tmp10_), _tmp11_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (old_value);
		_g_value_array_free0 (expected_array);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		return;
	}
	g_assert (_tmp12_);
	desktop_agnostic_config_backend_set_list (self->priv->cfg, "list", key, old_value, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (old_value);
		_g_value_array_free0 (expected_array);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		return;
	}
	_tmp13_ = desktop_agnostic_config_backend_get_list (self->priv->cfg, "list", key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (old_value);
		_g_value_array_free0 (expected_array);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		return;
	}
	_tmp16_ = (_tmp15_ = test_case_array_equals (self, old_value, _tmp14_ = _tmp13_, &_inner_error_), _g_value_array_free0 (_tmp14_), _tmp15_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (old_value);
		_g_value_array_free0 (expected_array);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		return;
	}
	g_assert (_tmp16_);
	desktop_agnostic_config_backend_set_value (self->priv->cfg, "list", key, &expected, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (old_value);
		_g_value_array_free0 (expected_array);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		return;
	}
	_tmp18_ = (desktop_agnostic_config_backend_get_value (self->priv->cfg, "list", key, &_tmp17_, &_inner_error_), _tmp17_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (old_value);
		_g_value_array_free0 (expected_array);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		return;
	}
	test_case_assert_equals (self, &expected, (_tmp20_ = _tmp19_ = _tmp18_, &_tmp20_), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (old_value);
		_g_value_array_free0 (expected_array);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		return;
	}
	G_IS_VALUE (&_tmp19_) ? (g_value_unset (&_tmp19_), NULL) : NULL;
	_tmp21_ = desktop_agnostic_config_backend_get_list (self->priv->cfg, "list", key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (old_value);
		_g_value_array_free0 (expected_array);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		return;
	}
	_tmp24_ = (_tmp23_ = test_case_array_equals (self, expected_array, _tmp22_ = _tmp21_, &_inner_error_), _g_value_array_free0 (_tmp22_), _tmp23_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (old_value);
		_g_value_array_free0 (expected_array);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		return;
	}
	g_assert (_tmp24_);
	_g_value_array_free0 (old_value);
	_g_value_array_free0 (expected_array);
	G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
}


static void test_case_test_set (TestCase* self, GError** error) {
	GError * _inner_error_;
	GValue expected = {0};
	GValue item_1 = {0};
	GValue item_2 = {0};
	GValue item_3 = {0};
	GValueArray* expected_array;
	GValue _tmp1_;
	GValue _tmp0_ = {0};
	GValue _tmp2_ = {0};
	GValue _tmp3_;
	GValue _tmp5_;
	GValue _tmp4_;
	gboolean _tmp6_;
	GValue _tmp8_;
	GValue _tmp7_ = {0};
	GValue _tmp9_ = {0};
	GValue _tmp10_;
	GValue _tmp12_;
	GValue _tmp11_;
	gint _tmp13_;
	GValue _tmp15_;
	GValue _tmp14_ = {0};
	GValue _tmp16_ = {0};
	GValue _tmp17_;
	GValue _tmp19_;
	GValue _tmp18_;
	float _tmp20_;
	GValue _tmp22_;
	GValue _tmp21_ = {0};
	GValue _tmp23_ = {0};
	GValue _tmp24_;
	GValue _tmp26_;
	GValue _tmp25_;
	char* _tmp27_;
	char* _tmp28_;
	GValueArray* _tmp29_;
	GValue _tmp31_;
	GValue _tmp30_ = {0};
	GValue _tmp33_;
	GValue _tmp32_ = {0};
	GValue _tmp35_;
	GValue _tmp34_ = {0};
	GValue _tmp37_;
	GValue _tmp36_ = {0};
	GValue _tmp38_ = {0};
	GValue _tmp39_;
	GValue _tmp41_;
	GValue _tmp40_;
	GValueArray* _tmp42_;
	GValueArray* _tmp43_;
	gboolean _tmp44_;
	gboolean _tmp45_;
	GValueArray* _tmp46_;
	GValue _tmp48_;
	GValue _tmp47_ = {0};
	GValue _tmp50_;
	GValue _tmp49_ = {0};
	GValue _tmp52_;
	GValue _tmp51_ = {0};
	GValue _tmp54_;
	GValue _tmp53_ = {0};
	GValue _tmp55_ = {0};
	GValue _tmp56_;
	GValue _tmp58_;
	GValue _tmp57_;
	GValueArray* _tmp59_;
	GValueArray* _tmp60_;
	gboolean _tmp61_;
	gboolean _tmp62_;
	GValueArray* _tmp63_;
	GValue _tmp65_;
	GValue _tmp64_ = {0};
	GValue _tmp67_;
	GValue _tmp66_ = {0};
	GValue _tmp69_;
	GValue _tmp68_ = {0};
	GValue _tmp71_;
	GValue _tmp70_ = {0};
	GValue _tmp72_ = {0};
	GValue _tmp73_;
	GValue _tmp75_;
	GValue _tmp74_;
	GValueArray* _tmp76_;
	GValueArray* _tmp77_;
	gboolean _tmp78_;
	gboolean _tmp79_;
	GValueArray* _tmp80_;
	GValue _tmp82_;
	GValue _tmp81_ = {0};
	GValue _tmp84_;
	GValue _tmp83_ = {0};
	GValue _tmp86_;
	GValue _tmp85_ = {0};
	GValue _tmp88_;
	GValue _tmp87_ = {0};
	GValue _tmp89_ = {0};
	GValue _tmp90_;
	GValue _tmp92_;
	GValue _tmp91_;
	GValueArray* _tmp93_;
	GValueArray* _tmp94_;
	gboolean _tmp95_;
	gboolean _tmp96_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	expected_array = NULL;
	expected = (_tmp1_ = (g_value_init (&_tmp0_, G_TYPE_BOOLEAN), g_value_set_boolean (&_tmp0_, FALSE), _tmp0_), G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL, _tmp1_);
	desktop_agnostic_config_backend_set_bool (self->priv->cfg, "numeric", "boolean", g_value_get_boolean (&expected), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	_tmp3_ = (desktop_agnostic_config_backend_get_value (self->priv->cfg, "numeric", "boolean", &_tmp2_, &_inner_error_), _tmp2_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_assert_equals (self, &expected, (_tmp5_ = _tmp4_ = _tmp3_, &_tmp5_), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	G_IS_VALUE (&_tmp4_) ? (g_value_unset (&_tmp4_), NULL) : NULL;
	_tmp6_ = desktop_agnostic_config_backend_get_bool (self->priv->cfg, "numeric", "boolean", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	g_assert (g_value_get_boolean (&expected) == _tmp6_);
	expected = (_tmp8_ = (g_value_init (&_tmp7_, G_TYPE_INT), g_value_set_int (&_tmp7_, 10), _tmp7_), G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL, _tmp8_);
	desktop_agnostic_config_backend_set_int (self->priv->cfg, "numeric", "integer", g_value_get_int (&expected), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	_tmp10_ = (desktop_agnostic_config_backend_get_value (self->priv->cfg, "numeric", "integer", &_tmp9_, &_inner_error_), _tmp9_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_assert_equals (self, &expected, (_tmp12_ = _tmp11_ = _tmp10_, &_tmp12_), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	G_IS_VALUE (&_tmp11_) ? (g_value_unset (&_tmp11_), NULL) : NULL;
	_tmp13_ = desktop_agnostic_config_backend_get_int (self->priv->cfg, "numeric", "integer", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	g_assert (g_value_get_int (&expected) == _tmp13_);
	expected = (_tmp15_ = (g_value_init (&_tmp14_, G_TYPE_FLOAT), g_value_set_float (&_tmp14_, 2.718f), _tmp14_), G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL, _tmp15_);
	desktop_agnostic_config_backend_set_float (self->priv->cfg, "numeric", "float", g_value_get_float (&expected), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	_tmp17_ = (desktop_agnostic_config_backend_get_value (self->priv->cfg, "numeric", "float", &_tmp16_, &_inner_error_), _tmp16_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_assert_equals (self, &expected, (_tmp19_ = _tmp18_ = _tmp17_, &_tmp19_), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	G_IS_VALUE (&_tmp18_) ? (g_value_unset (&_tmp18_), NULL) : NULL;
	_tmp20_ = desktop_agnostic_config_backend_get_float (self->priv->cfg, "numeric", "float", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	g_assert (g_value_get_float (&expected) == _tmp20_);
	expected = (_tmp22_ = (g_value_init (&_tmp21_, G_TYPE_STRING), g_value_set_string (&_tmp21_, "Quux baz"), _tmp21_), G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL, _tmp22_);
	desktop_agnostic_config_backend_set_string (self->priv->cfg, "misc", "string", g_value_get_string (&expected), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	_tmp24_ = (desktop_agnostic_config_backend_get_value (self->priv->cfg, "misc", "string", &_tmp23_, &_inner_error_), _tmp23_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_assert_equals (self, &expected, (_tmp26_ = _tmp25_ = _tmp24_, &_tmp26_), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	G_IS_VALUE (&_tmp25_) ? (g_value_unset (&_tmp25_), NULL) : NULL;
	_tmp27_ = desktop_agnostic_config_backend_get_string (self->priv->cfg, "misc", "string", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	g_assert (_vala_strcmp0 (g_value_get_string (&expected), _tmp28_ = _tmp27_) == 0);
	_g_free0 (_tmp28_);
	expected_array = (_tmp29_ = g_value_array_new ((guint) 3), _g_value_array_free0 (expected_array), _tmp29_);
	item_1 = (_tmp31_ = (g_value_init (&_tmp30_, G_TYPE_BOOLEAN), g_value_set_boolean (&_tmp30_, FALSE), _tmp30_), G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL, _tmp31_);
	item_2 = (_tmp33_ = (g_value_init (&_tmp32_, G_TYPE_BOOLEAN), g_value_set_boolean (&_tmp32_, TRUE), _tmp32_), G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL, _tmp33_);
	item_3 = (_tmp35_ = (g_value_init (&_tmp34_, G_TYPE_BOOLEAN), g_value_set_boolean (&_tmp34_, FALSE), _tmp34_), G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL, _tmp35_);
	g_value_array_append (expected_array, &item_1);
	g_value_array_append (expected_array, &item_2);
	g_value_array_append (expected_array, &item_3);
	expected = (_tmp37_ = (g_value_init (&_tmp36_, G_TYPE_VALUE_ARRAY), g_value_set_boxed (&_tmp36_, expected_array), _tmp36_), G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL, _tmp37_);
	desktop_agnostic_config_backend_set_list (self->priv->cfg, "list", "boolean", g_value_get_boxed (&expected), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	_tmp39_ = (desktop_agnostic_config_backend_get_value (self->priv->cfg, "list", "boolean", &_tmp38_, &_inner_error_), _tmp38_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_assert_equals (self, &expected, (_tmp41_ = _tmp40_ = _tmp39_, &_tmp41_), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	G_IS_VALUE (&_tmp40_) ? (g_value_unset (&_tmp40_), NULL) : NULL;
	_tmp42_ = desktop_agnostic_config_backend_get_list (self->priv->cfg, "list", "boolean", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	_tmp45_ = (_tmp44_ = test_case_array_equals (self, g_value_get_boxed (&expected), _tmp43_ = _tmp42_, &_inner_error_), _g_value_array_free0 (_tmp43_), _tmp44_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	g_assert (_tmp45_);
	expected_array = (_tmp46_ = g_value_array_new ((guint) 3), _g_value_array_free0 (expected_array), _tmp46_);
	item_1 = (_tmp48_ = (g_value_init (&_tmp47_, G_TYPE_INT), g_value_set_int (&_tmp47_, 10), _tmp47_), G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL, _tmp48_);
	item_2 = (_tmp50_ = (g_value_init (&_tmp49_, G_TYPE_INT), g_value_set_int (&_tmp49_, 20), _tmp49_), G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL, _tmp50_);
	item_3 = (_tmp52_ = (g_value_init (&_tmp51_, G_TYPE_INT), g_value_set_int (&_tmp51_, 30), _tmp51_), G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL, _tmp52_);
	g_value_array_append (expected_array, &item_1);
	g_value_array_append (expected_array, &item_2);
	g_value_array_append (expected_array, &item_3);
	expected = (_tmp54_ = (g_value_init (&_tmp53_, G_TYPE_VALUE_ARRAY), g_value_set_boxed (&_tmp53_, expected_array), _tmp53_), G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL, _tmp54_);
	desktop_agnostic_config_backend_set_list (self->priv->cfg, "list", "integer", g_value_get_boxed (&expected), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	_tmp56_ = (desktop_agnostic_config_backend_get_value (self->priv->cfg, "list", "integer", &_tmp55_, &_inner_error_), _tmp55_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_assert_equals (self, &expected, (_tmp58_ = _tmp57_ = _tmp56_, &_tmp58_), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	G_IS_VALUE (&_tmp57_) ? (g_value_unset (&_tmp57_), NULL) : NULL;
	_tmp59_ = desktop_agnostic_config_backend_get_list (self->priv->cfg, "list", "integer", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	_tmp62_ = (_tmp61_ = test_case_array_equals (self, g_value_get_boxed (&expected), _tmp60_ = _tmp59_, &_inner_error_), _g_value_array_free0 (_tmp60_), _tmp61_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	g_assert (_tmp62_);
	expected_array = (_tmp63_ = g_value_array_new ((guint) 3), _g_value_array_free0 (expected_array), _tmp63_);
	item_1 = (_tmp65_ = (g_value_init (&_tmp64_, G_TYPE_FLOAT), g_value_set_float (&_tmp64_, 10.5f), _tmp64_), G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL, _tmp65_);
	item_2 = (_tmp67_ = (g_value_init (&_tmp66_, G_TYPE_FLOAT), g_value_set_float (&_tmp66_, 20.6f), _tmp66_), G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL, _tmp67_);
	item_3 = (_tmp69_ = (g_value_init (&_tmp68_, G_TYPE_FLOAT), g_value_set_float (&_tmp68_, 30.7f), _tmp68_), G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL, _tmp69_);
	g_value_array_append (expected_array, &item_1);
	g_value_array_append (expected_array, &item_2);
	g_value_array_append (expected_array, &item_3);
	expected = (_tmp71_ = (g_value_init (&_tmp70_, G_TYPE_VALUE_ARRAY), g_value_set_boxed (&_tmp70_, expected_array), _tmp70_), G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL, _tmp71_);
	desktop_agnostic_config_backend_set_list (self->priv->cfg, "list", "float", g_value_get_boxed (&expected), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	_tmp73_ = (desktop_agnostic_config_backend_get_value (self->priv->cfg, "list", "float", &_tmp72_, &_inner_error_), _tmp72_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_assert_equals (self, &expected, (_tmp75_ = _tmp74_ = _tmp73_, &_tmp75_), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	G_IS_VALUE (&_tmp74_) ? (g_value_unset (&_tmp74_), NULL) : NULL;
	_tmp76_ = desktop_agnostic_config_backend_get_list (self->priv->cfg, "list", "float", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	_tmp79_ = (_tmp78_ = test_case_array_equals (self, g_value_get_boxed (&expected), _tmp77_ = _tmp76_, &_inner_error_), _g_value_array_free0 (_tmp77_), _tmp78_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	g_assert (_tmp79_);
	expected_array = (_tmp80_ = g_value_array_new ((guint) 3), _g_value_array_free0 (expected_array), _tmp80_);
	item_1 = (_tmp82_ = (g_value_init (&_tmp81_, G_TYPE_STRING), g_value_set_string (&_tmp81_, "Quux"), _tmp81_), G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL, _tmp82_);
	item_2 = (_tmp84_ = (g_value_init (&_tmp83_, G_TYPE_STRING), g_value_set_string (&_tmp83_, "Baz"), _tmp83_), G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL, _tmp84_);
	item_3 = (_tmp86_ = (g_value_init (&_tmp85_, G_TYPE_STRING), g_value_set_string (&_tmp85_, "Foo"), _tmp85_), G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL, _tmp86_);
	g_value_array_append (expected_array, &item_1);
	g_value_array_append (expected_array, &item_2);
	g_value_array_append (expected_array, &item_3);
	expected = (_tmp88_ = (g_value_init (&_tmp87_, G_TYPE_VALUE_ARRAY), g_value_set_boxed (&_tmp87_, expected_array), _tmp87_), G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL, _tmp88_);
	desktop_agnostic_config_backend_set_list (self->priv->cfg, "list", "string", g_value_get_boxed (&expected), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	_tmp90_ = (desktop_agnostic_config_backend_get_value (self->priv->cfg, "list", "string", &_tmp89_, &_inner_error_), _tmp89_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_assert_equals (self, &expected, (_tmp92_ = _tmp91_ = _tmp90_, &_tmp92_), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	G_IS_VALUE (&_tmp91_) ? (g_value_unset (&_tmp91_), NULL) : NULL;
	_tmp93_ = desktop_agnostic_config_backend_get_list (self->priv->cfg, "list", "string", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	_tmp96_ = (_tmp95_ = test_case_array_equals (self, g_value_get_boxed (&expected), _tmp94_ = _tmp93_, &_inner_error_), _g_value_array_free0 (_tmp94_), _tmp95_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	g_assert (_tmp96_);
	test_case_test_set_empty_list (self, "boolean", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_test_set_empty_list (self, "integer", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_test_set_empty_list (self, "float", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	test_case_test_set_empty_list (self, "string", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
		G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
		G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
		G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
		_g_value_array_free0 (expected_array);
		return;
	}
	G_IS_VALUE (&expected) ? (g_value_unset (&expected), NULL) : NULL;
	G_IS_VALUE (&item_1) ? (g_value_unset (&item_1), NULL) : NULL;
	G_IS_VALUE (&item_2) ? (g_value_unset (&item_2), NULL) : NULL;
	G_IS_VALUE (&item_3) ? (g_value_unset (&item_3), NULL) : NULL;
	_g_value_array_free0 (expected_array);
}


static void test_case_update_notify_value (TestCase* self, GMainContext* ctx, const char* value, guint counter_expected, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (value != NULL);
	_inner_error_ = NULL;
	desktop_agnostic_config_backend_set_string (self->priv->cfg, "misc", "string", value, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	g_usleep ((gulong) 250000);
	while (TRUE) {
		if (!g_main_context_pending (ctx)) {
			break;
		}
		g_main_context_iteration (ctx, FALSE);
	}
	g_assert (self->priv->notify_counter == counter_expected);
}


static void _test_case_on_string_changed_desktop_agnostic_config_notify_func (const char* group, const char* key, GValue* value, gpointer self) {
	test_case_on_string_changed (self, group, key, value);
}


static void _test_case_on_string_changed2_desktop_agnostic_config_notify_func (const char* group, const char* key, GValue* value, gpointer self) {
	test_case_on_string_changed2 (self, group, key, value);
}


static void test_case_test_notify (TestCase* self, GError** error) {
	GError * _inner_error_;
	GMainContext* ctx;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	ctx = g_main_loop_get_context (self->priv->ml);
	desktop_agnostic_config_backend_notify_add (self->priv->cfg, "misc", "string", _test_case_on_string_changed_desktop_agnostic_config_notify_func, self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	desktop_agnostic_config_backend_notify_add (self->priv->cfg, "misc", "string", _test_case_on_string_changed2_desktop_agnostic_config_notify_func, self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	test_case_update_notify_value (self, ctx, "Bar foo", (guint) 1, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	test_case_update_notify_value (self, ctx, "Foo quux", (guint) 5, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	desktop_agnostic_config_backend_notify_remove (self->priv->cfg, "misc", "string", _test_case_on_string_changed_desktop_agnostic_config_notify_func, self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	test_case_update_notify_value (self, ctx, "Bar quux", (guint) 8, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	desktop_agnostic_config_backend_notify_remove (self->priv->cfg, "misc", "string", _test_case_on_string_changed2_desktop_agnostic_config_notify_func, self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	test_case_update_notify_value (self, ctx, "Baz foo", (guint) 8, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void test_case_test_invalid_func (TestCase* self, TestCaseGetCfgFunc func, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		func (self->priv->cfg, "foo", "bar", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_inner_error_ = g_error_new_literal (ASSERTION_ERROR, ASSERTION_ERROR_NOT_REACHED, "Key should have been nonexistent.");
		{
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			if (!g_error_matches (err, DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_KEY_NOT_FOUND)) {
				_inner_error_ = _g_error_copy0 (err);
				{
					_g_error_free0 (err);
					goto __finally0;
				}
			}
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void test_case_test_invalid (TestCase* self, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	test_case_test_invalid_func (self, (TestCaseGetCfgFunc) desktop_agnostic_config_backend_get_bool, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	test_case_test_invalid_func (self, (TestCaseGetCfgFunc) desktop_agnostic_config_backend_get_float, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	test_case_test_invalid_func (self, (TestCaseGetCfgFunc) desktop_agnostic_config_backend_get_int, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	test_case_test_invalid_func (self, (TestCaseGetCfgFunc) desktop_agnostic_config_backend_get_string, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	test_case_test_invalid_func (self, (TestCaseGetCfgFunc) desktop_agnostic_config_backend_get_list, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


gint test_case_main (char** args, int args_length1) {
	gint result;
	GError * _inner_error_;
	_inner_error_ = NULL;
	{
		TestCase* test;
		test = test_case_new (&_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ASSERTION_ERROR) {
				goto __catch1_assertion_error;
			}
			goto __catch1_g_error;
		}
		test_case_test_defaults (test, &_inner_error_);
		if (_inner_error_ != NULL) {
			_test_case_unref0 (test);
			if (_inner_error_->domain == ASSERTION_ERROR) {
				goto __catch1_assertion_error;
			}
			goto __catch1_g_error;
		}
		test_case_test_set (test, &_inner_error_);
		if (_inner_error_ != NULL) {
			_test_case_unref0 (test);
			if (_inner_error_->domain == ASSERTION_ERROR) {
				goto __catch1_assertion_error;
			}
			goto __catch1_g_error;
		}
		test_case_test_invalid (test, &_inner_error_);
		if (_inner_error_ != NULL) {
			_test_case_unref0 (test);
			if (_inner_error_->domain == ASSERTION_ERROR) {
				goto __catch1_assertion_error;
			}
			goto __catch1_g_error;
		}
		test_case_test_notify (test, &_inner_error_);
		if (_inner_error_ != NULL) {
			_test_case_unref0 (test);
			if (_inner_error_->domain == ASSERTION_ERROR) {
				goto __catch1_assertion_error;
			}
			goto __catch1_g_error;
		}
		_test_case_unref0 (test);
	}
	goto __finally1;
	__catch1_assertion_error:
	{
		GError * assertion;
		assertion = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("test-config.vala:400: Assertion Error: %s", assertion->message);
			result = EXIT_ASSERTION;
			_g_error_free0 (assertion);
			return result;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("test-config.vala:405: Error: %s", err->message);
			result = EXIT_EXCEPTION;
			_g_error_free0 (err);
			return result;
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = EXIT_SUCCESS;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return test_case_main (argv, argc);
}


static void value_test_case_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_test_case_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		test_case_unref (value->data[0].v_pointer);
	}
}


static void value_test_case_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = test_case_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_test_case_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_test_case_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TestCase* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = test_case_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_test_case_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TestCase** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = test_case_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_test_case (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTestCase* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TEST_CASE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_test_case (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_CASE), NULL);
	return value->data[0].v_pointer;
}


void value_set_test_case (GValue* value, gpointer v_object) {
	TestCase* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST_CASE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEST_CASE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		test_case_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		test_case_unref (old);
	}
}


static void test_case_class_init (TestCaseClass * klass) {
	test_case_parent_class = g_type_class_peek_parent (klass);
	TEST_CASE_CLASS (klass)->finalize = test_case_finalize;
	g_type_class_add_private (klass, sizeof (TestCasePrivate));
}


static void test_case_instance_init (TestCase * self) {
	self->priv = TEST_CASE_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void test_case_finalize (TestCase* obj) {
	TestCase * self;
	self = TEST_CASE (obj);
	_g_object_unref0 (self->priv->cfg);
	_g_main_loop_unref0 (self->priv->ml);
}


GType test_case_get_type (void) {
	static GType test_case_type_id = 0;
	if (test_case_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { value_test_case_init, value_test_case_free_value, value_test_case_copy_value, value_test_case_peek_pointer, "p", value_test_case_collect_value, "p", value_test_case_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TestCaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_case_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestCase), 0, (GInstanceInitFunc) test_case_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		test_case_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TestCase", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return test_case_type_id;
}


gpointer test_case_ref (gpointer instance) {
	TestCase* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void test_case_unref (gpointer instance) {
	TestCase* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TEST_CASE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




