/* vfs-volume.c generated by valac, the Vala compiler
 * generated from vfs-volume.vala, do not modify */

/*
 * Desktop Agnostic Library: VFS Volume interface.
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME (desktop_agnostic_vfs_volume_get_type ())
#define DESKTOP_AGNOSTIC_VFS_VOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME, DesktopAgnosticVFSVolume))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME, DesktopAgnosticVFSVolumeIface))

typedef struct _DesktopAgnosticVFSVolume DesktopAgnosticVFSVolume;
typedef struct _DesktopAgnosticVFSVolumeIface DesktopAgnosticVFSVolumeIface;

#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE (desktop_agnostic_vfs_file_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE, DesktopAgnosticVFSFile))
#define DESKTOP_AGNOSTIC_VFS_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE, DesktopAgnosticVFSFileClass))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE))
#define DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE, DesktopAgnosticVFSFileClass))

typedef struct _DesktopAgnosticVFSFile DesktopAgnosticVFSFile;
typedef struct _DesktopAgnosticVFSFileClass DesktopAgnosticVFSFileClass;

#define DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR (desktop_agnostic_vfs_volume_monitor_get_type ())
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR, DesktopAgnosticVFSVolumeMonitor))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR, DesktopAgnosticVFSVolumeMonitorIface))

typedef struct _DesktopAgnosticVFSVolumeMonitor DesktopAgnosticVFSVolumeMonitor;
typedef struct _DesktopAgnosticVFSVolumeMonitorIface DesktopAgnosticVFSVolumeMonitorIface;

#define DESKTOP_AGNOSTIC_VFS_TYPE_IMPLEMENTATION (desktop_agnostic_vfs_implementation_get_type ())
#define DESKTOP_AGNOSTIC_VFS_IMPLEMENTATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_IMPLEMENTATION, DesktopAgnosticVFSImplementation))
#define DESKTOP_AGNOSTIC_VFS_IS_IMPLEMENTATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_IMPLEMENTATION))
#define DESKTOP_AGNOSTIC_VFS_IMPLEMENTATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_IMPLEMENTATION, DesktopAgnosticVFSImplementationIface))

typedef struct _DesktopAgnosticVFSImplementation DesktopAgnosticVFSImplementation;
typedef struct _DesktopAgnosticVFSImplementationIface DesktopAgnosticVFSImplementationIface;

typedef enum  {
	DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR_MOUNT,
	DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR_UNMOUNT,
	DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR_EJECT
} DesktopAgnosticVFSVolumeError;
#define DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR desktop_agnostic_vfs_volume_error_quark ()
typedef void (*DesktopAgnosticVFSVolumeCallback) (void* user_data);
struct _DesktopAgnosticVFSVolumeIface {
	GTypeInterface parent_iface;
	gboolean (*is_mounted) (DesktopAgnosticVFSVolume* self);
	void (*mount) (DesktopAgnosticVFSVolume* self, DesktopAgnosticVFSVolumeCallback callback, void* callback_target);
	gboolean (*mount_finish) (DesktopAgnosticVFSVolume* self, GError** error);
	void (*unmount) (DesktopAgnosticVFSVolume* self, DesktopAgnosticVFSVolumeCallback callback, void* callback_target);
	gboolean (*unmount_finish) (DesktopAgnosticVFSVolume* self, GError** error);
	gboolean (*can_eject) (DesktopAgnosticVFSVolume* self);
	void (*eject) (DesktopAgnosticVFSVolume* self, DesktopAgnosticVFSVolumeCallback callback, void* callback_target);
	gboolean (*eject_finish) (DesktopAgnosticVFSVolume* self, GError** error);
	const char* (*get_name) (DesktopAgnosticVFSVolume* self);
	DesktopAgnosticVFSFile* (*get_uri) (DesktopAgnosticVFSVolume* self);
	char* (*get_icon) (DesktopAgnosticVFSVolume* self);
};

struct _DesktopAgnosticVFSVolumeMonitorIface {
	GTypeInterface parent_iface;
	void* (*get_implementation) (DesktopAgnosticVFSVolumeMonitor* self);
	GList* (*get_volumes) (DesktopAgnosticVFSVolumeMonitor* self);
};

struct _DesktopAgnosticVFSImplementationIface {
	GTypeInterface parent_iface;
	void (*init) (DesktopAgnosticVFSImplementation* self);
	GSList* (*files_from_uri_list) (DesktopAgnosticVFSImplementation* self, const char* uri_list, GError** error);
	DesktopAgnosticVFSVolumeMonitor* (*volume_monitor_get_default) (DesktopAgnosticVFSImplementation* self);
	void (*shutdown) (DesktopAgnosticVFSImplementation* self);
	const char* (*get_name) (DesktopAgnosticVFSImplementation* self);
	GType (*get_file_type) (DesktopAgnosticVFSImplementation* self);
	GType (*get_file_monitor_type) (DesktopAgnosticVFSImplementation* self);
	GType (*get_trash_type) (DesktopAgnosticVFSImplementation* self);
	GType (*get_volume_type) (DesktopAgnosticVFSImplementation* self);
};



GQuark desktop_agnostic_vfs_volume_error_quark (void);
GType desktop_agnostic_vfs_file_get_type (void);
GType desktop_agnostic_vfs_volume_get_type (void);
gboolean desktop_agnostic_vfs_volume_is_mounted (DesktopAgnosticVFSVolume* self);
void desktop_agnostic_vfs_volume_mount (DesktopAgnosticVFSVolume* self, DesktopAgnosticVFSVolumeCallback callback, void* callback_target);
gboolean desktop_agnostic_vfs_volume_mount_finish (DesktopAgnosticVFSVolume* self, GError** error);
void desktop_agnostic_vfs_volume_unmount (DesktopAgnosticVFSVolume* self, DesktopAgnosticVFSVolumeCallback callback, void* callback_target);
gboolean desktop_agnostic_vfs_volume_unmount_finish (DesktopAgnosticVFSVolume* self, GError** error);
gboolean desktop_agnostic_vfs_volume_can_eject (DesktopAgnosticVFSVolume* self);
void desktop_agnostic_vfs_volume_eject (DesktopAgnosticVFSVolume* self, DesktopAgnosticVFSVolumeCallback callback, void* callback_target);
gboolean desktop_agnostic_vfs_volume_eject_finish (DesktopAgnosticVFSVolume* self, GError** error);
const char* desktop_agnostic_vfs_volume_get_name (DesktopAgnosticVFSVolume* self);
DesktopAgnosticVFSFile* desktop_agnostic_vfs_volume_get_uri (DesktopAgnosticVFSVolume* self);
char* desktop_agnostic_vfs_volume_get_icon (DesktopAgnosticVFSVolume* self);
GType desktop_agnostic_vfs_volume_monitor_get_type (void);
void* desktop_agnostic_vfs_volume_monitor_get_implementation (DesktopAgnosticVFSVolumeMonitor* self);
GList* desktop_agnostic_vfs_volume_monitor_get_volumes (DesktopAgnosticVFSVolumeMonitor* self);
GType desktop_agnostic_vfs_implementation_get_type (void);
DesktopAgnosticVFSImplementation* desktop_agnostic_vfs_get_default (GError** error);
DesktopAgnosticVFSVolumeMonitor* desktop_agnostic_vfs_implementation_volume_monitor_get_default (DesktopAgnosticVFSImplementation* self);
DesktopAgnosticVFSVolumeMonitor* desktop_agnostic_vfs_volume_monitor_get_default (GError** error);



GQuark desktop_agnostic_vfs_volume_error_quark (void) {
	return g_quark_from_static_string ("desktop_agnostic_vfs_volume_error-quark");
}


gboolean desktop_agnostic_vfs_volume_is_mounted (DesktopAgnosticVFSVolume* self) {
	return DESKTOP_AGNOSTIC_VFS_VOLUME_GET_INTERFACE (self)->is_mounted (self);
}


void desktop_agnostic_vfs_volume_mount (DesktopAgnosticVFSVolume* self, DesktopAgnosticVFSVolumeCallback callback, void* callback_target) {
	DESKTOP_AGNOSTIC_VFS_VOLUME_GET_INTERFACE (self)->mount (self, callback, callback_target);
}


gboolean desktop_agnostic_vfs_volume_mount_finish (DesktopAgnosticVFSVolume* self, GError** error) {
	return DESKTOP_AGNOSTIC_VFS_VOLUME_GET_INTERFACE (self)->mount_finish (self, error);
}


void desktop_agnostic_vfs_volume_unmount (DesktopAgnosticVFSVolume* self, DesktopAgnosticVFSVolumeCallback callback, void* callback_target) {
	DESKTOP_AGNOSTIC_VFS_VOLUME_GET_INTERFACE (self)->unmount (self, callback, callback_target);
}


gboolean desktop_agnostic_vfs_volume_unmount_finish (DesktopAgnosticVFSVolume* self, GError** error) {
	return DESKTOP_AGNOSTIC_VFS_VOLUME_GET_INTERFACE (self)->unmount_finish (self, error);
}


gboolean desktop_agnostic_vfs_volume_can_eject (DesktopAgnosticVFSVolume* self) {
	return DESKTOP_AGNOSTIC_VFS_VOLUME_GET_INTERFACE (self)->can_eject (self);
}


void desktop_agnostic_vfs_volume_eject (DesktopAgnosticVFSVolume* self, DesktopAgnosticVFSVolumeCallback callback, void* callback_target) {
	DESKTOP_AGNOSTIC_VFS_VOLUME_GET_INTERFACE (self)->eject (self, callback, callback_target);
}


gboolean desktop_agnostic_vfs_volume_eject_finish (DesktopAgnosticVFSVolume* self, GError** error) {
	return DESKTOP_AGNOSTIC_VFS_VOLUME_GET_INTERFACE (self)->eject_finish (self, error);
}


const char* desktop_agnostic_vfs_volume_get_name (DesktopAgnosticVFSVolume* self) {
	return DESKTOP_AGNOSTIC_VFS_VOLUME_GET_INTERFACE (self)->get_name (self);
}


DesktopAgnosticVFSFile* desktop_agnostic_vfs_volume_get_uri (DesktopAgnosticVFSVolume* self) {
	return DESKTOP_AGNOSTIC_VFS_VOLUME_GET_INTERFACE (self)->get_uri (self);
}


char* desktop_agnostic_vfs_volume_get_icon (DesktopAgnosticVFSVolume* self) {
	return DESKTOP_AGNOSTIC_VFS_VOLUME_GET_INTERFACE (self)->get_icon (self);
}


static void desktop_agnostic_vfs_volume_base_init (DesktopAgnosticVFSVolumeIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_object ("uri", "uri", "uri", DESKTOP_AGNOSTIC_VFS_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("icon", "icon", "icon", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	}
}


GType desktop_agnostic_vfs_volume_get_type (void) {
	static GType desktop_agnostic_vfs_volume_type_id = 0;
	if (desktop_agnostic_vfs_volume_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSVolumeIface), (GBaseInitFunc) desktop_agnostic_vfs_volume_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		desktop_agnostic_vfs_volume_type_id = g_type_register_static (G_TYPE_INTERFACE, "DesktopAgnosticVFSVolume", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (desktop_agnostic_vfs_volume_type_id, G_TYPE_OBJECT);
	}
	return desktop_agnostic_vfs_volume_type_id;
}


void* desktop_agnostic_vfs_volume_monitor_get_implementation (DesktopAgnosticVFSVolumeMonitor* self) {
	return DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GET_INTERFACE (self)->get_implementation (self);
}


GList* desktop_agnostic_vfs_volume_monitor_get_volumes (DesktopAgnosticVFSVolumeMonitor* self) {
	return DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GET_INTERFACE (self)->get_volumes (self);
}


static void desktop_agnostic_vfs_volume_monitor_base_init (DesktopAgnosticVFSVolumeMonitorIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_pointer ("implementation", "implementation", "implementation", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_pointer ("volumes", "volumes", "volumes", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_signal_new ("volume_mounted", DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME);
		g_signal_new ("volume_unmounted", DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME);
	}
}


GType desktop_agnostic_vfs_volume_monitor_get_type (void) {
	static GType desktop_agnostic_vfs_volume_monitor_type_id = 0;
	if (desktop_agnostic_vfs_volume_monitor_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSVolumeMonitorIface), (GBaseInitFunc) desktop_agnostic_vfs_volume_monitor_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		desktop_agnostic_vfs_volume_monitor_type_id = g_type_register_static (G_TYPE_INTERFACE, "DesktopAgnosticVFSVolumeMonitor", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (desktop_agnostic_vfs_volume_monitor_type_id, G_TYPE_OBJECT);
	}
	return desktop_agnostic_vfs_volume_monitor_type_id;
}


DesktopAgnosticVFSVolumeMonitor* desktop_agnostic_vfs_volume_monitor_get_default (GError** error) {
	DesktopAgnosticVFSVolumeMonitor* result;
	GError * _inner_error_;
	DesktopAgnosticVFSImplementation* vfs;
	_inner_error_ = NULL;
	vfs = desktop_agnostic_vfs_get_default (&_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if (vfs == NULL) {
		result = NULL;
		return result;
	} else {
		result = desktop_agnostic_vfs_implementation_volume_monitor_get_default (vfs);
		return result;
	}
}




