/* vfs-impl-thunar-vfs.c generated by valac, the Vala compiler
 * generated from vfs-impl-thunar-vfs.vala, do not modify */

/*
 * Desktop Agnostic Library: VFS implementation (with Thunar VFS).
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libdesktop-agnostic/vfs.h>
#include <thunar-vfs/thunar-vfs.h>
#include <stdlib.h>
#include <string.h>


#define DESKTOP_AGNOSTIC_VFS_TYPE_THUNAR_VFS_IMPLEMENTATION (desktop_agnostic_vfs_thunar_vfs_implementation_get_type ())
#define DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_THUNAR_VFS_IMPLEMENTATION, DesktopAgnosticVFSThunarVFSImplementation))
#define DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_THUNAR_VFS_IMPLEMENTATION, DesktopAgnosticVFSThunarVFSImplementationClass))
#define DESKTOP_AGNOSTIC_VFS_IS_THUNAR_VFS_IMPLEMENTATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_THUNAR_VFS_IMPLEMENTATION))
#define DESKTOP_AGNOSTIC_VFS_IS_THUNAR_VFS_IMPLEMENTATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_THUNAR_VFS_IMPLEMENTATION))
#define DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_THUNAR_VFS_IMPLEMENTATION, DesktopAgnosticVFSThunarVFSImplementationClass))

typedef struct _DesktopAgnosticVFSThunarVFSImplementation DesktopAgnosticVFSThunarVFSImplementation;
typedef struct _DesktopAgnosticVFSThunarVFSImplementationClass DesktopAgnosticVFSThunarVFSImplementationClass;
typedef struct _DesktopAgnosticVFSThunarVFSImplementationPrivate DesktopAgnosticVFSThunarVFSImplementationPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_slist_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_object_unref (var), NULL)))

#define DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_THUNAR_VFS (desktop_agnostic_vfs_volume_monitor_thunar_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_THUNAR_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_THUNAR_VFS, DesktopAgnosticVFSVolumeMonitorThunarVFS))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_THUNAR_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_THUNAR_VFS, DesktopAgnosticVFSVolumeMonitorThunarVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_MONITOR_THUNAR_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_THUNAR_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_MONITOR_THUNAR_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_THUNAR_VFS))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_THUNAR_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_THUNAR_VFS, DesktopAgnosticVFSVolumeMonitorThunarVFSClass))

typedef struct _DesktopAgnosticVFSVolumeMonitorThunarVFS DesktopAgnosticVFSVolumeMonitorThunarVFS;
typedef struct _DesktopAgnosticVFSVolumeMonitorThunarVFSClass DesktopAgnosticVFSVolumeMonitorThunarVFSClass;

#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE_THUNAR_VFS (desktop_agnostic_vfs_file_thunar_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_THUNAR_VFS, DesktopAgnosticVFSFileThunarVFS))
#define DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_THUNAR_VFS, DesktopAgnosticVFSFileThunarVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_THUNAR_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_THUNAR_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_THUNAR_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_THUNAR_VFS))
#define DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_THUNAR_VFS, DesktopAgnosticVFSFileThunarVFSClass))

typedef struct _DesktopAgnosticVFSFileThunarVFS DesktopAgnosticVFSFileThunarVFS;
typedef struct _DesktopAgnosticVFSFileThunarVFSClass DesktopAgnosticVFSFileThunarVFSClass;

#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_THUNAR_VFS (desktop_agnostic_vfs_file_monitor_thunar_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_THUNAR_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_THUNAR_VFS, DesktopAgnosticVFSFileMonitorThunarVFS))
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_THUNAR_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_THUNAR_VFS, DesktopAgnosticVFSFileMonitorThunarVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_MONITOR_THUNAR_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_THUNAR_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_MONITOR_THUNAR_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_THUNAR_VFS))
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_THUNAR_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_THUNAR_VFS, DesktopAgnosticVFSFileMonitorThunarVFSClass))

typedef struct _DesktopAgnosticVFSFileMonitorThunarVFS DesktopAgnosticVFSFileMonitorThunarVFS;
typedef struct _DesktopAgnosticVFSFileMonitorThunarVFSClass DesktopAgnosticVFSFileMonitorThunarVFSClass;

#define DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_THUNAR_VFS (desktop_agnostic_vfs_trash_thunar_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_TRASH_THUNAR_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_THUNAR_VFS, DesktopAgnosticVFSTrashThunarVFS))
#define DESKTOP_AGNOSTIC_VFS_TRASH_THUNAR_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_THUNAR_VFS, DesktopAgnosticVFSTrashThunarVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_TRASH_THUNAR_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_THUNAR_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_TRASH_THUNAR_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_THUNAR_VFS))
#define DESKTOP_AGNOSTIC_VFS_TRASH_THUNAR_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_THUNAR_VFS, DesktopAgnosticVFSTrashThunarVFSClass))

typedef struct _DesktopAgnosticVFSTrashThunarVFS DesktopAgnosticVFSTrashThunarVFS;
typedef struct _DesktopAgnosticVFSTrashThunarVFSClass DesktopAgnosticVFSTrashThunarVFSClass;

#define DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_THUNAR_VFS (desktop_agnostic_vfs_volume_thunar_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_THUNAR_VFS, DesktopAgnosticVFSVolumeThunarVFS))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_THUNAR_VFS, DesktopAgnosticVFSVolumeThunarVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_THUNAR_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_THUNAR_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_THUNAR_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_THUNAR_VFS))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_THUNAR_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_THUNAR_VFS, DesktopAgnosticVFSVolumeThunarVFSClass))

typedef struct _DesktopAgnosticVFSVolumeThunarVFS DesktopAgnosticVFSVolumeThunarVFS;
typedef struct _DesktopAgnosticVFSVolumeThunarVFSClass DesktopAgnosticVFSVolumeThunarVFSClass;

struct _DesktopAgnosticVFSThunarVFSImplementation {
	GObject parent_instance;
	DesktopAgnosticVFSThunarVFSImplementationPrivate * priv;
};

struct _DesktopAgnosticVFSThunarVFSImplementationClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticVFSThunarVFSImplementationPrivate {
	DesktopAgnosticVFSVolumeMonitor* vmonitor;
};


static gpointer desktop_agnostic_vfs_thunar_vfs_implementation_parent_class = NULL;
static DesktopAgnosticVFSImplementationIface* desktop_agnostic_vfs_thunar_vfs_implementation_desktop_agnostic_vfs_implementation_parent_iface = NULL;

GType desktop_agnostic_vfs_thunar_vfs_implementation_get_type (void);
#define DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_VFS_TYPE_THUNAR_VFS_IMPLEMENTATION, DesktopAgnosticVFSThunarVFSImplementationPrivate))
enum  {
	DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION_NAME,
	DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION_FILE_TYPE,
	DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION_FILE_MONITOR_TYPE,
	DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION_TRASH_TYPE,
	DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION_VOLUME_TYPE
};
static void desktop_agnostic_vfs_thunar_vfs_implementation_real_init (DesktopAgnosticVFSImplementation* base);
static void _g_slist_free_g_object_unref (GSList* self);
static GSList* desktop_agnostic_vfs_thunar_vfs_implementation_real_files_from_uri_list (DesktopAgnosticVFSImplementation* base, const char* uri_list, GError** error);
DesktopAgnosticVFSVolumeMonitorThunarVFS* desktop_agnostic_vfs_volume_monitor_thunar_vfs_new (void);
DesktopAgnosticVFSVolumeMonitorThunarVFS* desktop_agnostic_vfs_volume_monitor_thunar_vfs_construct (GType object_type);
GType desktop_agnostic_vfs_volume_monitor_thunar_vfs_get_type (void);
static DesktopAgnosticVFSVolumeMonitor* desktop_agnostic_vfs_thunar_vfs_implementation_real_volume_monitor_get_default (DesktopAgnosticVFSImplementation* base);
static void desktop_agnostic_vfs_thunar_vfs_implementation_real_shutdown (DesktopAgnosticVFSImplementation* base);
DesktopAgnosticVFSThunarVFSImplementation* desktop_agnostic_vfs_thunar_vfs_implementation_new (void);
DesktopAgnosticVFSThunarVFSImplementation* desktop_agnostic_vfs_thunar_vfs_implementation_construct (GType object_type);
GType desktop_agnostic_vfs_file_thunar_vfs_get_type (void);
GType desktop_agnostic_vfs_file_monitor_thunar_vfs_get_type (void);
GType desktop_agnostic_vfs_trash_thunar_vfs_get_type (void);
GType desktop_agnostic_vfs_volume_thunar_vfs_get_type (void);
static void desktop_agnostic_vfs_thunar_vfs_implementation_finalize (GObject* obj);
static void desktop_agnostic_vfs_thunar_vfs_implementation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType register_plugin (void);



static void desktop_agnostic_vfs_thunar_vfs_implementation_real_init (DesktopAgnosticVFSImplementation* base) {
	DesktopAgnosticVFSThunarVFSImplementation * self;
	self = (DesktopAgnosticVFSThunarVFSImplementation*) base;
	thunar_vfs_init ();
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


static GSList* desktop_agnostic_vfs_thunar_vfs_implementation_real_files_from_uri_list (DesktopAgnosticVFSImplementation* base, const char* uri_list, GError** error) {
	DesktopAgnosticVFSThunarVFSImplementation * self;
	GSList* result;
	GError * _inner_error_;
	GSList* files;
	GList* paths;
	self = (DesktopAgnosticVFSThunarVFSImplementation*) base;
	g_return_val_if_fail (uri_list != NULL, NULL);
	_inner_error_ = NULL;
	files = NULL;
	paths = thunar_vfs_path_list_from_string (uri_list, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		__g_slist_free_g_object_unref0 (files);
		return NULL;
	}
	{
		GList* path_collection;
		GList* path_it;
		path_collection = paths;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			ThunarVfsPath* path;
			path = (ThunarVfsPath*) path_it->data;
			{
				const char* uri;
				DesktopAgnosticVFSFile* file;
				DesktopAgnosticVFSFile* _tmp0_;
				uri = thunar_vfs_path_dup_uri (path);
				file = desktop_agnostic_vfs_file_new_for_uri (uri, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					__g_slist_free_g_object_unref0 (files);
					return NULL;
				}
				files = g_slist_append (files, (_tmp0_ = file, file = NULL, _tmp0_));
				_g_object_unref0 (file);
			}
		}
	}
	result = files;
	return result;
}


static DesktopAgnosticVFSVolumeMonitor* desktop_agnostic_vfs_thunar_vfs_implementation_real_volume_monitor_get_default (DesktopAgnosticVFSImplementation* base) {
	DesktopAgnosticVFSThunarVFSImplementation * self;
	DesktopAgnosticVFSVolumeMonitor* result;
	self = (DesktopAgnosticVFSThunarVFSImplementation*) base;
	if (self->priv->vmonitor == NULL) {
		DesktopAgnosticVFSVolumeMonitor* _tmp0_;
		self->priv->vmonitor = (_tmp0_ = (DesktopAgnosticVFSVolumeMonitor*) desktop_agnostic_vfs_volume_monitor_thunar_vfs_new (), _g_object_unref0 (self->priv->vmonitor), _tmp0_);
	}
	result = self->priv->vmonitor;
	return result;
}


static void desktop_agnostic_vfs_thunar_vfs_implementation_real_shutdown (DesktopAgnosticVFSImplementation* base) {
	DesktopAgnosticVFSThunarVFSImplementation * self;
	self = (DesktopAgnosticVFSThunarVFSImplementation*) base;
	thunar_vfs_shutdown ();
}


DesktopAgnosticVFSThunarVFSImplementation* desktop_agnostic_vfs_thunar_vfs_implementation_construct (GType object_type) {
	DesktopAgnosticVFSThunarVFSImplementation * self;
	self = (DesktopAgnosticVFSThunarVFSImplementation*) g_object_new (object_type, NULL);
	return self;
}


DesktopAgnosticVFSThunarVFSImplementation* desktop_agnostic_vfs_thunar_vfs_implementation_new (void) {
	return desktop_agnostic_vfs_thunar_vfs_implementation_construct (DESKTOP_AGNOSTIC_VFS_TYPE_THUNAR_VFS_IMPLEMENTATION);
}


static const char* desktop_agnostic_vfs_thunar_vfs_implementation_real_get_name (DesktopAgnosticVFSImplementation* base) {
	const char* result;
	DesktopAgnosticVFSThunarVFSImplementation* self;
	self = (DesktopAgnosticVFSThunarVFSImplementation*) base;
	result = "Thunar VFS";
	return result;
}


static GType desktop_agnostic_vfs_thunar_vfs_implementation_real_get_file_type (DesktopAgnosticVFSImplementation* base) {
	GType result;
	DesktopAgnosticVFSThunarVFSImplementation* self;
	self = (DesktopAgnosticVFSThunarVFSImplementation*) base;
	result = DESKTOP_AGNOSTIC_VFS_TYPE_FILE_THUNAR_VFS;
	return result;
}


static GType desktop_agnostic_vfs_thunar_vfs_implementation_real_get_file_monitor_type (DesktopAgnosticVFSImplementation* base) {
	GType result;
	DesktopAgnosticVFSThunarVFSImplementation* self;
	self = (DesktopAgnosticVFSThunarVFSImplementation*) base;
	result = DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_THUNAR_VFS;
	return result;
}


static GType desktop_agnostic_vfs_thunar_vfs_implementation_real_get_trash_type (DesktopAgnosticVFSImplementation* base) {
	GType result;
	DesktopAgnosticVFSThunarVFSImplementation* self;
	self = (DesktopAgnosticVFSThunarVFSImplementation*) base;
	result = DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_THUNAR_VFS;
	return result;
}


static GType desktop_agnostic_vfs_thunar_vfs_implementation_real_get_volume_type (DesktopAgnosticVFSImplementation* base) {
	GType result;
	DesktopAgnosticVFSThunarVFSImplementation* self;
	self = (DesktopAgnosticVFSThunarVFSImplementation*) base;
	result = DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_THUNAR_VFS;
	return result;
}


static void desktop_agnostic_vfs_thunar_vfs_implementation_class_init (DesktopAgnosticVFSThunarVFSImplementationClass * klass) {
	desktop_agnostic_vfs_thunar_vfs_implementation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticVFSThunarVFSImplementationPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_thunar_vfs_implementation_get_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_vfs_thunar_vfs_implementation_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION_NAME, "name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION_FILE_TYPE, "file-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION_FILE_MONITOR_TYPE, "file-monitor-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION_TRASH_TYPE, "trash-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION_VOLUME_TYPE, "volume-type");
}


static void desktop_agnostic_vfs_thunar_vfs_implementation_desktop_agnostic_vfs_implementation_interface_init (DesktopAgnosticVFSImplementationIface * iface) {
	desktop_agnostic_vfs_thunar_vfs_implementation_desktop_agnostic_vfs_implementation_parent_iface = g_type_interface_peek_parent (iface);
	iface->init = desktop_agnostic_vfs_thunar_vfs_implementation_real_init;
	iface->files_from_uri_list = desktop_agnostic_vfs_thunar_vfs_implementation_real_files_from_uri_list;
	iface->volume_monitor_get_default = desktop_agnostic_vfs_thunar_vfs_implementation_real_volume_monitor_get_default;
	iface->shutdown = desktop_agnostic_vfs_thunar_vfs_implementation_real_shutdown;
	iface->get_name = desktop_agnostic_vfs_thunar_vfs_implementation_real_get_name;
	iface->get_file_type = desktop_agnostic_vfs_thunar_vfs_implementation_real_get_file_type;
	iface->get_file_monitor_type = desktop_agnostic_vfs_thunar_vfs_implementation_real_get_file_monitor_type;
	iface->get_trash_type = desktop_agnostic_vfs_thunar_vfs_implementation_real_get_trash_type;
	iface->get_volume_type = desktop_agnostic_vfs_thunar_vfs_implementation_real_get_volume_type;
}


static void desktop_agnostic_vfs_thunar_vfs_implementation_instance_init (DesktopAgnosticVFSThunarVFSImplementation * self) {
	self->priv = DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION_GET_PRIVATE (self);
}


static void desktop_agnostic_vfs_thunar_vfs_implementation_finalize (GObject* obj) {
	DesktopAgnosticVFSThunarVFSImplementation * self;
	self = DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION (obj);
	_g_object_unref0 (self->priv->vmonitor);
	G_OBJECT_CLASS (desktop_agnostic_vfs_thunar_vfs_implementation_parent_class)->finalize (obj);
}


GType desktop_agnostic_vfs_thunar_vfs_implementation_get_type (void) {
	static GType desktop_agnostic_vfs_thunar_vfs_implementation_type_id = 0;
	if (desktop_agnostic_vfs_thunar_vfs_implementation_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSThunarVFSImplementationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_thunar_vfs_implementation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSThunarVFSImplementation), 0, (GInstanceInitFunc) desktop_agnostic_vfs_thunar_vfs_implementation_instance_init, NULL };
		static const GInterfaceInfo desktop_agnostic_vfs_implementation_info = { (GInterfaceInitFunc) desktop_agnostic_vfs_thunar_vfs_implementation_desktop_agnostic_vfs_implementation_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		desktop_agnostic_vfs_thunar_vfs_implementation_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticVFSThunarVFSImplementation", &g_define_type_info, 0);
		g_type_add_interface_static (desktop_agnostic_vfs_thunar_vfs_implementation_type_id, DESKTOP_AGNOSTIC_VFS_TYPE_IMPLEMENTATION, &desktop_agnostic_vfs_implementation_info);
	}
	return desktop_agnostic_vfs_thunar_vfs_implementation_type_id;
}


static void desktop_agnostic_vfs_thunar_vfs_implementation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSThunarVFSImplementation * self;
	self = DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION_NAME:
		g_value_set_string (value, desktop_agnostic_vfs_implementation_get_name ((DesktopAgnosticVFSImplementation*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION_FILE_TYPE:
		g_value_set_gtype (value, desktop_agnostic_vfs_implementation_get_file_type ((DesktopAgnosticVFSImplementation*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION_FILE_MONITOR_TYPE:
		g_value_set_gtype (value, desktop_agnostic_vfs_implementation_get_file_monitor_type ((DesktopAgnosticVFSImplementation*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION_TRASH_TYPE:
		g_value_set_gtype (value, desktop_agnostic_vfs_implementation_get_trash_type ((DesktopAgnosticVFSImplementation*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_THUNAR_VFS_IMPLEMENTATION_VOLUME_TYPE:
		g_value_set_gtype (value, desktop_agnostic_vfs_implementation_get_volume_type ((DesktopAgnosticVFSImplementation*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GType register_plugin (void) {
	GType result;
	result = DESKTOP_AGNOSTIC_VFS_TYPE_THUNAR_VFS_IMPLEMENTATION;
	return result;
}




