/* vfs-glob.c generated by valac, the Vala compiler
 * generated from vfs-glob.vala, do not modify */

/*
 * Desktop Agnostic Library: glob() wrapper.
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <glob.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>


#define DESKTOP_AGNOSTIC_VFS_TYPE_GLOB (desktop_agnostic_vfs_glob_get_type ())
#define DESKTOP_AGNOSTIC_VFS_GLOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_GLOB, DesktopAgnosticVFSGlob))
#define DESKTOP_AGNOSTIC_VFS_GLOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_GLOB, DesktopAgnosticVFSGlobClass))
#define DESKTOP_AGNOSTIC_VFS_IS_GLOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_GLOB))
#define DESKTOP_AGNOSTIC_VFS_IS_GLOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_GLOB))
#define DESKTOP_AGNOSTIC_VFS_GLOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_GLOB, DesktopAgnosticVFSGlobClass))

typedef struct _DesktopAgnosticVFSGlob DesktopAgnosticVFSGlob;
typedef struct _DesktopAgnosticVFSGlobClass DesktopAgnosticVFSGlobClass;
typedef struct _DesktopAgnosticVFSGlobPrivate DesktopAgnosticVFSGlobPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	DESKTOP_AGNOSTIC_VFS_GLOB_ERROR_NOSPACE,
	DESKTOP_AGNOSTIC_VFS_GLOB_ERROR_ABORTED,
	DESKTOP_AGNOSTIC_VFS_GLOB_ERROR_NOMATCH,
	DESKTOP_AGNOSTIC_VFS_GLOB_ERROR_BAD_PATTERN,
	DESKTOP_AGNOSTIC_VFS_GLOB_ERROR_BAD_FLAGS,
	DESKTOP_AGNOSTIC_VFS_GLOB_ERROR_ERRNO
} DesktopAgnosticVFSGlobError;
#define DESKTOP_AGNOSTIC_VFS_GLOB_ERROR desktop_agnostic_vfs_glob_error_quark ()
struct _DesktopAgnosticVFSGlob {
	GObject parent_instance;
	DesktopAgnosticVFSGlobPrivate * priv;
};

struct _DesktopAgnosticVFSGlobClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticVFSGlobPrivate {
	glob_t glob;
	char* _pattern;
	gint _flags;
};


static gpointer desktop_agnostic_vfs_glob_parent_class = NULL;

GQuark desktop_agnostic_vfs_glob_error_quark (void);
GType desktop_agnostic_vfs_glob_get_type (void);
#define DESKTOP_AGNOSTIC_VFS_GLOB_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_VFS_TYPE_GLOB, DesktopAgnosticVFSGlobPrivate))
enum  {
	DESKTOP_AGNOSTIC_VFS_GLOB_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_GLOB_OFFSET,
	DESKTOP_AGNOSTIC_VFS_GLOB_PATTERN,
	DESKTOP_AGNOSTIC_VFS_GLOB_FLAGS
};
static void desktop_agnostic_vfs_glob_run_glob (DesktopAgnosticVFSGlob* self, const char* pattern, gint flags, GError** error);
DesktopAgnosticVFSGlob* desktop_agnostic_vfs_glob_execute (const char* pattern, GError** error);
DesktopAgnosticVFSGlob* desktop_agnostic_vfs_glob_execute_with_flags (const char* pattern, gint flags, GError** error);
void desktop_agnostic_vfs_glob_append (DesktopAgnosticVFSGlob* self, const char* pattern, GError** error);
char** desktop_agnostic_vfs_glob_get_paths (DesktopAgnosticVFSGlob* self, int* result_length1);
static gint desktop_agnostic_vfs_glob_on_glob_error (const char* path, gint eerrno);
DesktopAgnosticVFSGlob* desktop_agnostic_vfs_glob_new (void);
DesktopAgnosticVFSGlob* desktop_agnostic_vfs_glob_construct (GType object_type);
gsize desktop_agnostic_vfs_glob_get_offset (DesktopAgnosticVFSGlob* self);
const char* desktop_agnostic_vfs_glob_get_pattern (DesktopAgnosticVFSGlob* self);
void desktop_agnostic_vfs_glob_set_pattern (DesktopAgnosticVFSGlob* self, const char* value);
gint desktop_agnostic_vfs_glob_get_flags (DesktopAgnosticVFSGlob* self);
void desktop_agnostic_vfs_glob_set_flags (DesktopAgnosticVFSGlob* self, gint value);
static void desktop_agnostic_vfs_glob_finalize (GObject* obj);
static void desktop_agnostic_vfs_glob_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void desktop_agnostic_vfs_glob_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark desktop_agnostic_vfs_glob_error_quark (void) {
	return g_quark_from_static_string ("desktop_agnostic_vfs_glob_error-quark");
}


DesktopAgnosticVFSGlob* desktop_agnostic_vfs_glob_execute (const char* pattern, GError** error) {
	DesktopAgnosticVFSGlob* result;
	GError * _inner_error_;
	DesktopAgnosticVFSGlob* g;
	g_return_val_if_fail (pattern != NULL, NULL);
	_inner_error_ = NULL;
	g = DESKTOP_AGNOSTIC_VFS_GLOB (g_object_new (DESKTOP_AGNOSTIC_VFS_TYPE_GLOB, "pattern", pattern, NULL));
	desktop_agnostic_vfs_glob_run_glob (g, g->priv->_pattern, g->priv->_flags, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DESKTOP_AGNOSTIC_VFS_GLOB_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (g);
			return NULL;
		} else {
			_g_object_unref0 (g);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = g;
	return result;
}


DesktopAgnosticVFSGlob* desktop_agnostic_vfs_glob_execute_with_flags (const char* pattern, gint flags, GError** error) {
	DesktopAgnosticVFSGlob* result;
	GError * _inner_error_;
	DesktopAgnosticVFSGlob* g;
	g_return_val_if_fail (pattern != NULL, NULL);
	_inner_error_ = NULL;
	g = DESKTOP_AGNOSTIC_VFS_GLOB (g_object_new (DESKTOP_AGNOSTIC_VFS_TYPE_GLOB, "pattern", pattern, "flags", flags, NULL));
	desktop_agnostic_vfs_glob_run_glob (g, g->priv->_pattern, g->priv->_flags, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DESKTOP_AGNOSTIC_VFS_GLOB_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (g);
			return NULL;
		} else {
			_g_object_unref0 (g);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = g;
	return result;
}


void desktop_agnostic_vfs_glob_append (DesktopAgnosticVFSGlob* self, const char* pattern, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pattern != NULL);
	_inner_error_ = NULL;
	desktop_agnostic_vfs_glob_run_glob (self, pattern, self->priv->_flags | GLOB_APPEND, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DESKTOP_AGNOSTIC_VFS_GLOB_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


char** desktop_agnostic_vfs_glob_get_paths (DesktopAgnosticVFSGlob* self, int* result_length1) {
	char** result;
	char** _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp0_ = self->priv->glob.gl_pathv, *result_length1 = self->priv->glob.gl_pathc, _tmp0_);
	return result;
}


static void desktop_agnostic_vfs_glob_run_glob (DesktopAgnosticVFSGlob* self, const char* pattern, gint flags, GError** error) {
	GError * _inner_error_;
	glob_t _tmp2_;
	gint _tmp1_;
	glob_t _tmp0_ = {0};
	gint res;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pattern != NULL);
	_inner_error_ = NULL;
	res = (_tmp1_ = glob (pattern, flags, (void*) desktop_agnostic_vfs_glob_on_glob_error, &_tmp0_), self->priv->glob = (_tmp2_ = _tmp0_, globfree (&self->priv->glob), _tmp2_), _tmp1_);
	if (res != 0) {
		switch (res) {
			case GLOB_NOSPACE:
			{
				_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_VFS_GLOB_ERROR, DESKTOP_AGNOSTIC_VFS_GLOB_ERROR_NOSPACE, "Ran out of memory.");
				{
					if (_inner_error_->domain == DESKTOP_AGNOSTIC_VFS_GLOB_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
			case GLOB_ABORTED:
			{
				_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_VFS_GLOB_ERROR, DESKTOP_AGNOSTIC_VFS_GLOB_ERROR_ABORTED, "Read error.");
				{
					if (_inner_error_->domain == DESKTOP_AGNOSTIC_VFS_GLOB_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
			case GLOB_NOMATCH:
			{
				_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_VFS_GLOB_ERROR, DESKTOP_AGNOSTIC_VFS_GLOB_ERROR_NOMATCH, "No matches found.");
				{
					if (_inner_error_->domain == DESKTOP_AGNOSTIC_VFS_GLOB_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
			default:
			{
				g_critical ("vfs-glob.vala:126: Unknown error code: %d", res);
				break;
			}
		}
	}
}


static gint desktop_agnostic_vfs_glob_on_glob_error (const char* path, gint eerrno) {
	gint result;
	GError * _inner_error_;
	g_return_val_if_fail (path != NULL, 0);
	_inner_error_ = NULL;
	switch (eerrno) {
		case EACCES:
		case EBADF:
		case EMFILE:
		case ENFILE:
		case ENOENT:
		case ENOMEM:
		case ENOTDIR:
		case EFAULT:
		case EINVAL:
		case ELOOP:
		case ENAMETOOLONG:
		{
			_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_VFS_GLOB_ERROR, DESKTOP_AGNOSTIC_VFS_GLOB_ERROR_ERRNO, "Miscellaneous error for '%s' (%d): %s", path, eerrno, strerror (eerrno));
			{
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		default:
		{
			g_critical ("vfs-glob.vala:151: Unknown error code: %d", eerrno);
			break;
		}
	}
	result = 1;
	return result;
}


DesktopAgnosticVFSGlob* desktop_agnostic_vfs_glob_construct (GType object_type) {
	DesktopAgnosticVFSGlob * self;
	self = (DesktopAgnosticVFSGlob*) g_object_new (object_type, NULL);
	return self;
}


DesktopAgnosticVFSGlob* desktop_agnostic_vfs_glob_new (void) {
	return desktop_agnostic_vfs_glob_construct (DESKTOP_AGNOSTIC_VFS_TYPE_GLOB);
}


gsize desktop_agnostic_vfs_glob_get_offset (DesktopAgnosticVFSGlob* self) {
	gsize result;
	g_return_val_if_fail (self != NULL, 0UL);
	result = self->priv->glob.gl_offs;
	return result;
}


const char* desktop_agnostic_vfs_glob_get_pattern (DesktopAgnosticVFSGlob* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_pattern;
	return result;
}


void desktop_agnostic_vfs_glob_set_pattern (DesktopAgnosticVFSGlob* self, const char* value) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (_vala_strcmp0 (value, "") != 0) {
		char* _tmp0_;
		self->priv->_pattern = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_pattern), _tmp0_);
	} else {
		_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_VFS_GLOB_ERROR, DESKTOP_AGNOSTIC_VFS_GLOB_ERROR_BAD_PATTERN, "Invalid pattern.");
		{
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_object_notify ((GObject *) self, "pattern");
}


gint desktop_agnostic_vfs_glob_get_flags (DesktopAgnosticVFSGlob* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_flags;
	return result;
}


void desktop_agnostic_vfs_glob_set_flags (DesktopAgnosticVFSGlob* self, gint value) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (value >= 0) {
		self->priv->_flags = value;
	} else {
		_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_VFS_GLOB_ERROR, DESKTOP_AGNOSTIC_VFS_GLOB_ERROR_BAD_FLAGS, "Invalid flags.");
		{
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_object_notify ((GObject *) self, "flags");
}


static void desktop_agnostic_vfs_glob_class_init (DesktopAgnosticVFSGlobClass * klass) {
	desktop_agnostic_vfs_glob_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticVFSGlobPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_glob_get_property;
	G_OBJECT_CLASS (klass)->set_property = desktop_agnostic_vfs_glob_set_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_vfs_glob_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_GLOB_OFFSET, g_param_spec_ulong ("offset", "offset", "offset", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_GLOB_PATTERN, g_param_spec_string ("pattern", "pattern", "pattern", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_GLOB_FLAGS, g_param_spec_int ("flags", "flags", "flags", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void desktop_agnostic_vfs_glob_instance_init (DesktopAgnosticVFSGlob * self) {
	self->priv = DESKTOP_AGNOSTIC_VFS_GLOB_GET_PRIVATE (self);
	self->priv->_flags = (GLOB_MARK | GLOB_BRACE) | GLOB_TILDE_CHECK;
}


static void desktop_agnostic_vfs_glob_finalize (GObject* obj) {
	DesktopAgnosticVFSGlob * self;
	self = DESKTOP_AGNOSTIC_VFS_GLOB (obj);
	globfree (&self->priv->glob);
	_g_free0 (self->priv->_pattern);
	G_OBJECT_CLASS (desktop_agnostic_vfs_glob_parent_class)->finalize (obj);
}


GType desktop_agnostic_vfs_glob_get_type (void) {
	static GType desktop_agnostic_vfs_glob_type_id = 0;
	if (desktop_agnostic_vfs_glob_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSGlobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_glob_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSGlob), 0, (GInstanceInitFunc) desktop_agnostic_vfs_glob_instance_init, NULL };
		desktop_agnostic_vfs_glob_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticVFSGlob", &g_define_type_info, 0);
	}
	return desktop_agnostic_vfs_glob_type_id;
}


static void desktop_agnostic_vfs_glob_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSGlob * self;
	self = DESKTOP_AGNOSTIC_VFS_GLOB (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_GLOB_OFFSET:
		g_value_set_ulong (value, desktop_agnostic_vfs_glob_get_offset (self));
		break;
		case DESKTOP_AGNOSTIC_VFS_GLOB_PATTERN:
		g_value_set_string (value, desktop_agnostic_vfs_glob_get_pattern (self));
		break;
		case DESKTOP_AGNOSTIC_VFS_GLOB_FLAGS:
		g_value_set_int (value, desktop_agnostic_vfs_glob_get_flags (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void desktop_agnostic_vfs_glob_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSGlob * self;
	self = DESKTOP_AGNOSTIC_VFS_GLOB (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_GLOB_PATTERN:
		desktop_agnostic_vfs_glob_set_pattern (self, g_value_get_string (value));
		break;
		case DESKTOP_AGNOSTIC_VFS_GLOB_FLAGS:
		desktop_agnostic_vfs_glob_set_flags (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




