/* ui-launcher-editor-dialog.c generated by valac, the Vala compiler
 * generated from ui-launcher-editor-dialog.vala, do not modify */

/*
 * Desktop Agnostic Library: Icon chooser dialog.
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <build-config.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <libdesktop-agnostic/vfs.h>
#include <libdesktop-agnostic/fdo.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>


#define DESKTOP_AGNOSTIC_UI_TYPE_FIXED_TABLE (desktop_agnostic_ui_fixed_table_get_type ())
#define DESKTOP_AGNOSTIC_UI_FIXED_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_UI_TYPE_FIXED_TABLE, DesktopAgnosticUIFixedTable))
#define DESKTOP_AGNOSTIC_UI_FIXED_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_UI_TYPE_FIXED_TABLE, DesktopAgnosticUIFixedTableClass))
#define DESKTOP_AGNOSTIC_UI_IS_FIXED_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_UI_TYPE_FIXED_TABLE))
#define DESKTOP_AGNOSTIC_UI_IS_FIXED_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_UI_TYPE_FIXED_TABLE))
#define DESKTOP_AGNOSTIC_UI_FIXED_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_UI_TYPE_FIXED_TABLE, DesktopAgnosticUIFixedTableClass))

typedef struct _DesktopAgnosticUIFixedTable DesktopAgnosticUIFixedTable;
typedef struct _DesktopAgnosticUIFixedTableClass DesktopAgnosticUIFixedTableClass;
typedef struct _DesktopAgnosticUIFixedTablePrivate DesktopAgnosticUIFixedTablePrivate;

#define DESKTOP_AGNOSTIC_UI_TYPE_LAUNCHER_EDITOR_DIALOG (desktop_agnostic_ui_launcher_editor_dialog_get_type ())
#define DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_UI_TYPE_LAUNCHER_EDITOR_DIALOG, DesktopAgnosticUILauncherEditorDialog))
#define DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_UI_TYPE_LAUNCHER_EDITOR_DIALOG, DesktopAgnosticUILauncherEditorDialogClass))
#define DESKTOP_AGNOSTIC_UI_IS_LAUNCHER_EDITOR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_UI_TYPE_LAUNCHER_EDITOR_DIALOG))
#define DESKTOP_AGNOSTIC_UI_IS_LAUNCHER_EDITOR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_UI_TYPE_LAUNCHER_EDITOR_DIALOG))
#define DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_UI_TYPE_LAUNCHER_EDITOR_DIALOG, DesktopAgnosticUILauncherEditorDialogClass))

typedef struct _DesktopAgnosticUILauncherEditorDialog DesktopAgnosticUILauncherEditorDialog;
typedef struct _DesktopAgnosticUILauncherEditorDialogClass DesktopAgnosticUILauncherEditorDialogClass;
typedef struct _DesktopAgnosticUILauncherEditorDialogPrivate DesktopAgnosticUILauncherEditorDialogPrivate;

#define DESKTOP_AGNOSTIC_UI_TYPE_ICON_BUTTON (desktop_agnostic_ui_icon_button_get_type ())
#define DESKTOP_AGNOSTIC_UI_ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_UI_TYPE_ICON_BUTTON, DesktopAgnosticUIIconButton))
#define DESKTOP_AGNOSTIC_UI_ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_UI_TYPE_ICON_BUTTON, DesktopAgnosticUIIconButtonClass))
#define DESKTOP_AGNOSTIC_UI_IS_ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_UI_TYPE_ICON_BUTTON))
#define DESKTOP_AGNOSTIC_UI_IS_ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_UI_TYPE_ICON_BUTTON))
#define DESKTOP_AGNOSTIC_UI_ICON_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_UI_TYPE_ICON_BUTTON, DesktopAgnosticUIIconButtonClass))

typedef struct _DesktopAgnosticUIIconButton DesktopAgnosticUIIconButton;
typedef struct _DesktopAgnosticUIIconButtonClass DesktopAgnosticUIIconButtonClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DesktopAgnosticUIFixedTable {
	GtkTable parent_instance;
	DesktopAgnosticUIFixedTablePrivate * priv;
};

struct _DesktopAgnosticUIFixedTableClass {
	GtkTableClass parent_class;
};

struct _DesktopAgnosticUILauncherEditorDialog {
	GtkDialog parent_instance;
	DesktopAgnosticUILauncherEditorDialogPrivate * priv;
};

struct _DesktopAgnosticUILauncherEditorDialogClass {
	GtkDialogClass parent_class;
};

struct _DesktopAgnosticUILauncherEditorDialogPrivate {
	DesktopAgnosticUIIconButton* _icon;
	GtkEntry* _name;
	GtkEntry* _desc;
	GtkEntry* _exec;
	GtkCheckButton* _terminal;
	GtkCheckButton* _startup_notification;
	DesktopAgnosticVFSFile* _file;
	DesktopAgnosticVFSFile* _output;
	gboolean _standalone;
	DesktopAgnosticFDODesktopEntry* _entry;
};


static gpointer desktop_agnostic_ui_fixed_table_parent_class = NULL;
static gpointer desktop_agnostic_ui_launcher_editor_dialog_parent_class = NULL;

#define LAUNCHER_I18N_PACKAGE GETTEXT_PACKAGE
GType desktop_agnostic_ui_fixed_table_get_type (void);
enum  {
	DESKTOP_AGNOSTIC_UI_FIXED_TABLE_DUMMY_PROPERTY
};
DesktopAgnosticUIFixedTable* desktop_agnostic_ui_fixed_table_new (guint columns, guint rows);
DesktopAgnosticUIFixedTable* desktop_agnostic_ui_fixed_table_construct (GType object_type, guint columns, guint rows);
void desktop_agnostic_ui_fixed_table_attach_defaults (DesktopAgnosticUIFixedTable* self, GtkWidget* widget, guint left_attach, guint right_attach, guint top_attach, guint bottom_attach);
void desktop_agnostic_ui_fixed_table_attach_fill (DesktopAgnosticUIFixedTable* self, GtkWidget* widget, guint left_attach, guint right_attach, guint top_attach, guint bottom_attach);
GType desktop_agnostic_ui_launcher_editor_dialog_get_type (void);
GType desktop_agnostic_ui_icon_button_get_type (void);
#define DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_UI_TYPE_LAUNCHER_EDITOR_DIALOG, DesktopAgnosticUILauncherEditorDialogPrivate))
enum  {
	DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_FILE,
	DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_OUTPUT
};
static void desktop_agnostic_ui_launcher_editor_dialog_set_file (DesktopAgnosticUILauncherEditorDialog* self, DesktopAgnosticVFSFile* value);
static void desktop_agnostic_ui_launcher_editor_dialog_set_output (DesktopAgnosticUILauncherEditorDialog* self, DesktopAgnosticVFSFile* value);
DesktopAgnosticUILauncherEditorDialog* desktop_agnostic_ui_launcher_editor_dialog_new (DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* output, gboolean standalone);
DesktopAgnosticUILauncherEditorDialog* desktop_agnostic_ui_launcher_editor_dialog_construct (GType object_type, DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* output, gboolean standalone);
static gboolean _lambda0_ (GtkWidget* widget, GdkEvent* event, DesktopAgnosticUILauncherEditorDialog* self);
static gboolean __lambda0__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
DesktopAgnosticVFSFile* desktop_agnostic_ui_launcher_editor_dialog_get_file (DesktopAgnosticUILauncherEditorDialog* self);
static void desktop_agnostic_ui_launcher_editor_dialog_build_ui (DesktopAgnosticUILauncherEditorDialog* self);
static void desktop_agnostic_ui_launcher_editor_dialog_real_constructed (GObject* base);
static void desktop_agnostic_ui_launcher_editor_dialog_on_response (DesktopAgnosticUILauncherEditorDialog* self, gint response_id);
static void _desktop_agnostic_ui_launcher_editor_dialog_on_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
DesktopAgnosticUIIconButton* desktop_agnostic_ui_icon_button_new (const char* icon);
DesktopAgnosticUIIconButton* desktop_agnostic_ui_icon_button_construct (GType object_type, const char* icon);
static void desktop_agnostic_ui_launcher_editor_dialog_on_icon_changed (DesktopAgnosticUILauncherEditorDialog* self, DesktopAgnosticUIIconButton* button);
static void _desktop_agnostic_ui_launcher_editor_dialog_on_icon_changed_desktop_agnostic_ui_icon_button_icon_selected (DesktopAgnosticUIIconButton* _sender, gpointer self);
static void desktop_agnostic_ui_launcher_editor_dialog_on_name_changed (DesktopAgnosticUILauncherEditorDialog* self, GtkEditable* editable);
static void _desktop_agnostic_ui_launcher_editor_dialog_on_name_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void desktop_agnostic_ui_launcher_editor_dialog_on_desc_changed (DesktopAgnosticUILauncherEditorDialog* self, GtkEditable* editable);
static void _desktop_agnostic_ui_launcher_editor_dialog_on_desc_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void desktop_agnostic_ui_launcher_editor_dialog_on_exec_changed (DesktopAgnosticUILauncherEditorDialog* self, GtkEditable* editable);
static void _desktop_agnostic_ui_launcher_editor_dialog_on_exec_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void desktop_agnostic_ui_launcher_editor_dialog_on_exec_browse (DesktopAgnosticUILauncherEditorDialog* self, GtkButton* btn);
static void _desktop_agnostic_ui_launcher_editor_dialog_on_exec_browse_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void desktop_agnostic_ui_launcher_editor_dialog_on_terminal_toggled (DesktopAgnosticUILauncherEditorDialog* self, GtkToggleButton* button);
static void _desktop_agnostic_ui_launcher_editor_dialog_on_terminal_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void desktop_agnostic_ui_launcher_editor_dialog_on_startup_notification_toggled (DesktopAgnosticUILauncherEditorDialog* self, GtkToggleButton* button);
static void _desktop_agnostic_ui_launcher_editor_dialog_on_startup_notification_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
const char* desktop_agnostic_ui_icon_button_get_icon (DesktopAgnosticUIIconButton* self);
static gboolean desktop_agnostic_ui_launcher_editor_dialog_change_output_file_prompt (DesktopAgnosticUILauncherEditorDialog* self);
DesktopAgnosticVFSFile* desktop_agnostic_ui_launcher_editor_dialog_get_output (DesktopAgnosticUILauncherEditorDialog* self);
static void desktop_agnostic_ui_launcher_editor_dialog_finalize (GObject* obj);
static void desktop_agnostic_ui_launcher_editor_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void desktop_agnostic_ui_launcher_editor_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



DesktopAgnosticUIFixedTable* desktop_agnostic_ui_fixed_table_construct (GType object_type, guint columns, guint rows) {
	DesktopAgnosticUIFixedTable * self;
	self = g_object_newv (object_type, 0, NULL);
	g_object_set ((GtkTable*) self, "n-columns", columns, NULL);
	g_object_set ((GtkTable*) self, "n-rows", rows, NULL);
	gtk_table_set_homogeneous ((GtkTable*) self, FALSE);
	return self;
}


DesktopAgnosticUIFixedTable* desktop_agnostic_ui_fixed_table_new (guint columns, guint rows) {
	return desktop_agnostic_ui_fixed_table_construct (DESKTOP_AGNOSTIC_UI_TYPE_FIXED_TABLE, columns, rows);
}


void desktop_agnostic_ui_fixed_table_attach_defaults (DesktopAgnosticUIFixedTable* self, GtkWidget* widget, guint left_attach, guint right_attach, guint top_attach, guint bottom_attach) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	gtk_table_attach ((GtkTable*) self, widget, left_attach, right_attach, top_attach, bottom_attach, GTK_FILL, GTK_SHRINK, (guint) 0, (guint) 0);
}


void desktop_agnostic_ui_fixed_table_attach_fill (DesktopAgnosticUIFixedTable* self, GtkWidget* widget, guint left_attach, guint right_attach, guint top_attach, guint bottom_attach) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	gtk_table_attach ((GtkTable*) self, widget, left_attach, right_attach, top_attach, bottom_attach, GTK_FILL, 0, (guint) 0, (guint) 0);
}


static void desktop_agnostic_ui_fixed_table_class_init (DesktopAgnosticUIFixedTableClass * klass) {
	desktop_agnostic_ui_fixed_table_parent_class = g_type_class_peek_parent (klass);
}


static void desktop_agnostic_ui_fixed_table_instance_init (DesktopAgnosticUIFixedTable * self) {
}


GType desktop_agnostic_ui_fixed_table_get_type (void) {
	static GType desktop_agnostic_ui_fixed_table_type_id = 0;
	if (desktop_agnostic_ui_fixed_table_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticUIFixedTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_ui_fixed_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticUIFixedTable), 0, (GInstanceInitFunc) desktop_agnostic_ui_fixed_table_instance_init, NULL };
		desktop_agnostic_ui_fixed_table_type_id = g_type_register_static (GTK_TYPE_TABLE, "DesktopAgnosticUIFixedTable", &g_define_type_info, 0);
	}
	return desktop_agnostic_ui_fixed_table_type_id;
}


DesktopAgnosticUILauncherEditorDialog* desktop_agnostic_ui_launcher_editor_dialog_construct (GType object_type, DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* output, gboolean standalone) {
	GParameter * __params;
	GParameter * __params_it;
	GtkWindowType type = 0;
	DesktopAgnosticUILauncherEditorDialog * self;
	g_return_val_if_fail (file != NULL, NULL);
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	if (standalone) {
		type = GTK_WINDOW_TOPLEVEL;
	} else {
		type = GTK_WINDOW_POPUP;
	}
	__params_it->name = "type";
	g_value_init (&__params_it->value, GTK_TYPE_WINDOW_TYPE);
	g_value_set_enum (&__params_it->value, type);
	__params_it++;
	self->priv->_standalone = standalone;
	__params_it->name = "file";
	g_value_init (&__params_it->value, DESKTOP_AGNOSTIC_VFS_TYPE_FILE);
	g_value_set_object (&__params_it->value, file);
	__params_it++;
	__params_it->name = "output";
	g_value_init (&__params_it->value, DESKTOP_AGNOSTIC_VFS_TYPE_FILE);
	g_value_set_object (&__params_it->value, output);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DesktopAgnosticUILauncherEditorDialog* desktop_agnostic_ui_launcher_editor_dialog_new (DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* output, gboolean standalone) {
	return desktop_agnostic_ui_launcher_editor_dialog_construct (DESKTOP_AGNOSTIC_UI_TYPE_LAUNCHER_EDITOR_DIALOG, file, output, standalone);
}


static gboolean _lambda0_ (GtkWidget* widget, GdkEvent* event, DesktopAgnosticUILauncherEditorDialog* self) {
	gboolean result;
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	gtk_main_quit ();
	result = TRUE;
	return result;
}


static gboolean __lambda0__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	return _lambda0_ (_sender, event, self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void desktop_agnostic_ui_launcher_editor_dialog_real_constructed (GObject* base) {
	DesktopAgnosticUILauncherEditorDialog * self;
	GError * _inner_error_;
	DesktopAgnosticFDODesktopEntry* _tmp1_;
	DesktopAgnosticFDODesktopEntry* _tmp2_;
	self = (DesktopAgnosticUILauncherEditorDialog*) base;
	_inner_error_ = NULL;
	gtk_window_set_title ((GtkWindow*) self, _ ("Desktop Entry Editor"));
	gtk_window_set_icon_name ((GtkWindow*) self, "gtk-preferences");
	if (self->priv->_standalone) {
		g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) __lambda0__gtk_widget_delete_event, self, 0);
	}
	if (self->priv->_output == NULL) {
		DesktopAgnosticVFSFile* _tmp0_;
		self->priv->_output = (_tmp0_ = _g_object_ref0 (self->priv->_file), _g_object_unref0 (self->priv->_output), _tmp0_);
	}
	_tmp1_ = desktop_agnostic_fdo_desktop_entry_new_for_file (self->priv->_file, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->_entry = (_tmp2_ = _tmp1_, _g_object_unref0 (self->priv->_entry), _tmp2_);
	desktop_agnostic_ui_launcher_editor_dialog_build_ui (self);
}


static void _desktop_agnostic_ui_launcher_editor_dialog_on_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	desktop_agnostic_ui_launcher_editor_dialog_on_response (self, response_id);
}


static void _desktop_agnostic_ui_launcher_editor_dialog_on_icon_changed_desktop_agnostic_ui_icon_button_icon_selected (DesktopAgnosticUIIconButton* _sender, gpointer self) {
	desktop_agnostic_ui_launcher_editor_dialog_on_icon_changed (self, _sender);
}


static void _desktop_agnostic_ui_launcher_editor_dialog_on_name_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	desktop_agnostic_ui_launcher_editor_dialog_on_name_changed (self, _sender);
}


static void _desktop_agnostic_ui_launcher_editor_dialog_on_desc_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	desktop_agnostic_ui_launcher_editor_dialog_on_desc_changed (self, _sender);
}


static void _desktop_agnostic_ui_launcher_editor_dialog_on_exec_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	desktop_agnostic_ui_launcher_editor_dialog_on_exec_changed (self, _sender);
}


static void _desktop_agnostic_ui_launcher_editor_dialog_on_exec_browse_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	desktop_agnostic_ui_launcher_editor_dialog_on_exec_browse (self, _sender);
}


static void _desktop_agnostic_ui_launcher_editor_dialog_on_terminal_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	desktop_agnostic_ui_launcher_editor_dialog_on_terminal_toggled (self, _sender);
}


static void _desktop_agnostic_ui_launcher_editor_dialog_on_startup_notification_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	desktop_agnostic_ui_launcher_editor_dialog_on_startup_notification_toggled (self, _sender);
}


static void desktop_agnostic_ui_launcher_editor_dialog_build_ui (DesktopAgnosticUILauncherEditorDialog* self) {
	DesktopAgnosticUIFixedTable* table;
	char* icon;
	GtkButton* exec_button;
	GtkImage* exec_image;
	GtkLabel* name_label;
	GtkLabel* desc_label;
	GtkLabel* exec_label;
	GtkHBox* exec_hbox;
	GtkExpander* advanced;
	GtkVBox* advanced_vbox;
	DesktopAgnosticUIFixedTable* _tmp0_;
	DesktopAgnosticUIIconButton* _tmp3_;
	GtkLabel* _tmp4_;
	GtkEntry* _tmp5_;
	GtkLabel* _tmp7_;
	GtkEntry* _tmp8_;
	GtkLabel* _tmp10_;
	GtkHBox* _tmp11_;
	GtkEntry* _tmp12_;
	GtkButton* _tmp14_;
	GtkImage* _tmp15_;
	GtkExpander* _tmp16_;
	GtkVBox* _tmp17_;
	GtkCheckButton* _tmp18_;
	GtkCheckButton* _tmp19_;
	g_return_if_fail (self != NULL);
	table = NULL;
	icon = NULL;
	exec_button = NULL;
	exec_image = NULL;
	name_label = NULL;
	desc_label = NULL;
	exec_label = NULL;
	exec_hbox = NULL;
	advanced = NULL;
	advanced_vbox = NULL;
	gtk_dialog_add_buttons ((GtkDialog*) self, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_APPLY, NULL);
	gtk_dialog_set_default_response ((GtkDialog*) self, (gint) GTK_RESPONSE_CANCEL);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) _desktop_agnostic_ui_launcher_editor_dialog_on_response_gtk_dialog_response, self, 0);
	table = (_tmp0_ = g_object_ref_sink (desktop_agnostic_ui_fixed_table_new ((guint) 4, (guint) 3)), _g_object_unref0 (table), _tmp0_);
	gtk_table_set_row_spacings ((GtkTable*) table, (guint) 5);
	g_object_set ((GtkTable*) table, "column-spacing", (guint) 5, NULL);
	if (desktop_agnostic_fdo_desktop_entry_key_exists (self->priv->_entry, "Icon")) {
		char* _tmp1_;
		icon = (_tmp1_ = desktop_agnostic_fdo_desktop_entry_get_icon (self->priv->_entry), _g_free0 (icon), _tmp1_);
	} else {
		char* _tmp2_;
		icon = (_tmp2_ = g_strdup (GTK_STOCK_MISSING_IMAGE), _g_free0 (icon), _tmp2_);
	}
	self->priv->_icon = (_tmp3_ = g_object_ref_sink (desktop_agnostic_ui_icon_button_new (icon)), _g_object_unref0 (self->priv->_icon), _tmp3_);
	g_signal_connect_object (self->priv->_icon, "icon-selected", (GCallback) _desktop_agnostic_ui_launcher_editor_dialog_on_icon_changed_desktop_agnostic_ui_icon_button_icon_selected, self, 0);
	desktop_agnostic_ui_fixed_table_attach_defaults (table, (GtkWidget*) self->priv->_icon, (guint) 0, (guint) 1, (guint) 0, (guint) 3);
	name_label = (_tmp4_ = g_object_ref_sink ((GtkLabel*) gtk_label_new_with_mnemonic (_ ("_Name:"))), _g_object_unref0 (name_label), _tmp4_);
	desktop_agnostic_ui_fixed_table_attach_defaults (table, (GtkWidget*) name_label, (guint) 1, (guint) 2, (guint) 0, (guint) 1);
	self->priv->_name = (_tmp5_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->priv->_name), _tmp5_);
	gtk_label_set_mnemonic_widget (name_label, (GtkWidget*) self->priv->_name);
	if (desktop_agnostic_fdo_desktop_entry_key_exists (self->priv->_entry, "Name")) {
		char* _tmp6_;
		gtk_entry_set_text (self->priv->_name, _tmp6_ = desktop_agnostic_fdo_desktop_entry_get_name (self->priv->_entry));
		_g_free0 (_tmp6_);
	}
	g_signal_connect_object ((GtkEditable*) self->priv->_name, "changed", (GCallback) _desktop_agnostic_ui_launcher_editor_dialog_on_name_changed_gtk_editable_changed, self, 0);
	desktop_agnostic_ui_fixed_table_attach_defaults (table, (GtkWidget*) self->priv->_name, (guint) 2, (guint) 3, (guint) 0, (guint) 1);
	desc_label = (_tmp7_ = g_object_ref_sink ((GtkLabel*) gtk_label_new_with_mnemonic (_ ("_Description:"))), _g_object_unref0 (desc_label), _tmp7_);
	desktop_agnostic_ui_fixed_table_attach_defaults (table, (GtkWidget*) desc_label, (guint) 1, (guint) 2, (guint) 1, (guint) 2);
	self->priv->_desc = (_tmp8_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->priv->_desc), _tmp8_);
	gtk_label_set_mnemonic_widget (desc_label, (GtkWidget*) self->priv->_desc);
	if (desktop_agnostic_fdo_desktop_entry_key_exists (self->priv->_entry, "Comment")) {
		char* _tmp9_;
		gtk_entry_set_text (self->priv->_desc, _tmp9_ = desktop_agnostic_fdo_desktop_entry_get_string (self->priv->_entry, "Comment"));
		_g_free0 (_tmp9_);
	}
	g_signal_connect_object ((GtkEditable*) self->priv->_desc, "changed", (GCallback) _desktop_agnostic_ui_launcher_editor_dialog_on_desc_changed_gtk_editable_changed, self, 0);
	desktop_agnostic_ui_fixed_table_attach_defaults (table, (GtkWidget*) self->priv->_desc, (guint) 2, (guint) 3, (guint) 1, (guint) 2);
	exec_label = (_tmp10_ = g_object_ref_sink ((GtkLabel*) gtk_label_new_with_mnemonic (_ ("_Command:"))), _g_object_unref0 (exec_label), _tmp10_);
	desktop_agnostic_ui_fixed_table_attach_defaults (table, (GtkWidget*) exec_label, (guint) 1, (guint) 2, (guint) 2, (guint) 3);
	exec_hbox = (_tmp11_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 5)), _g_object_unref0 (exec_hbox), _tmp11_);
	self->priv->_exec = (_tmp12_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->priv->_exec), _tmp12_);
	gtk_label_set_mnemonic_widget (exec_label, (GtkWidget*) self->priv->_exec);
	if (desktop_agnostic_fdo_desktop_entry_key_exists (self->priv->_entry, "Exec")) {
		char* _tmp13_;
		gtk_entry_set_text (self->priv->_exec, _tmp13_ = desktop_agnostic_fdo_desktop_entry_get_string (self->priv->_entry, "Exec"));
		_g_free0 (_tmp13_);
	}
	g_signal_connect_object ((GtkEditable*) self->priv->_exec, "changed", (GCallback) _desktop_agnostic_ui_launcher_editor_dialog_on_exec_changed_gtk_editable_changed, self, 0);
	gtk_container_add ((GtkContainer*) exec_hbox, (GtkWidget*) self->priv->_exec);
	exec_button = (_tmp14_ = g_object_ref_sink ((GtkButton*) gtk_button_new_with_mnemonic (_ ("_Browse..."))), _g_object_unref0 (exec_button), _tmp14_);
	exec_image = (_tmp15_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_OPEN, GTK_ICON_SIZE_BUTTON)), _g_object_unref0 (exec_image), _tmp15_);
	gtk_button_set_image (exec_button, (GtkWidget*) exec_image);
	g_signal_connect_object (exec_button, "clicked", (GCallback) _desktop_agnostic_ui_launcher_editor_dialog_on_exec_browse_gtk_button_clicked, self, 0);
	gtk_container_add ((GtkContainer*) exec_hbox, (GtkWidget*) exec_button);
	desktop_agnostic_ui_fixed_table_attach_defaults (table, (GtkWidget*) exec_hbox, (guint) 2, (guint) 3, (guint) 2, (guint) 3);
	advanced = (_tmp16_ = g_object_ref_sink ((GtkExpander*) gtk_expander_new_with_mnemonic (_ ("_Advanced"))), _g_object_unref0 (advanced), _tmp16_);
	advanced_vbox = (_tmp17_ = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 5)), _g_object_unref0 (advanced_vbox), _tmp17_);
	self->priv->_terminal = (_tmp18_ = g_object_ref_sink ((GtkCheckButton*) gtk_check_button_new_with_mnemonic (_ ("Run in _terminal"))), _g_object_unref0 (self->priv->_terminal), _tmp18_);
	if (desktop_agnostic_fdo_desktop_entry_key_exists (self->priv->_entry, "Terminal")) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->_terminal, desktop_agnostic_fdo_desktop_entry_get_boolean (self->priv->_entry, "Terminal"));
	}
	g_signal_connect_object ((GtkToggleButton*) self->priv->_terminal, "toggled", (GCallback) _desktop_agnostic_ui_launcher_editor_dialog_on_terminal_toggled_gtk_toggle_button_toggled, self, 0);
	gtk_container_add ((GtkContainer*) advanced_vbox, (GtkWidget*) self->priv->_terminal);
	self->priv->_startup_notification = (_tmp19_ = g_object_ref_sink ((GtkCheckButton*) gtk_check_button_new_with_mnemonic (_ ("Use _startup notification"))), _g_object_unref0 (self->priv->_startup_notification), _tmp19_);
	if (desktop_agnostic_fdo_desktop_entry_key_exists (self->priv->_entry, "StartupNotify")) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->_startup_notification, desktop_agnostic_fdo_desktop_entry_get_boolean (self->priv->_entry, "StartupNotify"));
	}
	g_signal_connect_object ((GtkToggleButton*) self->priv->_startup_notification, "toggled", (GCallback) _desktop_agnostic_ui_launcher_editor_dialog_on_startup_notification_toggled_gtk_toggle_button_toggled, self, 0);
	gtk_container_add ((GtkContainer*) advanced_vbox, (GtkWidget*) self->priv->_startup_notification);
	gtk_container_add ((GtkContainer*) advanced, (GtkWidget*) advanced_vbox);
	desktop_agnostic_ui_fixed_table_attach_fill (table, (GtkWidget*) advanced, (guint) 0, (guint) 3, (guint) 3, (guint) 4);
	gtk_container_add ((GtkContainer*) ((GtkDialog*) self)->vbox, (GtkWidget*) table);
	_g_object_unref0 (table);
	_g_free0 (icon);
	_g_object_unref0 (exec_button);
	_g_object_unref0 (exec_image);
	_g_object_unref0 (name_label);
	_g_object_unref0 (desc_label);
	_g_object_unref0 (exec_label);
	_g_object_unref0 (exec_hbox);
	_g_object_unref0 (advanced);
	_g_object_unref0 (advanced_vbox);
}


static void desktop_agnostic_ui_launcher_editor_dialog_on_icon_changed (DesktopAgnosticUILauncherEditorDialog* self, DesktopAgnosticUIIconButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	desktop_agnostic_fdo_desktop_entry_set_icon (self->priv->_entry, desktop_agnostic_ui_icon_button_get_icon (button));
}


static void desktop_agnostic_ui_launcher_editor_dialog_on_name_changed (DesktopAgnosticUILauncherEditorDialog* self, GtkEditable* editable) {
	GtkEditable* _tmp0_;
	GtkEntry* entry;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	entry = _g_object_ref0 ((_tmp0_ = editable, GTK_IS_ENTRY (_tmp0_) ? ((GtkEntry*) _tmp0_) : NULL));
	desktop_agnostic_fdo_desktop_entry_set_name (self->priv->_entry, gtk_entry_get_text (entry));
	_g_object_unref0 (entry);
}


static void desktop_agnostic_ui_launcher_editor_dialog_on_desc_changed (DesktopAgnosticUILauncherEditorDialog* self, GtkEditable* editable) {
	GtkEditable* _tmp0_;
	GtkEntry* entry;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	entry = _g_object_ref0 ((_tmp0_ = editable, GTK_IS_ENTRY (_tmp0_) ? ((GtkEntry*) _tmp0_) : NULL));
	desktop_agnostic_fdo_desktop_entry_set_string (self->priv->_entry, "Comment", gtk_entry_get_text (entry));
	_g_object_unref0 (entry);
}


static void desktop_agnostic_ui_launcher_editor_dialog_on_exec_changed (DesktopAgnosticUILauncherEditorDialog* self, GtkEditable* editable) {
	GtkEditable* _tmp0_;
	GtkEntry* entry;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	entry = _g_object_ref0 ((_tmp0_ = editable, GTK_IS_ENTRY (_tmp0_) ? ((GtkEntry*) _tmp0_) : NULL));
	desktop_agnostic_fdo_desktop_entry_set_string (self->priv->_entry, "Exec", gtk_entry_get_text (entry));
	_g_object_unref0 (entry);
}


static void desktop_agnostic_ui_launcher_editor_dialog_on_exec_browse (DesktopAgnosticUILauncherEditorDialog* self, GtkButton* btn) {
	GtkFileChooserDialog* dialog;
	gint response = 0;
	GtkFileChooserDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (btn != NULL);
	dialog = NULL;
	dialog = (_tmp0_ = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Locate Command"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OK, GTK_RESPONSE_OK, NULL)), _g_object_unref0 (dialog), _tmp0_);
	response = gtk_dialog_run ((GtkDialog*) dialog);
	if (response == GTK_RESPONSE_OK) {
		char* _tmp1_;
		gtk_entry_set_text (self->priv->_exec, _tmp1_ = gtk_file_chooser_get_filename ((GtkFileChooser*) dialog));
		_g_free0 (_tmp1_);
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (dialog);
}


static void desktop_agnostic_ui_launcher_editor_dialog_on_terminal_toggled (DesktopAgnosticUILauncherEditorDialog* self, GtkToggleButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	desktop_agnostic_fdo_desktop_entry_set_boolean (self->priv->_entry, "Terminal", gtk_toggle_button_get_active (button));
}


static void desktop_agnostic_ui_launcher_editor_dialog_on_startup_notification_toggled (DesktopAgnosticUILauncherEditorDialog* self, GtkToggleButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	desktop_agnostic_fdo_desktop_entry_set_boolean (self->priv->_entry, "StartupNotify", gtk_toggle_button_get_active (button));
}


static gboolean desktop_agnostic_ui_launcher_editor_dialog_change_output_file_prompt (DesktopAgnosticUILauncherEditorDialog* self) {
	gboolean result;
	GError * _inner_error_;
	GtkFileChooserDialog* dialog;
	gint response = 0;
	gboolean try_to_save = FALSE;
	GtkFileChooserDialog* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	dialog = NULL;
	dialog = (_tmp0_ = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Save As"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE_AS, GTK_RESPONSE_ACCEPT, NULL)), _g_object_unref0 (dialog), _tmp0_);
	response = gtk_dialog_run ((GtkDialog*) dialog);
	if (response == GTK_RESPONSE_ACCEPT) {
		char* _tmp1_;
		DesktopAgnosticVFSFile* _tmp2_;
		DesktopAgnosticVFSFile* _tmp3_;
		DesktopAgnosticVFSFile* _tmp4_;
		_tmp3_ = (_tmp2_ = desktop_agnostic_vfs_file_new_for_uri (_tmp1_ = gtk_file_chooser_get_uri ((GtkFileChooser*) dialog), &_inner_error_), _g_free0 (_tmp1_), _tmp2_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dialog);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		self->priv->_output = (_tmp4_ = _tmp3_, _g_object_unref0 (self->priv->_output), _tmp4_);
		try_to_save = TRUE;
	} else {
		try_to_save = FALSE;
	}
	gtk_object_destroy ((GtkObject*) dialog);
	result = try_to_save;
	_g_object_unref0 (dialog);
	return result;
}


static void desktop_agnostic_ui_launcher_editor_dialog_on_response (DesktopAgnosticUILauncherEditorDialog* self, gint response_id) {
	GError * _inner_error_;
	gboolean try_to_save;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	try_to_save = TRUE;
	if (response_id == GTK_RESPONSE_APPLY) {
		if (desktop_agnostic_vfs_file_exists (self->priv->_output)) {
			if (!desktop_agnostic_vfs_file_is_writable (self->priv->_output)) {
				try_to_save = desktop_agnostic_ui_launcher_editor_dialog_change_output_file_prompt (self);
			}
		} else {
			DesktopAgnosticVFSFile* directory;
			DesktopAgnosticVFSFile* _tmp0_;
			gboolean _tmp1_ = FALSE;
			directory = NULL;
			directory = (_tmp0_ = desktop_agnostic_vfs_file_get_parent (self->priv->_output), _g_object_unref0 (directory), _tmp0_);
			if (directory == NULL) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = !desktop_agnostic_vfs_file_is_writable (directory);
			}
			if (_tmp1_) {
				try_to_save = desktop_agnostic_ui_launcher_editor_dialog_change_output_file_prompt (self);
			}
			_g_object_unref0 (directory);
		}
		if (try_to_save) {
			if (desktop_agnostic_fdo_desktop_entry_get_entry_type (self->priv->_entry) == DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_UNKNOWN) {
				desktop_agnostic_fdo_desktop_entry_set_entry_type (self->priv->_entry, DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_APPLICATION);
			}
			{
				desktop_agnostic_fdo_desktop_entry_save (self->priv->_entry, self->priv->_output, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch3_g_error;
				}
			}
			goto __finally3;
			__catch3_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					GtkMessageDialog* dialog;
					GtkMessageDialog* _tmp2_;
					dialog = NULL;
					dialog = (_tmp2_ = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("An error occurred while trying to save the desktop entry:\n\n%s"), err->message)), _g_object_unref0 (dialog), _tmp2_);
					gtk_dialog_run ((GtkDialog*) dialog);
					gtk_object_destroy ((GtkObject*) dialog);
					_g_error_free0 (err);
					_g_object_unref0 (dialog);
				}
			}
			__finally3:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	if (self->priv->_standalone) {
		gtk_main_quit ();
	} else {
		gtk_widget_hide ((GtkWidget*) self);
	}
}


DesktopAgnosticVFSFile* desktop_agnostic_ui_launcher_editor_dialog_get_file (DesktopAgnosticUILauncherEditorDialog* self) {
	DesktopAgnosticVFSFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_file;
	return result;
}


static void desktop_agnostic_ui_launcher_editor_dialog_set_file (DesktopAgnosticUILauncherEditorDialog* self, DesktopAgnosticVFSFile* value) {
	g_return_if_fail (self != NULL);
	self->priv->_file = value;
	g_object_notify ((GObject *) self, "file");
}


DesktopAgnosticVFSFile* desktop_agnostic_ui_launcher_editor_dialog_get_output (DesktopAgnosticUILauncherEditorDialog* self) {
	DesktopAgnosticVFSFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_output;
	return result;
}


static void desktop_agnostic_ui_launcher_editor_dialog_set_output (DesktopAgnosticUILauncherEditorDialog* self, DesktopAgnosticVFSFile* value) {
	DesktopAgnosticVFSFile* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_output = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_output), _tmp0_);
	g_object_notify ((GObject *) self, "output");
}


static void desktop_agnostic_ui_launcher_editor_dialog_class_init (DesktopAgnosticUILauncherEditorDialogClass * klass) {
	desktop_agnostic_ui_launcher_editor_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticUILauncherEditorDialogPrivate));
	G_OBJECT_CLASS (klass)->constructed = desktop_agnostic_ui_launcher_editor_dialog_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_ui_launcher_editor_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = desktop_agnostic_ui_launcher_editor_dialog_set_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_ui_launcher_editor_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_FILE, g_param_spec_object ("file", "file", "file", DESKTOP_AGNOSTIC_VFS_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_OUTPUT, g_param_spec_object ("output", "output", "output", DESKTOP_AGNOSTIC_VFS_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void desktop_agnostic_ui_launcher_editor_dialog_instance_init (DesktopAgnosticUILauncherEditorDialog * self) {
	self->priv = DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_GET_PRIVATE (self);
}


static void desktop_agnostic_ui_launcher_editor_dialog_finalize (GObject* obj) {
	DesktopAgnosticUILauncherEditorDialog * self;
	self = DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG (obj);
	_g_object_unref0 (self->priv->_icon);
	_g_object_unref0 (self->priv->_name);
	_g_object_unref0 (self->priv->_desc);
	_g_object_unref0 (self->priv->_exec);
	_g_object_unref0 (self->priv->_terminal);
	_g_object_unref0 (self->priv->_startup_notification);
	_g_object_unref0 (self->priv->_output);
	_g_object_unref0 (self->priv->_entry);
	G_OBJECT_CLASS (desktop_agnostic_ui_launcher_editor_dialog_parent_class)->finalize (obj);
}


GType desktop_agnostic_ui_launcher_editor_dialog_get_type (void) {
	static GType desktop_agnostic_ui_launcher_editor_dialog_type_id = 0;
	if (desktop_agnostic_ui_launcher_editor_dialog_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticUILauncherEditorDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_ui_launcher_editor_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticUILauncherEditorDialog), 0, (GInstanceInitFunc) desktop_agnostic_ui_launcher_editor_dialog_instance_init, NULL };
		desktop_agnostic_ui_launcher_editor_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "DesktopAgnosticUILauncherEditorDialog", &g_define_type_info, 0);
	}
	return desktop_agnostic_ui_launcher_editor_dialog_type_id;
}


static void desktop_agnostic_ui_launcher_editor_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticUILauncherEditorDialog * self;
	self = DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_FILE:
		g_value_set_object (value, desktop_agnostic_ui_launcher_editor_dialog_get_file (self));
		break;
		case DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_OUTPUT:
		g_value_set_object (value, desktop_agnostic_ui_launcher_editor_dialog_get_output (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void desktop_agnostic_ui_launcher_editor_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesktopAgnosticUILauncherEditorDialog * self;
	self = DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_FILE:
		desktop_agnostic_ui_launcher_editor_dialog_set_file (self, g_value_get_object (value));
		break;
		case DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_OUTPUT:
		desktop_agnostic_ui_launcher_editor_dialog_set_output (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




