/* config-schema.c generated by valac, the Vala compiler
 * generated from config-schema.vala, do not modify */

/*
 * Desktop Agnostic Library: Configuration Schema.
 *
 * Copyright (C) 2008, 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <hashtable-gtype-key.c>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <libdesktop-agnostic/desktop-agnostic.h>
#include <libdesktop-agnostic/vfs.h>


#define DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA (desktop_agnostic_config_schema_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA, DesktopAgnosticConfigSchema))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA, DesktopAgnosticConfigSchemaClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA, DesktopAgnosticConfigSchemaClass))

typedef struct _DesktopAgnosticConfigSchema DesktopAgnosticConfigSchema;
typedef struct _DesktopAgnosticConfigSchemaClass DesktopAgnosticConfigSchemaClass;
typedef struct _DesktopAgnosticConfigSchemaPrivate DesktopAgnosticConfigSchemaPrivate;

#define DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION (desktop_agnostic_config_schema_option_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION, DesktopAgnosticConfigSchemaOption))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION, DesktopAgnosticConfigSchemaOptionClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA_OPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION, DesktopAgnosticConfigSchemaOptionClass))

typedef struct _DesktopAgnosticConfigSchemaOption DesktopAgnosticConfigSchemaOption;
typedef struct _DesktopAgnosticConfigSchemaOptionClass DesktopAgnosticConfigSchemaOptionClass;

#define DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE (desktop_agnostic_config_schema_type_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE, DesktopAgnosticConfigSchemaType))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE, DesktopAgnosticConfigSchemaTypeClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE, DesktopAgnosticConfigSchemaTypeClass))

typedef struct _DesktopAgnosticConfigSchemaType DesktopAgnosticConfigSchemaType;
typedef struct _DesktopAgnosticConfigSchemaTypeClass DesktopAgnosticConfigSchemaTypeClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_slist_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_free (var), NULL)))

typedef enum  {
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_PARSE,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_INVALID_METADATA_OPTION,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_INVALID_METADATA_TYPE,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_INVALID_TYPE,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_INVALID_LIST_TYPE,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_TYPE_NAME_EXISTS,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_TYPE_GTYPE_EXISTS
} DesktopAgnosticConfigSchemaError;
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR desktop_agnostic_config_schema_error_quark ()
struct _DesktopAgnosticConfigSchema {
	GObject parent_instance;
	DesktopAgnosticConfigSchemaPrivate * priv;
};

struct _DesktopAgnosticConfigSchemaClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticConfigSchemaPrivate {
	char* _filename;
	char* _app_name;
	GData* options;
	GHashTable* keys;
	GList* valid_metadata_keys;
	GData* metadata_options;
};


static GHashTable* desktop_agnostic_config_schema_type_registry;
static GHashTable* desktop_agnostic_config_schema_type_registry = NULL;
static GHashTable* desktop_agnostic_config_schema_name_registry;
static GHashTable* desktop_agnostic_config_schema_name_registry = NULL;
static GHashTable* desktop_agnostic_config_schema_common_metadata_keys;
static GHashTable* desktop_agnostic_config_schema_common_metadata_keys = NULL;
static gpointer desktop_agnostic_config_schema_parent_class = NULL;

GQuark desktop_agnostic_config_schema_error_quark (void);
GType desktop_agnostic_config_schema_get_type (void);
GType desktop_agnostic_config_schema_option_get_type (void);
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA, DesktopAgnosticConfigSchemaPrivate))
enum  {
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_FILENAME,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_APP_NAME
};
GType desktop_agnostic_config_schema_type_get_type (void);
static void _g_list_free_g_free (GList* self);
static void desktop_agnostic_config_schema_set_filename (DesktopAgnosticConfigSchema* self, const char* value);
static GValue* _g_value_dup (GValue* self);
GHashTable* desktop_agnostic_config_backend_get_backend_metadata_keys (void);
static void desktop_agnostic_config_schema_parse (DesktopAgnosticConfigSchema* self, GError** error);
DesktopAgnosticConfigSchema* desktop_agnostic_config_schema_new (const char* filename, GError** error);
DesktopAgnosticConfigSchema* desktop_agnostic_config_schema_construct (GType object_type, const char* filename, GError** error);
gboolean desktop_agnostic_config_schema_exists (DesktopAgnosticConfigSchema* self, const char* group, const char* key);
DesktopAgnosticConfigSchemaOption* desktop_agnostic_config_schema_option_new (GKeyFile** schema, const char* group, const char* key, GError** error);
DesktopAgnosticConfigSchemaOption* desktop_agnostic_config_schema_option_construct (GType object_type, GKeyFile** schema, const char* group, const char* key, GError** error);
#define DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT "DEFAULT"
GList* desktop_agnostic_config_schema_get_groups (DesktopAgnosticConfigSchema* self);
GList* desktop_agnostic_config_schema_get_keys (DesktopAgnosticConfigSchema* self, const char* group);
DesktopAgnosticConfigSchemaOption* desktop_agnostic_config_schema_get_option (DesktopAgnosticConfigSchema* self, const char* group, const char* key);
GValue* desktop_agnostic_config_schema_get_metadata_option (DesktopAgnosticConfigSchema* self, const char* name, GError** error);
GType desktop_agnostic_config_schema_type_get_schema_type (DesktopAgnosticConfigSchemaType* self);
char* desktop_agnostic_config_schema_type_get_name (DesktopAgnosticConfigSchemaType* self);
void desktop_agnostic_config_schema_register_type (DesktopAgnosticConfigSchemaType* st, GError** error);
DesktopAgnosticConfigSchemaType* desktop_agnostic_config_schema_find_type (GType type);
DesktopAgnosticConfigSchemaType* desktop_agnostic_config_schema_find_type_by_name (const char* name);
static void desktop_agnostic_config_schema_set_app_name (DesktopAgnosticConfigSchema* self, const char* value);
const char* desktop_agnostic_config_schema_get_app_name (DesktopAgnosticConfigSchema* self);
GType desktop_agnostic_config_get_type (GError** error);
static void _g_slist_free_g_free (GSList* self);
static void desktop_agnostic_config_schema_finalize (GObject* obj);
static void desktop_agnostic_config_schema_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void desktop_agnostic_config_schema_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark desktop_agnostic_config_schema_error_quark (void) {
	return g_quark_from_static_string ("desktop_agnostic_config_schema_error-quark");
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


DesktopAgnosticConfigSchema* desktop_agnostic_config_schema_construct (GType object_type, const char* filename, GError** error) {
	GError * _inner_error_;
	GParameter * __params;
	GParameter * __params_it;
	DesktopAgnosticConfigSchema * self;
	GHashTable* backend_metadata_keys;
	GData* _tmp0_ = {0};
	GHashTable* _tmp1_;
	GList* _tmp2_;
	GData* _tmp3_ = {0};
	g_return_val_if_fail (filename != NULL, NULL);
	_inner_error_ = NULL;
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "filename";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, filename);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	backend_metadata_keys = NULL;
	self->priv->options = (g_datalist_init (&_tmp0_), _tmp0_);
	self->priv->keys = (_tmp1_ = g_hash_table_new (g_str_hash, g_str_equal), _g_hash_table_unref0 (self->priv->keys), _tmp1_);
	self->priv->valid_metadata_keys = (_tmp2_ = NULL, __g_list_free_g_free0 (self->priv->valid_metadata_keys), _tmp2_);
	self->priv->metadata_options = (g_datalist_init (&_tmp3_), _tmp3_);
	{
		GList* key_collection;
		GList* key_it;
		key_collection = g_hash_table_get_keys (desktop_agnostic_config_schema_common_metadata_keys);
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			const char* key;
			key = (const char*) key_it->data;
			{
				self->priv->valid_metadata_keys = g_list_append (self->priv->valid_metadata_keys, g_strdup (key));
				g_datalist_set_data (&self->priv->metadata_options, key, __g_value_dup0 ((GValue*) g_hash_table_lookup (desktop_agnostic_config_schema_common_metadata_keys, key)));
			}
		}
		_g_list_free0 (key_collection);
	}
	backend_metadata_keys = desktop_agnostic_config_backend_get_backend_metadata_keys ();
	{
		GList* key_collection;
		GList* key_it;
		key_collection = g_hash_table_get_keys (backend_metadata_keys);
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			const char* key;
			key = (const char*) key_it->data;
			{
				self->priv->valid_metadata_keys = g_list_append (self->priv->valid_metadata_keys, g_strdup (key));
				g_datalist_set_data (&self->priv->metadata_options, key, __g_value_dup0 ((GValue*) g_hash_table_lookup (backend_metadata_keys, key)));
			}
		}
		_g_list_free0 (key_collection);
	}
	desktop_agnostic_config_schema_parse (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		g_object_unref (self);
		return NULL;
	}
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DesktopAgnosticConfigSchema* desktop_agnostic_config_schema_new (const char* filename, GError** error) {
	return desktop_agnostic_config_schema_construct (DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA, filename, error);
}


static gboolean string_contains (const char* self, const char* needle) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	result = strstr (self, needle) != NULL;
	return result;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void desktop_agnostic_config_schema_parse (DesktopAgnosticConfigSchema* self, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (self->priv->_filename == NULL) {
		_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR, DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_PARSE, "A (valid) schema file was not given.");
		{
			g_propagate_error (error, _inner_error_);
			return;
		}
	} else {
		GKeyFile* data;
		data = g_key_file_new ();
		g_key_file_load_from_file (data, self->priv->_filename, G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_key_file_free0 (data);
			return;
		}
		{
			gsize _tmp0_;
			char** group_collection;
			int group_collection_length1;
			int group_it;
			group_collection = g_key_file_get_groups (data, &_tmp0_);
			group_collection_length1 = _tmp0_;
			for (group_it = 0; group_it < _tmp0_; group_it = group_it + 1) {
				const char* group;
				group = group_collection[group_it];
				{
					if (string_contains (group, "/")) {
						const char* last_slash;
						glong offset;
						char* option_group;
						const char* option_key;
						GList* list;
						DesktopAgnosticConfigSchemaOption* option;
						last_slash = g_utf8_strrchr (group, (gssize) string_get_length (group), (gunichar) '/');
						offset = g_utf8_pointer_to_offset (group, last_slash);
						option_group = string_substring (group, (glong) 0, offset);
						option_key = g_utf8_offset_to_pointer (group, offset + 1);
						list = (GList*) g_hash_table_lookup (self->priv->keys, option_group);
						if (list == NULL) {
							GList* key_list;
							GList* _tmp1_;
							key_list = NULL;
							key_list = g_list_append (key_list, g_strdup (option_key));
							g_hash_table_insert (self->priv->keys, g_strdup (option_group), (_tmp1_ = key_list, key_list = NULL, _tmp1_));
							__g_list_free_g_free0 (key_list);
						} else {
							if (!desktop_agnostic_config_schema_exists (self, option_group, option_key)) {
								list = g_list_append (list, g_strdup (option_key));
							} else {
								_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR, DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_PARSE, "Duplicate key found in '%s': %s", option_group, option_key);
								{
									g_propagate_error (error, _inner_error_);
									_g_free0 (option_group);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_key_file_free0 (data);
									return;
								}
							}
						}
						option = desktop_agnostic_config_schema_option_new (&data, option_group, option_key, &_inner_error_);
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (option_group);
							group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
							_g_key_file_free0 (data);
							return;
						}
						g_datalist_set_data (&self->priv->options, group, _g_object_ref0 (option));
						_g_free0 (option_group);
						_g_object_unref0 (option);
					} else {
						if (_vala_strcmp0 (group, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT) == 0) {
							char** _tmp4_;
							gint _tmp3__size;
							gint _tmp3__length1;
							gsize _tmp2_;
							char** _tmp3_;
							_tmp3_ = (_tmp4_ = g_key_file_get_keys (data, group, &_tmp2_, &_inner_error_), _tmp3__length1 = _tmp2_, _tmp3__size = _tmp3__length1, _tmp4_);
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
								_g_key_file_free0 (data);
								return;
							}
							{
								char** key_collection;
								int key_collection_length1;
								int key_it;
								key_collection = _tmp3_;
								key_collection_length1 = _tmp3__length1;
								for (key_it = 0; key_it < _tmp3__length1; key_it = key_it + 1) {
									const char* key;
									key = key_collection[key_it];
									{
										if (g_list_find_custom (self->priv->valid_metadata_keys, key, (GCompareFunc) strcmp) == NULL) {
											_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR, DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_INVALID_METADATA_OPTION, "The option '%s' is not a registered metadata option.", key);
											{
												g_propagate_error (error, _inner_error_);
												key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
												group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
												_g_key_file_free0 (data);
												return;
											}
										} else {
											GValue cur_val = {0};
											GValue new_val = {0};
											GType cur_val_type = 0UL;
											GValue _tmp6_;
											GValue _tmp5_ = {0};
											GValue _tmp8_;
											GValue _tmp7_ = {0};
											cur_val = (_tmp6_ = G_IS_VALUE ((GValue*) g_datalist_get_data (&self->priv->metadata_options, key)) ? (g_value_init (&_tmp5_, G_VALUE_TYPE ((GValue*) g_datalist_get_data (&self->priv->metadata_options, key))), g_value_copy ((GValue*) g_datalist_get_data (&self->priv->metadata_options, key), &_tmp5_), _tmp5_) : (*((GValue*) g_datalist_get_data (&self->priv->metadata_options, key))), G_IS_VALUE (&cur_val) ? (g_value_unset (&cur_val), NULL) : NULL, _tmp6_);
											cur_val_type = G_VALUE_TYPE (&cur_val);
											new_val = (_tmp8_ = (g_value_init (&_tmp7_, cur_val_type), _tmp7_), G_IS_VALUE (&new_val) ? (g_value_unset (&new_val), NULL) : NULL, _tmp8_);
											if (cur_val_type == G_TYPE_BOOLEAN) {
												gboolean _tmp9_;
												_tmp9_ = g_key_file_get_boolean (data, group, key, &_inner_error_);
												if (_inner_error_ != NULL) {
													g_propagate_error (error, _inner_error_);
													G_IS_VALUE (&cur_val) ? (g_value_unset (&cur_val), NULL) : NULL;
													G_IS_VALUE (&new_val) ? (g_value_unset (&new_val), NULL) : NULL;
													key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
													group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
													_g_key_file_free0 (data);
													return;
												}
												g_value_set_boolean (&new_val, _tmp9_);
											} else {
												if (cur_val_type == G_TYPE_INT) {
													gint _tmp10_;
													_tmp10_ = g_key_file_get_integer (data, group, key, &_inner_error_);
													if (_inner_error_ != NULL) {
														g_propagate_error (error, _inner_error_);
														G_IS_VALUE (&cur_val) ? (g_value_unset (&cur_val), NULL) : NULL;
														G_IS_VALUE (&new_val) ? (g_value_unset (&new_val), NULL) : NULL;
														key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
														group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
														_g_key_file_free0 (data);
														return;
													}
													g_value_set_int (&new_val, _tmp10_);
												} else {
													if (cur_val_type == G_TYPE_FLOAT) {
														double _tmp11_;
														_tmp11_ = g_key_file_get_double (data, group, key, &_inner_error_);
														if (_inner_error_ != NULL) {
															g_propagate_error (error, _inner_error_);
															G_IS_VALUE (&cur_val) ? (g_value_unset (&cur_val), NULL) : NULL;
															G_IS_VALUE (&new_val) ? (g_value_unset (&new_val), NULL) : NULL;
															key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
															group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
															_g_key_file_free0 (data);
															return;
														}
														g_value_set_float (&new_val, (float) _tmp11_);
													} else {
														if (cur_val_type == G_TYPE_STRING) {
															char* _tmp12_;
															char* _tmp13_;
															_tmp12_ = g_key_file_get_string (data, group, key, &_inner_error_);
															if (_inner_error_ != NULL) {
																g_propagate_error (error, _inner_error_);
																G_IS_VALUE (&cur_val) ? (g_value_unset (&cur_val), NULL) : NULL;
																G_IS_VALUE (&new_val) ? (g_value_unset (&new_val), NULL) : NULL;
																key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
																group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
																_g_key_file_free0 (data);
																return;
															}
															g_value_set_string (&new_val, _tmp13_ = _tmp12_);
															_g_free0 (_tmp13_);
														} else {
															_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR, DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_INVALID_METADATA_TYPE, "The metadata option type can only be a simple type.");
															{
																g_propagate_error (error, _inner_error_);
																G_IS_VALUE (&cur_val) ? (g_value_unset (&cur_val), NULL) : NULL;
																G_IS_VALUE (&new_val) ? (g_value_unset (&new_val), NULL) : NULL;
																key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
																group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
																_g_key_file_free0 (data);
																return;
															}
														}
													}
												}
											}
											g_datalist_set_data (&self->priv->metadata_options, key, __g_value_dup0 (&new_val));
											G_IS_VALUE (&cur_val) ? (g_value_unset (&cur_val), NULL) : NULL;
											G_IS_VALUE (&new_val) ? (g_value_unset (&new_val), NULL) : NULL;
										}
									}
								}
								key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
							}
						} else {
							_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR, DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_PARSE, "Invalid section in schema ('%s'), there is no group name: %s", self->priv->_filename, group);
							{
								g_propagate_error (error, _inner_error_);
								group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
								_g_key_file_free0 (data);
								return;
							}
						}
					}
				}
			}
			group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_key_file_free0 (data);
	}
}


GList* desktop_agnostic_config_schema_get_groups (DesktopAgnosticConfigSchema* self) {
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = g_hash_table_get_keys (self->priv->keys);
	return result;
}


GList* desktop_agnostic_config_schema_get_keys (DesktopAgnosticConfigSchema* self, const char* group) {
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	result = (GList*) g_hash_table_lookup (self->priv->keys, group);
	return result;
}


gboolean desktop_agnostic_config_schema_exists (DesktopAgnosticConfigSchema* self, const char* group, const char* key) {
	gboolean result;
	GList* group_keys;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	group_keys = (GList*) g_hash_table_lookup (self->priv->keys, group);
	if (group_keys != NULL) {
		_tmp0_ = g_list_find_custom (group_keys, key, (GCompareFunc) strcmp) != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


DesktopAgnosticConfigSchemaOption* desktop_agnostic_config_schema_get_option (DesktopAgnosticConfigSchema* self, const char* group, const char* key) {
	DesktopAgnosticConfigSchemaOption* result;
	char* _tmp0_;
	char* _tmp1_;
	char* full_key;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	full_key = (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (group, "/", NULL), key, NULL), _g_free0 (_tmp0_), _tmp1_);
	result = (DesktopAgnosticConfigSchemaOption*) g_datalist_get_data (&self->priv->options, full_key);
	_g_free0 (full_key);
	return result;
}


GValue* desktop_agnostic_config_schema_get_metadata_option (DesktopAgnosticConfigSchema* self, const char* name, GError** error) {
	GValue* result;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_inner_error_ = NULL;
	if (g_list_find_custom (self->priv->valid_metadata_keys, name, (GCompareFunc) strcmp) == NULL) {
		_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR, DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_INVALID_METADATA_OPTION, "The option '%s' is not a registered metadata option.", name);
		{
			if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	} else {
		result = __g_value_dup0 ((GValue*) g_datalist_get_data (&self->priv->metadata_options, name));
		return result;
	}
}


void desktop_agnostic_config_schema_register_type (DesktopAgnosticConfigSchemaType* st, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (st != NULL);
	_inner_error_ = NULL;
	if (((DesktopAgnosticConfigSchemaType*) g_hash_table_lookup (desktop_agnostic_config_schema_type_registry, GINT_TO_POINTER (desktop_agnostic_config_schema_type_get_schema_type (st)))) != NULL) {
		_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR, DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_TYPE_GTYPE_EXISTS, "The GType associated with the SchemaType is already registered.");
		{
			if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		char* _tmp0_;
		gboolean _tmp1_;
		if ((_tmp1_ = ((DesktopAgnosticConfigSchemaType*) g_hash_table_lookup (desktop_agnostic_config_schema_name_registry, _tmp0_ = desktop_agnostic_config_schema_type_get_name (st))) != NULL, _g_free0 (_tmp0_), _tmp1_)) {
			_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR, DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_TYPE_NAME_EXISTS, "The name associated with the SchemaType is already registered.");
			{
				if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		} else {
			g_hash_table_insert (desktop_agnostic_config_schema_type_registry, GINT_TO_POINTER (desktop_agnostic_config_schema_type_get_schema_type (st)), _g_object_ref0 (st));
			g_hash_table_insert (desktop_agnostic_config_schema_name_registry, desktop_agnostic_config_schema_type_get_name (st), _g_object_ref0 (st));
		}
	}
}


DesktopAgnosticConfigSchemaType* desktop_agnostic_config_schema_find_type (GType type) {
	DesktopAgnosticConfigSchemaType* result;
	result = (DesktopAgnosticConfigSchemaType*) g_hash_table_lookup (desktop_agnostic_config_schema_type_registry, GINT_TO_POINTER (type));
	return result;
}


DesktopAgnosticConfigSchemaType* desktop_agnostic_config_schema_find_type_by_name (const char* name) {
	DesktopAgnosticConfigSchemaType* result;
	g_return_val_if_fail (name != NULL, NULL);
	result = (DesktopAgnosticConfigSchemaType*) g_hash_table_lookup (desktop_agnostic_config_schema_name_registry, name);
	return result;
}


static void desktop_agnostic_config_schema_set_filename (DesktopAgnosticConfigSchema* self, const char* value) {
	char* basename;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	g_return_if_fail (self != NULL);
	basename = NULL;
	if (!g_str_has_suffix (value, ".schema-ini")) {
		g_critical ("config-schema.vala:166: Schema files MUST have the extension '.schema-ini'.");
		_g_free0 (basename);
		return;
	}
	if (!g_file_test (value, G_FILE_TEST_EXISTS)) {
		g_critical ("config-schema.vala:171: The file '%s' could not be found.", value);
		_g_free0 (basename);
		return;
	}
	self->priv->_filename = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_filename), _tmp0_);
	basename = (_tmp1_ = g_path_get_basename (value), _g_free0 (basename), _tmp1_);
	desktop_agnostic_config_schema_set_app_name (self, _tmp2_ = string_substring (basename, (glong) 0, string_get_length (basename) - 11));
	_g_free0 (_tmp2_);
	_g_free0 (basename);
	g_object_notify ((GObject *) self, "filename");
}


const char* desktop_agnostic_config_schema_get_app_name (DesktopAgnosticConfigSchema* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_app_name;
	return result;
}


static void desktop_agnostic_config_schema_set_app_name (DesktopAgnosticConfigSchema* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_app_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_app_name), _tmp0_);
	g_object_notify ((GObject *) self, "app-name");
}


static void _g_slist_free_g_free (GSList* self) {
	g_slist_foreach (self, (GFunc) g_free, NULL);
	g_slist_free (self);
}


static void desktop_agnostic_config_schema_class_init (DesktopAgnosticConfigSchemaClass * klass) {
	GError * _inner_error_;
	desktop_agnostic_config_schema_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticConfigSchemaPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_config_schema_get_property;
	G_OBJECT_CLASS (klass)->set_property = desktop_agnostic_config_schema_set_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_config_schema_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_CONFIG_SCHEMA_FILENAME, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_CONFIG_SCHEMA_APP_NAME, g_param_spec_string ("app-name", "Application name", "The name of the application associated with the schema", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	desktop_agnostic_config_schema_type_registry = g_hash_table_new ((GHashFunc) desktop_agnostic_config_gtype_hash, (GEqualFunc) desktop_agnostic_config_gtype_equal);
	desktop_agnostic_config_schema_name_registry = g_hash_table_new (g_str_hash, g_str_equal);
	desktop_agnostic_config_schema_common_metadata_keys = g_hash_table_new (g_str_hash, g_str_equal);
	_inner_error_ = NULL;
	{
		GList* type_modules;
		gint paths_size;
		gint paths_length1;
		char** paths;
		GSList* search_paths;
		GList* _tmp0_;
		char** _tmp2_;
		gint _tmp1_;
		GSList* _tmp3_;
		GValue _tmp11_ = {0};
		GValue val;
		type_modules = NULL;
		paths = (paths_length1 = 0, NULL);
		search_paths = NULL;
		type_modules = (_tmp0_ = NULL, __g_list_free_g_free0 (type_modules), _tmp0_);
		desktop_agnostic_module_loader_get_default ();
		{
			desktop_agnostic_config_get_type (&_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				_g_error_free0 (err);
			}
		}
		__finally3:
		if (_inner_error_ != NULL) {
			__g_list_free_g_free0 (type_modules);
			paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
			__g_slist_free_g_free0 (search_paths);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		paths = (_tmp2_ = desktop_agnostic_module_loader_get_search_paths (&_tmp1_), paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL), paths_length1 = _tmp1_, paths_size = paths_length1, _tmp2_);
		search_paths = (_tmp3_ = NULL, __g_slist_free_g_free0 (search_paths), _tmp3_);
		{
			char** path_collection;
			int path_collection_length1;
			int path_it;
			path_collection = paths;
			path_collection_length1 = paths_length1;
			for (path_it = 0; path_it < paths_length1; path_it = path_it + 1) {
				const char* path;
				path = path_collection[path_it];
				{
					if (path != NULL) {
						search_paths = g_slist_append (search_paths, g_strdup (path));
					}
				}
			}
		}
		search_paths = g_slist_append (search_paths, g_get_current_dir ());
		{
			GSList* path_collection;
			GSList* path_it;
			path_collection = search_paths;
			for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
				const char* path;
				path = (const char*) path_it->data;
				{
					char* module_glob;
					if (!g_file_test (path, G_FILE_TEST_IS_DIR)) {
						continue;
					}
					module_glob = g_build_filename (path, "libda-cfg-type-*", NULL);
					{
						DesktopAgnosticVFSGlob* found_modules;
						gint modules_paths_size;
						gint modules_paths_length1;
						char** modules_paths;
						DesktopAgnosticVFSGlob* _tmp4_;
						DesktopAgnosticVFSGlob* _tmp5_;
						char** _tmp7_;
						gint _tmp6_;
						found_modules = NULL;
						modules_paths = (modules_paths_length1 = 0, NULL);
						_tmp4_ = desktop_agnostic_vfs_glob_execute (module_glob, &_inner_error_);
						if (_inner_error_ != NULL) {
							_g_object_unref0 (found_modules);
							if (_inner_error_->domain == DESKTOP_AGNOSTIC_VFS_GLOB_ERROR) {
								goto __catch4_desktop_agnostic_vfs_glob_error;
							}
							_g_object_unref0 (found_modules);
							_g_free0 (module_glob);
							__g_list_free_g_free0 (type_modules);
							paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
							__g_slist_free_g_free0 (search_paths);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
						}
						found_modules = (_tmp5_ = _tmp4_, _g_object_unref0 (found_modules), _tmp5_);
						modules_paths = (_tmp7_ = desktop_agnostic_vfs_glob_get_paths (found_modules, &_tmp6_), modules_paths_length1 = _tmp6_, modules_paths_size = modules_paths_length1, _tmp7_);
						{
							char** module_collection;
							int module_collection_length1;
							int module_it;
							module_collection = modules_paths;
							module_collection_length1 = modules_paths_length1;
							for (module_it = 0; module_it < modules_paths_length1; module_it = module_it + 1) {
								const char* module;
								module = module_collection[module_it];
								{
									if (g_list_find (type_modules, module) == NULL) {
										GType type = 0UL;
										DesktopAgnosticModuleLoader* loader;
										char* _tmp8_;
										loader = desktop_agnostic_module_loader_get_default ();
										type = desktop_agnostic_module_loader_load_from_path (loader, _tmp8_ = g_path_get_basename (module), module);
										_g_free0 (_tmp8_);
										if (type != G_TYPE_INVALID) {
											{
												GObject* obj;
												DesktopAgnosticConfigSchemaType* _tmp10_;
												GObject* _tmp9_;
												obj = g_object_new (type, NULL);
												desktop_agnostic_config_schema_register_type (_tmp10_ = DESKTOP_AGNOSTIC_CONFIG_SCHEMA_TYPE ((_tmp9_ = obj, obj = NULL, _tmp9_)), &_inner_error_);
												if (_inner_error_ != NULL) {
													_g_object_unref0 (obj);
													if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR) {
														goto __catch5_desktop_agnostic_config_schema_error;
													}
													_g_object_unref0 (obj);
													_g_object_unref0 (found_modules);
													_g_free0 (module_glob);
													__g_list_free_g_free0 (type_modules);
													paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
													__g_slist_free_g_free0 (search_paths);
													g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
												}
												_g_object_unref0 (_tmp10_);
												type_modules = g_list_append (type_modules, g_strdup (module));
												_g_object_unref0 (obj);
											}
											goto __finally5;
											__catch5_desktop_agnostic_config_schema_error:
											{
												GError * err;
												err = _inner_error_;
												_inner_error_ = NULL;
												{
													g_warning ("config-schema.vala:120: Schema error: %s", err->message);
													_g_error_free0 (err);
												}
											}
											__finally5:
											if (_inner_error_ != NULL) {
												_g_object_unref0 (found_modules);
												if (_inner_error_->domain == DESKTOP_AGNOSTIC_VFS_GLOB_ERROR) {
													goto __catch4_desktop_agnostic_vfs_glob_error;
												}
												_g_object_unref0 (found_modules);
												_g_free0 (module_glob);
												__g_list_free_g_free0 (type_modules);
												paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
												__g_slist_free_g_free0 (search_paths);
												g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
											}
										} else {
											g_warning ("config-schema.vala:125: Could not load the config type module: %s", module);
										}
									}
								}
							}
						}
						_g_object_unref0 (found_modules);
					}
					goto __finally4;
					__catch4_desktop_agnostic_vfs_glob_error:
					{
						GError * err;
						err = _inner_error_;
						_inner_error_ = NULL;
						{
							if (!g_error_matches (err, DESKTOP_AGNOSTIC_VFS_GLOB_ERROR, DESKTOP_AGNOSTIC_VFS_GLOB_ERROR_NOMATCH)) {
								g_warning ("config-schema.vala:134: Glob-related error: %s", err->message);
							}
							_g_error_free0 (err);
						}
					}
					__finally4:
					if (_inner_error_ != NULL) {
						_g_free0 (module_glob);
						__g_list_free_g_free0 (type_modules);
						paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
						__g_slist_free_g_free0 (search_paths);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
					}
					_g_free0 (module_glob);
				}
			}
		}
		val = (g_value_init (&_tmp11_, G_TYPE_BOOLEAN), _tmp11_);
		g_value_set_boolean (&val, TRUE);
		g_hash_table_insert (desktop_agnostic_config_schema_common_metadata_keys, g_strdup ("single_instance"), __g_value_dup0 (&val));
		{
			desktop_agnostic_config_get_type (&_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch6_g_error;
			}
		}
		goto __finally6;
		__catch6_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("config-schema.vala:149: Config error: %s", err->message);
				_g_error_free0 (err);
			}
		}
		__finally6:
		if (_inner_error_ != NULL) {
			__g_list_free_g_free0 (type_modules);
			paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
			__g_slist_free_g_free0 (search_paths);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		__g_list_free_g_free0 (type_modules);
		paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
		__g_slist_free_g_free0 (search_paths);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	}
}


static void desktop_agnostic_config_schema_instance_init (DesktopAgnosticConfigSchema * self) {
	self->priv = DESKTOP_AGNOSTIC_CONFIG_SCHEMA_GET_PRIVATE (self);
}


static void desktop_agnostic_config_schema_finalize (GObject* obj) {
	DesktopAgnosticConfigSchema * self;
	self = DESKTOP_AGNOSTIC_CONFIG_SCHEMA (obj);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_app_name);
	_g_hash_table_unref0 (self->priv->keys);
	__g_list_free_g_free0 (self->priv->valid_metadata_keys);
	G_OBJECT_CLASS (desktop_agnostic_config_schema_parent_class)->finalize (obj);
}


GType desktop_agnostic_config_schema_get_type (void) {
	static GType desktop_agnostic_config_schema_type_id = 0;
	if (desktop_agnostic_config_schema_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticConfigSchemaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_config_schema_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticConfigSchema), 0, (GInstanceInitFunc) desktop_agnostic_config_schema_instance_init, NULL };
		desktop_agnostic_config_schema_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticConfigSchema", &g_define_type_info, 0);
	}
	return desktop_agnostic_config_schema_type_id;
}


static void desktop_agnostic_config_schema_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticConfigSchema * self;
	self = DESKTOP_AGNOSTIC_CONFIG_SCHEMA (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_CONFIG_SCHEMA_APP_NAME:
		g_value_set_string (value, desktop_agnostic_config_schema_get_app_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void desktop_agnostic_config_schema_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesktopAgnosticConfigSchema * self;
	self = DESKTOP_AGNOSTIC_CONFIG_SCHEMA (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_CONFIG_SCHEMA_FILENAME:
		desktop_agnostic_config_schema_set_filename (self, g_value_get_string (value));
		break;
		case DESKTOP_AGNOSTIC_CONFIG_SCHEMA_APP_NAME:
		desktop_agnostic_config_schema_set_app_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




