/* config-schema-option.c generated by valac, the Vala compiler
 * generated from config-schema-option.vala, do not modify */

/*
 * Desktop Agnostic Library: Configuration Schema Abstract Type.
 *
 * Copyright (C) 2008, 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION (desktop_agnostic_config_schema_option_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION, DesktopAgnosticConfigSchemaOption))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION, DesktopAgnosticConfigSchemaOptionClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA_OPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION, DesktopAgnosticConfigSchemaOptionClass))

typedef struct _DesktopAgnosticConfigSchemaOption DesktopAgnosticConfigSchemaOption;
typedef struct _DesktopAgnosticConfigSchemaOptionClass DesktopAgnosticConfigSchemaOptionClass;
typedef struct _DesktopAgnosticConfigSchemaOptionPrivate DesktopAgnosticConfigSchemaOptionPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))

#define DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE (desktop_agnostic_config_schema_type_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE, DesktopAgnosticConfigSchemaType))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE, DesktopAgnosticConfigSchemaTypeClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE, DesktopAgnosticConfigSchemaTypeClass))

typedef struct _DesktopAgnosticConfigSchemaType DesktopAgnosticConfigSchemaType;
typedef struct _DesktopAgnosticConfigSchemaTypeClass DesktopAgnosticConfigSchemaTypeClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DesktopAgnosticConfigSchemaOption {
	GObject parent_instance;
	DesktopAgnosticConfigSchemaOptionPrivate * priv;
};

struct _DesktopAgnosticConfigSchemaOptionClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticConfigSchemaOptionPrivate {
	GType _option_type;
	GType _list_type;
	GValue _default_value;
	char* _description;
	char* _summary;
	GValue* _lower_boundary;
	GValue* _upper_boundary;
	GValueArray* _whitelist;
	GValueArray* _blacklist;
	gboolean _per_instance;
};

typedef enum  {
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_PARSE,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_INVALID_METADATA_OPTION,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_INVALID_METADATA_TYPE,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_INVALID_TYPE,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_INVALID_LIST_TYPE,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_TYPE_NAME_EXISTS,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_TYPE_GTYPE_EXISTS
} DesktopAgnosticConfigSchemaError;
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR desktop_agnostic_config_schema_error_quark ()
typedef enum  {
	DESKTOP_AGNOSTIC_CONFIG_ERROR_NO_SCHEMA,
	DESKTOP_AGNOSTIC_CONFIG_ERROR_INVALID_TYPE,
	DESKTOP_AGNOSTIC_CONFIG_ERROR_KEY_NOT_FOUND,
	DESKTOP_AGNOSTIC_CONFIG_ERROR_METADATA_NOT_FOUND,
	DESKTOP_AGNOSTIC_CONFIG_ERROR_NOTIFY,
	DESKTOP_AGNOSTIC_CONFIG_ERROR_DUPLICATE_BINDING
} DesktopAgnosticConfigError;
#define DESKTOP_AGNOSTIC_CONFIG_ERROR desktop_agnostic_config_error_quark ()

static gpointer desktop_agnostic_config_schema_option_parent_class = NULL;

GType desktop_agnostic_config_schema_option_get_type (void);
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION, DesktopAgnosticConfigSchemaOptionPrivate))
enum  {
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_OPTION_TYPE,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_LIST_TYPE,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_DEFAULT_VALUE,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_DESCRIPTION,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_SUMMARY,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_WHITELIST,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_BLACKLIST,
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_PER_INSTANCE
};
static void desktop_agnostic_config_schema_option_parse_type (DesktopAgnosticConfigSchemaOption* self, const char* serialized);
static void desktop_agnostic_config_schema_option_parse_default_value (DesktopAgnosticConfigSchemaOption* self, GKeyFile* schema, const char* group, GError** error);
static char* desktop_agnostic_config_schema_option_parse_localized_value (DesktopAgnosticConfigSchemaOption* self, GKeyFile* schema, const char* group, const char* key, gboolean mandatory, GError** error);
static void desktop_agnostic_config_schema_option_set_per_instance (DesktopAgnosticConfigSchemaOption* self, gboolean value);
DesktopAgnosticConfigSchemaOption* desktop_agnostic_config_schema_option_new (GKeyFile** schema, const char* group, const char* key, GError** error);
DesktopAgnosticConfigSchemaOption* desktop_agnostic_config_schema_option_construct (GType object_type, GKeyFile** schema, const char* group, const char* key, GError** error);
static void desktop_agnostic_config_schema_option_set_option_type (DesktopAgnosticConfigSchemaOption* self, GType value);
static GType desktop_agnostic_config_schema_option_parse_simple_type_from_string (DesktopAgnosticConfigSchemaOption* self, const char* serialized);
static void desktop_agnostic_config_schema_option_set_list_type (DesktopAgnosticConfigSchemaOption* self, GType value);
GType desktop_agnostic_config_schema_type_get_type (void);
DesktopAgnosticConfigSchemaType* desktop_agnostic_config_schema_find_type_by_name (const char* name);
GType desktop_agnostic_config_schema_type_get_schema_type (DesktopAgnosticConfigSchemaType* self);
GType desktop_agnostic_config_schema_option_get_option_type (DesktopAgnosticConfigSchemaOption* self);
DesktopAgnosticConfigSchemaType* desktop_agnostic_config_schema_find_type (GType type);
GQuark desktop_agnostic_config_schema_error_quark (void);
void desktop_agnostic_config_schema_type_deserialize (DesktopAgnosticConfigSchemaType* self, const char* serialized, GValue* result, GError** error);
GType desktop_agnostic_config_schema_option_get_list_type (DesktopAgnosticConfigSchemaOption* self);
GQuark desktop_agnostic_config_error_quark (void);
void desktop_agnostic_config_schema_option_get_default_value (DesktopAgnosticConfigSchemaOption* self, GValue* result);
static void desktop_agnostic_config_schema_option_set_default_value (DesktopAgnosticConfigSchemaOption* self, GValue* value);
const char* desktop_agnostic_config_schema_option_get_description (DesktopAgnosticConfigSchemaOption* self);
static void desktop_agnostic_config_schema_option_set_description (DesktopAgnosticConfigSchemaOption* self, const char* value);
const char* desktop_agnostic_config_schema_option_get_summary (DesktopAgnosticConfigSchemaOption* self);
static void desktop_agnostic_config_schema_option_set_summary (DesktopAgnosticConfigSchemaOption* self, const char* value);
GValue* desktop_agnostic_config_schema_option_get_lower_boundary (DesktopAgnosticConfigSchemaOption* self);
static GValue* _g_value_dup (GValue* self);
static void desktop_agnostic_config_schema_option_set_lower_boundary (DesktopAgnosticConfigSchemaOption* self, GValue* value);
GValue* desktop_agnostic_config_schema_option_get_upper_boundary (DesktopAgnosticConfigSchemaOption* self);
static void desktop_agnostic_config_schema_option_set_upper_boundary (DesktopAgnosticConfigSchemaOption* self, GValue* value);
GValueArray* desktop_agnostic_config_schema_option_get_whitelist (DesktopAgnosticConfigSchemaOption* self);
GValueArray* desktop_agnostic_config_schema_option_get_blacklist (DesktopAgnosticConfigSchemaOption* self);
gboolean desktop_agnostic_config_schema_option_get_per_instance (DesktopAgnosticConfigSchemaOption* self);
static void desktop_agnostic_config_schema_option_finalize (GObject* obj);
static void desktop_agnostic_config_schema_option_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void desktop_agnostic_config_schema_option_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



DesktopAgnosticConfigSchemaOption* desktop_agnostic_config_schema_option_construct (GType object_type, GKeyFile** schema, const char* group, const char* key, GError** error) {
	GError * _inner_error_;
	DesktopAgnosticConfigSchemaOption * self;
	char* _tmp0_;
	char* _tmp1_;
	char* full_key;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	gboolean _tmp8_;
	g_return_val_if_fail (schema != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_inner_error_ = NULL;
	self = (DesktopAgnosticConfigSchemaOption*) g_object_new (object_type, NULL);
	full_key = (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (group, "/", NULL), key, NULL), _g_free0 (_tmp0_), _tmp1_);
	_tmp2_ = g_key_file_get_value (*schema, full_key, "type", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		g_object_unref (self);
		return NULL;
	}
	desktop_agnostic_config_schema_option_parse_type (self, _tmp3_ = _tmp2_);
	_g_free0 (_tmp3_);
	desktop_agnostic_config_schema_option_parse_default_value (self, *schema, full_key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		g_object_unref (self);
		return NULL;
	}
	_tmp4_ = desktop_agnostic_config_schema_option_parse_localized_value (self, *schema, full_key, "description", TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		g_object_unref (self);
		return NULL;
	}
	self->priv->_description = (_tmp5_ = _tmp4_, _g_free0 (self->priv->_description), _tmp5_);
	_tmp6_ = desktop_agnostic_config_schema_option_parse_localized_value (self, *schema, full_key, "summary", FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		g_object_unref (self);
		return NULL;
	}
	self->priv->_summary = (_tmp7_ = _tmp6_, _g_free0 (self->priv->_summary), _tmp7_);
	_tmp8_ = g_key_file_has_key (*schema, full_key, "per_instance", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (full_key);
		g_object_unref (self);
		return NULL;
	}
	if (_tmp8_) {
		gboolean _tmp9_;
		_tmp9_ = g_key_file_get_boolean (*schema, full_key, "per_instance", &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (full_key);
			g_object_unref (self);
			return NULL;
		}
		desktop_agnostic_config_schema_option_set_per_instance (self, _tmp9_);
	}
	_g_free0 (full_key);
	return self;
}


DesktopAgnosticConfigSchemaOption* desktop_agnostic_config_schema_option_new (GKeyFile** schema, const char* group, const char* key, GError** error) {
	return desktop_agnostic_config_schema_option_construct (DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_OPTION, schema, group, key, error);
}


static void desktop_agnostic_config_schema_option_parse_type (DesktopAgnosticConfigSchemaOption* self, const char* serialized) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (serialized != NULL);
	if (g_str_has_prefix (serialized, "list-")) {
		const char* subtype;
		desktop_agnostic_config_schema_option_set_option_type (self, G_TYPE_VALUE_ARRAY);
		subtype = g_utf8_offset_to_pointer (serialized, (glong) 5);
		desktop_agnostic_config_schema_option_set_list_type (self, desktop_agnostic_config_schema_option_parse_simple_type_from_string (self, subtype));
	} else {
		desktop_agnostic_config_schema_option_set_option_type (self, desktop_agnostic_config_schema_option_parse_simple_type_from_string (self, serialized));
		desktop_agnostic_config_schema_option_set_list_type (self, G_TYPE_INVALID);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GType desktop_agnostic_config_schema_option_parse_simple_type_from_string (DesktopAgnosticConfigSchemaOption* self, const char* serialized) {
	GType result;
	GType type = 0UL;
	GQuark _tmp1_;
	const char* _tmp0_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	static GQuark _tmp1__label3 = 0;
	g_return_val_if_fail (self != NULL, 0UL);
	g_return_val_if_fail (serialized != NULL, 0UL);
	_tmp0_ = serialized;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("boolean"))))
	do {
		type = G_TYPE_BOOLEAN;
		break;
	} while (0); else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("integer"))))
	do {
		type = G_TYPE_INT;
		break;
	} while (0); else if (_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("float"))))
	do {
		type = G_TYPE_FLOAT;
		break;
	} while (0); else if (_tmp1_ == ((0 != _tmp1__label3) ? _tmp1__label3 : (_tmp1__label3 = g_quark_from_static_string ("string"))))
	do {
		type = G_TYPE_STRING;
		break;
	} while (0); else
	do {
		DesktopAgnosticConfigSchemaType* st;
		st = _g_object_ref0 (desktop_agnostic_config_schema_find_type_by_name (serialized));
		if (st == NULL) {
			type = G_TYPE_INVALID;
		} else {
			type = desktop_agnostic_config_schema_type_get_schema_type (st);
		}
		_g_object_unref0 (st);
		break;
	} while (0);
	result = type;
	return result;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void desktop_agnostic_config_schema_option_parse_default_value (DesktopAgnosticConfigSchemaOption* self, GKeyFile* schema, const char* group, GError** error) {
	GError * _inner_error_;
	char* key;
	g_return_if_fail (self != NULL);
	g_return_if_fail (schema != NULL);
	g_return_if_fail (group != NULL);
	_inner_error_ = NULL;
	key = g_strdup ("default");
	{
		if (self->priv->_option_type == G_TYPE_BOOLEAN) {
			gboolean _tmp0_;
			GValue _tmp2_;
			GValue _tmp1_ = {0};
			_tmp0_ = g_key_file_get_boolean (schema, group, key, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_KEY_FILE_ERROR) {
					goto __catch7_g_key_file_error;
				}
				_g_free0 (key);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			self->priv->_default_value = (_tmp2_ = (g_value_init (&_tmp1_, G_TYPE_BOOLEAN), g_value_set_boolean (&_tmp1_, _tmp0_), _tmp1_), G_IS_VALUE (&self->priv->_default_value) ? (g_value_unset (&self->priv->_default_value), NULL) : NULL, _tmp2_);
		} else {
			if (self->priv->_option_type == G_TYPE_INT) {
				gint _tmp3_;
				GValue _tmp5_;
				GValue _tmp4_ = {0};
				_tmp3_ = g_key_file_get_integer (schema, group, key, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_KEY_FILE_ERROR) {
						goto __catch7_g_key_file_error;
					}
					_g_free0 (key);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				self->priv->_default_value = (_tmp5_ = (g_value_init (&_tmp4_, G_TYPE_INT), g_value_set_int (&_tmp4_, _tmp3_), _tmp4_), G_IS_VALUE (&self->priv->_default_value) ? (g_value_unset (&self->priv->_default_value), NULL) : NULL, _tmp5_);
			} else {
				if (self->priv->_option_type == G_TYPE_FLOAT) {
					double _tmp6_;
					GValue _tmp8_;
					GValue _tmp7_ = {0};
					_tmp6_ = g_key_file_get_double (schema, group, key, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch7_g_key_file_error;
						}
						_g_free0 (key);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					self->priv->_default_value = (_tmp8_ = (g_value_init (&_tmp7_, G_TYPE_FLOAT), g_value_set_float (&_tmp7_, (float) _tmp6_), _tmp7_), G_IS_VALUE (&self->priv->_default_value) ? (g_value_unset (&self->priv->_default_value), NULL) : NULL, _tmp8_);
				} else {
					if (self->priv->_option_type == G_TYPE_STRING) {
						char* _tmp9_;
						GValue _tmp12_;
						GValue _tmp11_ = {0};
						char* _tmp10_;
						_tmp9_ = g_key_file_get_string (schema, group, key, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == G_KEY_FILE_ERROR) {
								goto __catch7_g_key_file_error;
							}
							_g_free0 (key);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						self->priv->_default_value = (_tmp12_ = (g_value_init (&_tmp11_, G_TYPE_STRING), g_value_set_string (&_tmp11_, _tmp10_ = _tmp9_), _tmp11_), G_IS_VALUE (&self->priv->_default_value) ? (g_value_unset (&self->priv->_default_value), NULL) : NULL, _tmp12_);
						_g_free0 (_tmp10_);
					} else {
						DesktopAgnosticConfigSchemaType* st;
						st = _g_object_ref0 (desktop_agnostic_config_schema_find_type (self->priv->_option_type));
						if (st != NULL) {
							char* _tmp13_;
							GValue _tmp15_ = {0};
							char* _tmp14_;
							GValue _tmp16_;
							GValue _tmp17_;
							GValue _tmp18_;
							_tmp13_ = g_key_file_get_string (schema, group, key, &_inner_error_);
							if (_inner_error_ != NULL) {
								_g_object_unref0 (st);
								if (_inner_error_->domain == G_KEY_FILE_ERROR) {
									goto __catch7_g_key_file_error;
								}
								_g_object_unref0 (st);
								_g_free0 (key);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_tmp17_ = (_tmp16_ = (desktop_agnostic_config_schema_type_deserialize (st, _tmp14_ = _tmp13_, &_tmp15_, &_inner_error_), _tmp15_), _g_free0 (_tmp14_), _tmp16_);
							if (_inner_error_ != NULL) {
								_g_object_unref0 (st);
								if (_inner_error_->domain == G_KEY_FILE_ERROR) {
									goto __catch7_g_key_file_error;
								}
								goto __finally7;
							}
							self->priv->_default_value = (_tmp18_ = _tmp17_, G_IS_VALUE (&self->priv->_default_value) ? (g_value_unset (&self->priv->_default_value), NULL) : NULL, _tmp18_);
						} else {
							if (self->priv->_option_type == G_TYPE_VALUE_ARRAY) {
								GValueArray* array;
								char* _tmp19_;
								char* _tmp20_;
								gboolean _tmp21_;
								GValue _tmp55_;
								GValue _tmp54_ = {0};
								array = NULL;
								_tmp19_ = g_key_file_get_value (schema, group, key, &_inner_error_);
								if (_inner_error_ != NULL) {
									_g_value_array_free0 (array);
									_g_object_unref0 (st);
									if (_inner_error_->domain == G_KEY_FILE_ERROR) {
										goto __catch7_g_key_file_error;
									}
									_g_value_array_free0 (array);
									_g_object_unref0 (st);
									_g_free0 (key);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
								if ((_tmp21_ = _vala_strcmp0 (_tmp20_ = _tmp19_, "") == 0, _g_free0 (_tmp20_), _tmp21_)) {
									GValueArray* _tmp22_;
									array = (_tmp22_ = g_value_array_new ((guint) 0), _g_value_array_free0 (array), _tmp22_);
								} else {
									if (self->priv->_list_type == G_TYPE_BOOLEAN) {
										gboolean* _tmp24_;
										gint list_size;
										gint list_length1;
										gsize _tmp23_;
										gboolean* list;
										GValueArray* _tmp25_;
										list = (_tmp24_ = g_key_file_get_boolean_list (schema, group, key, &_tmp23_, &_inner_error_), list_length1 = _tmp23_, list_size = list_length1, _tmp24_);
										if (_inner_error_ != NULL) {
											_g_value_array_free0 (array);
											_g_object_unref0 (st);
											if (_inner_error_->domain == G_KEY_FILE_ERROR) {
												goto __catch7_g_key_file_error;
											}
											_g_value_array_free0 (array);
											_g_object_unref0 (st);
											_g_free0 (key);
											g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
										array = (_tmp25_ = g_value_array_new ((guint) list_length1), _g_value_array_free0 (array), _tmp25_);
										{
											gboolean* item_collection;
											int item_collection_length1;
											int item_it;
											item_collection = list;
											item_collection_length1 = list_length1;
											for (item_it = 0; item_it < list_length1; item_it = item_it + 1) {
												gboolean item;
												item = item_collection[item_it];
												{
													GValue val = {0};
													GValue _tmp27_;
													GValue _tmp26_ = {0};
													val = (_tmp27_ = (g_value_init (&_tmp26_, G_TYPE_BOOLEAN), g_value_set_boolean (&_tmp26_, item), _tmp26_), G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp27_);
													g_value_array_append (array, &val);
													G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
												}
											}
										}
										list = (g_free (list), NULL);
									} else {
										if (self->priv->_list_type == G_TYPE_INT) {
											gint* _tmp29_;
											gint list_size;
											gint list_length1;
											gsize _tmp28_;
											gint* list;
											GValueArray* _tmp30_;
											list = (_tmp29_ = g_key_file_get_integer_list (schema, group, key, &_tmp28_, &_inner_error_), list_length1 = _tmp28_, list_size = list_length1, _tmp29_);
											if (_inner_error_ != NULL) {
												_g_value_array_free0 (array);
												_g_object_unref0 (st);
												if (_inner_error_->domain == G_KEY_FILE_ERROR) {
													goto __catch7_g_key_file_error;
												}
												_g_value_array_free0 (array);
												_g_object_unref0 (st);
												_g_free0 (key);
												g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return;
											}
											array = (_tmp30_ = g_value_array_new ((guint) list_length1), _g_value_array_free0 (array), _tmp30_);
											{
												gint* item_collection;
												int item_collection_length1;
												int item_it;
												item_collection = list;
												item_collection_length1 = list_length1;
												for (item_it = 0; item_it < list_length1; item_it = item_it + 1) {
													gint item;
													item = item_collection[item_it];
													{
														GValue val = {0};
														GValue _tmp32_;
														GValue _tmp31_ = {0};
														val = (_tmp32_ = (g_value_init (&_tmp31_, G_TYPE_INT), g_value_set_int (&_tmp31_, item), _tmp31_), G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp32_);
														g_value_array_append (array, &val);
														G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
													}
												}
											}
											list = (g_free (list), NULL);
										} else {
											if (self->priv->_list_type == G_TYPE_FLOAT) {
												double* _tmp34_;
												gint list_size;
												gint list_length1;
												gsize _tmp33_;
												double* list;
												GValueArray* _tmp35_;
												list = (_tmp34_ = g_key_file_get_double_list (schema, group, key, &_tmp33_, &_inner_error_), list_length1 = _tmp33_, list_size = list_length1, _tmp34_);
												if (_inner_error_ != NULL) {
													_g_value_array_free0 (array);
													_g_object_unref0 (st);
													if (_inner_error_->domain == G_KEY_FILE_ERROR) {
														goto __catch7_g_key_file_error;
													}
													_g_value_array_free0 (array);
													_g_object_unref0 (st);
													_g_free0 (key);
													g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return;
												}
												array = (_tmp35_ = g_value_array_new ((guint) list_length1), _g_value_array_free0 (array), _tmp35_);
												{
													double* item_collection;
													int item_collection_length1;
													int item_it;
													item_collection = list;
													item_collection_length1 = list_length1;
													for (item_it = 0; item_it < list_length1; item_it = item_it + 1) {
														double item;
														item = item_collection[item_it];
														{
															GValue val = {0};
															GValue _tmp37_;
															GValue _tmp36_ = {0};
															val = (_tmp37_ = (g_value_init (&_tmp36_, G_TYPE_FLOAT), g_value_set_float (&_tmp36_, (float) item), _tmp36_), G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp37_);
															g_value_array_append (array, &val);
															G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
														}
													}
												}
												list = (g_free (list), NULL);
											} else {
												if (self->priv->_list_type == G_TYPE_STRING) {
													char** _tmp39_;
													gint list_size;
													gint list_length1;
													gsize _tmp38_;
													char** list;
													GValueArray* _tmp40_;
													list = (_tmp39_ = g_key_file_get_string_list (schema, group, key, &_tmp38_, &_inner_error_), list_length1 = _tmp38_, list_size = list_length1, _tmp39_);
													if (_inner_error_ != NULL) {
														_g_value_array_free0 (array);
														_g_object_unref0 (st);
														if (_inner_error_->domain == G_KEY_FILE_ERROR) {
															goto __catch7_g_key_file_error;
														}
														_g_value_array_free0 (array);
														_g_object_unref0 (st);
														_g_free0 (key);
														g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return;
													}
													array = (_tmp40_ = g_value_array_new ((guint) list_length1), _g_value_array_free0 (array), _tmp40_);
													{
														char** item_collection;
														int item_collection_length1;
														int item_it;
														item_collection = list;
														item_collection_length1 = list_length1;
														for (item_it = 0; item_it < list_length1; item_it = item_it + 1) {
															const char* item;
															item = item_collection[item_it];
															{
																GValue val = {0};
																GValue _tmp42_;
																GValue _tmp41_ = {0};
																val = (_tmp42_ = (g_value_init (&_tmp41_, G_TYPE_STRING), g_value_set_string (&_tmp41_, item), _tmp41_), G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp42_);
																g_value_array_append (array, &val);
																G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
															}
														}
													}
													list = (_vala_array_free (list, list_length1, (GDestroyNotify) g_free), NULL);
												} else {
													DesktopAgnosticConfigSchemaType* _tmp43_;
													st = (_tmp43_ = _g_object_ref0 (desktop_agnostic_config_schema_find_type (self->priv->_list_type)), _g_object_unref0 (st), _tmp43_);
													if (st == NULL) {
														char* _tmp44_;
														char* _tmp45_;
														GError* _tmp46_;
														_tmp44_ = g_key_file_get_value (schema, group, "type", &_inner_error_);
														if (_inner_error_ != NULL) {
															_g_value_array_free0 (array);
															_g_object_unref0 (st);
															if (_inner_error_->domain == G_KEY_FILE_ERROR) {
																goto __catch7_g_key_file_error;
															}
															_g_value_array_free0 (array);
															_g_object_unref0 (st);
															_g_free0 (key);
															g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return;
														}
														_inner_error_ = (_tmp46_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR, DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_INVALID_LIST_TYPE, "Invalid option list type for %s: %s (given: '%s').", group, g_type_name (self->priv->_list_type), _tmp45_ = _tmp44_), _g_free0 (_tmp45_), _tmp46_);
														{
															_g_value_array_free0 (array);
															_g_object_unref0 (st);
															if (_inner_error_->domain == G_KEY_FILE_ERROR) {
																goto __catch7_g_key_file_error;
															}
															goto __finally7;
														}
													} else {
														char** _tmp48_;
														gint list_size;
														gint list_length1;
														gsize _tmp47_;
														char** list;
														GValueArray* _tmp49_;
														list = (_tmp48_ = g_key_file_get_string_list (schema, group, key, &_tmp47_, &_inner_error_), list_length1 = _tmp47_, list_size = list_length1, _tmp48_);
														if (_inner_error_ != NULL) {
															_g_value_array_free0 (array);
															_g_object_unref0 (st);
															if (_inner_error_->domain == G_KEY_FILE_ERROR) {
																goto __catch7_g_key_file_error;
															}
															_g_value_array_free0 (array);
															_g_object_unref0 (st);
															_g_free0 (key);
															g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return;
														}
														array = (_tmp49_ = g_value_array_new ((guint) list_length1), _g_value_array_free0 (array), _tmp49_);
														{
															char** item_collection;
															int item_collection_length1;
															int item_it;
															item_collection = list;
															item_collection_length1 = list_length1;
															for (item_it = 0; item_it < list_length1; item_it = item_it + 1) {
																const char* item;
																item = item_collection[item_it];
																{
																	GValue _tmp50_ = {0};
																	GValue _tmp51_;
																	GValue _tmp53_;
																	GValue _tmp52_;
																	_tmp51_ = (desktop_agnostic_config_schema_type_deserialize (st, item, &_tmp50_, &_inner_error_), _tmp50_);
																	if (_inner_error_ != NULL) {
																		list = (_vala_array_free (list, list_length1, (GDestroyNotify) g_free), NULL);
																		_g_value_array_free0 (array);
																		_g_object_unref0 (st);
																		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
																			goto __catch7_g_key_file_error;
																		}
																		goto __finally7;
																	}
																	g_value_array_append (array, (_tmp53_ = _tmp52_ = _tmp51_, &_tmp53_));
																	G_IS_VALUE (&_tmp52_) ? (g_value_unset (&_tmp52_), NULL) : NULL;
																}
															}
														}
														list = (_vala_array_free (list, list_length1, (GDestroyNotify) g_free), NULL);
													}
												}
											}
										}
									}
								}
								self->priv->_default_value = (_tmp55_ = (g_value_init (&_tmp54_, G_TYPE_VALUE_ARRAY), g_value_set_boxed (&_tmp54_, array), _tmp54_), G_IS_VALUE (&self->priv->_default_value) ? (g_value_unset (&self->priv->_default_value), NULL) : NULL, _tmp55_);
								_g_value_array_free0 (array);
							} else {
								char* _tmp56_;
								char* _tmp57_;
								GError* _tmp58_;
								_tmp56_ = g_key_file_get_value (schema, group, "type", &_inner_error_);
								if (_inner_error_ != NULL) {
									_g_object_unref0 (st);
									if (_inner_error_->domain == G_KEY_FILE_ERROR) {
										goto __catch7_g_key_file_error;
									}
									_g_object_unref0 (st);
									_g_free0 (key);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
								_inner_error_ = (_tmp58_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR, DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_INVALID_TYPE, "Invalid option type for %s: %s (given: '%s').", group, g_type_name (self->priv->_option_type), _tmp57_ = _tmp56_), _g_free0 (_tmp57_), _tmp58_);
								{
									_g_object_unref0 (st);
									if (_inner_error_->domain == G_KEY_FILE_ERROR) {
										goto __catch7_g_key_file_error;
									}
									goto __finally7;
								}
							}
						}
						_g_object_unref0 (st);
					}
				}
			}
		}
	}
	goto __finally7;
	__catch7_g_key_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			if (g_error_matches (err, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_INVALID_VALUE)) {
				_inner_error_ = g_error_new (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_INVALID_VALUE, "%s (key: %s)", err->message, group);
				{
					_g_error_free0 (err);
					_g_free0 (key);
					goto __finally7;
				}
			} else {
				_inner_error_ = _g_error_copy0 (err);
				{
					_g_error_free0 (err);
					_g_free0 (key);
					goto __finally7;
				}
			}
			_g_error_free0 (err);
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (key);
		return;
	}
	_g_free0 (key);
}


static char* desktop_agnostic_config_schema_option_parse_localized_value (DesktopAgnosticConfigSchemaOption* self, GKeyFile* schema, const char* group, const char* key, gboolean mandatory, GError** error) {
	char* result;
	GError * _inner_error_;
	char* _result_;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (schema != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_inner_error_ = NULL;
	_result_ = NULL;
	_tmp0_ = g_key_file_has_key (schema, group, key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (_result_);
		return NULL;
	}
	if (_tmp0_) {
		{
			char** _tmp1_;
			char** locale_collection;
			int locale_collection_length1;
			int locale_it;
			locale_collection = _tmp1_ = g_get_language_names ();
			locale_collection_length1 = _vala_array_length (_tmp1_);
			for (locale_it = 0; locale_it < _vala_array_length (_tmp1_); locale_it = locale_it + 1) {
				const char* locale;
				locale = locale_collection[locale_it];
				{
					if (_vala_strcmp0 (locale, "C") == 0) {
						char* _tmp2_;
						char* _tmp3_;
						_tmp2_ = g_key_file_get_string (schema, group, key, &_inner_error_);
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						}
						_result_ = (_tmp3_ = _tmp2_, _g_free0 (_result_), _tmp3_);
						break;
					}
					{
						char* _tmp4_;
						char* _tmp5_;
						_tmp4_ = g_key_file_get_locale_string (schema, group, key, locale, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (g_error_matches (_inner_error_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
								goto __catch8_g_key_file_error_key_not_found;
							}
							goto __finally8;
						}
						_result_ = (_tmp5_ = _tmp4_, _g_free0 (_result_), _tmp5_);
						break;
					}
					goto __finally8;
					__catch8_g_key_file_error_key_not_found:
					{
						GError * err;
						err = _inner_error_;
						_inner_error_ = NULL;
						{
							_g_error_free0 (err);
						}
					}
					__finally8:
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (_result_);
						return NULL;
					}
				}
			}
		}
	} else {
		if (mandatory) {
			_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_METADATA_NOT_FOUND, "The metadata value '%s' for the config key '%s' was not found.", key, group);
			{
				g_propagate_error (error, _inner_error_);
				_g_free0 (_result_);
				return NULL;
			}
		}
	}
	result = _result_;
	return result;
}


GType desktop_agnostic_config_schema_option_get_option_type (DesktopAgnosticConfigSchemaOption* self) {
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	result = self->priv->_option_type;
	return result;
}


static void desktop_agnostic_config_schema_option_set_option_type (DesktopAgnosticConfigSchemaOption* self, GType value) {
	g_return_if_fail (self != NULL);
	self->priv->_option_type = value;
	g_object_notify ((GObject *) self, "option-type");
}


GType desktop_agnostic_config_schema_option_get_list_type (DesktopAgnosticConfigSchemaOption* self) {
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	result = self->priv->_list_type;
	return result;
}


static void desktop_agnostic_config_schema_option_set_list_type (DesktopAgnosticConfigSchemaOption* self, GType value) {
	g_return_if_fail (self != NULL);
	self->priv->_list_type = value;
	g_object_notify ((GObject *) self, "list-type");
}


void desktop_agnostic_config_schema_option_get_default_value (DesktopAgnosticConfigSchemaOption* self, GValue* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->_default_value;
	return;
}


static void desktop_agnostic_config_schema_option_set_default_value (DesktopAgnosticConfigSchemaOption* self, GValue* value) {
	GValue _tmp1_;
	GValue _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	self->priv->_default_value = (_tmp1_ = G_IS_VALUE (value) ? (g_value_init (&_tmp0_, G_VALUE_TYPE (value)), g_value_copy (value, &_tmp0_), _tmp0_) : (*value), G_IS_VALUE (&self->priv->_default_value) ? (g_value_unset (&self->priv->_default_value), NULL) : NULL, _tmp1_);
	g_object_notify ((GObject *) self, "default-value");
}


const char* desktop_agnostic_config_schema_option_get_description (DesktopAgnosticConfigSchemaOption* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_description;
	return result;
}


static void desktop_agnostic_config_schema_option_set_description (DesktopAgnosticConfigSchemaOption* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_description = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_description), _tmp0_);
	g_object_notify ((GObject *) self, "description");
}


const char* desktop_agnostic_config_schema_option_get_summary (DesktopAgnosticConfigSchemaOption* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_summary;
	return result;
}


static void desktop_agnostic_config_schema_option_set_summary (DesktopAgnosticConfigSchemaOption* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_summary = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_summary), _tmp0_);
	g_object_notify ((GObject *) self, "summary");
}


GValue* desktop_agnostic_config_schema_option_get_lower_boundary (DesktopAgnosticConfigSchemaOption* self) {
	GValue* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_lower_boundary;
	return result;
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static void desktop_agnostic_config_schema_option_set_lower_boundary (DesktopAgnosticConfigSchemaOption* self, GValue* value) {
	GValue* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_lower_boundary = (_tmp0_ = __g_value_dup0 (value), _g_free0 (self->priv->_lower_boundary), _tmp0_);
}


GValue* desktop_agnostic_config_schema_option_get_upper_boundary (DesktopAgnosticConfigSchemaOption* self) {
	GValue* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_upper_boundary;
	return result;
}


static void desktop_agnostic_config_schema_option_set_upper_boundary (DesktopAgnosticConfigSchemaOption* self, GValue* value) {
	GValue* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_upper_boundary = (_tmp0_ = __g_value_dup0 (value), _g_free0 (self->priv->_upper_boundary), _tmp0_);
}


GValueArray* desktop_agnostic_config_schema_option_get_whitelist (DesktopAgnosticConfigSchemaOption* self) {
	GValueArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = g_value_array_copy (self->priv->_whitelist);
	return result;
}


GValueArray* desktop_agnostic_config_schema_option_get_blacklist (DesktopAgnosticConfigSchemaOption* self) {
	GValueArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = g_value_array_copy (self->priv->_blacklist);
	return result;
}


gboolean desktop_agnostic_config_schema_option_get_per_instance (DesktopAgnosticConfigSchemaOption* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_per_instance;
	return result;
}


static void desktop_agnostic_config_schema_option_set_per_instance (DesktopAgnosticConfigSchemaOption* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_per_instance = value;
	g_object_notify ((GObject *) self, "per-instance");
}


static void desktop_agnostic_config_schema_option_class_init (DesktopAgnosticConfigSchemaOptionClass * klass) {
	desktop_agnostic_config_schema_option_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticConfigSchemaOptionPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_config_schema_option_get_property;
	G_OBJECT_CLASS (klass)->set_property = desktop_agnostic_config_schema_option_set_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_config_schema_option_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_OPTION_TYPE, g_param_spec_gtype ("option-type", "option-type", "option-type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_LIST_TYPE, g_param_spec_gtype ("list-type", "list-type", "list-type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_DEFAULT_VALUE, g_param_spec_boxed ("default-value", "default-value", "default-value", G_TYPE_VALUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_SUMMARY, g_param_spec_string ("summary", "summary", "summary", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_WHITELIST, g_param_spec_boxed ("whitelist", "whitelist", "whitelist", G_TYPE_VALUE_ARRAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_BLACKLIST, g_param_spec_boxed ("blacklist", "blacklist", "blacklist", G_TYPE_VALUE_ARRAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_PER_INSTANCE, g_param_spec_boolean ("per-instance", "per-instance", "per-instance", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void desktop_agnostic_config_schema_option_instance_init (DesktopAgnosticConfigSchemaOption * self) {
	self->priv = DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_GET_PRIVATE (self);
	self->priv->_per_instance = TRUE;
}


static void desktop_agnostic_config_schema_option_finalize (GObject* obj) {
	DesktopAgnosticConfigSchemaOption * self;
	self = DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION (obj);
	G_IS_VALUE (&self->priv->_default_value) ? (g_value_unset (&self->priv->_default_value), NULL) : NULL;
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_summary);
	_g_free0 (self->priv->_lower_boundary);
	_g_free0 (self->priv->_upper_boundary);
	_g_value_array_free0 (self->priv->_whitelist);
	_g_value_array_free0 (self->priv->_blacklist);
	G_OBJECT_CLASS (desktop_agnostic_config_schema_option_parent_class)->finalize (obj);
}


GType desktop_agnostic_config_schema_option_get_type (void) {
	static GType desktop_agnostic_config_schema_option_type_id = 0;
	if (desktop_agnostic_config_schema_option_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticConfigSchemaOptionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_config_schema_option_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticConfigSchemaOption), 0, (GInstanceInitFunc) desktop_agnostic_config_schema_option_instance_init, NULL };
		desktop_agnostic_config_schema_option_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticConfigSchemaOption", &g_define_type_info, 0);
	}
	return desktop_agnostic_config_schema_option_type_id;
}


static void desktop_agnostic_config_schema_option_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticConfigSchemaOption * self;
	gpointer boxed;
	self = DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_OPTION_TYPE:
		g_value_set_gtype (value, desktop_agnostic_config_schema_option_get_option_type (self));
		break;
		case DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_LIST_TYPE:
		g_value_set_gtype (value, desktop_agnostic_config_schema_option_get_list_type (self));
		break;
		case DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_DEFAULT_VALUE:
		boxed = g_new0 (GValue, 1);
		desktop_agnostic_config_schema_option_get_default_value (self, boxed);
		g_value_take_boxed (value, boxed);
		break;
		case DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_DESCRIPTION:
		g_value_set_string (value, desktop_agnostic_config_schema_option_get_description (self));
		break;
		case DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_SUMMARY:
		g_value_set_string (value, desktop_agnostic_config_schema_option_get_summary (self));
		break;
		case DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_WHITELIST:
		g_value_set_boxed (value, desktop_agnostic_config_schema_option_get_whitelist (self));
		break;
		case DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_BLACKLIST:
		g_value_set_boxed (value, desktop_agnostic_config_schema_option_get_blacklist (self));
		break;
		case DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_PER_INSTANCE:
		g_value_set_boolean (value, desktop_agnostic_config_schema_option_get_per_instance (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void desktop_agnostic_config_schema_option_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesktopAgnosticConfigSchemaOption * self;
	self = DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_OPTION_TYPE:
		desktop_agnostic_config_schema_option_set_option_type (self, g_value_get_gtype (value));
		break;
		case DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_LIST_TYPE:
		desktop_agnostic_config_schema_option_set_list_type (self, g_value_get_gtype (value));
		break;
		case DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_DEFAULT_VALUE:
		desktop_agnostic_config_schema_option_set_default_value (self, g_value_get_boxed (value));
		break;
		case DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_DESCRIPTION:
		desktop_agnostic_config_schema_option_set_description (self, g_value_get_string (value));
		break;
		case DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_SUMMARY:
		desktop_agnostic_config_schema_option_set_summary (self, g_value_get_string (value));
		break;
		case DESKTOP_AGNOSTIC_CONFIG_SCHEMA_OPTION_PER_INSTANCE:
		desktop_agnostic_config_schema_option_set_per_instance (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




