/* vfs-file-impl-gio.c generated by valac, the Vala compiler
 * generated from vfs-file-impl-gio.vala, do not modify */

/*
 * Desktop Agnostic Library: File implementation (with GIO).
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libdesktop-agnostic/vfs.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GIO (desktop_agnostic_vfs_file_gio_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE_GIO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GIO, DesktopAgnosticVFSFileGIO))
#define DESKTOP_AGNOSTIC_VFS_FILE_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GIO, DesktopAgnosticVFSFileGIOClass))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_GIO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GIO))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GIO))
#define DESKTOP_AGNOSTIC_VFS_FILE_GIO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GIO, DesktopAgnosticVFSFileGIOClass))

typedef struct _DesktopAgnosticVFSFileGIO DesktopAgnosticVFSFileGIO;
typedef struct _DesktopAgnosticVFSFileGIOClass DesktopAgnosticVFSFileGIOClass;
typedef struct _DesktopAgnosticVFSFileGIOPrivate DesktopAgnosticVFSFileGIOPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GIO (desktop_agnostic_vfs_file_monitor_gio_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GIO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GIO, DesktopAgnosticVFSFileMonitorGIO))
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GIO, DesktopAgnosticVFSFileMonitorGIOClass))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_MONITOR_GIO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GIO))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_MONITOR_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GIO))
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GIO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GIO, DesktopAgnosticVFSFileMonitorGIOClass))

typedef struct _DesktopAgnosticVFSFileMonitorGIO DesktopAgnosticVFSFileMonitorGIO;
typedef struct _DesktopAgnosticVFSFileMonitorGIOClass DesktopAgnosticVFSFileMonitorGIOClass;
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
#define __g_slist_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DesktopAgnosticVFSFileGIO {
	DesktopAgnosticVFSFile parent_instance;
	DesktopAgnosticVFSFileGIOPrivate * priv;
};

struct _DesktopAgnosticVFSFileGIOClass {
	DesktopAgnosticVFSFileClass parent_class;
};

struct _DesktopAgnosticVFSFileGIOPrivate {
	GFile* _file;
	char* _uri;
};


static gpointer desktop_agnostic_vfs_file_gio_parent_class = NULL;

GType desktop_agnostic_vfs_file_gio_get_type (void);
#define DESKTOP_AGNOSTIC_VFS_FILE_GIO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GIO, DesktopAgnosticVFSFileGIOPrivate))
enum  {
	DESKTOP_AGNOSTIC_VFS_FILE_GIO_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_FILE_GIO_IMPLEMENTATION,
	DESKTOP_AGNOSTIC_VFS_FILE_GIO_IMPL_PATH,
	DESKTOP_AGNOSTIC_VFS_FILE_GIO_IMPL_URI,
	DESKTOP_AGNOSTIC_VFS_FILE_GIO_FILE_TYPE,
	DESKTOP_AGNOSTIC_VFS_FILE_GIO_ACCESS_FLAGS,
	DESKTOP_AGNOSTIC_VFS_FILE_GIO_PARENT
};
static void desktop_agnostic_vfs_file_gio_real_init (DesktopAgnosticVFSFile* base, const char* uri);
static gboolean desktop_agnostic_vfs_file_gio_real_exists (DesktopAgnosticVFSFile* base);
DesktopAgnosticVFSFileMonitorGIO* desktop_agnostic_vfs_file_monitor_gio_new (DesktopAgnosticVFSFileGIO* file);
DesktopAgnosticVFSFileMonitorGIO* desktop_agnostic_vfs_file_monitor_gio_construct (GType object_type, DesktopAgnosticVFSFileGIO* file);
GType desktop_agnostic_vfs_file_monitor_gio_get_type (void);
static DesktopAgnosticVFSFileMonitor* desktop_agnostic_vfs_file_gio_real_monitor (DesktopAgnosticVFSFile* base);
static gboolean desktop_agnostic_vfs_file_gio_real_load_contents (DesktopAgnosticVFSFile* base, char** contents, gsize* length, GError** error);
static gboolean desktop_agnostic_vfs_file_gio_real_replace_contents (DesktopAgnosticVFSFile* base, const char* contents, GError** error);
static void _g_list_free_g_object_unref (GList* self);
static gboolean desktop_agnostic_vfs_file_gio_real_launch (DesktopAgnosticVFSFile* base, GError** error);
static void _g_slist_free_g_object_unref (GSList* self);
static GSList* desktop_agnostic_vfs_file_gio_real_enumerate_children (DesktopAgnosticVFSFile* base, GError** error);
static gboolean desktop_agnostic_vfs_file_gio_real_copy (DesktopAgnosticVFSFile* base, DesktopAgnosticVFSFile* destination, gboolean overwrite, GError** error);
static gboolean desktop_agnostic_vfs_file_gio_real_remove (DesktopAgnosticVFSFile* base, GError** error);
DesktopAgnosticVFSFileGIO* desktop_agnostic_vfs_file_gio_new (void);
DesktopAgnosticVFSFileGIO* desktop_agnostic_vfs_file_gio_construct (GType object_type);
static void desktop_agnostic_vfs_file_gio_finalize (GObject* obj);
static void desktop_agnostic_vfs_file_gio_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);



static void desktop_agnostic_vfs_file_gio_real_init (DesktopAgnosticVFSFile* base, const char* uri) {
	DesktopAgnosticVFSFileGIO * self;
	GFile* _tmp0_;
	self = (DesktopAgnosticVFSFileGIO*) base;
	g_return_if_fail (uri != NULL);
	self->priv->_file = (_tmp0_ = g_file_new_for_uri (uri), _g_object_unref0 (self->priv->_file), _tmp0_);
}


static gboolean desktop_agnostic_vfs_file_gio_real_exists (DesktopAgnosticVFSFile* base) {
	DesktopAgnosticVFSFileGIO * self;
	gboolean result;
	self = (DesktopAgnosticVFSFileGIO*) base;
	result = g_file_query_exists (self->priv->_file, NULL);
	return result;
}


static DesktopAgnosticVFSFileMonitor* desktop_agnostic_vfs_file_gio_real_monitor (DesktopAgnosticVFSFile* base) {
	DesktopAgnosticVFSFileGIO * self;
	DesktopAgnosticVFSFileMonitor* result;
	self = (DesktopAgnosticVFSFileGIO*) base;
	result = (DesktopAgnosticVFSFileMonitor*) desktop_agnostic_vfs_file_monitor_gio_new (self);
	return result;
}


static gboolean desktop_agnostic_vfs_file_gio_real_load_contents (DesktopAgnosticVFSFile* base, char** contents, gsize* length, GError** error) {
	DesktopAgnosticVFSFileGIO * self;
	gboolean result;
	GError * _inner_error_;
	char* _tmp2_;
	gboolean _tmp1_;
	char* _tmp0_ = NULL;
	gboolean _tmp3_;
	self = (DesktopAgnosticVFSFileGIO*) base;
	if (contents != NULL) {
		*contents = NULL;
	}
	_inner_error_ = NULL;
	_tmp3_ = (_tmp1_ = g_file_load_contents (self->priv->_file, NULL, &_tmp0_, length, NULL, &_inner_error_), *contents = (_tmp2_ = _tmp0_, _g_free0 (*contents), _tmp2_), _tmp1_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp3_;
	return result;
}


static gboolean desktop_agnostic_vfs_file_gio_real_replace_contents (DesktopAgnosticVFSFile* base, const char* contents, GError** error) {
	DesktopAgnosticVFSFileGIO * self;
	gboolean result;
	GError * _inner_error_;
	gboolean _tmp0_;
	self = (DesktopAgnosticVFSFileGIO*) base;
	g_return_val_if_fail (contents != NULL, FALSE);
	_inner_error_ = NULL;
	_tmp0_ = g_file_replace_contents (self->priv->_file, contents, strlen (contents), NULL, FALSE, 0, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
	return result;
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean desktop_agnostic_vfs_file_gio_real_launch (DesktopAgnosticVFSFile* base, GError** error) {
	DesktopAgnosticVFSFileGIO * self;
	gboolean result;
	GError * _inner_error_;
	GAppInfo* app_info;
	GList* files;
	GAppInfo* _tmp0_;
	GAppInfo* _tmp1_;
	gboolean _tmp2_;
	self = (DesktopAgnosticVFSFileGIO*) base;
	_inner_error_ = NULL;
	app_info = NULL;
	files = NULL;
	_tmp0_ = g_file_query_default_handler (self->priv->_file, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (app_info);
		__g_list_free_g_object_unref0 (files);
		return FALSE;
	}
	app_info = (_tmp1_ = _tmp0_, _g_object_unref0 (app_info), _tmp1_);
	files = g_list_append (files, _g_object_ref0 (self->priv->_file));
	_tmp2_ = g_app_info_launch (app_info, files, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (app_info);
		__g_list_free_g_object_unref0 (files);
		return FALSE;
	}
	result = _tmp2_;
	_g_object_unref0 (app_info);
	__g_list_free_g_object_unref0 (files);
	return result;
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


static GSList* desktop_agnostic_vfs_file_gio_real_enumerate_children (DesktopAgnosticVFSFile* base, GError** error) {
	DesktopAgnosticVFSFileGIO * self;
	GSList* result;
	GError * _inner_error_;
	GSList* children;
	GFileEnumerator* enumerator;
	GFileInfo* info;
	GSList* _tmp0_;
	GFileEnumerator* _tmp1_;
	GFileEnumerator* _tmp2_;
	self = (DesktopAgnosticVFSFileGIO*) base;
	_inner_error_ = NULL;
	children = NULL;
	enumerator = NULL;
	info = NULL;
	children = (_tmp0_ = NULL, __g_slist_free_g_object_unref0 (children), _tmp0_);
	_tmp1_ = g_file_enumerate_children (self->priv->_file, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		__g_slist_free_g_object_unref0 (children);
		_g_object_unref0 (enumerator);
		_g_object_unref0 (info);
		return NULL;
	}
	enumerator = (_tmp2_ = _tmp1_, _g_object_unref0 (enumerator), _tmp2_);
	while (TRUE) {
		GFileInfo* _tmp3_;
		GFileInfo* _tmp4_;
		GFile* gchild;
		DesktopAgnosticVFSFile* child;
		GFile* _tmp5_;
		char* _tmp6_;
		DesktopAgnosticVFSFile* _tmp7_;
		DesktopAgnosticVFSFile* _tmp8_;
		DesktopAgnosticVFSFile* _tmp9_;
		DesktopAgnosticVFSFile* _tmp10_;
		_tmp3_ = g_file_enumerator_next_file (enumerator, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			__g_slist_free_g_object_unref0 (children);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (info);
			return NULL;
		}
		if (!((info = (_tmp4_ = _tmp3_, _g_object_unref0 (info), _tmp4_)) != NULL)) {
			break;
		}
		gchild = NULL;
		child = NULL;
		gchild = (_tmp5_ = g_file_get_child (self->priv->_file, g_file_info_get_name (info)), _g_object_unref0 (gchild), _tmp5_);
		_tmp8_ = (_tmp7_ = desktop_agnostic_vfs_file_new_for_uri (_tmp6_ = g_file_get_uri (gchild), &_inner_error_), _g_free0 (_tmp6_), _tmp7_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (gchild);
			_g_object_unref0 (child);
			__g_slist_free_g_object_unref0 (children);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (info);
			return NULL;
		}
		child = (_tmp9_ = _tmp8_, _g_object_unref0 (child), _tmp9_);
		children = g_slist_append (children, (_tmp10_ = child, child = NULL, _tmp10_));
		_g_object_unref0 (gchild);
		_g_object_unref0 (child);
	}
	result = children;
	_g_object_unref0 (enumerator);
	_g_object_unref0 (info);
	return result;
}


static gboolean desktop_agnostic_vfs_file_gio_real_copy (DesktopAgnosticVFSFile* base, DesktopAgnosticVFSFile* destination, gboolean overwrite, GError** error) {
	DesktopAgnosticVFSFileGIO * self;
	gboolean result;
	GError * _inner_error_;
	GFileCopyFlags flags;
	gboolean _tmp0_;
	self = (DesktopAgnosticVFSFileGIO*) base;
	g_return_val_if_fail (destination != NULL, FALSE);
	_inner_error_ = NULL;
	flags = 0;
	if (overwrite) {
		flags = G_FILE_COPY_OVERWRITE;
	}
	_tmp0_ = g_file_copy (self->priv->_file, G_FILE (desktop_agnostic_vfs_file_get_implementation (destination)), flags, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean desktop_agnostic_vfs_file_gio_real_remove (DesktopAgnosticVFSFile* base, GError** error) {
	DesktopAgnosticVFSFileGIO * self;
	gboolean result;
	GError * _inner_error_;
	gboolean _tmp2_;
	self = (DesktopAgnosticVFSFileGIO*) base;
	_inner_error_ = NULL;
	if (!desktop_agnostic_vfs_file_exists ((DesktopAgnosticVFSFile*) self)) {
		char* _tmp0_;
		GError* _tmp1_;
		_inner_error_ = (_tmp1_ = g_error_new (DESKTOP_AGNOSTIC_VFS_FILE_ERROR, DESKTOP_AGNOSTIC_VFS_FILE_ERROR_FILE_NOT_FOUND, "The file '%s' does not exist.", _tmp0_ = desktop_agnostic_vfs_file_get_uri ((DesktopAgnosticVFSFile*) self)), _g_free0 (_tmp0_), _tmp1_);
		{
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	}
	_tmp2_ = g_file_delete (self->priv->_file, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp2_;
	return result;
}


DesktopAgnosticVFSFileGIO* desktop_agnostic_vfs_file_gio_construct (GType object_type) {
	DesktopAgnosticVFSFileGIO * self;
	self = (DesktopAgnosticVFSFileGIO*) desktop_agnostic_vfs_file_construct (object_type);
	return self;
}


DesktopAgnosticVFSFileGIO* desktop_agnostic_vfs_file_gio_new (void) {
	return desktop_agnostic_vfs_file_gio_construct (DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GIO);
}


static void* desktop_agnostic_vfs_file_gio_real_get_implementation (DesktopAgnosticVFSFile* base) {
	void* result;
	DesktopAgnosticVFSFileGIO* self;
	self = (DesktopAgnosticVFSFileGIO*) base;
	result = (void*) self->priv->_file;
	return result;
}


static char* desktop_agnostic_vfs_file_gio_real_get_impl_path (DesktopAgnosticVFSFile* base) {
	char* result;
	DesktopAgnosticVFSFileGIO* self;
	self = (DesktopAgnosticVFSFileGIO*) base;
	result = g_file_get_path (self->priv->_file);
	return result;
}


static char* desktop_agnostic_vfs_file_gio_real_get_impl_uri (DesktopAgnosticVFSFile* base) {
	char* result;
	DesktopAgnosticVFSFileGIO* self;
	self = (DesktopAgnosticVFSFileGIO*) base;
	if (self->priv->_uri == NULL) {
		char* _tmp0_;
		self->priv->_uri = (_tmp0_ = g_file_get_uri (self->priv->_file), _g_free0 (self->priv->_uri), _tmp0_);
	}
	result = g_strdup (self->priv->_uri);
	return result;
}


static DesktopAgnosticVFSFileType desktop_agnostic_vfs_file_gio_real_get_file_type (DesktopAgnosticVFSFile* base) {
	GError * _inner_error_;
	DesktopAgnosticVFSFileType result;
	DesktopAgnosticVFSFileGIO* self;
	DesktopAgnosticVFSFileType ft;
	_inner_error_ = NULL;
	self = (DesktopAgnosticVFSFileGIO*) base;
	ft = DESKTOP_AGNOSTIC_VFS_FILE_TYPE_UNKNOWN;
	if (desktop_agnostic_vfs_file_exists ((DesktopAgnosticVFSFile*) self)) {
		GFileInfo* info;
		GFileType gft = 0;
		info = NULL;
		{
			GFileInfo* _tmp0_;
			GFileInfo* _tmp1_;
			_tmp0_ = g_file_query_info (self->priv->_file, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
			info = (_tmp1_ = _tmp0_, _g_object_unref0 (info), _tmp1_);
			gft = (GFileType) g_file_info_get_attribute_uint32 (info, G_FILE_ATTRIBUTE_STANDARD_TYPE);
			switch (gft) {
				case G_FILE_TYPE_REGULAR:
				{
					ft = DESKTOP_AGNOSTIC_VFS_FILE_TYPE_REGULAR;
					break;
				}
				case G_FILE_TYPE_DIRECTORY:
				case G_FILE_TYPE_MOUNTABLE:
				{
					ft = DESKTOP_AGNOSTIC_VFS_FILE_TYPE_DIRECTORY;
					break;
				}
				case G_FILE_TYPE_SYMBOLIC_LINK:
				case G_FILE_TYPE_SHORTCUT:
				{
					ft = DESKTOP_AGNOSTIC_VFS_FILE_TYPE_SYMBOLIC_LINK;
					break;
				}
				case G_FILE_TYPE_SPECIAL:
				{
					ft = DESKTOP_AGNOSTIC_VFS_FILE_TYPE_SPECIAL;
					break;
				}
				case G_FILE_TYPE_UNKNOWN:
				{
					ft = DESKTOP_AGNOSTIC_VFS_FILE_TYPE_UNKNOWN;
					break;
				}
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("vfs-file-impl-gio.vala:94: An error occurred while querying the file type: %s", err->message);
				ft = DESKTOP_AGNOSTIC_VFS_FILE_TYPE_UNKNOWN;
				_g_error_free0 (err);
			}
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_object_unref0 (info);
	}
	result = ft;
	return result;
}


static DesktopAgnosticVFSAccessFlags desktop_agnostic_vfs_file_gio_real_get_access_flags (DesktopAgnosticVFSFile* base) {
	GError * _inner_error_;
	DesktopAgnosticVFSAccessFlags result;
	DesktopAgnosticVFSFileGIO* self;
	DesktopAgnosticVFSAccessFlags flags;
	_inner_error_ = NULL;
	self = (DesktopAgnosticVFSFileGIO*) base;
	flags = DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_NONE;
	if (desktop_agnostic_vfs_file_exists ((DesktopAgnosticVFSFile*) self)) {
		GFileInfo* info;
		info = NULL;
		{
			char* attrs;
			char* _tmp0_;
			GFileInfo* _tmp1_;
			GFileInfo* _tmp2_;
			attrs = NULL;
			attrs = (_tmp0_ = g_strdup_printf ("%s,%s,%s", G_FILE_ATTRIBUTE_ACCESS_CAN_READ, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE, G_FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE), _g_free0 (attrs), _tmp0_);
			_tmp1_ = g_file_query_info (self->priv->_file, attrs, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (attrs);
				goto __catch1_g_error;
			}
			info = (_tmp2_ = _tmp1_, _g_object_unref0 (info), _tmp2_);
			if (g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_READ)) {
				flags = flags | DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_READ;
			}
			if (g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE)) {
				flags = flags | DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_WRITE;
			}
			if (g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE)) {
				flags = flags | DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_EXECUTE;
			}
			_g_free0 (attrs);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("vfs-file-impl-gio.vala:135: An error occurred while querying the access flags: %s", err->message);
				_g_error_free0 (err);
			}
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_object_unref0 (info);
	}
	result = flags;
	return result;
}


static DesktopAgnosticVFSFile* desktop_agnostic_vfs_file_gio_real_get_parent (DesktopAgnosticVFSFile* base) {
	DesktopAgnosticVFSFile* result;
	DesktopAgnosticVFSFileGIO* self;
	GFile* file;
	GFile* _tmp0_;
	self = (DesktopAgnosticVFSFileGIO*) base;
	file = NULL;
	file = (_tmp0_ = g_file_get_parent (self->priv->_file), _g_object_unref0 (file), _tmp0_);
	if (file == NULL) {
		result = NULL;
		_g_object_unref0 (file);
		return result;
	} else {
		DesktopAgnosticVFSFile* _result_;
		DesktopAgnosticVFSFile* _tmp1_;
		char* _tmp2_;
		_result_ = NULL;
		_result_ = (_tmp1_ = (DesktopAgnosticVFSFile*) desktop_agnostic_vfs_file_gio_new (), _g_object_unref0 (_result_), _tmp1_);
		desktop_agnostic_vfs_file_init (_result_, _tmp2_ = g_file_get_uri (file));
		_g_free0 (_tmp2_);
		result = _result_;
		_g_object_unref0 (file);
		return result;
	}
	_g_object_unref0 (file);
}


static void desktop_agnostic_vfs_file_gio_class_init (DesktopAgnosticVFSFileGIOClass * klass) {
	desktop_agnostic_vfs_file_gio_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticVFSFileGIOPrivate));
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->init = desktop_agnostic_vfs_file_gio_real_init;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->exists = desktop_agnostic_vfs_file_gio_real_exists;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->monitor = desktop_agnostic_vfs_file_gio_real_monitor;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->load_contents = desktop_agnostic_vfs_file_gio_real_load_contents;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->replace_contents = desktop_agnostic_vfs_file_gio_real_replace_contents;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->launch = desktop_agnostic_vfs_file_gio_real_launch;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->enumerate_children = desktop_agnostic_vfs_file_gio_real_enumerate_children;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->copy = desktop_agnostic_vfs_file_gio_real_copy;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->remove = desktop_agnostic_vfs_file_gio_real_remove;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_implementation = desktop_agnostic_vfs_file_gio_real_get_implementation;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_impl_path = desktop_agnostic_vfs_file_gio_real_get_impl_path;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_impl_uri = desktop_agnostic_vfs_file_gio_real_get_impl_uri;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_file_type = desktop_agnostic_vfs_file_gio_real_get_file_type;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_access_flags = desktop_agnostic_vfs_file_gio_real_get_access_flags;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_parent = desktop_agnostic_vfs_file_gio_real_get_parent;
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_file_gio_get_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_vfs_file_gio_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_GIO_IMPLEMENTATION, "implementation");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_GIO_IMPL_PATH, "impl-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_GIO_IMPL_URI, "impl-uri");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_GIO_FILE_TYPE, "file-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_GIO_ACCESS_FLAGS, "access-flags");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_GIO_PARENT, "parent");
}


static void desktop_agnostic_vfs_file_gio_instance_init (DesktopAgnosticVFSFileGIO * self) {
	self->priv = DESKTOP_AGNOSTIC_VFS_FILE_GIO_GET_PRIVATE (self);
}


static void desktop_agnostic_vfs_file_gio_finalize (GObject* obj) {
	DesktopAgnosticVFSFileGIO * self;
	self = DESKTOP_AGNOSTIC_VFS_FILE_GIO (obj);
	_g_object_unref0 (self->priv->_file);
	_g_free0 (self->priv->_uri);
	G_OBJECT_CLASS (desktop_agnostic_vfs_file_gio_parent_class)->finalize (obj);
}


GType desktop_agnostic_vfs_file_gio_get_type (void) {
	static GType desktop_agnostic_vfs_file_gio_type_id = 0;
	if (desktop_agnostic_vfs_file_gio_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSFileGIOClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_file_gio_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSFileGIO), 0, (GInstanceInitFunc) desktop_agnostic_vfs_file_gio_instance_init, NULL };
		desktop_agnostic_vfs_file_gio_type_id = g_type_register_static (DESKTOP_AGNOSTIC_VFS_TYPE_FILE, "DesktopAgnosticVFSFileGIO", &g_define_type_info, 0);
	}
	return desktop_agnostic_vfs_file_gio_type_id;
}


static void desktop_agnostic_vfs_file_gio_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSFileGIO * self;
	self = DESKTOP_AGNOSTIC_VFS_FILE_GIO (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_FILE_GIO_IMPLEMENTATION:
		g_value_set_pointer (value, desktop_agnostic_vfs_file_get_implementation ((DesktopAgnosticVFSFile*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_FILE_GIO_IMPL_PATH:
		g_value_set_string (value, desktop_agnostic_vfs_file_get_impl_path ((DesktopAgnosticVFSFile*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_FILE_GIO_IMPL_URI:
		g_value_set_string (value, desktop_agnostic_vfs_file_get_impl_uri ((DesktopAgnosticVFSFile*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_FILE_GIO_FILE_TYPE:
		g_value_set_enum (value, desktop_agnostic_vfs_file_get_file_type ((DesktopAgnosticVFSFile*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_FILE_GIO_ACCESS_FLAGS:
		g_value_set_enum (value, desktop_agnostic_vfs_file_get_access_flags ((DesktopAgnosticVFSFile*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_FILE_GIO_PARENT:
		g_value_set_object (value, desktop_agnostic_vfs_file_get_parent ((DesktopAgnosticVFSFile*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




