/* config-bridge.c generated by valac, the Vala compiler
 * generated from config-bridge.vala, do not modify */

/*
 * Provides a method to bind configuration entries to a GObject.
 *
 * Copyright (C) 2008, 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Neil J. Patel <njpatel@gmail.com> (Original C code)
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define DESKTOP_AGNOSTIC_CONFIG_TYPE_BINDING_NOTIFIER (desktop_agnostic_config_binding_notifier_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_BINDING_NOTIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BINDING_NOTIFIER, DesktopAgnosticConfigBindingNotifier))
#define DESKTOP_AGNOSTIC_CONFIG_BINDING_NOTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_BINDING_NOTIFIER, DesktopAgnosticConfigBindingNotifierClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_BINDING_NOTIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BINDING_NOTIFIER))
#define DESKTOP_AGNOSTIC_CONFIG_IS_BINDING_NOTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_BINDING_NOTIFIER))
#define DESKTOP_AGNOSTIC_CONFIG_BINDING_NOTIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BINDING_NOTIFIER, DesktopAgnosticConfigBindingNotifierClass))

typedef struct _DesktopAgnosticConfigBindingNotifier DesktopAgnosticConfigBindingNotifier;
typedef struct _DesktopAgnosticConfigBindingNotifierClass DesktopAgnosticConfigBindingNotifierClass;
typedef struct _DesktopAgnosticConfigBindingNotifierPrivate DesktopAgnosticConfigBindingNotifierPrivate;

#define DESKTOP_AGNOSTIC_CONFIG_TYPE_BACKEND (desktop_agnostic_config_backend_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BACKEND, DesktopAgnosticConfigBackend))
#define DESKTOP_AGNOSTIC_CONFIG_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_BACKEND, DesktopAgnosticConfigBackendClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BACKEND))
#define DESKTOP_AGNOSTIC_CONFIG_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_BACKEND))
#define DESKTOP_AGNOSTIC_CONFIG_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BACKEND, DesktopAgnosticConfigBackendClass))

typedef struct _DesktopAgnosticConfigBackend DesktopAgnosticConfigBackend;
typedef struct _DesktopAgnosticConfigBackendClass DesktopAgnosticConfigBackendClass;

#define DESKTOP_AGNOSTIC_CONFIG_TYPE_BINDING_LIST_WRAPPER (desktop_agnostic_config_binding_list_wrapper_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_BINDING_LIST_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BINDING_LIST_WRAPPER, DesktopAgnosticConfigBindingListWrapper))
#define DESKTOP_AGNOSTIC_CONFIG_BINDING_LIST_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_BINDING_LIST_WRAPPER, DesktopAgnosticConfigBindingListWrapperClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_BINDING_LIST_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BINDING_LIST_WRAPPER))
#define DESKTOP_AGNOSTIC_CONFIG_IS_BINDING_LIST_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_BINDING_LIST_WRAPPER))
#define DESKTOP_AGNOSTIC_CONFIG_BINDING_LIST_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BINDING_LIST_WRAPPER, DesktopAgnosticConfigBindingListWrapperClass))

typedef struct _DesktopAgnosticConfigBindingListWrapper DesktopAgnosticConfigBindingListWrapper;
typedef struct _DesktopAgnosticConfigBindingListWrapperClass DesktopAgnosticConfigBindingListWrapperClass;

#define DESKTOP_AGNOSTIC_CONFIG_TYPE_BRIDGE (desktop_agnostic_config_bridge_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_BRIDGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BRIDGE, DesktopAgnosticConfigBridge))
#define DESKTOP_AGNOSTIC_CONFIG_BRIDGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_BRIDGE, DesktopAgnosticConfigBridgeClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_BRIDGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BRIDGE))
#define DESKTOP_AGNOSTIC_CONFIG_IS_BRIDGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_BRIDGE))
#define DESKTOP_AGNOSTIC_CONFIG_BRIDGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BRIDGE, DesktopAgnosticConfigBridgeClass))

typedef struct _DesktopAgnosticConfigBridge DesktopAgnosticConfigBridge;
typedef struct _DesktopAgnosticConfigBridgeClass DesktopAgnosticConfigBridgeClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DesktopAgnosticConfigBindingListWrapperPrivate DesktopAgnosticConfigBindingListWrapperPrivate;

#define DESKTOP_AGNOSTIC_CONFIG_TYPE_BINDING (desktop_agnostic_config_binding_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BINDING, DesktopAgnosticConfigBinding))
#define DESKTOP_AGNOSTIC_CONFIG_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_BINDING, DesktopAgnosticConfigBindingClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BINDING))
#define DESKTOP_AGNOSTIC_CONFIG_IS_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_BINDING))
#define DESKTOP_AGNOSTIC_CONFIG_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_BINDING, DesktopAgnosticConfigBindingClass))

typedef struct _DesktopAgnosticConfigBinding DesktopAgnosticConfigBinding;
typedef struct _DesktopAgnosticConfigBindingClass DesktopAgnosticConfigBindingClass;
typedef struct _DesktopAgnosticConfigBindingPrivate DesktopAgnosticConfigBindingPrivate;

#define DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE (desktop_agnostic_config_schema_type_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE, DesktopAgnosticConfigSchemaType))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE, DesktopAgnosticConfigSchemaTypeClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE))
#define DESKTOP_AGNOSTIC_CONFIG_IS_SCHEMA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE))
#define DESKTOP_AGNOSTIC_CONFIG_SCHEMA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE, DesktopAgnosticConfigSchemaTypeClass))

typedef struct _DesktopAgnosticConfigSchemaType DesktopAgnosticConfigSchemaType;
typedef struct _DesktopAgnosticConfigSchemaTypeClass DesktopAgnosticConfigSchemaTypeClass;
#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
typedef struct _DesktopAgnosticConfigBridgePrivate DesktopAgnosticConfigBridgePrivate;
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DesktopAgnosticConfigBindingNotifier {
	GObject parent_instance;
	DesktopAgnosticConfigBindingNotifierPrivate * priv;
	DesktopAgnosticConfigBackend* config;
};

struct _DesktopAgnosticConfigBindingNotifierClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticConfigBindingListWrapper {
	GObject parent_instance;
	DesktopAgnosticConfigBindingListWrapperPrivate * priv;
	GList* binding_list;
};

struct _DesktopAgnosticConfigBindingListWrapperClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticConfigBinding {
	GObject parent_instance;
	DesktopAgnosticConfigBindingPrivate * priv;
	DesktopAgnosticConfigBackend* cfg;
	char* group;
	char* key;
	GObject* obj;
	char* property_name;
	gulong notify_id;
	gboolean read_only;
};

struct _DesktopAgnosticConfigBindingClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticConfigBridge {
	GObject parent_instance;
	DesktopAgnosticConfigBridgePrivate * priv;
};

struct _DesktopAgnosticConfigBridgeClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticConfigBridgePrivate {
	GData* bindings;
};

typedef void (*DesktopAgnosticConfigNotifyFunc) (const char* group, const char* key, GValue* value, void* user_data);
typedef void (*DesktopAgnosticConfigBridgeNotifyFuncHandler) (DesktopAgnosticConfigBackend* config, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc func, void* func_target, GError** error);
typedef enum  {
	DESKTOP_AGNOSTIC_CONFIG_ERROR_NO_SCHEMA,
	DESKTOP_AGNOSTIC_CONFIG_ERROR_INVALID_TYPE,
	DESKTOP_AGNOSTIC_CONFIG_ERROR_KEY_NOT_FOUND,
	DESKTOP_AGNOSTIC_CONFIG_ERROR_METADATA_NOT_FOUND,
	DESKTOP_AGNOSTIC_CONFIG_ERROR_NOTIFY,
	DESKTOP_AGNOSTIC_CONFIG_ERROR_DUPLICATE_BINDING
} DesktopAgnosticConfigError;
#define DESKTOP_AGNOSTIC_CONFIG_ERROR desktop_agnostic_config_error_quark ()

static gpointer desktop_agnostic_config_binding_notifier_parent_class = NULL;
static gpointer desktop_agnostic_config_binding_list_wrapper_parent_class = NULL;
static gpointer desktop_agnostic_config_binding_parent_class = NULL;
static DesktopAgnosticConfigBridge* desktop_agnostic_config_bridge_bridge;
static DesktopAgnosticConfigBridge* desktop_agnostic_config_bridge_bridge = NULL;
static gpointer desktop_agnostic_config_bridge_parent_class = NULL;

GType desktop_agnostic_config_binding_notifier_get_type (void);
GType desktop_agnostic_config_backend_get_type (void);
enum  {
	DESKTOP_AGNOSTIC_CONFIG_BINDING_NOTIFIER_DUMMY_PROPERTY
};
DesktopAgnosticConfigBindingNotifier* desktop_agnostic_config_binding_notifier_new (DesktopAgnosticConfigBackend* cfg);
DesktopAgnosticConfigBindingNotifier* desktop_agnostic_config_binding_notifier_construct (GType object_type, DesktopAgnosticConfigBackend* cfg);
GType desktop_agnostic_config_binding_list_wrapper_get_type (void);
GType desktop_agnostic_config_bridge_get_type (void);
DesktopAgnosticConfigBridge* desktop_agnostic_config_bridge_get_default (void);
const char* desktop_agnostic_config_backend_get_instance_id (DesktopAgnosticConfigBackend* self);
void desktop_agnostic_config_bridge_get_all_bindings (DesktopAgnosticConfigBridge* self, GData** result);
GType desktop_agnostic_config_binding_get_type (void);
void desktop_agnostic_config_binding_notifier_on_simple_value_changed (DesktopAgnosticConfigBindingNotifier* self, const char* group, const char* key, GValue* value);
void desktop_agnostic_config_binding_notifier_on_list_changed (DesktopAgnosticConfigBindingNotifier* self, const char* group, const char* key, GValue* value);
GType desktop_agnostic_config_schema_type_get_type (void);
GParamSpec* desktop_agnostic_config_bridge_get_property_spec (GObject* obj, const char* property_name);
DesktopAgnosticConfigSchemaType* desktop_agnostic_config_schema_find_type (GType type);
void desktop_agnostic_config_binding_notifier_on_serialized_object_changed (DesktopAgnosticConfigBindingNotifier* self, const char* group, const char* key, GValue* value);
static void desktop_agnostic_config_binding_notifier_finalize (GObject* obj);
enum  {
	DESKTOP_AGNOSTIC_CONFIG_BINDING_LIST_WRAPPER_DUMMY_PROPERTY
};
static void _g_list_free_g_object_unref (GList* self);
DesktopAgnosticConfigBindingListWrapper* desktop_agnostic_config_binding_list_wrapper_new (void);
DesktopAgnosticConfigBindingListWrapper* desktop_agnostic_config_binding_list_wrapper_construct (GType object_type);
static void desktop_agnostic_config_binding_list_wrapper_finalize (GObject* obj);
enum  {
	DESKTOP_AGNOSTIC_CONFIG_BINDING_DUMMY_PROPERTY
};
DesktopAgnosticConfigBinding* desktop_agnostic_config_binding_new (void);
DesktopAgnosticConfigBinding* desktop_agnostic_config_binding_construct (GType object_type);
static void desktop_agnostic_config_binding_finalize (GObject* obj);
#define DESKTOP_AGNOSTIC_CONFIG_BRIDGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_CONFIG_TYPE_BRIDGE, DesktopAgnosticConfigBridgePrivate))
enum  {
	DESKTOP_AGNOSTIC_CONFIG_BRIDGE_DUMMY_PROPERTY
};
static DesktopAgnosticConfigBridge* desktop_agnostic_config_bridge_new (void);
static DesktopAgnosticConfigBridge* desktop_agnostic_config_bridge_construct (GType object_type);
static void desktop_agnostic_config_bridge_handle_notify_func_with_param_spec (DesktopAgnosticConfigBridge* self, DesktopAgnosticConfigBackend* config, const char* group, const char* key, GParamSpec* spec, DesktopAgnosticConfigBridgeNotifyFuncHandler func, GError** error);
static void desktop_agnostic_config_bridge_handle_notify_func (DesktopAgnosticConfigBridge* self, DesktopAgnosticConfigBackend* config, const char* group, const char* key, GObject* obj, const char* property_name, DesktopAgnosticConfigBridgeNotifyFuncHandler func, GError** error);
static void _g_object_unref_gdestroy_notify (void* data);
static void _desktop_agnostic_config_binding_notifier_on_simple_value_changed_desktop_agnostic_config_notify_func (const char* group, const char* key, GValue* value, gpointer self);
static void _desktop_agnostic_config_binding_notifier_on_list_changed_desktop_agnostic_config_notify_func (const char* group, const char* key, GValue* value, gpointer self);
GQuark desktop_agnostic_config_error_quark (void);
static void _desktop_agnostic_config_binding_notifier_on_serialized_object_changed_desktop_agnostic_config_notify_func (const char* group, const char* key, GValue* value, gpointer self);
void desktop_agnostic_config_bridge_remove (DesktopAgnosticConfigBridge* self, DesktopAgnosticConfigBackend* config, const char* group, const char* key, GObject* obj, const char* property_name, GError** error);
static void desktop_agnostic_config_bridge_cleanup_bindings (DesktopAgnosticConfigBindingListWrapper* obj);
void desktop_agnostic_config_backend_get_value (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GValue* result, GError** error);
static void desktop_agnostic_config_bridge_on_property_changed (GObject* obj, GParamSpec* spec, DesktopAgnosticConfigBinding* binding);
void desktop_agnostic_config_backend_notify_add (DesktopAgnosticConfigBackend* self, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error);
static void _desktop_agnostic_config_backend_notify_add_desktop_agnostic_config_bridge_notify_func_handler (DesktopAgnosticConfigBackend* config, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc func, void* func_target, GError** error);
void desktop_agnostic_config_bridge_bind (DesktopAgnosticConfigBridge* self, DesktopAgnosticConfigBackend* config, const char* group, const char* key, GObject* obj, const char* property_name, gboolean read_only, GError** error);
void desktop_agnostic_config_backend_notify_remove (DesktopAgnosticConfigBackend* self, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc callback, void* callback_target, GError** error);
static void _desktop_agnostic_config_backend_notify_remove_desktop_agnostic_config_bridge_notify_func_handler (DesktopAgnosticConfigBackend* config, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc func, void* func_target, GError** error);
void desktop_agnostic_config_bridge_remove_all_for_object (DesktopAgnosticConfigBridge* self, DesktopAgnosticConfigBackend* config, GObject* obj, GError** error);
void desktop_agnostic_config_backend_set_value (DesktopAgnosticConfigBackend* self, const char* group, const char* key, GValue* value, GError** error);
static void desktop_agnostic_config_bridge_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



DesktopAgnosticConfigBindingNotifier* desktop_agnostic_config_binding_notifier_construct (GType object_type, DesktopAgnosticConfigBackend* cfg) {
	DesktopAgnosticConfigBindingNotifier * self;
	g_return_val_if_fail (cfg != NULL, NULL);
	self = (DesktopAgnosticConfigBindingNotifier*) g_object_new (object_type, NULL);
	self->config = cfg;
	return self;
}


DesktopAgnosticConfigBindingNotifier* desktop_agnostic_config_binding_notifier_new (DesktopAgnosticConfigBackend* cfg) {
	return desktop_agnostic_config_binding_notifier_construct (DESKTOP_AGNOSTIC_CONFIG_TYPE_BINDING_NOTIFIER, cfg);
}


void desktop_agnostic_config_binding_notifier_on_simple_value_changed (DesktopAgnosticConfigBindingNotifier* self, const char* group, const char* key, GValue* value) {
	DesktopAgnosticConfigBindingListWrapper* bindings_list;
	char* full_key;
	DesktopAgnosticConfigBridge* bridge;
	char* _tmp0_;
	GData* _tmp2_;
	GData* _tmp1_ = {0};
	GObject* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	bindings_list = NULL;
	full_key = NULL;
	bridge = desktop_agnostic_config_bridge_get_default ();
	full_key = (_tmp0_ = g_strdup_printf ("%s/%s/%s", desktop_agnostic_config_backend_get_instance_id (self->config), group, key), _g_free0 (full_key), _tmp0_);
	bindings_list = (_tmp3_ = (GObject*) g_datalist_get_data ((_tmp2_ = (desktop_agnostic_config_bridge_get_all_bindings (bridge, &_tmp1_), _tmp1_), &_tmp2_), full_key), DESKTOP_AGNOSTIC_CONFIG_IS_BINDING_LIST_WRAPPER (_tmp3_) ? ((DesktopAgnosticConfigBindingListWrapper*) _tmp3_) : NULL);
	g_return_if_fail (bindings_list != NULL);
	{
		GList* binding_collection;
		GList* binding_it;
		binding_collection = bindings_list->binding_list;
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
			DesktopAgnosticConfigBinding* binding;
			binding = (DesktopAgnosticConfigBinding*) binding_it->data;
			{
				if (!binding->read_only) {
					g_signal_handler_block (binding->obj, binding->notify_id);
				}
				g_object_set_property (binding->obj, binding->property_name, value);
				if (!binding->read_only) {
					g_signal_handler_unblock (binding->obj, binding->notify_id);
				}
			}
		}
	}
	_g_free0 (full_key);
}


void desktop_agnostic_config_binding_notifier_on_list_changed (DesktopAgnosticConfigBindingNotifier* self, const char* group, const char* key, GValue* value) {
	DesktopAgnosticConfigBindingListWrapper* bindings_list;
	char* full_key;
	DesktopAgnosticConfigBridge* bridge;
	char* _tmp0_;
	GData* _tmp2_;
	GData* _tmp1_ = {0};
	GObject* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	bindings_list = NULL;
	full_key = NULL;
	bridge = desktop_agnostic_config_bridge_get_default ();
	full_key = (_tmp0_ = g_strdup_printf ("%s/%s/%s", desktop_agnostic_config_backend_get_instance_id (self->config), group, key), _g_free0 (full_key), _tmp0_);
	bindings_list = (_tmp3_ = (GObject*) g_datalist_get_data ((_tmp2_ = (desktop_agnostic_config_bridge_get_all_bindings (bridge, &_tmp1_), _tmp1_), &_tmp2_), full_key), DESKTOP_AGNOSTIC_CONFIG_IS_BINDING_LIST_WRAPPER (_tmp3_) ? ((DesktopAgnosticConfigBindingListWrapper*) _tmp3_) : NULL);
	g_return_if_fail (bindings_list != NULL);
	{
		GList* binding_collection;
		GList* binding_it;
		binding_collection = bindings_list->binding_list;
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
			DesktopAgnosticConfigBinding* binding;
			binding = (DesktopAgnosticConfigBinding*) binding_it->data;
			{
				if (!binding->read_only) {
					g_signal_handler_block (binding->obj, binding->notify_id);
				}
				g_object_set (binding->obj, binding->property_name, g_value_get_boxed (value), NULL);
				if (!binding->read_only) {
					g_signal_handler_unblock (binding->obj, binding->notify_id);
				}
			}
		}
	}
	_g_free0 (full_key);
}


static gpointer _g_param_spec_ref0 (gpointer self) {
	return self ? g_param_spec_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void desktop_agnostic_config_binding_notifier_on_serialized_object_changed (DesktopAgnosticConfigBindingNotifier* self, const char* group, const char* key, GValue* value) {
	DesktopAgnosticConfigBindingListWrapper* bindings_list;
	char* full_key;
	DesktopAgnosticConfigBridge* bridge;
	char* _tmp0_;
	GData* _tmp2_;
	GData* _tmp1_ = {0};
	GObject* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	bindings_list = NULL;
	full_key = NULL;
	bridge = desktop_agnostic_config_bridge_get_default ();
	full_key = (_tmp0_ = g_strdup_printf ("%s/%s/%s", desktop_agnostic_config_backend_get_instance_id (self->config), group, key), _g_free0 (full_key), _tmp0_);
	bindings_list = (_tmp3_ = (GObject*) g_datalist_get_data ((_tmp2_ = (desktop_agnostic_config_bridge_get_all_bindings (bridge, &_tmp1_), _tmp1_), &_tmp2_), full_key), DESKTOP_AGNOSTIC_CONFIG_IS_BINDING_LIST_WRAPPER (_tmp3_) ? ((DesktopAgnosticConfigBindingListWrapper*) _tmp3_) : NULL);
	g_return_if_fail (bindings_list != NULL);
	{
		GList* binding_collection;
		GList* binding_it;
		binding_collection = bindings_list->binding_list;
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
			DesktopAgnosticConfigBinding* binding;
			binding = (DesktopAgnosticConfigBinding*) binding_it->data;
			{
				GParamSpec* spec;
				DesktopAgnosticConfigSchemaType* st;
				GParamSpec* _tmp4_;
				DesktopAgnosticConfigSchemaType* _tmp5_;
				spec = NULL;
				st = NULL;
				spec = (_tmp4_ = _g_param_spec_ref0 (desktop_agnostic_config_bridge_get_property_spec (binding->obj, binding->property_name)), _g_param_spec_unref0 (spec), _tmp4_);
				st = (_tmp5_ = _g_object_ref0 (desktop_agnostic_config_schema_find_type (spec->value_type)), _g_object_unref0 (st), _tmp5_);
				if (st != NULL) {
					if (!binding->read_only) {
						g_signal_handler_block (binding->obj, binding->notify_id);
					}
					g_object_set_property (binding->obj, binding->property_name, value);
					if (!binding->read_only) {
						g_signal_handler_unblock (binding->obj, binding->notify_id);
					}
				}
				_g_param_spec_unref0 (spec);
				_g_object_unref0 (st);
			}
		}
	}
	_g_free0 (full_key);
}


static void desktop_agnostic_config_binding_notifier_class_init (DesktopAgnosticConfigBindingNotifierClass * klass) {
	desktop_agnostic_config_binding_notifier_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_config_binding_notifier_finalize;
}


static void desktop_agnostic_config_binding_notifier_instance_init (DesktopAgnosticConfigBindingNotifier * self) {
}


static void desktop_agnostic_config_binding_notifier_finalize (GObject* obj) {
	DesktopAgnosticConfigBindingNotifier * self;
	self = DESKTOP_AGNOSTIC_CONFIG_BINDING_NOTIFIER (obj);
	G_OBJECT_CLASS (desktop_agnostic_config_binding_notifier_parent_class)->finalize (obj);
}


GType desktop_agnostic_config_binding_notifier_get_type (void) {
	static GType desktop_agnostic_config_binding_notifier_type_id = 0;
	if (desktop_agnostic_config_binding_notifier_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticConfigBindingNotifierClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_config_binding_notifier_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticConfigBindingNotifier), 0, (GInstanceInitFunc) desktop_agnostic_config_binding_notifier_instance_init, NULL };
		desktop_agnostic_config_binding_notifier_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticConfigBindingNotifier", &g_define_type_info, 0);
	}
	return desktop_agnostic_config_binding_notifier_type_id;
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


DesktopAgnosticConfigBindingListWrapper* desktop_agnostic_config_binding_list_wrapper_construct (GType object_type) {
	DesktopAgnosticConfigBindingListWrapper * self;
	self = (DesktopAgnosticConfigBindingListWrapper*) g_object_new (object_type, NULL);
	return self;
}


DesktopAgnosticConfigBindingListWrapper* desktop_agnostic_config_binding_list_wrapper_new (void) {
	return desktop_agnostic_config_binding_list_wrapper_construct (DESKTOP_AGNOSTIC_CONFIG_TYPE_BINDING_LIST_WRAPPER);
}


static void desktop_agnostic_config_binding_list_wrapper_class_init (DesktopAgnosticConfigBindingListWrapperClass * klass) {
	desktop_agnostic_config_binding_list_wrapper_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_config_binding_list_wrapper_finalize;
}


static void desktop_agnostic_config_binding_list_wrapper_instance_init (DesktopAgnosticConfigBindingListWrapper * self) {
	self->binding_list = NULL;
}


static void desktop_agnostic_config_binding_list_wrapper_finalize (GObject* obj) {
	DesktopAgnosticConfigBindingListWrapper * self;
	self = DESKTOP_AGNOSTIC_CONFIG_BINDING_LIST_WRAPPER (obj);
	__g_list_free_g_object_unref0 (self->binding_list);
	G_OBJECT_CLASS (desktop_agnostic_config_binding_list_wrapper_parent_class)->finalize (obj);
}


GType desktop_agnostic_config_binding_list_wrapper_get_type (void) {
	static GType desktop_agnostic_config_binding_list_wrapper_type_id = 0;
	if (desktop_agnostic_config_binding_list_wrapper_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticConfigBindingListWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_config_binding_list_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticConfigBindingListWrapper), 0, (GInstanceInitFunc) desktop_agnostic_config_binding_list_wrapper_instance_init, NULL };
		desktop_agnostic_config_binding_list_wrapper_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticConfigBindingListWrapper", &g_define_type_info, 0);
	}
	return desktop_agnostic_config_binding_list_wrapper_type_id;
}


DesktopAgnosticConfigBinding* desktop_agnostic_config_binding_construct (GType object_type) {
	DesktopAgnosticConfigBinding * self;
	self = (DesktopAgnosticConfigBinding*) g_object_new (object_type, NULL);
	return self;
}


DesktopAgnosticConfigBinding* desktop_agnostic_config_binding_new (void) {
	return desktop_agnostic_config_binding_construct (DESKTOP_AGNOSTIC_CONFIG_TYPE_BINDING);
}


static void desktop_agnostic_config_binding_class_init (DesktopAgnosticConfigBindingClass * klass) {
	desktop_agnostic_config_binding_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_config_binding_finalize;
}


static void desktop_agnostic_config_binding_instance_init (DesktopAgnosticConfigBinding * self) {
}


static void desktop_agnostic_config_binding_finalize (GObject* obj) {
	DesktopAgnosticConfigBinding * self;
	self = DESKTOP_AGNOSTIC_CONFIG_BINDING (obj);
	{
		gboolean _tmp0_ = FALSE;
		if (!self->read_only) {
			_tmp0_ = g_signal_handler_is_connected (self->obj, self->notify_id);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			g_signal_handler_disconnect (self->obj, self->notify_id);
		}
		self->obj = NULL;
	}
	_g_free0 (self->group);
	_g_free0 (self->key);
	_g_free0 (self->property_name);
	G_OBJECT_CLASS (desktop_agnostic_config_binding_parent_class)->finalize (obj);
}


GType desktop_agnostic_config_binding_get_type (void) {
	static GType desktop_agnostic_config_binding_type_id = 0;
	if (desktop_agnostic_config_binding_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticConfigBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_config_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticConfigBinding), 0, (GInstanceInitFunc) desktop_agnostic_config_binding_instance_init, NULL };
		desktop_agnostic_config_binding_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticConfigBinding", &g_define_type_info, 0);
	}
	return desktop_agnostic_config_binding_type_id;
}


static DesktopAgnosticConfigBridge* desktop_agnostic_config_bridge_construct (GType object_type) {
	DesktopAgnosticConfigBridge * self;
	GData* _tmp0_ = {0};
	self = (DesktopAgnosticConfigBridge*) g_object_new (object_type, NULL);
	self->priv->bindings = (g_datalist_init (&_tmp0_), _tmp0_);
	return self;
}


static DesktopAgnosticConfigBridge* desktop_agnostic_config_bridge_new (void) {
	return desktop_agnostic_config_bridge_construct (DESKTOP_AGNOSTIC_CONFIG_TYPE_BRIDGE);
}


void desktop_agnostic_config_bridge_get_all_bindings (DesktopAgnosticConfigBridge* self, GData** result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->bindings;
	return;
}


DesktopAgnosticConfigBridge* desktop_agnostic_config_bridge_get_default (void) {
	DesktopAgnosticConfigBridge* result;
	if (desktop_agnostic_config_bridge_bridge == NULL) {
		DesktopAgnosticConfigBridge* _tmp0_;
		desktop_agnostic_config_bridge_bridge = (_tmp0_ = desktop_agnostic_config_bridge_new (), _g_object_unref0 (desktop_agnostic_config_bridge_bridge), _tmp0_);
	}
	result = desktop_agnostic_config_bridge_bridge;
	return result;
}


GParamSpec* desktop_agnostic_config_bridge_get_property_spec (GObject* obj, const char* property_name) {
	GParamSpec* result;
	GObjectClass* obj_cls;
	g_return_val_if_fail (obj != NULL, NULL);
	g_return_val_if_fail (property_name != NULL, NULL);
	obj_cls = (GObjectClass*) g_type_class_peek (G_TYPE_FROM_INSTANCE (obj));
	result = g_object_class_find_property (obj_cls, property_name);
	return result;
}


static void desktop_agnostic_config_bridge_handle_notify_func (DesktopAgnosticConfigBridge* self, DesktopAgnosticConfigBackend* config, const char* group, const char* key, GObject* obj, const char* property_name, DesktopAgnosticConfigBridgeNotifyFuncHandler func, GError** error) {
	GError * _inner_error_;
	GParamSpec* spec;
	g_return_if_fail (self != NULL);
	g_return_if_fail (config != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (property_name != NULL);
	_inner_error_ = NULL;
	spec = NULL;
	spec = desktop_agnostic_config_bridge_get_property_spec (obj, property_name);
	if (spec != NULL) {
		desktop_agnostic_config_bridge_handle_notify_func_with_param_spec (self, config, group, key, spec, func, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


static void _g_object_unref_gdestroy_notify (void* data) {
	g_object_unref (data);
}


static void _desktop_agnostic_config_binding_notifier_on_simple_value_changed_desktop_agnostic_config_notify_func (const char* group, const char* key, GValue* value, gpointer self) {
	desktop_agnostic_config_binding_notifier_on_simple_value_changed (self, group, key, value);
}


static void _desktop_agnostic_config_binding_notifier_on_list_changed_desktop_agnostic_config_notify_func (const char* group, const char* key, GValue* value, gpointer self) {
	desktop_agnostic_config_binding_notifier_on_list_changed (self, group, key, value);
}


static void _desktop_agnostic_config_binding_notifier_on_serialized_object_changed_desktop_agnostic_config_notify_func (const char* group, const char* key, GValue* value, gpointer self) {
	desktop_agnostic_config_binding_notifier_on_serialized_object_changed (self, group, key, value);
}


static void desktop_agnostic_config_bridge_handle_notify_func_with_param_spec (DesktopAgnosticConfigBridge* self, DesktopAgnosticConfigBackend* config, const char* group, const char* key, GParamSpec* spec, DesktopAgnosticConfigBridgeNotifyFuncHandler func, GError** error) {
	GError * _inner_error_;
	DesktopAgnosticConfigBindingNotifier* notifier;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (config != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (spec != NULL);
	_inner_error_ = NULL;
	notifier = NULL;
	notifier = (DesktopAgnosticConfigBindingNotifier*) g_object_get_data ((GObject*) config, "lda-binding-notifier");
	if (notifier == NULL) {
		DesktopAgnosticConfigBindingNotifier* new_notifier;
		new_notifier = desktop_agnostic_config_binding_notifier_new (config);
		notifier = new_notifier;
		g_object_set_data_full ((GObject*) config, "lda-binding-notifier", g_object_ref ((GObject*) notifier), _g_object_unref_gdestroy_notify);
		_g_object_unref0 (new_notifier);
	}
	if (spec->value_type == G_TYPE_BOOLEAN) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = spec->value_type == G_TYPE_FLOAT;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = spec->value_type == G_TYPE_DOUBLE;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = spec->value_type == G_TYPE_INT;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = spec->value_type == G_TYPE_LONG;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = G_IS_PARAM_SPEC_ENUM (spec);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = spec->value_type == G_TYPE_STRING;
	}
	if (_tmp0_) {
		func (config, group, key, _desktop_agnostic_config_binding_notifier_on_simple_value_changed_desktop_agnostic_config_notify_func, notifier, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	} else {
		if (spec->value_type == G_TYPE_VALUE_ARRAY) {
			func (config, group, key, _desktop_agnostic_config_binding_notifier_on_list_changed_desktop_agnostic_config_notify_func, notifier, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				return;
			}
		} else {
			DesktopAgnosticConfigSchemaType* st;
			st = _g_object_ref0 (desktop_agnostic_config_schema_find_type (spec->value_type));
			if (st == NULL) {
				_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_ERROR, DESKTOP_AGNOSTIC_CONFIG_ERROR_INVALID_TYPE, "Invalid property type to bind: %s.", g_type_name (spec->value_type));
				{
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (st);
					return;
				}
			} else {
				func (config, group, key, _desktop_agnostic_config_binding_notifier_on_serialized_object_changed_desktop_agnostic_config_notify_func, notifier, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (st);
					return;
				}
			}
			_g_object_unref0 (st);
		}
	}
}


static void desktop_agnostic_config_bridge_cleanup_bindings (DesktopAgnosticConfigBindingListWrapper* obj) {
	GError * _inner_error_;
	DesktopAgnosticConfigBridge* bridge;
	g_return_if_fail (obj != NULL);
	_inner_error_ = NULL;
	bridge = desktop_agnostic_config_bridge_get_default ();
	{
		GList* b_collection;
		GList* b_it;
		b_collection = obj->binding_list;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			DesktopAgnosticConfigBinding* b;
			b = _g_object_ref0 ((DesktopAgnosticConfigBinding*) b_it->data);
			{
				desktop_agnostic_config_bridge_remove (bridge, b->cfg, b->group, b->key, b->obj, b->property_name, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (b);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_object_unref0 (b);
			}
		}
	}
	g_object_unref ((GObject*) obj);
}


static void _desktop_agnostic_config_backend_notify_add_desktop_agnostic_config_bridge_notify_func_handler (DesktopAgnosticConfigBackend* config, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc func, void* func_target, GError** error) {
	desktop_agnostic_config_backend_notify_add (config, group, key, func, func_target, error);
}


void desktop_agnostic_config_bridge_bind (DesktopAgnosticConfigBridge* self, DesktopAgnosticConfigBackend* config, const char* group, const char* key, GObject* obj, const char* property_name, gboolean read_only, GError** error) {
	GError * _inner_error_;
	DesktopAgnosticConfigBinding* binding;
	GParamSpec* spec;
	DesktopAgnosticConfigBinding* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (config != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (property_name != NULL);
	_inner_error_ = NULL;
	binding = NULL;
	spec = NULL;
	binding = (_tmp0_ = desktop_agnostic_config_binding_new (), _g_object_unref0 (binding), _tmp0_);
	binding->cfg = config;
	binding->group = (_tmp1_ = g_strdup (group), _g_free0 (binding->group), _tmp1_);
	binding->key = (_tmp2_ = g_strdup (key), _g_free0 (binding->key), _tmp2_);
	binding->obj = obj;
	spec = desktop_agnostic_config_bridge_get_property_spec (obj, property_name);
	if (spec != NULL) {
		char* binding_key;
		DesktopAgnosticConfigBindingListWrapper* bindings_list;
		char* _tmp3_;
		char* _tmp4_;
		void* obj_bindings;
		GValue _tmp5_ = {0};
		GValue _tmp6_;
		GValue _tmp8_;
		GValue _tmp7_;
		binding_key = NULL;
		bindings_list = NULL;
		binding->property_name = (_tmp3_ = g_strdup (spec->name), _g_free0 (binding->property_name), _tmp3_);
		binding_key = (_tmp4_ = g_strdup_printf ("%s/%s/%s", desktop_agnostic_config_backend_get_instance_id (config), group, key), _g_free0 (binding_key), _tmp4_);
		obj_bindings = g_object_get_data (obj, "lda-bindings");
		if (obj_bindings == NULL) {
			DesktopAgnosticConfigBindingListWrapper* new_bindings_list;
			new_bindings_list = desktop_agnostic_config_binding_list_wrapper_new ();
			new_bindings_list->binding_list = g_list_append (new_bindings_list->binding_list, _g_object_ref0 (binding));
			g_object_set_data_full (obj, "lda-bindings", g_object_ref ((GObject*) new_bindings_list), (GDestroyNotify) desktop_agnostic_config_bridge_cleanup_bindings);
			_g_object_unref0 (new_bindings_list);
		} else {
			DesktopAgnosticConfigBindingListWrapper* object_bindings;
			object_bindings = DESKTOP_AGNOSTIC_CONFIG_BINDING_LIST_WRAPPER (obj_bindings);
			object_bindings->binding_list = g_list_append (object_bindings->binding_list, _g_object_ref0 (binding));
		}
		_tmp6_ = (desktop_agnostic_config_backend_get_value (config, group, key, &_tmp5_, &_inner_error_), _tmp5_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (binding_key);
			_g_object_unref0 (binding);
			return;
		}
		g_object_set_property (obj, spec->name, (_tmp8_ = _tmp7_ = _tmp6_, &_tmp8_));
		G_IS_VALUE (&_tmp7_) ? (g_value_unset (&_tmp7_), NULL) : NULL;
		if (!read_only) {
			char* _tmp9_;
			binding->notify_id = g_signal_connect (obj, _tmp9_ = g_strdup_printf ("notify::%s", spec->name), (GCallback) desktop_agnostic_config_bridge_on_property_changed, binding);
			_g_free0 (_tmp9_);
		}
		binding->read_only = read_only;
		bindings_list = (DesktopAgnosticConfigBindingListWrapper*) g_datalist_get_data (&self->priv->bindings, binding_key);
		if (bindings_list == NULL) {
			DesktopAgnosticConfigBindingListWrapper* new_bindings_list;
			DesktopAgnosticConfigBindingListWrapper* _tmp10_;
			new_bindings_list = desktop_agnostic_config_binding_list_wrapper_new ();
			new_bindings_list->binding_list = g_list_append (new_bindings_list->binding_list, _g_object_ref0 (binding));
			g_datalist_set_data_full (&self->priv->bindings, binding_key, (_tmp10_ = new_bindings_list, new_bindings_list = NULL, _tmp10_), (GDestroyNotify) g_object_unref);
			desktop_agnostic_config_bridge_handle_notify_func_with_param_spec (self, config, group, key, spec, _desktop_agnostic_config_backend_notify_add_desktop_agnostic_config_bridge_notify_func_handler, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (new_bindings_list);
				_g_free0 (binding_key);
				_g_object_unref0 (binding);
				return;
			}
			_g_object_unref0 (new_bindings_list);
		} else {
			bindings_list->binding_list = g_list_append (bindings_list->binding_list, _g_object_ref0 (binding));
		}
		_g_free0 (binding_key);
	} else {
		gint properties_size;
		gint properties_length1;
		GParamSpec** properties;
		char* props_str;
		GParamSpec** _tmp12_;
		guint _tmp11_;
		char* _tmp13_;
		properties = (properties_length1 = 0, NULL);
		props_str = NULL;
		properties = (_tmp12_ = g_object_class_list_properties ((GObjectClass*) g_type_class_peek (G_TYPE_FROM_INSTANCE (obj)), &_tmp11_), properties_length1 = _tmp11_, properties_size = properties_length1, _tmp12_);
		props_str = (_tmp13_ = g_strdup (""), _g_free0 (props_str), _tmp13_);
		{
			GParamSpec** property_collection;
			int property_collection_length1;
			int property_it;
			property_collection = properties;
			property_collection_length1 = properties_length1;
			for (property_it = 0; property_it < properties_length1; property_it = property_it + 1) {
				GParamSpec* property;
				property = property_collection[property_it];
				{
					char* _tmp15_;
					if (_vala_strcmp0 (props_str, "") != 0) {
						char* _tmp14_;
						props_str = (_tmp14_ = g_strconcat (props_str, ", ", NULL), _g_free0 (props_str), _tmp14_);
					}
					props_str = (_tmp15_ = g_strconcat (props_str, property->name, NULL), _g_free0 (props_str), _tmp15_);
				}
			}
		}
		g_warning ("config-bridge.vala:338: Invalid property name for the object (%s). Valid properties (%d): %s", property_name, properties_length1, props_str);
		_g_free0 (props_str);
	}
	_g_object_unref0 (binding);
}


static void _desktop_agnostic_config_backend_notify_remove_desktop_agnostic_config_bridge_notify_func_handler (DesktopAgnosticConfigBackend* config, const char* group, const char* key, DesktopAgnosticConfigNotifyFunc func, void* func_target, GError** error) {
	desktop_agnostic_config_backend_notify_remove (config, group, key, func, func_target, error);
}


void desktop_agnostic_config_bridge_remove (DesktopAgnosticConfigBridge* self, DesktopAgnosticConfigBackend* config, const char* group, const char* key, GObject* obj, const char* property_name, GError** error) {
	GError * _inner_error_;
	DesktopAgnosticConfigBindingListWrapper* bindings_list;
	GSList* bindings_to_remove;
	guint pos;
	char* binding_key;
	DesktopAgnosticConfigBindingListWrapper* obj_bindings;
	char* _tmp0_;
	GSList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (config != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (property_name != NULL);
	_inner_error_ = NULL;
	bindings_list = NULL;
	bindings_to_remove = NULL;
	pos = (guint) (-1);
	binding_key = NULL;
	obj_bindings = (DesktopAgnosticConfigBindingListWrapper*) g_object_get_data (obj, "lda-bindings");
	binding_key = (_tmp0_ = g_strdup_printf ("%s/%s/%s", desktop_agnostic_config_backend_get_instance_id (config), group, key), _g_free0 (binding_key), _tmp0_);
	bindings_list = (DesktopAgnosticConfigBindingListWrapper*) g_datalist_get_data (&self->priv->bindings, binding_key);
	bindings_to_remove = (_tmp1_ = NULL, _g_slist_free0 (bindings_to_remove), _tmp1_);
	if (bindings_list == NULL) {
		_g_slist_free0 (bindings_to_remove);
		_g_free0 (binding_key);
		return;
	}
	{
		GList* binding_collection;
		GList* binding_it;
		binding_collection = bindings_list->binding_list;
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
			DesktopAgnosticConfigBinding* binding;
			binding = (DesktopAgnosticConfigBinding*) binding_it->data;
			{
				pos++;
				if (binding->obj == obj) {
					bindings_to_remove = g_slist_prepend (bindings_to_remove, GUINT_TO_POINTER (pos));
					if (obj_bindings != NULL) {
						GList* node;
						node = NULL;
						node = g_list_find (obj_bindings->binding_list, binding);
						if (node != NULL) {
							DesktopAgnosticConfigBinding* _tmp2_;
							node->data = (_tmp2_ = NULL, _g_object_unref0 (node->data), _tmp2_);
							obj_bindings->binding_list = g_list_delete_link (obj_bindings->binding_list, node);
						}
					}
				}
			}
		}
	}
	{
		GSList* binding_pos_collection;
		GSList* binding_pos_it;
		binding_pos_collection = bindings_to_remove;
		for (binding_pos_it = binding_pos_collection; binding_pos_it != NULL; binding_pos_it = binding_pos_it->next) {
			guint binding_pos;
			binding_pos = GPOINTER_TO_UINT (binding_pos_it->data);
			{
				GList* node;
				DesktopAgnosticConfigBinding* _tmp3_;
				node = NULL;
				node = g_list_nth (bindings_list->binding_list, binding_pos);
				node->data = (_tmp3_ = NULL, _g_object_unref0 (node->data), _tmp3_);
				bindings_list->binding_list = g_list_delete_link (bindings_list->binding_list, node);
			}
		}
	}
	if (g_list_length (bindings_list->binding_list) == 0) {
		desktop_agnostic_config_bridge_handle_notify_func (self, config, group, key, obj, property_name, _desktop_agnostic_config_backend_notify_remove_desktop_agnostic_config_bridge_notify_func_handler, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_slist_free0 (bindings_to_remove);
			_g_free0 (binding_key);
			return;
		}
		g_datalist_remove_data (&self->priv->bindings, binding_key);
	}
	_g_slist_free0 (bindings_to_remove);
	_g_free0 (binding_key);
}


void desktop_agnostic_config_bridge_remove_all_for_object (DesktopAgnosticConfigBridge* self, DesktopAgnosticConfigBackend* config, GObject* obj, GError** error) {
	GError * _inner_error_;
	void* data;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_inner_error_ = NULL;
	data = g_object_steal_data (obj, "lda-bindings");
	if (data != NULL) {
		DesktopAgnosticConfigBindingListWrapper* obj_bindings;
		obj_bindings = DESKTOP_AGNOSTIC_CONFIG_BINDING_LIST_WRAPPER (data);
		{
			GList* b_collection;
			GList* b_it;
			b_collection = obj_bindings->binding_list;
			for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
				DesktopAgnosticConfigBinding* b;
				b = _g_object_ref0 ((DesktopAgnosticConfigBinding*) b_it->data);
				{
					desktop_agnostic_config_bridge_remove (self, b->cfg, b->group, b->key, obj, b->property_name, &_inner_error_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (b);
						return;
					}
					_g_object_unref0 (b);
				}
			}
		}
		g_object_unref ((GObject*) obj_bindings);
	}
}


static void desktop_agnostic_config_bridge_on_property_changed (GObject* obj, GParamSpec* spec, DesktopAgnosticConfigBinding* binding) {
	GError * _inner_error_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (spec != NULL);
	g_return_if_fail (binding != NULL);
	_inner_error_ = NULL;
	{
		GValue _tmp0_ = {0};
		GValue val;
		val = (g_value_init (&_tmp0_, spec->value_type), _tmp0_);
		g_object_get_property (obj, spec->name, &val);
		desktop_agnostic_config_backend_set_value (binding->cfg, binding->group, binding->key, &val, &_inner_error_);
		if (_inner_error_ != NULL) {
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			goto __catch0_g_error;
		}
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("config-bridge.vala:437: Configuration error: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void desktop_agnostic_config_bridge_class_init (DesktopAgnosticConfigBridgeClass * klass) {
	desktop_agnostic_config_bridge_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticConfigBridgePrivate));
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_config_bridge_finalize;
}


static void desktop_agnostic_config_bridge_instance_init (DesktopAgnosticConfigBridge * self) {
	self->priv = DESKTOP_AGNOSTIC_CONFIG_BRIDGE_GET_PRIVATE (self);
}


static void desktop_agnostic_config_bridge_finalize (GObject* obj) {
	DesktopAgnosticConfigBridge * self;
	self = DESKTOP_AGNOSTIC_CONFIG_BRIDGE (obj);
	G_OBJECT_CLASS (desktop_agnostic_config_bridge_parent_class)->finalize (obj);
}


GType desktop_agnostic_config_bridge_get_type (void) {
	static GType desktop_agnostic_config_bridge_type_id = 0;
	if (desktop_agnostic_config_bridge_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticConfigBridgeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_config_bridge_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticConfigBridge), 0, (GInstanceInitFunc) desktop_agnostic_config_bridge_instance_init, NULL };
		desktop_agnostic_config_bridge_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticConfigBridge", &g_define_type_info, 0);
	}
	return desktop_agnostic_config_bridge_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




