/* (C) Marcin Kwadrans <quar@vitea.pl> */

/*! \file program.h 
	\brief Obsługa programu
*/

#ifndef __LW_PROGRAM_H
#define __LW_PROGRAM_H

#include "message.h"

/*! \class LWProgram
	\brief Klasa reprezentująca program

	Klasa zarządzająca programem
*/

class LWBoard;
class LWInterpreter;
class LWProgramData;

class LWProgram {
LWBoard *world;
LWInterpreter *interp;
LWProgramData *program_data;

virtual void showParseMessage (LWMessage *msg);
virtual void showRunTimeMessage (LWMessage *msg);	
	
public:
LWProgram (); 
virtual ~LWProgram ();
void showMessage (LWMessage *msg);
gboolean parse (LWBoard *program, gboolean enable_debug=FALSE);
void setWorld (LWBoard *a_world);
LWBoard *getWorld ();
void execute ();
virtual void finish ();
gboolean isFinished();
void stop();
};
#endif
