package tests::UIXMLSpecListWidgetTest;

use strict;

use base qw/ Lire::Test::TestCase tests::TestStoreFixture /;

use Lire::Config::TypeSpec;
use Lire::Test::CursesUIDriver;
use Lire::UI::XMLSpecListWidget;
use Curses::UI;
use Lire::Config::Index;
use Lire::UI;
use Lire::Test::Mock;

sub new {
    my $self = shift->SUPER::new( @_ );

    $self->init();

    return $self;
}

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->set_up_test_schema();
    $self->{'cfg'}{'lr_reports_path'} = [ "$self->{'testdir'}/reports" ];
    $self->{'cfg'}{'lr_filters_path'} = [ "$self->{'testdir'}/filters" ];

    $self->{'driver'} = new Lire::Test::CursesUIDriver();
    $self->{'driver'}->setup_curses_ui();

    $self->{'ui'} = new Curses::UI();
    $self->{'driver'}->set_curses_ui( $self->{'ui'} );
    $self->{'window'} = $self->{'ui'}->add( 'window', 'Window' );

    $self->{'reports'} =
      new Lire::Config::XMLSpecListSpec( 'name' => 'reports',
                                         'type' => 'reports' )->instance();

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    $self->{'driver'}->teardown_curses_ui();

    return;
}

sub test_new {
    my $self = $_[0];


    $self->assert_dies( qr/\'value\' parameter\'s spec should be a \'Lire::Config::XMLSpecListSpec\' instance, not \'Lire::Config::ListSpec/,
                        sub { $self->{'window'}->add( 'widget',
                                                      'Lire::UI::XMLSpecListWidget',
                                                      'Value' => new Lire::Config::ListSpec( 'name' => 'list' )->instance() ) } );
    my $widget = $self->{'window'}->add( 'widget', 'Lire::UI::Widget',
                                         'value' => $self->{'reports'},
                                         'superservice' => 'test'
                                       );
    $self->assert_isa( 'Lire::UI::XMLSpecListWidget', $widget );
    $self->assert_str_equals( 'test', $widget->{'superservice'} );
    $self->assert_str_equals( \&Lire::UI::XMLSpecListWidget::edit_element,
                              $widget->{'-routines'}{'edit-element'} );
}

sub test_superservice_filter {
    my $self = $_[0];

    my $widget = $self->{'window'}->add( 'widget',
                                         'Lire::UI::XMLSpecListWidget',
                                         'value' => $self->{'reports'} );
    $self->assert_isa( 'Lire::UI::XMLSpecListWidget', $widget );
    $self->assert_null( $widget->superservice_filter() );
    $self->assert_null( $widget->{'superservice'} );

    my $type_popup = $widget->getobj( 'type_widget' );
    $self->assert_deep_equals( [], $type_popup->{'-values'} );
    $self->assert_deep_equals( {}, $type_popup->{'-labels'} );

    $self->assert_str_equals( 'test', $widget->superservice_filter( 'test' ) );
    $self->assert_str_equals( 'test', $widget->{'superservice'} );
    $self->assert_deep_equals( [ qw/avg-file_size-by-timeslot downloads-by-period sessions-by-length sessions-by-user_class top-dirs top-dirs2 top-files user-downloads-utf8 user_downloads-report / ],
                               $type_popup->{'-values'} );
    $self->assert_deep_equals( {}, $type_popup->{'-labels'} );
}

sub test_new_value {
    my $self = $_[0];

    my $widget = $self->{'window'}->add( 'list_widget',
                                         'Lire::UI::XMLSpecListWidget',
                                         'value' => $self->{'reports'},
                                         'superservice' => 'test' );
    my $popup = $widget->getobj( 'type_widget' );
    $self->assert_null( $widget->new_value(), 'new_value() != undef' );

    $popup->{'-selected'} = 1;
    my $value = $widget->new_value();
    $self->assert_isa( 'Lire::Config::Object', $value );
    $self->assert_str_equals( 'test:downloads-by-period', $value->name() );
}

sub test_edit_element {
    my $self = $_[0];

    $self->{'reports'}->append( $self->{'reports'}->spec()->get( 'test:top-dirs' )->instance() );
    my $widget = $self->{'window'}->add( 'list_widget',
                                         'Lire::UI::XMLSpecListWidget',
                                         'value' => $self->{'reports'},
                                         'superservice' => 'test' );
    my $mock_ui = new Lire::Test::Mock( 'Lire::UI',
                                        'edit_value_dialog' => sub {
                                            $self->assert( Lire::Config::Index->has_index( 'variables' ) ? 1 : 0,
                                                           'missing "variables" index' ) } );
    $widget->root()->userdata( $mock_ui );
    my $list = $widget->getobj( 'list' );
    $list->{'-focusable'} = 0;
    $widget->do_routine( 'edit-element' ); 
    $self->assert_num_equals( 0, $mock_ui->invocation_count( 'edit_value_dialog' ) );

    $list->{'-focusable'} = 1;
    $list->{'-selected'} = 0;
    $widget->do_routine( 'edit-element' );
    $self->assert( !Lire::Config::Index->has_index( 'variables' ) ? 1 : 0,
                   '"variables" index should be removed' );
    $self->assert_num_equals( 1, $mock_ui->invocation_count( 'edit_value_dialog' ) );
}


1;
