/****************************************************************
 *
 * vdictov: Scale.H
 *
 * Copyright (C) Max Planck Institute 
 * for Human Cognitive and Brain Sciences, Leipzig
 *
 * Author Thomas Arnold, 2002, <lipsia@cbs.mpg.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * $Id: scale.H 687 2004-02-12 09:29:58Z karstenm $
 *
 *****************************************************************/


#ifndef SCALE_H_INCLUDED
#define SCALE_H_INCLUDED

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <float.h>
#include <math.h>
#include <time.h>
#include <assert.h>

extern "C"
{
   #include <Vlib.h>
   #include <VImage.h>
   #include <option.h>
   #include <mu.h>
}


/*------------------------------------------------------------------------------

LinearScale
===========

Src      source image with voxels of type T
Scale    scaling factor
Offset   offset value
Dest     scaled image with voxels of type T (created)

Note: This function performs the operation

      Value = Scale * Value + Offset

      on every voxel.

------------------------------------------------------------------------------*/

template <class T> void LinearScale (VImage Src, float Scale, float Offset, VImage& Dest)
{
   int Voxels;   /* number of voxels */

   T* src;    /* source data pointer      */
   T* dest;   /* destination data pointer */

   long n;   /* index */


   /* get source image size */
   Voxels = VImageNPixels (Src);

   /* create scaled image */
   Dest = VCreateImage (VImageNBands (Src), VImageNRows (Src), VImageNColumns (Src), VPixelRepn (Src));
   VImageAttrList (Dest) = VCopyAttrList (VImageAttrList (Src));


   /* scale image */
   src  = (T*) VPixelPtr (Src,  0, 0, 0);
   dest = (T*) VPixelPtr (Dest, 0, 0, 0);
   for (n = 0; n < Voxels; n++)
      *(dest++) = (T) (Scale * *(src++) + Offset);

} /* LinearScale */

template <class T> void LinearScale (VImage& Src, float Scale, float Offset)
{
   VImage Dest;   /* destination image */


   /* scale image */
   LinearScale<T> (Src, Scale, Offset, Dest);
   VDestroyImage (Src);
   Src = Dest;

} /* LinearScale*/

/*----------------------------------------------------------------------------*/

#endif
