#include <assert.h>
#include <sys/stat.h>
// #include <getopt.h>

#include <fstream>
// #include <iomanip>
#include <iostream>

// #include <libmpeg3.h>

using namespace std;


// #define PODXTPRO_RATE 39062.5
// #define PODXTPRO_BYTES_PER_FRAME 6

#define CHANNELS 2
#define BYTES_PER_SAMPLE 2

#define BYTES_PER_FRAME (CHANNELS * BYTES_PER_SAMPLE)


void
usage()
{
  cerr << "usage: resample <in-file> <in-rate> <out-file> <out-rate>\n";
  exit(1);
}

int
main(int argc, char *argv[])
{
  if(argc != 5)
    usage();

  const char *name_in = argv[1];
  const double rate_in = atof(argv[2]);
  const char *name_out = argv[3];
  const double rate_out = atof(argv[4]);
  const double speed = 1;
  int bufframes_out = 10000;

  ifstream file_in(name_in);
  ofstream file_out(name_out);

  if(!file_in || !file_out)
    {
      cerr << "Error opening file(s)\n";
      return 1;

    }

  // const int rate_in = mpeg3_sample_rate(file, stream);
  struct stat s;
  stat(name_in, &s);
  long frames_in = s.st_size / BYTES_PER_FRAME;
  // cout << rate << endl << samples << endl;

  const double rr = rate_out / speed / rate_in;  // rate ratio
  const int bufframes_in = (int)ceil(bufframes_out / rr) + 2;
  const int bufsize_out = bufframes_out * BYTES_PER_FRAME;
  const int bufsize_in = bufframes_in * BYTES_PER_FRAME;
  /*
  short *buf0_in = (short *)malloc(bufsize_in);  // right buffer
  short *buf1_in = buf0_in + bufframes_in;     // left buffer
  */
  short *buf_in = (short *)malloc(bufsize_in);
  short *buf_out = (short *)malloc(bufsize_out);
  memset(buf_out, 0, bufsize_out);

  int pos_out = 0;
  int pos1i_in_prev = -1;
  int read_in_prev = 0;

  while(frames_in > 0)
    {
      // fractional positions in MP3 stream:
      double pos0_in = pos_out / rr;
      double pos1_in = (pos_out + bufframes_out - 1) / rr;

      // compute integer positions in MP3 stream needed for this request:
      int pos0i_in = (int)floor(pos0_in);
      int pos1i_in = (int)ceil(pos1_in);

      // decode MP3 stream:
      int ofs;
      int read_in = pos1i_in - pos0i_in + 1;
      // cout << read_in << ' ' << bufframes_in << endl;
      assert(read_in <= bufframes_in);

      if(pos0i_in == pos1i_in_prev)
	{
	  // last frame can be reused, so read one frame less:
	  --read_in;
	  ofs = 1;

	  // and copy last frame:
	  /*
	  buf0_in[0] = buf0_in[read_in_prev - 1];
	  buf1_in[0] = buf1_in[read_in_prev - 1];
	  */

	  for(int j = CHANNELS; j--;)
	    buf_in[j] = buf_in[(read_in_prev - 1) * CHANNELS + j];

	  // cout << "here1\n";
	}
      else
	{
	  ofs = 0;
	  // cout << "here2\n";
	}

      if(read_in > frames_in)
	read_in = frames_in;

      // read and decode the MP3 stream:
      // int ret = 0;
      /*
      buf0_in[ofs + read_in - 1] = 12345;
      buf0_in[ofs + read_in - 0] = 12345;
      buf1_in[ofs + read_in - 1] = 12345;
      buf1_in[ofs + read_in - 0] = 12345;
      */
      /*
      ret |= mpeg3_read_audio(file, 0, buf0_in + ofs, 0, read_in, stream);
      ret |= mpeg3_reread_audio(file, 0, buf1_in + ofs, 1, read_in, stream);
      */
      file_in.read((char *)(buf_in + ofs * CHANNELS), read_in * CHANNELS);
      /*
      cout << buf0_in[ofs + read_in - 1] << ' ' << buf0_in[ofs + read_in - 0] << ' ' << buf1_in[ofs + read_in - 1] << ' ' << buf1_in[ofs + read_in - 0] << endl;
      */

      // usb.write((const char *)(buf1_in + ofs), read_in * 2);

      if(!file_in.good())
	{
	  cerr << "Error reading input file\n";
	  return 2;
	}

      read_in_prev = read_in;
      pos1i_in_prev = pos1i_in;

      // convert data to PodXT Pro format:
      // cout << "converting MP3 from " << pos0_in << " to " << pos1_in << " (" << read_in << " frames read)\n";
      // memset(buf_out, 0, bufsize_out);

      for(int i = 0; i < bufframes_out; i++)
	{
	  double pos_in = (pos_out + i) / rr;
	  int ofs_in = (int)floor(pos_in) - pos0i_in;
	  assert(ofs_in >= 0);
	  assert(ofs_in < bufsize_in - 1);
	  double t1 = pos_in - floor(pos_in);
	  double t0 = 1 - t1;
	  // cout << ofs_in << ' ' << t << endl;
	  // int v[2];
	  int ic = i * CHANNELS;
	  int oic = ofs_in * CHANNELS;

	  for(int j = CHANNELS; j--;)
	    buf_out[ic + j] = (short)((t0 * buf_in[oic + j] + t1 * buf_in[oic + j + CHANNELS]) + 0.5);

	  /*
	  for(int c = 2; c--;)
	    for(int b = 3; b--;)
	      {
		buf_out[(2 * i + c) * PODXTPRO_BYTES_PER_FRAME + b] = *((unsigned char *)(v + c) + b);
		// int oo = (2 * i + c) * PODXTPRO_BYTES_PER_FRAME + b;
		// assert((oo & 0xf) < 3);
	      }

	  // memset(buf_out + i * 6 + 3, 0, 3);
	  */
	  // memcpy(buf_out + i * PODXTPRO_BYTES_PER_FRAME, &v0, 3);
	  // memcpy(buf_out + i * PODXTPRO_BYTES_PER_FRAME + 3, &v1, 3);
	}

      // usb.write((const char *)buf_out, bufsize_out);
      file_out.write((const char *)buf_out, bufsize_out);
      pos_out += bufframes_out;
      frames_in -= read_in;
    }

  return 0;
}
