// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: Janusz SP9UMX <sp9umx@sr9zaa.ampr.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <qfile.h>
#include <qapplication.h>
#include <qmessagebox.h>
#include <qlistview.h>

#include "AxGetList.h"
#include "utils.h"
#include "shellex.h"
#include "event.h"
#include "AxUnit.h"
#include "llista.h"

extern TUtils Util;
extern TShellEx *ShellEx;
extern TList_window *List_window;
extern TAxUnit AxU;

extern QApplication *Application;
extern QString  PrgPath;
extern QString  LineFormat;
extern int   lastnum;
extern QString  bbs_wo_ssid;
extern QString  Cmds2GetLst;
extern QString  Cmds2LogOff;
extern int   header_lines;
extern int   StatusByte;
extern QString  BBSprompt;


int lastnumb;
QString line;
QFile ListFile;
QTextStream ListStream;
QListViewItem *lastIt = NULL;

TConBBS::TConBBS()
{
   stopped = FALSE;
}


void TConBBS::run()
{
   if (!stopped)  ConBBSEvent();
   stopped = FALSE;
}

void TConBBS::stop()
{
  stopped = TRUE;
}

int TConBBS::LastMessage( QString bbs_call )
{
  QString s;
  int msgnum;
  
  msgnum = 1;
  s = PrgPath+"ulistd/" + bbs_call;
  
  QFile fl(s);
  if (fl.exists() )
  {
    if ( fl.open( IO_ReadWrite ) ) 
    {
      QTextStream stream( &fl );
    
      while ( ! stream.atEnd() )
      {
        s = stream.readLine();
        if (! s.isEmpty() )
        {
           msgnum = Util.substring('l','N',s).toInt();
        }
      } //while
    }
  }
  else
  {
    if ( fl.open( IO_WriteOnly ) );
  }
  
  return msgnum;
    
}

void  TConBBS::AddLine( int MsgNum )
{
  QString s;
  
  if (MsgNum > lastnumb && (! line.isEmpty()))
  {
/*    s= PrgPath+"ulistd/"+bbs;
  
    QFile fl( s );
    if (fl.open( IO_WriteOnly | IO_Append ) )
    {
      QTextStream stream ( &fl );*/
      ListStream << line;
      ListStream << "\n";
/*      fl.close();
    }*/
  
    LiViLineEvent* lvln = new LiViLineEvent( line );
    QApplication::postEvent( List_window, lvln );  // Qt will delete it when done
  
  }
  
}


int TConBBS::ConvertEntry( QString data)
{
  QString tmp;
  idx_record idx_tmp;
//  uint i;
  bool isnum=TRUE;
  
  if ((data != (char)(13)) && (! data.isEmpty() ))
  {
     	tmp = "";
     	line = "";
     	idx_tmp.number  = Util.substring('l','N',data);
	idx_tmp.flag    = data[LineFormat.find('L',0,FALSE)]; 
 	idx_tmp.size    = Util.substring('l','S',data);
	idx_tmp.to_a    = Util.substring('l','T',data);
	idx_tmp.at      = Util.substring('l','A',data);
	idx_tmp.from    = Util.substring('l','F',data);
	idx_tmp.date    = Util.substring('l','D',data);
	idx_tmp.time    = Util.substring('l','M',data);
	idx_tmp.subject = Util.substring('l','X',data);
	tmp = Util.Idx2Str('l', idx_tmp );
/*     tmp = Util.substring('l','N',data)+"  ";
     tmp += data[LineFormat.find('L',0,FALSE)] + "  " + Util.substring('l','S',data) + " ";
     tmp += Util.substring('l','T',data) + "@" + Util.substring('l','A',data) + " ";
     tmp += Util.substring('l','F',data) + " " + Util.substring('l','D',data) + " ";
     tmp += Util.substring('l','M',data) + " " + Util.substring('l','X',data);*/
     line = tmp;
     tmp = Util.substring('l','N',data);
     isnum = TRUE;
//     for (i=0;i<=tmp.length();i++)
  //   { 
    //   if (((tmp[i].digitValue()<48) || ((tmp[i].digitValue())>57)) && tmp[i] != ' ') isnum = FALSE;
    // }
  }
  
  if (isnum) return tmp.toInt();
  else return 0;

}


void TConBBS::ConBBSEvent()
{
  int i;
  int empty;
  int msgnum;
  QString s;
  
  ShellEx->show();
  Application->processEvents();

  if (AxU.ConnectBBS())
  {
    lastnumb = LastMessage(bbs_wo_ssid);
    lastIt = List_window->ListView1->lastItem();
    AxU.SendCommands( Cmds2GetLst );

    if (StatusByte==6) AxU.DiscBBS();
       
    empty = 0;
    for (i=1;i<=4;i++)  
    {
      s = AxU.GetLine();
      
      ShExLineEvent* shln = new ShExLineEvent( s );
      QApplication::postEvent( ShellEx, shln );  
      
      if (s.find('>'+(char)(13),0,FALSE) >= 0 )   // prompt detected
      {
        empty = 1;
	break;
      }

      if (StatusByte==6) 
      {
        AxU.DiscBBS();
	break;
      }
    }  // for  
          

    // read message lines
    if (empty == 0)
    {
       QFile ListFile( PrgPath+"ulistd/"+bbs_wo_ssid );
       if (ListFile.open( IO_WriteOnly | IO_Append ) )
       {
          ListStream.setDevice( &ListFile );

          while (s.find(BBSprompt,0,FALSE) < 0)
          {
      
            if (StatusByte==6 || stopped) 
            {
              AxU.DiscBBS();
	      break;
            }
	
	    s = AxU.GetLine();
	
           ShExLineEvent* shln = new ShExLineEvent( s );
           QApplication::postEvent( ShellEx, shln );  // Qt will delete it when done
	
	   msgnum = ConvertEntry(s);
	
	   if (msgnum > 0) AddLine( msgnum );
         }
	 ListFile.close();
       } // if ListFile
    } // if
   
    AxU.SendCommands( Cmds2LogOff );
    
    AxU.WaitDisc();
    AxU.DiscBBS();
    ShellEx->hide();
    List_window->ListView1->ensureItemVisible( lastIt );
  }  
  else
  {
	  StatusByte = 6;
  } 
  stopped = TRUE;
}
