/***********************************************************************************

	Copyright (C) 2007-2009 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_HEADER
#define LIFEOGRAPH_HEADER

//#define LIFEOGRAPH_DEVELOPMENT_VERSION


#include <gconfmm.h>
#include <gtkmm.h>

#include "helpers.hpp"
#include "textview.hpp"
#include "dialogpassword.hpp"
#include "dialogtageditor.hpp"
#include "dialogchaptereditor.hpp"
#include "dialogexport.hpp"
#include "database.hpp"
#include "undo.hpp"


namespace LIFEO
{
	const char			PROGRAM_NAME[]				= "Lifeograph";
	const int			PROGRAM_VERSION_INT			= 6030;
	const char			PROGRAM_VERSION_STRING[]	= "0.6.3";

	const std::string	CONFIG_PATH					= "/apps/lifeograph";
	const int			BACKUP_INTERVAL				= 30;	// seconds
	const int			LOGOUT_COUNTDOWN			= 10;	// seconds

	// LONG AND EPIC TEXT MESSAGES
	namespace STRING
	{
		const char		SLOGAN[]    = N_(	"Personal, digital diary" );

		const char      WRONG_PASSWORD[]
                                    = N_(	"Wrong password. Please retry..." );

		const char      ENTER_PASSWORD[]
                                    = N_(	"Please enter password for selected diary..." );

		const char      ENTER_PASSWORD_TIMEOUT[]
                                    = N_(	"Program logged out to protect your privacy. "
											"Please re-enter password..." );

		const char		INCOMPATIBLE_DB[]
									= N_(	"Selected diary is not compatible with "
											"this version of Lifeograph. "
											"Please select another file..." );

		const char		CORRUPT_DB[]
									= N_(	"Selected file is not a valid "
											"Lifeograph diary. "
											"Please select another file..." );

		const char      FAILED_TO_OPEN_DB[]
                                    = N_(	"Failed to open diary. "
											"Please select anoter file..." );

		const char      DB_IS_NOT_ENCRYPTED[]
                                    = N_(	"Unencrypted diary. Press OK to open" );

		const char      SALUTATION[]    /*  TRANSLATORS: this is the message
                                            shown to the fist time users */
                                    = N_(	"Knowing others is intelligence;\n"
											"knowing yourself is true wisdom.\n"
											"Mastering others is strength;\n"
											"mastering yourself is true power.\n\n"
											"<i>--Lao Tzu</i>" );

		const char      CANNOT_WRITE[]
                                    = N_(	"Changes could not be written to diary!" );

		const char      CANNOT_WRITE_SUB[]
                                    = N_(	"Check if you have write permissions on the "
											"file and containing folder" );

	}

	// GLOBALLY USED COLUMN RECORD FOR TAGS
	extern ColrecTag *colrec_tag;

class ColrecEntry : public Gtk::TreeModel::ColumnRecord
{
	public:
		enum ItemType
		{
			IT_Datefolder, IT_Untaggedfolder, IT_Tagfolder, IT_Earlier,
			IT_Chapterfolder, IT_Entry
		};
	// CONSTRUCTOR
		ColrecEntry()
		{
			add( m_ptr );
			add( m_type );
			add( m_date_long );
			add( m_id );
			add( m_info );
			add( m_icon );
		}
		// HIDDEN COLUMNS
		Gtk::TreeModelColumn< void* >			m_ptr;
		Gtk::TreeModelColumn< ItemType >		m_type;
		Gtk::TreeModelColumn< Date >			m_date_long;
		// COLUMNS
		Gtk::TreeModelColumn< Glib::ustring >	m_id;
		Gtk::TreeModelColumn< Glib::ustring >	m_info;
		Gtk::TreeModelColumn< Glib::RefPtr< Gdk::Pixbuf > >
												m_icon;
};


class Lifeograph
{
	public:
		enum				Updateindex
		{
			UI_NONE = 0, UI_CAL = 1, UI_LIST = 2, UI_BOTH = 3
		};

		enum				LoginStatus
		{
			LOGGED_OUT = 0, LOGGED_IN = 1, LOGGED_TIME_OUT = 2
		};

		enum				Entryliststyle
		{
			LIST_BYDATE = 0, LIST_BYTAG = 1
		};

							Lifeograph( int, char ** );
		virtual				~Lifeograph () { }

		void				run( void );

		bool				read_conf( void );
		bool				write_conf( void );

		void				draw_welcomescreen( void );
		void				draw_loginscreen( void );
		void				draw_editscreen( void );

		void				show_row( const Gtk::TreeRow&, Updateindex = UI_NONE );
		void				show_listitem( const void*, Updateindex = UI_NONE );
		void				show_today( void );
		void				show_empty( void );
		void				go_back( void );
		void				sync_entry_current( void );	// synchronize with db
		void				present_entryrow( const Gtk::TreeRow& );
		void				present_currentrow( void );
		void				delete_entry( Gtk::TreeRow& );
		void				toggle_entryfavoredness( Gtk::TreeRow& );

		void				edit_tag( Tag* );
		void				delete_tag( Tag* );

		void				update_login_file( void );
		void				update_indices( void );
		void				update_treeview_entries();
		void				update_entryliststyle( void );
		void				update_calendar( void );
		void				update_title( void );
		void				update_toolbar( void );
		void				update_tags( void );
		void				update_combobox_entryliststyle( void );

		void				focus_filter( void );
		void				focus_tag( void );

		int					run_dialog( Gtk::Dialog* );
		void				start_dialog_password( void );
		void				start_dialog_chaptereditor( void );

		bool				initialize_new_database( void );
		bool				save_database( void );
		void				logout( bool );

		// SIGNAL HANDLERS
		bool				handle_event( GdkEvent* );
		bool				handle_event_delete( GdkEventAny* );
		bool				handle_event_expose( GdkEventExpose* );
		bool				handle_idle( void );
		bool				handle_backup( void );
		void				handle_filebutton_db_selectionchanged( void );
		void				handle_create_new_diary( void );
		void				handle_entry_password_changed( void );
		void				handle_button_opendb_clicked( void );
		void				handle_button_about_clicked( void );
		void				handle_button_quit_clicked( void );

		void				handle_button_backup_clicked( void );
		void				handle_autologout_toggled( void );
		void				handle_toolbutton_previous( void );
		void				handle_toolbutton_next( void );

		void				handle_treeview_entries_selectionchanged( void );
		void				handle_treeview_entries_rowactivated(
									const Gtk::TreeModel::Path&, Gtk::TreeViewColumn* );
		void				handle_treeview_entries_event_buttonpress( GdkEventButton* );
		void				handle_treeview_sortcolumnchanged( void );
		void				handle_entryliststyle_changed( void );

		void				handle_textview_entry_changed( void );
		void				handle_textview_link_activated( Date );
		LinkStatus			handle_textbuffer_link_needs_checking( Date );
		void				handle_textbuffer_title_changed( const Glib::ustring& );

		bool				handle_hboxtagtools_enternotify( GdkEventCrossing* );
		void				handle_removetags( void );
		void				handle_iconviewtags_buttonpress( GdkEventButton* );
		void				handle_iconviewtags_keyrelease( GdkEventKey* );
		void				handle_tagwidget_activated( void );

		void				handle_calendar_doubleclicked( void );
		void				handle_calendar_monthchanged( void );
		void				handle_calendar_dayselected( void );

		void				handle_entry_filter_changed( void );
		void				handle_entry_filter_clear(
									Gtk::EntryIconPosition, const GdkEventButton* );
		void				handle_matchprevious( void );
		void				handle_matchnext( void );
		void				replace_match( void );
		void				replace_allmatches( void );

		void				handle_undo( void );
		void				handle_redo( void );

		// TREEVIEW SORTER FUNCTIONS
		int					sort_bydate(
									const Gtk::TreeModel::iterator&,
									const Gtk::TreeModel::iterator& );
		int					sort_bytitle(
									const Gtk::TreeModel::iterator&,
									const Gtk::TreeModel::iterator& );

	protected:
		void				create_action(	Glib::RefPtr< Gtk::Action >&,
											Glib::RefPtr< Gtk::ActionGroup >&,
											const Glib::ustring&,
											const Gtk::StockID&,
											const Glib::ustring&,
											const Glib::ustring&,
											const Gtk::AccelKey&,
											const Glib::SignalProxy0< void >::SlotType&,
											Gtk::Widget* = NULL );
		// WIDGETS
		Gtk::Window					*m_window;
		DialogPassword				*m_dialog_password;
		DialogTageditor				*m_dialog_tageditor;
		DialogChaptereditor			*m_dialog_chaptereditor;
		DialogExport				*m_dialog_export;
		Gtk::Table					*m_table_login;
		Gtk::Label					*m_label_startupmessage;
		FilebuttonRecent			*m_filebuttonrecent;
		Gtk::Entry					*m_entry_password;
		Gtk::Button					*m_button_opendiary;
		Gtk::TreeView				*m_treeview_entries;
		Gtk::ComboBoxText			*m_combobox_liststyle;
		Gtk::IconView				*m_iconview_tags;
		Tagwidget					*m_tagwidget;
		TextbufferDiary				*m_textbufferdiary;
		TextviewDiary				*m_textviewdiary;
		Gtk::Calendar				*m_calendar;
		EntryIdletext				*m_entry_filter;
		Gtk::Entry					*m_entry_replace;
		Gtk::Button					*m_button_replace;
		Gtk::Button					*m_button_replaceall;
		Gtk::Menu					*m_menu_treeviewentries;
		Gtk::Menu					*m_menu_tag;
		Gtk::Menu					*m_menu_link;

		Gtk::HPaned					*m_hpaned_main;
		Gtk::HBox					*m_hbox_tagtools;
		Gtk::HBox					*m_hbox_replace;

		Gtk::ToolButton				*m_toolbutton_previous;
		Gtk::ToolButton				*m_toolbutton_next;
		Gtk::ToolButton				*m_toolbutton_today;
		Gtk::ToolItem				*m_toolitem_filter;
		Gtk::ToolButton				*m_toolbutton_findprevious;
		Gtk::ToolButton				*m_toolbutton_findnext;
		Gtk::MenuToolButton			*m_toolbutton_logout;
		Gtk::CheckMenuItem			*m_menuitem_logoutonidle;

		Glib::RefPtr< Gtk::TreeStore >
									m_treestore_entries;
		Glib::RefPtr< Gtk::ListStore >
									m_liststore_tagtable;
		Glib::RefPtr< Gtk::ListStore >
									m_liststore_tagcombo;
		ColrecEntry					m_colrec_entry;

		Glib::RefPtr<Gdk::Pixbuf>	m_pixbuf_favored;
		Glib::RefPtr<Gdk::Pixbuf>	m_pixbuf_unfavored;
		Glib::RefPtr<Gdk::Pixbuf>	m_pixbuf_folder;
		Glib::RefPtr<Gdk::Pixbuf>	m_pixbuf_tag;
		Glib::RefPtr<Gdk::Pixbuf>	m_pixbuf_add;
		Glib::RefPtr<Gdk::Pixbuf>	m_pixbuf_background;

		sigc::connection			m_connection_event;
		sigc::connection			m_connection_timeout;
		sigc::connection			m_connection_event_expose;
		sigc::connection			m_connection_backup;

		Glib::RefPtr< Gnome::Conf::Client >
									m_gconfclient;

		// ACTIONS
		Glib::RefPtr< Gtk::Action >	m_action_undo;
		Glib::RefPtr< Gtk::Action >	m_action_redo;
		Glib::RefPtr< Gtk::Action >	m_action_previous_list;
		Glib::RefPtr< Gtk::Action >	m_action_next_list;
		Glib::RefPtr< Gtk::Action >	m_action_previous_browsing;
		Glib::RefPtr< Gtk::Action >	m_action_previous_match;
		Glib::RefPtr< Gtk::Action >	m_action_next_match;
		Glib::RefPtr< Gtk::Action >	m_action_today;
		Glib::RefPtr< Gtk::Action >	m_action_jump2current;
		Glib::RefPtr< Gtk::Action >	m_action_focusfilter;
		Glib::RefPtr< Gtk::Action >	m_action_focustag;

		// VARIABLES
		const std::string			m_programpath;
		LoginStatus					m_loginstatus;
		bool						m_flag_firsttimeuser;
		int							m_option_idletime_max;
		bool						m_option_autologout;
		std::string					m_option_bg_path;
		int							m_secondsremaining;
		int							m_entrycount;
		int							m_internaloperation;
		bool						m_flag_entrychanged;
		Gtk::TreeRow				m_row_cur;
		void						*m_ptr2listitem_cur;
		void						*m_ptr2listitem_prev;
		int							m_address_tagnew;			// address for new tag
		int							m_address_folderuntagged;	// address for void* in row
		int							m_address_folderearlier;	// address for void* in row

		// FUNCTIONS
		bool						get_entryrow( Gtk::TreeRow&, const void* );
		Entry *						get_entry_current( void );
		Entry *						get_treerow_ptr_entry( const Gtk::TreeRow& );
		Tag *						get_treerow_ptr_tag( const Gtk::TreeRow& );

	private:
		Database					m_database;
		UndoManager					m_undomanager;

};

} // end of namespace LIFEO

#endif

