<?php
/*
$Id: profilemain.php,v 1.39 2010/05/26 18:41:00 gruberroland Exp $

  This code is part of LDAP Account Manager (http://www.ldap-account-manager.org/)
  Copyright (C) 2003 - 2010  Roland Gruber

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/**
* This is the main window of the profile editor.
*
* @package profiles
* @author Roland Gruber
*/

/** security functions */
include_once("../../lib/security.inc");
/** helper functions for profiles */
include_once("../../lib/profiles.inc");
/** access to LDAP server */
include_once("../../lib/ldap.inc");
/** access to configuration options */
include_once("../../lib/config.inc");

// start session
startSecureSession();

// die if no write access
if (!checkIfWriteAccessIsAllowed()) die();

setlanguage();

$types = $_SESSION['config']->get_ActiveTypes();
$profileClasses = array();
$profileClassesTemp = array();
for ($i = 0; $i < sizeof($types); $i++) {
	$profileClassesTemp[getTypeAlias($types[$i])] = array(
		'scope' => $types[$i],
		'title' => getTypeAlias($types[$i]),
		'profiles' => "");
}
$profileClassesKeys = array_keys($profileClassesTemp);
natcasesort($profileClassesKeys);
$profileClassesKeys = array_values($profileClassesKeys);
for ($i = 0; $i < sizeof($profileClassesKeys); $i++) {
	$profileClasses[] = $profileClassesTemp[$profileClassesKeys[$i]];
}

// check if user is logged in, if not go to login
if (!$_SESSION['ldap'] || !$_SESSION['ldap']->server()) {
	metaRefresh("../login.php");
	exit;
}

// check if new profile should be created
elseif (isset($_POST['createProfileButton'])) {
	metaRefresh("profilepage.php?type=" . $_POST['createProfile']);
	exit;
}
// check if a profile should be edited
for ($i = 0; $i < sizeof($profileClasses); $i++) {
	if (isset($_POST['editProfile_' . $profileClasses[$i]['scope']]) || isset($_POST['editProfile_' . $profileClasses[$i]['scope'] . '_x'])) {
		metaRefresh("profilepage.php?type=" . $profileClasses[$i]['scope'] .
					"&amp;edit=" . $_POST['profile_' . $profileClasses[$i]['scope']]);
		exit;
	}
}
// check if a profile should be deleted
for ($i = 0; $i < sizeof($profileClasses); $i++) {
	if (isset($_POST['deleteProfile_' . $profileClasses[$i]['scope']]) || isset($_POST['deleteProfile_' . $profileClasses[$i]['scope'] . '_x'])) {
		metaRefresh("profiledelete.php?type=" . $profileClasses[$i]['scope'] .
					"&amp;del=" . $_POST['profile_' . $profileClasses[$i]['scope']]);
		exit;
	}
}

// get list of profiles for each account type
for ($i = 0; $i < sizeof($profileClasses); $i++) {
	$profileList = getAccountProfiles($profileClasses[$i]['scope']);
	natcasesort($profileList);
	$profiles = "";
	foreach ($profileList as $p) {
		$profiles = $profiles . "<option>" . $p . "</option>\n";
	}
	$profileClasses[$i]['profiles'] = $profiles;
}

include '../main_header.php';

echo "<h1>" . _('Profile editor') . "</h1>\n";

if (isset($_GET['savedSuccessfully'])) {
	StatusMessage("INFO", _("Profile was saved."), htmlspecialchars($_GET['savedSuccessfully']));
}
if (isset($_GET['deleteFailed'])) {
	StatusMessage('ERROR', _('Unable to delete profile!'), getTypeAlias($_GET['deleteScope']) . ': ' . htmlspecialchars($_GET['deleteFailed']));
}
if (isset($_GET['deleteSucceeded'])) {
	StatusMessage('INFO', _('Deleted profile.'), getTypeAlias($_GET['deleteScope']) . ': ' . htmlspecialchars($_GET['deleteSucceeded']));
}

echo "<br>\n";
echo "<form action=\"profilemain.php\" method=\"post\">\n";

// new profile
echo "<fieldset class=\"useredit\">\n";
echo "<legend>\n";
echo "<b>" . _('Create a new profile') . "</b>\n";
echo "</legend>\n";
echo "<br><table border=0>\n";
	echo "<tr><td>\n";
		echo "<select class=\"user\" name=\"createProfile\">\n";
			$sortedTypes = array();
			for ($i = 0; $i < sizeof($profileClasses); $i++) {
				$sortedTypes[$profileClasses[$i]['scope']] = $profileClasses[$i]['title'];
			}
			natcasesort($sortedTypes);
			foreach ($sortedTypes as $key => $value) {
				echo "<option value=\"" . $key . "\">" . $value . "</option>\n";
			}
		echo "</select>\n";
	echo "</td>\n";
	echo "<td>\n";
		echo "<input type=\"submit\" name=\"createProfileButton\" value=\"" . _('Create') . "\">";
	echo "</td></tr>\n";
echo "</table>\n";
echo "</fieldset>\n";
echo "<br>\n";

// existing profiles
echo "<fieldset class=\"useredit\">\n";
echo "<legend>\n";
echo "<b>" . _('Manage existing profiles') . "</b>\n";
echo "</legend>\n";
echo "<br><table border=0>\n";
for ($i = 0; $i < sizeof($profileClasses); $i++) {
	if ($i > 0) {
		echo "<tr><td colspan=3>&nbsp;</td></tr>\n";
	}
	echo "<tr>\n";
		echo "<td>";
			echo "<img alt=\"" . $profileClasses[$i]['title'] . "\" src=\"../../graphics/" . $profileClasses[$i]['scope'] . ".png\">&nbsp;\n";
			echo $profileClasses[$i]['title'];
		echo "</td>\n";
		echo "<td>&nbsp;";
			echo "<select class=\"user\" style=\"width: 20em;\" name=\"profile_" . $profileClasses[$i]['scope'] . "\">\n";
				echo $profileClasses[$i]['profiles'];
			echo "</select>\n";
		echo "</td>\n";
		echo "<td>&nbsp;";
			echo "<input type=\"image\" src=\"../../graphics/edit.png\" name=\"editProfile_" . $profileClasses[$i]['scope'] . "\" " .
			 "alt=\"" . _('Edit') . "\" title=\"" . _('Edit') . "\">";
			echo "&nbsp;";
			echo "<input type=\"image\" src=\"../../graphics/delete.png\" name=\"deleteProfile_" . $profileClasses[$i]['scope'] . "\" " .
			"alt=\"" . _('Delete') . "\" title=\"" . _('Delete') . "\">";
		echo "</td>\n";
	echo "</tr>\n";
}
echo "</table>\n";
echo "</fieldset>\n";
echo "<br>\n";

echo "</form>\n";
echo "</body>\n";
echo "</html>\n";

?>
