/* -*-C-*-

$Id: get-addr.c,v 1.2 2003/01/20 20:48:22 cph Exp $

Copyright 2002 Massachusetts Institute of Technology

This file is part of laptop-net.

Laptop-net is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

Laptop-net is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with laptop-net; if not, write to the Free Software Foundation,
Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "if-params.h"

int
main (int argc, const char ** argv)
{
  const char * ifname;
  struct if_params ifp;

  if (argc != 2)
    {
      fprintf (stderr, "usage: %s INTERFACE\n", (argv[0]));
      return (EXIT_FAILURE);
    }
  ifname = (argv[1]);
  if ((read_interface_configuration (ifname, (&ifp))) < 0)
    printf ("unknown\n");
  else if (((ifp . flags) & IFF_UP) == 0)
    printf ("down\n");
  else if (((ifp . addr_flags) & IFP_VALID_ADDR) == 0)
    printf ("unknown\n");
  else
    printf ("%s\n", (inet_ntoa (ifp . addr . sin_addr)));
  return (EXIT_SUCCESS);
}
