/***************************************************************************
 *            langupdate.h
 *
 *  Mon Nov 13 12:54:07 2006
 *  Copyright  2006  Neil Williams
 *  linux@codehelp.co.uk
 ****************************************************************************/
/*
    This package is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
/**	@file   langupdate.h
	@brief  Parse the cache output
	@author Neil Williams <codehelp@debian.org>
*/
/** @{
*/
#ifndef _LANGUPDATE_H
#define _LANGUPDATE_H

#define LOCALE_SUFFIX "locale"
#define PACKAGE_CHK   "Package"

/** \brief default for the command line configuration. */
#define SUITE "unstable"

/** \brief Collate the various apt options into a string

Depending on various settings, the apt configuration list needs to be
adjusted so it cannot be completely defined as a macro. This function adds
the customisations, creates a newly allocated string and returns it. The
caller is responsible for freeing the string.

Also sets the langupdate cache data to the same configuration
if this has not been done already.

 \return newly allocated string of apt options or NULL on error.
*/
gchar * lu_get_aptstring (void);

/** @} */

#endif /* _LANGUPDATE_H */
