//LabPlot : Plot3D.h

#ifndef PLOT3D_H
#define PLOT3D_H

#include "Plot.h"

class Plot3D:public Plot {
public:
	Plot3D(Worksheet *p);
	QStringList Info();
	~Plot3D();
	Axis *getAxis(int i) { return &axis[i]; }
	void saveAxes(QTextStream *t);
	void openAxes(QTextStream *t,int version);
	void saveXML(QDomDocument doc, QDomElement plottag);
	void openXML(QDomElement e);
	void draw(QPainter* p,int w, int h);
	void drawBorder(QPainter* p,int w, int h,bool hide);
	void drawCurves(QPainter* p,int w, int h);
	void drawAxes(QPainter* p,int w, int h, bool hide);
	void setBorder(int item, bool on);
	void setRange(LRange* r,int i) {range[i]=*r;}
	void setActRange(LRange* r,int i) {actrange[i]=*r;}
	void setRanges(LRange* r) {range[0]=r[0];range[1]=r[1];range[2]=r[2];}
	void setActRanges(LRange* r) {actrange[0]=r[0];actrange[1]=r[1];actrange[2]=r[2];}
	bool RenderStyle() { return renderstyle; }
	void setRenderStyle(bool v=true) { renderstyle=v; }
private:
	Axis axis[12];		// x, y, z, x2, y2, z2, x3, y3, z3, x4, y4, z4
	bool renderstyle;	// 0: surface (2d delaunay), 1: hull (3d delaunay)
};

#endif // PLOT3D_H
