/***************************************************************************
 *
 *  $Id: kzenalbum.h,v 1.11 2005/06/01 08:04:19 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KZENALBUM_H
#define KZENALBUM_H

#include <qptrlist.h>
#include <qstring.h>

#include "kzenitem.h"

class QPainter;

class KZenTrack;
class KZenAlbumItem;
class KZenArtist;

/**
@author Andreas Mussgiller
*/
class KZenAlbum
{

 public:
 
  KZenAlbum(const char * name);
  ~KZenAlbum();

  const char *                getName() { return fName; }
  void                        setName(const char * name);

  void                        addTrack(KZenTrack *);
  QPtrList<KZenTrack> *       getTrackList() { return fTracks; }

  KZenAlbumItem *             getItem() { return fItem; }
  void                        setItem(KZenAlbumItem * i) { fItem = i; }

  KZenArtist *                getArtist() { return fArtist; }
  void                        setArtist(KZenArtist * a) { fArtist = a; }

  static QStringList &        getAlbums();

  uint                        getTrackCount();
  uint                        getLength();
  
 protected:

  QString                     fName;
  QPtrList<KZenTrack>        *fTracks;

  KZenArtist                 *fArtist;

  static QStringList          fAlbums;

  KZenAlbumItem              *fItem;
};

class KZenAlbumItem : public KZenItem
{
 public:

  KZenAlbumItem(QListViewItem * parent, KZenAlbum * Album);
  ~KZenAlbumItem();

  KZenAlbum *                 getAlbum() { return fAlbum; }

  bool                        getIsCompilation() { return fIsCompilation; }
  void                        setIsCompilation(bool c);

  void                        paintCell(QPainter*, const QColorGroup&, int, int, int);

 protected:

  KZenAlbum                  *fAlbum;

  bool                        fIsCompilation;  
};

class KZenAlbumItemTL : public KZenItem
{
 public:

  KZenAlbumItemTL(QListView * parent, const QString & name);
  ~KZenAlbumItemTL();

  void                        addTrack(KZenTrack *);
  QPtrList<KZenTrack> *       getTrackList() { return fTracks; }

  bool                        getIsCompilation() { return fIsCompilation; }
  void                        setIsCompilation(bool c);

  void                        paintCell(QPainter*, const QColorGroup&, int, int, int);

 protected:

  QPtrList<KZenTrack>        *fTracks;

  bool                        fIsCompilation;  
};

#endif
