/***************************************************************************
 *   Copyright (C) 2004-2008 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include <qstring.h>

#include "captureoptions.h"
#include "../version.h"

CaptureOptions::CaptureOptions()
{
  m_strSniffingInterface = QString::null;
  m_strSniffingFilename = QString::null;
}


CaptureOptions::CaptureOptions(const QString& strInterface)
{
  m_strSniffingInterface = strInterface;
  m_showAfter = false;
}


CaptureOptions::~CaptureOptions()
{
}


void CaptureOptions::setSniffingInterface(const QString& str)
{
  m_strSniffingInterface = str;
  m_strSniffingFilename = QString::null;
}


void CaptureOptions::setSniffingFilename( const QString& filename )
{
  m_strSniffingFilename = filename;
  m_strSniffingInterface = QString::null;
}


void CaptureOptions::setTmpDir( const QString& str)
{
  m_strDirTmp = str;
}


void CaptureOptions::setShowAfter( const bool& display )
{
  m_showAfter = display;
}


void CaptureOptions::setTrayBar( const bool& trayBar )
{
  m_trayBar = trayBar;
}


void CaptureOptions::setWarning( const bool& warn )
{
  m_warning = warn;
}


void CaptureOptions::setPassiveWarn( const bool& passive )
{
  m_passivePopUp = passive;
}


void CaptureOptions::setShowSplash( const bool& splash )
{
  m_showSplash = splash;
}


void CaptureOptions::setPacketsNumber( const long& number )
{
  m_packetsNumber = number;
}


void CaptureOptions::setPacketsSize( const long& packsize )
{
  m_packetsSize = packsize;
}


void CaptureOptions::setPacketsTime( const long& packtime )
{
  m_packetsTime = packtime;
}


void CaptureOptions::setPacketsInfoSizeUnits( const int& sizeunit )
{
  m_packetsInfoSizeUnits = sizeunit;
}


void CaptureOptions::setPacketsInfoTimeUnits( const int& timeunit )
{
  m_packetsInfoTimeUnits = timeunit;
}


void CaptureOptions::setSniffingType( const QString& sniffType )
{
  if (sniffType == "manually")
    m_sniffType = 0;
  else if (sniffType == "by packets")
    m_sniffType = 1;
  else if (sniffType == "by size")
    m_sniffType = 2;
  else if (sniffType == "by time")
    m_sniffType = 3;
}


void CaptureOptions::setRawFramePosition( const QString& position )
{
  m_rawFramePosition = position;
}


void CaptureOptions::setShowProtocolName( const bool& display )
{
  m_showProtocolName = display;
}


QString CaptureOptions::sniffingInterface() const
{
  return m_strSniffingInterface;
}


QString CaptureOptions::sniffingFilename() const
{
  return m_strSniffingFilename;
}


QString CaptureOptions::tmpFilePath() const
{
  QString path = m_strDirTmp;
  if (path[path.length() - 1] != '/')
    path.append( "/" );
  path.append( TEMP_PCAP_FILE_NAME );

  return path;
}


QString CaptureOptions::tmpFileConfigPath() const
{
  QString path = m_strDirTmp;
  if (path[path.length() - 1] != '/')
    path.append( "/" );
  path.append( TEMP_SNIFFER_CONFIG_FILE_NAME );

  return path;
}


QString CaptureOptions::tmpDir() const
{
  return m_strDirTmp;
}


bool CaptureOptions::showAfter() const
{
  return m_showAfter;
}


bool CaptureOptions::showTrayBar() const
{
  return m_trayBar;
}


bool CaptureOptions::showWarning() const
{
  return m_warning;
}


bool CaptureOptions::showPassiveWarn() const
{
  return m_passivePopUp;
}


bool CaptureOptions::showSplash() const
{
  return m_showSplash;
}


long CaptureOptions::packetsNumber() const
{
  return m_packetsNumber;
}


long CaptureOptions::packetsSize() const
{
  return m_packetsSize;
}


long CaptureOptions::packetsTime() const
{
  return m_packetsTime;
}


int CaptureOptions::packetsInfoSizeUnits() const
{
  return m_packetsInfoSizeUnits;
}


int CaptureOptions::packetsInfoTimeUnits() const
{
  return m_packetsInfoTimeUnits;
}


int CaptureOptions::sniffType() const
{
  return m_sniffType;
}


QString CaptureOptions::sniffingType() const
{
  QString res;

  switch (m_sniffType)
  {
    case 0:
      res = "manually";
      break;
    case 1:
      res = "packets";
      break;
    case 2:
      res = "size";
      break;
    case 3:
      res = "time";
      break;
  }

  return res;
}


QString CaptureOptions::rawFramePosition() const
{
  return m_rawFramePosition;
}


bool CaptureOptions::showProtocolName() const
{
  return m_showProtocolName;
}
