/***************************************************************************
                          kxetexteditordialog.cpp  -  description
                             -------------------
    begin                : Ne pro 14 2003
    copyright            : (C) 2003-2007 by The KXMLEditor Team
    email                : lvanek.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxetexteditordialog.h"


// include files for Qt
#include <qpushbutton.h>
#include <qdom.h>

// include files for KDE
#include <kmessagebox.h>
#include <klistbox.h>
#include <ktextedit.h>
#include <klocale.h>
#include <kdebug.h>
#include <kiconloader.h>

// application specific includes
#include "../kpogreview.h"
#include "../kpgconfiguration.h"
#include "kxetextviewsettings.h"


KXETextEditorDialog::KXETextEditorDialog(QWidget *parent)
  : KXETextEditorDialogBase(parent, "KXETextEditorDialog")
{
	m_pSyntaxHighlighter = new KXESyntaxHighlighter(m_pTextEditor);
	
	connect( m_pTextEditor, SIGNAL(textChanged()), this, SLOT(slotTextChanged()) );
	
	// Apply current configuration
	slotTextViewSettingsChanged();
	
	// and make sure to be informed about its changes.
	//@deprecated connect( KPoGreView::configuration()->kxetextview(), SIGNAL(sigChanged()), this, SLOT(slotTextViewSettingsChanged()) );
}

KXETextEditorDialog::~KXETextEditorDialog()
{
    delete m_pSyntaxHighlighter;
}

const QString KXETextEditorDialog::editorText() const 
{ 
    return m_pTextEditor->text(); 
}

void KXETextEditorDialog::setEditorText(const QString & strText) 
{ 
    m_pTextEditor->setText(strText); 
}

void KXETextEditorDialog::slotTextChanged()
{
	if ( m_pTextEditor->text().isEmpty())
		m_pButtonOk->setEnabled(false);
	else
		m_pButtonOk->setEnabled(true);
}

void KXETextEditorDialog::slotValidate()
{
    validateXml(true);
}

void KXETextEditorDialog::accept()
{
    if(validateXml(false))
        KXETextEditorDialogBase::accept();
}

bool KXETextEditorDialog::validateXml(bool bInfoIfOK)
{
	QString strXML = editorText();

	// create XML documemt from text
	QString strErrorMsg;
  	int iErrorLine, iErrorColumn;
	QDomDocument doc;

 	if(!doc.setContent(strXML, true, &strErrorMsg, &iErrorLine, &iErrorColumn) )
 	{ 
 		KMessageBox::error(this,
					 		i18n("%1 in line %2, column %3").arg(strErrorMsg).arg(iErrorLine).arg(iErrorColumn),
					 		i18n("Parsing error !"));

    	m_pTextEditor->setCursorPosition(iErrorLine - 1, iErrorColumn - 1);
    	return false;
	}

  	if(bInfoIfOK)
    	KMessageBox::information(this, i18n("OK"));

  	return true;
}

void KXETextEditorDialog::slotTextViewSettingsChanged()
{
	/* @deprecated m_pTextEditor->setFont(KPoGreView::configuration()->kxetextview()->font());
    
    m_pSyntaxHighlighter->setColorDefaultText( KPoGreView::configuration()->kxetextview()->colorDfltText() );
	m_pSyntaxHighlighter->setColorElementNames( KPoGreView::configuration()->kxetextview()->colorElemNames() );
	m_pSyntaxHighlighter->setColorAttributeNames( KPoGreView::configuration()->kxetextview()->colorAttrNames() );
	m_pSyntaxHighlighter->setColorAttributeValues( KPoGreView::configuration()->kxetextview()->colorAttrValues() );
	m_pSyntaxHighlighter->setColorXmlSyntaxChars( KPoGreView::configuration()->kxetextview()->colorSyntaxChars() );
	m_pSyntaxHighlighter->setColorComments( KPoGreView::configuration()->kxetextview()->colorComments() );
	m_pSyntaxHighlighter->setColorSyntaxError( KPoGreView::configuration()->kxetextview()->colorErrors() );
	
	if(KPoGreView::configuration()->kxetextview()->isWrapOn())
	{
		m_pTextEditor->setHScrollBarMode(QScrollView::AlwaysOff);
		m_pTextEditor->setWordWrap(QTextEdit::WidgetWidth);
	}

	m_pSyntaxHighlighter->rehighlight();*/
}
