//
// C++ Implementation: kpgtablecolumnwizinfo
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtablecolumnwizinfo.h"

// include files for Qt
#include <qpixmap.h>

// include files for KDE
#include <kdebug.h>

KPGTableColumnWizInfo::KPGTableColumnWizInfo(const QString & strName, 
	const QString & strTypName, 
	int nDimensions, 
	int iAttNum, 
	const QPixmap & icon,
	const QString & strDescription)
{
	m_strName = strName;
	m_strTypName = strTypName;
	m_Icon = icon;
	m_nDimensions = nDimensions;
	m_iAttNum = iAttNum;
	m_strDescription = strDescription;
	
	convertTypNameToBase();
}

KPGTableColumnWizInfo::KPGTableColumnWizInfo(const KPGTableColumnWizInfo &src)
{
	m_strName = src.name();
	m_strTypName = src.typName();
	m_Icon = src.icon();
	m_nDimensions = src.nDimensions();
	m_iAttNum = src.attNum();
	m_strDescription = src.description();
}

KPGTableColumnWizInfo::~KPGTableColumnWizInfo()
{
}

void KPGTableColumnWizInfo::convertTypNameToBase()
{
	if(m_strTypName == "bigint") { m_strTypName = "int8"; return; }
	if(m_strTypName == "bigserial") { m_strTypName = "int8"; return; }
	if(m_strTypName.left(12) == "bit varying(") { m_strTypName = "bitvar"; return; }
	if(m_strTypName.left(5) == "char(") { m_strTypName = "bpchar"; return; }
	if(m_strTypName.left(8) == "varchar(") { m_strTypName = "varchar"; return; }
	if(m_strTypName == "double precision") { m_strTypName = "float8"; return; }
	if(m_strTypName == "integer") { m_strTypName = "int4"; return; }
	if(m_strTypName.left(9) == "interval(") { m_strTypName = "interval"; return; }
	if(m_strTypName.left(8) == "numeric(") { m_strTypName = "numeric"; return; }
	if(m_strTypName.left(8) == "decimal(") { m_strTypName = "numeric"; return; }
	if(m_strTypName == "real") { m_strTypName = "float4"; return; }
	if(m_strTypName == "smallint") { m_strTypName = "int2"; return; }
	if(m_strTypName == "serial") { m_strTypName = "int4"; return; }
	if(m_strTypName.left(5) == "time(") { m_strTypName = "time"; return; }
	if(m_strTypName.left(20) == "time with time zone(") { m_strTypName = "timetz"; return; }
	if(m_strTypName.left(10) == "timestamp(") { m_strTypName = "timestamp"; return; }
	if(m_strTypName.left(25) == "timestamp with time zone(") { m_strTypName = "timestamptz"; return; }
}

// Decide, if other column type is compatible for create foreign key
bool KPGTableColumnWizInfo::isCompatible(const KPGTableColumnWizInfo &tableColumnWizInfoOther) const
{
	// Array fields aren't suitable for keys
	if((m_nDimensions > 0) || tableColumnWizInfoOther.nDimensions() > 0)
		return false;

	if(m_strTypName == tableColumnWizInfoOther.typName())
	{
		return true;
	}
	
	// Numeric datatypes are compatible with each other, instead of money
	if(m_strTypName == "int2")
	{
		if((tableColumnWizInfoOther.typName() == "int4") ||
			 (tableColumnWizInfoOther.typName() == "int8") ||
			 (tableColumnWizInfoOther.typName() == "float4") ||
			 (tableColumnWizInfoOther.typName() == "float8") ||
			 (tableColumnWizInfoOther.typName() == "numeric")
			)
			return true;
	} 
	
	if(m_strTypName == "int4")
	{
		if((tableColumnWizInfoOther.typName() == "int2") ||
			 (tableColumnWizInfoOther.typName() == "int8") ||
			 (tableColumnWizInfoOther.typName() == "float4") ||
			 (tableColumnWizInfoOther.typName() == "float8") ||
			 (tableColumnWizInfoOther.typName() == "numeric")
			)
			return true;
	} 
	
	if(m_strTypName == "int8")
	{
		if((tableColumnWizInfoOther.typName() == "int2") ||
			 (tableColumnWizInfoOther.typName() == "int4") ||
			 (tableColumnWizInfoOther.typName() == "float4") ||
			 (tableColumnWizInfoOther.typName() == "float8") ||
			 (tableColumnWizInfoOther.typName() == "numeric")
			)
			return true;
	}
	
	if(m_strTypName == "float4")
	{
		if((tableColumnWizInfoOther.typName() == "int4") ||
			 (tableColumnWizInfoOther.typName() == "int8") ||
			 (tableColumnWizInfoOther.typName() == "int2") ||
			 (tableColumnWizInfoOther.typName() == "float8") ||
			 (tableColumnWizInfoOther.typName() == "numeric")
			)
			return true;
	} 
	
	if(m_strTypName == "float8")
	{
		if((tableColumnWizInfoOther.typName() == "int4") ||
			 (tableColumnWizInfoOther.typName() == "int8") ||
			 (tableColumnWizInfoOther.typName() == "float4") ||
			 (tableColumnWizInfoOther.typName() == "int2") ||
			 (tableColumnWizInfoOther.typName() == "numeric")
			)
			return true;
	} 
	
	if(m_strTypName == "numeric")
	{
		if((tableColumnWizInfoOther.typName() == "int4") ||
			 (tableColumnWizInfoOther.typName() == "int8") ||
			 (tableColumnWizInfoOther.typName() == "float4") ||
			 (tableColumnWizInfoOther.typName() == "float8") ||
			 (tableColumnWizInfoOther.typName() == "int2")
			)
			return true;
	} 
	
	return false;
}

/******************************************************************************/

bool KPGListTableColumnWizInfo::appendColumn(KPGTableColumnWizInfo *pTableColumnWizInfo)
{ 
	// Avoid name duplicity
	for(unsigned int i = 0; i < count(); i++)
	{
		if((static_cast <KPGTableColumnWizInfo *> (at(i)))->name() ==  pTableColumnWizInfo->name())
		{
		  	kdError() << k_funcinfo << " Name duplicity !!!" << endl;
			return false;
		}
	}
	
	append(pTableColumnWizInfo);
	return true;
}

void KPGListTableColumnWizInfo::removeColumn(const QString &strColumnName) 
{
	KPGTableColumnWizInfo *pTableColumnWizInfo = 0;
	
 	for(unsigned int i = 0; i < count(); i++)
	{
		pTableColumnWizInfo = static_cast <KPGTableColumnWizInfo *> (at(i));
		 
		if(pTableColumnWizInfo->name() == strColumnName)
			{
				remove(pTableColumnWizInfo);
			  return;
			}
	}
	kdError() << k_funcinfo << " Name not found !!!" << endl;
}

KPGTableColumnWizInfo * KPGListTableColumnWizInfo::findColumn(const QString &strColumnName)
{
	KPGTableColumnWizInfo *pTableColumnWizInfo = 0;
	
 	for(unsigned int i = 0; i < count(); i++)
	{
		pTableColumnWizInfo = static_cast <KPGTableColumnWizInfo *> (at(i));
		 
		if(pTableColumnWizInfo->name() == strColumnName)
			return pTableColumnWizInfo;
	}
	kdError() << k_funcinfo << " Name not found !!!" << endl;
	return 0;
}


