//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgsettablespacewizard.h"

// include files for Qt
#include <qlayout.h>

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
//#include "../DbObjects/kpgtable.h"
#include "../DbObjects/kpgtablespacesfolder.h"
#include "kpgsettablespacewidget1.h"


KPGSetTablespaceWizard::KPGSetTablespaceWizard(QWidget *parent, const char *name, KPGTablespacesFolder *pTablespacesFolder, const char *szObjectTypeName, const QString &strNamespaceObjectName, const QString &strOldTablespace)
 : KPG3StepsWizard(parent, name)
{
  m_strObjectTypeName = szObjectTypeName; 
  m_strNamespaceObjectName = strNamespaceObjectName;
  
  KPGSetTablespaceWidget1 *pSetTablespaceWidget1 = new KPGSetTablespaceWidget1(WizardPage1, "KPGSetTablespaceWidget1", pTablespacesFolder, strOldTablespace);
  m_pPageWidget1 = pSetTablespaceWidget1;
  WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
  connect(pSetTablespaceWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
  
  setNextEnabled(WizardPage1, true);
  languageChange();
}

KPGSetTablespaceWizard::~KPGSetTablespaceWizard()
{
}

void KPGSetTablespaceWizard::languageChange()
{
    KPG3StepsWizard::languageChange();
    
    setCaption( i18n( "Set tablespace" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Choose tablespace" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Review SQL statement" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGSetTablespaceWizard::showPage(QWidget *pPage)
{
	if(pPage == WizardPage2) // Step 2 - Review SQL statement
	{
		// prepare SQL statement
		QString strSQL("ALTER " + m_strObjectTypeName + " ");
		strSQL.append(m_strNamespaceObjectName);
		strSQL.append((static_cast <KPGSetTablespaceWidget1 *> (m_pPageWidget1))->getSQL());
		m_pTextEditSQL->setText(strSQL);
	}
	
	if(pPage == WizardPage3) // Step 3 - Check operation result
	{
		runQuery(false);
	}
	
	// call parent
	KPG3StepsWizard::showPage(pPage);
}


#include "kpgsettablespacewizard.moc"
