/***************************************************************************
                          kpgsetdescriptionwizard.cpp  -  description
                          -------------------
    copyright            : (C) 2004-2006 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kpgsetdescriptionwizard.h"

// include files for Qt
#include <qlayout.h>

// include files for KDE
#include <ktextedit.h>
#include <klineedit.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "kpgsetdescriptionwidget1.h"
#include "../kpgutil.h"

KPGSetDescriptionWizard::KPGSetDescriptionWizard(
	QWidget *parent,
	const QString &strOldDesc,
	const QString &strObjectType,
	const QString &strNamespace,
	const QString &strObjectName,
	const QString &strTable,
	const QString &strObjectParameters
	)
 : KPG3StepsWizard(parent, "KPGSetDescriptionWizard")
{
	m_strOldDesc = strOldDesc;
	m_strObjectType = strObjectType;
  	m_strNamespace = strNamespace; 
	m_strObjectName = strObjectName; 
	m_strTable = strTable;
	m_strObjectParameters = strObjectParameters;
	
	KPGSetDescriptionWidget1 *pSetDescWidget1 = new KPGSetDescriptionWidget1(WizardPage1, "KPGSetDescriptionWidget1", strOldDesc);
	m_pPageWidget1 = pSetDescWidget1;
	WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
	
	languageChange();

	slotEnableNextButton1(true);	//next button should always be on.
}


KPGSetDescriptionWizard::~KPGSetDescriptionWizard()
{
}

void KPGSetDescriptionWizard::languageChange()
{
    KPG3StepsWizard::languageChange();

    setCaption( i18n( "Edit description of ")  + m_strObjectName );

    setTitle( WizardPage1, i18n( "Step 1 - Enter new description" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Review SQL statement" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Check operation result" ) );
}

const QString KPGSetDescriptionWizard::newDescription() const
{
  KPGSetDescriptionWidget1 *pWidget = static_cast <KPGSetDescriptionWidget1 *> (m_pPageWidget1);
  return pWidget->m_pTextEditDescription->text();
}

// When this function called, initialize appropriate Wizard page
void KPGSetDescriptionWizard::showPage(QWidget *pPage)
{
	if(pPage == WizardPage2) // Step 2 - Review SQL statement
	{
		KPGSetDescriptionWidget1 *pWidget = static_cast <KPGSetDescriptionWidget1 *> (m_pPageWidget1);
		
		// prepare SQL statement
		QString strSQL("COMMENT ON ");
		strSQL.append(m_strObjectType);
		strSQL.append(" ");
		
		if(m_strObjectType == QString("COLUMN"))
		{
			// For columns
			strSQL.append(KPGUtil::fullyQualifiedName(m_strNamespace, m_strTable));
			strSQL.append(".");
			strSQL.append(KPGUtil::quotedName(m_strObjectName));	
		}
		else if(m_strObjectType == QString("SCHEMA"))
		{
			strSQL.append(m_strObjectName);	
		}
		else
		{
			// For tables, views, ...
			if(m_strTable.isEmpty())
			{
				strSQL.append(KPGUtil::fullyQualifiedName(m_strNamespace, m_strObjectName));
				if(m_strObjectType == QString("FUNCTION"))
                {
                    strSQL.append(m_strObjectParameters);
                }
			}
			else
			{
				// For constraints
				strSQL.append(KPGUtil::quotedName(m_strObjectName));	
				strSQL.append(" ON ");
				strSQL.append(KPGUtil::fullyQualifiedName(m_strNamespace, m_strTable));
			}
		}
		
		strSQL.append(" IS ");
		strSQL.append("'" + pWidget->m_pTextEditDescription->text()+ "';");
		
		m_pTextEditSQL->setText(strSQL);
	}

	if(pPage == WizardPage3) // Step 3 - Check operation result
	{
		runQuery();
	}

	// call parent
	KPG3StepsWizard::showPage(pPage);
}





