//
// C++ Implementation: kpgrenameobjectwizard
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgrenameobjectwizard.h"

// include files for Qt
#include <qlayout.h>

// include files for KDE
#include <ktextedit.h>
#include <klineedit.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "kpgrenameobjectwidget1.h"
#include "../kpgutil.h"


KPGRenameObjectWizard::KPGRenameObjectWizard(QWidget *parent, const char *name,
	const QString &strOldName, const char *szSqlName, const QString & strObjectName)
 : KPG3StepsWizard(parent, name)
{
	KPGRenameObjectWidget1 *pRenameObjectWidget1 = new KPGRenameObjectWidget1(WizardPage1, "KPGRenameObjectWidget1", strOldName);
	m_pPageWidget1 = pRenameObjectWidget1;
	WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
	connect(pRenameObjectWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
	
	m_strObjectName = strObjectName;
	m_strSqlName = szSqlName;
	
	languageChange();
}

KPGRenameObjectWizard::KPGRenameObjectWizard(QWidget *parent, const char *name, const QString &strNamespaceTableName,
  const QString &strOldName, const char *szSqlName, const QString & strObjectName)
 : KPG3StepsWizard(parent, name)
{
  KPGRenameObjectWidget1 *pRenameObjectWidget1 = new KPGRenameObjectWidget1(WizardPage1, "KPGRenameObjectWidget1", strOldName);
  m_pPageWidget1 = pRenameObjectWidget1;
  WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
  connect(pRenameObjectWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
 
  m_strNamespaceTableName = strNamespaceTableName; 
  m_strObjectName = strObjectName;
  m_strSqlName = szSqlName;
  
  languageChange();
}

KPGRenameObjectWizard::~KPGRenameObjectWizard()
{
}

void KPGRenameObjectWizard::languageChange()
{
    KPG3StepsWizard::languageChange();
		
	setCaption( i18n( "Rename " ) + m_strObjectName );
		
    setTitle( WizardPage1, i18n( "Step 1 - Enter new  name" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Review SQL statement" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Check operation result" ) );
}

const QString KPGRenameObjectWizard::newObjectName() const
{
  KPGRenameObjectWidget1 *pWidget = static_cast <KPGRenameObjectWidget1 *> (m_pPageWidget1);
  return pWidget->m_pLineEditNewName->text();
}

// When this function called, initialize appropriate Wizard page
void KPGRenameObjectWizard::showPage(QWidget *pPage)
{
	if(pPage == WizardPage2) // Step 2 - Review SQL statement
	{
		KPGRenameObjectWidget1 *pWidget = static_cast <KPGRenameObjectWidget1 *> (m_pPageWidget1);
		// prepare SQL statement
		QString strSQL;
    
    if(m_strNamespaceTableName.isEmpty())
    {
		  strSQL.append("ALTER ");
		  strSQL.append(m_strSqlName);
		  strSQL.append(" ");
		  strSQL.append(pWidget->m_pLineEditOldName->text());
		  strSQL.append(" RENAME TO ");
		  strSQL.append(KPGUtil::quotedName(pWidget->m_pLineEditNewName->text()));
		  strSQL.append(";");
		}
    else
    {
      if(m_strSqlName == "COLUMN")
      {
        strSQL.append("ALTER TABLE ");
        strSQL.append(m_strNamespaceTableName);
        strSQL.append(" RENAME ");
        strSQL.append(m_strSqlName);
        strSQL.append(" ");
        strSQL.append(pWidget->m_pLineEditOldName->text());
        strSQL.append(" TO ");
        strSQL.append(KPGUtil::quotedName(pWidget->m_pLineEditNewName->text()));
        strSQL.append(";");
      }
      else
      {
        strSQL.append("ALTER ");
        strSQL.append(m_strSqlName);
        strSQL.append(" ");
        strSQL.append(pWidget->m_pLineEditOldName->text());
        strSQL.append(" ON ");
        strSQL.append(m_strNamespaceTableName);
        strSQL.append(" RENAME TO ");
        strSQL.append(KPGUtil::quotedName(pWidget->m_pLineEditNewName->text()));
        strSQL.append(";");
      }
    }
    
		m_pTextEditSQL->setText(strSQL);
	}
	
	if(pPage == WizardPage3) // Step 3 - Check operation result
	{
		runQuery();
	}
	
	// call parent
	KPG3StepsWizard::showPage(pPage);
}

#include "kpgrenameobjectwizard.moc"
