//
// C++ Implementation: kpgcreateuserwizard
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreateuserwizard.h"

// include files for Qt
#include <qlayout.h>

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <kactionselector.h> 
#include <kcombobox.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgserver.h"
#include "../DbObjects/kpggroupsfolder.h"
#include "kpgcreateuserwidget1.h"
#include "kpgcreateuserwidget2.h"


KPGCreateUserWizard::KPGCreateUserWizard(QWidget *parent, const char *name, KPGServer *pServer)
 : KPG4StepsWizard(parent, name)
{
	KPGCreateUserWidget1 *pCreateUserWidget1 = new KPGCreateUserWidget1(WizardPage1, "KPGCreateUserWidget1");
	m_pPageWidget1 = pCreateUserWidget1;
	WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
	connect(pCreateUserWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
	
	KPGCreateUserWidget2 *pCreateUserWidget2 = new KPGCreateUserWidget2(WizardPage2, "KPGCreateUserWidget2");
	m_pPageWidget2 = pCreateUserWidget2;
	WizardPage2Layout->addWidget(m_pPageWidget2, 0, 0);
	connect(pCreateUserWidget2, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton2(bool)));
	
  	pServer->getGroupsFolder()->fillListBoxWithChildItems(pCreateUserWidget2->m_pActionSelectorGroups->availableListBox());
  
	setNextEnabled(WizardPage2, true);
	
	languageChange();
}


KPGCreateUserWizard::~KPGCreateUserWizard()
{
}

void KPGCreateUserWizard::languageChange()
{
    KPG4StepsWizard::languageChange();
		
	setCaption( i18n( "Create new user" ) );
		
    setTitle( WizardPage1, i18n( "Step 1 - User name and another properties" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Groups membership" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Review SQL statement" ) );
    setTitle( WizardPage4, i18n( "Step 4 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGCreateUserWizard::showPage(QWidget *pPage)
{
	if(pPage == WizardPage3) // Step 3 - Review SQL statement
	{
		// prepare SQL statement
		QString strSQL("CREATE USER ");
		
		strSQL.append((static_cast <KPGCreateUserWidget1 *> (m_pPageWidget1))->getSQL(connection()));
		strSQL.append((static_cast <KPGCreateUserWidget2 *> (m_pPageWidget2))->getSQL());
				
		strSQL.append(";");
		
		m_pTextEditSQL->setText(strSQL);
	}
	
	if(pPage == WizardPage4) // Step 4 - Check operation result
	{
		runQuery();
	}
	
	// call parent
	KPG4StepsWizard::showPage(pPage);
}

#include "kpgcreateuserwizard.moc"
