//
// C++ Implementation: kpgcreatetablewidget1
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatetablewidget1.h"

// include files for Qt
#include <qlistview.h>
#include <qspinbox.h>

// include files for KDE
#include <kcombobox.h>
#include <klineedit.h>

#include "../kpgutil.h"

KPGCreateTableWidget1::KPGCreateTableWidget1(QWidget *parent, const char *name, QPtrList<QListViewItem> & listOfSchemas)
 : KPGCreateTableWidget1Base(parent, name)
{
	m_pLineEditTableName->setFocus();
     
	int iCurrentItem = -1;
	int i = 0;  
	for(QListViewItem *pSchema = listOfSchemas.first(); pSchema; pSchema = listOfSchemas.next())
	{
		m_pComboBoxSchema->insertItem(* pSchema->pixmap(0), pSchema->text(0));
		
		if(pSchema->text(0) == "public")
			iCurrentItem = i;
			
		++i;
	}
		
	if(iCurrentItem >= 0)
		m_pComboBoxSchema->setCurrentItem(iCurrentItem);
}


KPGCreateTableWidget1::~KPGCreateTableWidget1()
{
}

void KPGCreateTableWidget1::slotTableNameChanged(const QString& strText)
{
	emit sigEnableNextButton(! strText.isEmpty());
}

void KPGCreateTableWidget1::slotDefaultFillFactorToggled(bool bState)
{
    m_pSpinBoxFillFactor->setEnabled(!bState);
}

// Return part of SQL statement for CREATE TABLE
const QString KPGCreateTableWidget1::getSQL() const
{
	QString strSql("CREATE TABLE ");
	
	strSql.append(KPGUtil::fullyQualifiedName(m_pComboBoxSchema->currentText(), m_pLineEditTableName->text()));
	
	return strSql;
}

#include "kpgcreatetablewidget1.moc"
