//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatetableconstraintwizard.h"

// include files for Qt
#include <qcheckbox.h>
#include <qframe.h> 
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlistview.h>
#include <qwidgetstack.h> 

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <klistbox.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgserver.h"
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgschema.h"
#include "../DbObjects/kpgtablecolumnsfolder.h"
#include "../DbObjects/kpgtablesfolder.h"
#include "../DbObjects/kpgtablespacesfolder.h"
#include "kpgcreatetablewidget3.h"
#include "../kpgutil.h"

KPGCreateTableConstraintWizard::KPGCreateTableConstraintWizard(QWidget *parent, const char *name, KPGDatabase *pDatabase, KPGSchema *pSchema, KPGTable *pTable, bool bAllowPrimaryKey, int iRaisedWidget)
 : KPG3StepsWizard(parent, name)
{
  KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent());
  
  m_strTableName = pTable->text(0);
  m_strNamespace = pSchema->text(0); 
  
  KPGCreateTableWidget3 *pCreateTableWidget3 = new KPGCreateTableWidget3(WizardPage1, "KPGCreateTableWidget3", pDatabase, bAllowPrimaryKey);
  m_pPageWidget1 = pCreateTableWidget3;
  WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
  connect(pCreateTableWidget3, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
  
  // setup initial state for KPGCreateTableWidget3
  pTable->getTableColumnsFolder()->fillListColumnWizInfoWithChildItems(pCreateTableWidget3->getListOfAvailableColumns(), false);
	pCreateTableWidget3->refreshAvailableColumns();
	
  pCreateTableWidget3->setNamespace(pSchema->text(0));
  pCreateTableWidget3->setTableName(pTable->text(0));
  
  if(pServer->versionMajor() >= 8)
    pServer->getTablespacesFolder()->fillComboBoxWithChildItems(pCreateTableWidget3->m_pComboBoxTablespace);
  else
    pCreateTableWidget3->m_pComboBoxTablespace->setEnabled(false);
  
		        
  if(pCreateTableWidget3->m_pComboBoxRefTable->count() > 0)
    pCreateTableWidget3->refTableSelectChanged();
      
  pCreateTableWidget3->m_pLineEditConstraintName->setText(""); // clear preselected default name
  
  if(iRaisedWidget > 0)
    {
      int iIndex = iRaisedWidget;
      if(!bAllowPrimaryKey) iIndex--; // because PK is not inserted to combobox
      
      pCreateTableWidget3->m_pComboBoxConstraintType->setCurrentItem(iIndex);
      pCreateTableWidget3->m_pWidgetStack->raiseWidget(iRaisedWidget);
    }
  languageChange();
}


KPGCreateTableConstraintWizard::~KPGCreateTableConstraintWizard()
{
}

void KPGCreateTableConstraintWizard::languageChange()
{
    KPG3StepsWizard::languageChange();
    
    setCaption( i18n( "Add Constraint to Table" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Define table constraints" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Review SQL statement" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGCreateTableConstraintWizard::showPage(QWidget *pPage)
{
  if(pPage == WizardPage2) // Step 2 - Review SQL statement
  {
    KPGCreateTableWidget3 *pCreateTableWidget3 = static_cast <KPGCreateTableWidget3 *> (m_pPageWidget1);
    
    // prepare SQL statement
    QString strSQL;
    
    QListViewItem * pItem = pCreateTableWidget3->m_pListViewConstraints->firstChild();
    while(pItem)
    {
      QString strAlter("ALTER TABLE ");
    
      strAlter.append(KPGUtil::fullyQualifiedName(m_strNamespace, m_strTableName));
       strAlter.append(" ADD ");
      strAlter.append(pItem->text(0));
      strAlter.append(";\n");
      
      strSQL.append(strAlter);
              
      pItem = pItem->nextSibling();
    }
    
    m_pTextEditSQL->setText(strSQL);
  }
  
  if(pPage == WizardPage3) // Step 3 - Check operation result
  {
    runQuery();
  }

  // call parent
  KPG3StepsWizard::showPage(pPage);
}

#include "kpgcreatetableconstraintwizard.moc"
