//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatefunctionwidget2.h"

// include files for Qt
#include <qlabel.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qinputdialog.h> 

// include files for KDE
#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h> 
#include <klistview.h> 

// application specific includes
#include "../DbObjects/kpgtypesfolder.h"
#include "../DbObjects/kpgschema.h"
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgtype.h"
#include "../kpgutil.h"

#define NUM_BASIC_ARG_TYPES 38
#define NUM_BASIC_RET_TYPES 40


KPGCreateFunctionWidget2::KPGCreateFunctionWidget2(QWidget *parent, const char *name, KPGDatabase *pDatabase)
 : KPGCreateFunctionWidget2Base(parent, name)
{
	m_pDatabase = pDatabase;
	
	// fill schemas to comboboxes
	KPGUtil::fillComboBoxWithDatabaseSchemas(pDatabase, m_pComboBoxRetTypeSchema, true);
	KPGUtil::fillComboBoxWithDatabaseSchemas(pDatabase, m_pComboBoxArgTypeSchema, true);
	
	m_pListViewArguments->setAllColumnsShowFocus(true);
	m_pListViewArguments->setSortColumn(-1);
}


KPGCreateFunctionWidget2::~KPGCreateFunctionWidget2()
{
}

void KPGCreateFunctionWidget2::refreshListOfReturnTypes()
{
	m_pComboBoxReturnType->clear();
	
	//-------------------------------------------------------------------
	
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnChar, "char(n)");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnChar, "varchar(n)");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnChar, "text");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnXml, "xml");
	
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnNum, "smallint");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnNum, "integer");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnNum, "bigint");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnNum, "decimal(p, s)");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnNum, "numeric(p, s)");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnNum, "real");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnNum, "double precision");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnNum, "money");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnUuid, "uuid");
	
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnBit, "bit(n)");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnBit, "bit varying(n)");
	
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnBool, "bool");
	
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnTime, "time [(p)]");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnTime, "time [(p)] with time zone");
	
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnDate, "date");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnDate, "timestamp [(p)]");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnDate, "timestamp [(p)] with time zone");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnDate, "interval [(p)]");
	
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnBin, "bytea");
	
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "point");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "line");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "lseg");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "polygon");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "box");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "path");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "circle");
	
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnNet, "inet");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnNet, "cidr");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconColumnNet, "macaddr");
	
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconType, "anyelement");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconType, "anyarray");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconType, "cstring");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconType, "internal");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconType, "language_handler");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconType, "OPAQUE");
	m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconType, "trigger");
	
	if(m_pComboBoxReturnType->count() != NUM_BASIC_RET_TYPES)
		kdDebug() << "KPGCreateFunctionWidget2::refreshListOfReturnTypes() : NUM_BASIC_RET_TYPES wrong number" << endl;
		
		
	//-------------------------------------------------------------------
	
	//--- Obtain list of types
	KPGTreeItem *pItem = m_pDatabase->getChildByName(m_pComboBoxRetTypeSchema->currentText());
	if(!pItem)
	{
		kdDebug() << "KPGCreateFunctionWidget2::refreshListOfReturnTypes: no item found: " << m_pComboBoxRetTypeSchema->currentText() << endl;
		return;
	}
	
	KPGSchema *pSchema = static_cast <KPGSchema *> (pItem);
	KPGTypesFolder *pTypesFolder = pSchema->getTypesFolder();
	
	// traverse list of types
	QListViewItem * pLvItem = pTypesFolder->firstChild();
	while(pLvItem)
	{
		KPGType *pType = static_cast <KPGType *> (pLvItem);
		
		if((pType->kind() == "composite") || ((pType->kind() == "base") && pType->text(0)[0] != '_'))
		{
			m_pComboBoxReturnType->insertItem(* pType->pixmap(0), pType->text(0)); 
		}
		pLvItem = pLvItem->nextSibling();
	}
	
	//--- User defined datatype
	if(!strNewDatatype.isEmpty())
		m_pComboBoxReturnType->insertItem(* KPGTreeItem::m_pIconType, strNewDatatype);
	
	m_pComboBoxReturnType->setCurrentItem(0);
	slotComboReturnTypeActivated(m_pComboBoxReturnType->currentText());
}

void KPGCreateFunctionWidget2::refreshListOfArgumentTypes()
{
	m_pComboBoxArgumentType->clear();
	
	//-------------------------------------------------------------------
	
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnChar, "char(n)");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnChar, "varchar(n)");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnChar, "text");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnXml, "xml");
	
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnNum, "smallint");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnNum, "integer");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnNum, "bigint");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnNum, "decimal(p, s)");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnNum, "numeric(p, s)");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnNum, "real");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnNum, "double precision");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnNum, "money");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnUuid, "uuid");
		
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnBit, "bit(n)");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnBit, "bit varying(n)");
	
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnBool, "bool");
	
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnTime, "time [(p)]");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnTime, "time [(p)] with time zone");
	
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnDate, "date");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnDate, "timestamp [(p)]");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnDate, "timestamp [(p)] with time zone");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnDate, "interval [(p)]");
	
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnBin, "bytea");
	
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "point");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "line");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "lseg");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "polygon");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "box");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "path");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnGeo, "circle");
	
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnNet, "inet");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnNet, "cidr");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconColumnNet, "macaddr");
	
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconType, "anyelement");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconType, "anyarray");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconType, "cstring");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconType, "internal");
	m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconType, "OPAQUE");
	
	if(m_pComboBoxArgumentType->count() != NUM_BASIC_ARG_TYPES)
		kdDebug() << "KPGCreateFunctionWidget2::refreshListOfArgumentTypes : NUM_BASIC_ARG_TYPES wrong number" << endl;
	
	//--- Obtain list of types
	KPGTreeItem *pItem = m_pDatabase->getChildByName(m_pComboBoxArgTypeSchema->currentText());
	if(!pItem)
	{
		kdDebug() << "KPGCreateFunctionWidget2::refreshListOfArgumentTypes: no item found: " << m_pComboBoxArgTypeSchema->currentText() << endl;
		return;
	}
	
	KPGSchema *pSchema = static_cast <KPGSchema *> (pItem);
	KPGTypesFolder *pTypesFolder = pSchema->getTypesFolder();
	
	// traverse list of types
	QListViewItem * pLvItem = pTypesFolder->firstChild();
	while(pLvItem)
	{
		KPGType *pType = static_cast <KPGType *> (pLvItem);
		
		if((pType->kind() == "composite") || ((pType->kind() == "base") && pType->text(0)[0] != '_'))
		{
			m_pComboBoxArgumentType->insertItem(* pType->pixmap(0), pType->text(0));
		}
		pLvItem = pLvItem->nextSibling();
	}
	
	//--- User defined datatype
	if(!strNewDatatype.isEmpty())
		m_pComboBoxArgumentType->insertItem(* KPGTreeItem::m_pIconType, strNewDatatype);
		
	m_pComboBoxArgumentType->setCurrentItem(0);
	slotComboArgumentTypeActivated(m_pComboBoxArgumentType->currentText());
  
}

void KPGCreateFunctionWidget2::slotRetTypeSchemaActivated(int)
{
	// refresh types from selected namespace
	refreshListOfReturnTypes();
	slotComboReturnTypeActivated(m_pComboBoxReturnType->currentText());
} 
 
void KPGCreateFunctionWidget2::slotArgTypeSchemaActivated(int)
{
	// refresh types from selected namespace
	refreshListOfArgumentTypes();
	slotComboArgumentTypeActivated(m_pComboBoxArgumentType->currentText());
}    

void KPGCreateFunctionWidget2::slotArgumentCurrentChanged(QListViewItem *pItem)
{
	m_pPushButtonArgumentDel->setEnabled(pItem != 0);
	m_pPushButtonArgumentUp->setEnabled(pItem != 0);
	m_pPushButtonArgumentDown->setEnabled(pItem != 0);
  
}

void KPGCreateFunctionWidget2::slotColumnSelectionChanged(QListViewItem *pItem)
{
    m_pPushButtonArgumentDel->setEnabled(pItem != 0);
    m_pPushButtonArgumentUp->setEnabled(pItem != 0);
    m_pPushButtonArgumentDown->setEnabled(pItem != 0);
}

void KPGCreateFunctionWidget2::slotCheckBoxWithoutReturnToggled(bool bWithoutReturn)
{
    if(bWithoutReturn)
    {
        m_pSpinBoxRetPrecision->setEnabled(false);
        m_pSpinBoxRetScale->setEnabled(false);
    }
    else
    {
        // enable/disable depends from selected return type
        slotComboReturnTypeActivated(m_pComboBoxReturnType->currentText());
    }
    
    m_pCheckBoxReturnSet->setEnabled(!bWithoutReturn);
    m_pComboBoxRetTypeSchema->setEnabled(!bWithoutReturn);
    m_pComboBoxReturnType->setEnabled(!bWithoutReturn);
}

void KPGCreateFunctionWidget2::slotComboReturnTypeActivated(const QString &strText)
{
	// Enable/disable precision and scale spins
	m_pSpinBoxRetPrecision->setEnabled(false);
	m_pSpinBoxRetScale->setEnabled(false);
	
	if(strText.find("(n)") > 0)
	{
		m_pSpinBoxRetPrecision->setEnabled(true);
	}
	
	if(strText.find("(p, s)") > 0)
	{
		m_pSpinBoxRetPrecision->setEnabled(true);
		m_pSpinBoxRetScale->setEnabled(true);
	}
	
	if(strText.find("[(p)]") > 0)
	{
		m_pSpinBoxRetPrecision->setEnabled(true);
	}
	
	// Set help text for selected data type
	if((strText == "char(n)") || (strText == "varchar(n)"))
	{ 
		m_pSpinBoxRetPrecision->setMinValue( 0 );
		m_pSpinBoxRetPrecision->setMaxValue( 999 );
		
		m_pSpinBoxRetPrecision->setValue( 10 );
		
		return;
	}    
	
	if((strText == "decimal(p, s)") || (strText == "numeric(p, s)"))
	{ 
		m_pSpinBoxRetPrecision->setMinValue( 1 );
		m_pSpinBoxRetPrecision->setMaxValue( 999 );
		
		m_pSpinBoxRetScale->setMinValue( 0 );
		m_pSpinBoxRetScale->setMaxValue( 999 );
		
		m_pSpinBoxRetPrecision->setValue( 10 );
		
		return;
	}    
	
	if((strText == "bit(n)") || (strText == "bit varying(n)"))
	{ 
		m_pSpinBoxRetPrecision->setMinValue( 0 );
		m_pSpinBoxRetPrecision->setMaxValue( 999 );
		
		m_pSpinBoxRetPrecision->setValue( 255 );
		
		return;
	}
		
	if((strText == "time [(p)]") || (strText == "time [(p)] with time zone"))
	{ 
		m_pSpinBoxRetPrecision->setMinValue( 0 );
		m_pSpinBoxRetPrecision->setMaxValue( 13 );
		
		m_pSpinBoxRetPrecision->setValue( 13 );
		return;
	}
	
	if((strText == "timestamp [(p)]") || (strText == "timestamp [(p)] with time zone") || (strText == "interval [(p)]"))
	{ 
		m_pSpinBoxRetPrecision->setMinValue( 0 );
		m_pSpinBoxRetPrecision->setMaxValue( 6 );
		
		m_pSpinBoxRetPrecision->setValue( 6 );
	
		return;
	}
}

void KPGCreateFunctionWidget2::slotComboArgumentTypeActivated(const QString &strText)  
{
	// Enable/disable precision and scale spins
	m_pSpinBoxArgPrecision->setEnabled(false);
	m_pSpinBoxArgScale->setEnabled(false);
	
	if(strText.find("(n)") > 0)
	{
		m_pSpinBoxArgPrecision->setEnabled(true);
	}
	
	if(strText.find("(p, s)") > 0)
	{
		m_pSpinBoxArgPrecision->setEnabled(true);
		m_pSpinBoxArgScale->setEnabled(true);
	}
	
	if(strText.find("[(p)]") > 0)
	{
		m_pSpinBoxArgPrecision->setEnabled(true);
	}
	
	// Set help text for selected data type
	if((strText == "char(n)") || (strText == "varchar(n)"))
	{ 
		m_pSpinBoxArgPrecision->setMinValue( 0 );
		m_pSpinBoxArgPrecision->setMaxValue( 999 );
		
		m_pSpinBoxArgPrecision->setValue( 10 );
		
		return;
	}    
	
	if((strText == "decimal(p, s)") || (strText == "numeric(p, s)"))
	{ 
		m_pSpinBoxArgPrecision->setMinValue( 1 );
		m_pSpinBoxArgPrecision->setMaxValue( 999 );
		
		m_pSpinBoxArgScale->setMinValue( 0 );
		m_pSpinBoxArgScale->setMaxValue( 999 );
		
		m_pSpinBoxArgPrecision->setValue( 10 );
		
		return;
	}    
	
	if((strText == "bit(n)") || (strText == "bit varying(n)"))
	{ 
		m_pSpinBoxArgPrecision->setMinValue( 0 );
		m_pSpinBoxArgPrecision->setMaxValue( 999 );
		
		m_pSpinBoxArgPrecision->setValue( 255 );
		
		return;
	}
		
	if((strText == "time [(p)]") || (strText == "time [(p)] with time zone"))
	{ 
		m_pSpinBoxArgPrecision->setMinValue( 0 );
		m_pSpinBoxArgPrecision->setMaxValue( 13 );
		
		m_pSpinBoxArgPrecision->setValue( 13 );
		return;
	}
	
	if((strText == "timestamp [(p)]") || (strText == "timestamp [(p)] with time zone") || (strText == "interval [(p)]"))
	{ 
		m_pSpinBoxArgPrecision->setMinValue( 0 );
		m_pSpinBoxArgPrecision->setMaxValue( 6 );
		
		m_pSpinBoxArgPrecision->setValue( 6 );
	
		return;
	}
}

void KPGCreateFunctionWidget2::slotArgumentAdd()
{
	if(m_pComboBoxArgumentType->currentItem() < 0) return;
	
	QString strArgumentName(m_pLineEditArgumentName->text());
	QString strArgumentType(m_pComboBoxArgumentType->currentText());
	QString strNamespace(m_pComboBoxArgTypeSchema->currentText());
	
	QString strDefinition;
	
	if((m_pComboBoxArgumentType->currentItem() <= NUM_BASIC_ARG_TYPES - 1) || (strNamespace == "public"))
		strDefinition = strArgumentType;
	else
		strDefinition = "\"" + strNamespace + "\"." +  strArgumentType;
		
	// Avoid argument name duplicity, if it's not empty
	QListViewItem *pLastItem = 0;
			
	QListViewItem * pItem = m_pListViewArguments->firstChild();
	while(pItem)
	{
		pLastItem = pItem;
				
		if(strArgumentName.length() > 0)
		{
			if(pItem->text(0) == strArgumentName)
			{ 
			KMessageBox::sorry(this, i18n("Argument name already exists !"));
			return;     
			}   
		}  
		pItem = pItem->nextSibling();
	}
	
	
	//----------------------------------------------------------- 
	int i;
	if((i = strDefinition.find("(n)")) > 0)
	{
		strDefinition = strDefinition.left(strDefinition.length() - 3); // strip (n)
			
		strDefinition.append(QString("(%1)").arg(m_pSpinBoxArgPrecision->value()));
	}
	
	if((i = strDefinition.find("(p, s)")) > 0)
	{
		strDefinition = strDefinition.left(strDefinition.length() - 6); // strip (p, s)
		
		strDefinition.append(QString("(%1, %2)").arg(m_pSpinBoxArgPrecision->value()).arg(m_pSpinBoxArgScale->value()));
	}
	
	if((i = strDefinition.find("[(p)]")) > 0)
	{
		QString strDefinitionPostfix(strDefinition.mid(i + 5, strDefinition.length() - i - 5));
		strDefinition = strDefinition.left(i); // strip (n)
		
		strDefinition.append(QString("(%1)").arg(m_pSpinBoxArgPrecision->value()));
		strDefinition.append(strDefinitionPostfix);
	}
	
	// Create item for new column
	QListViewItem *pNewItem;
	if(pLastItem == 0) 
		pNewItem = new QListViewItem(m_pListViewArguments, strArgumentName, strDefinition, m_pComboBoxArgumentMode->currentText());
	else
		pNewItem = new QListViewItem(m_pListViewArguments, pLastItem, strArgumentName, strDefinition, m_pComboBoxArgumentMode->currentText());
		
	pNewItem->setPixmap(0, * m_pComboBoxArgumentType->pixmap(m_pComboBoxArgumentType->currentItem()));
	
	
	m_pLineEditArgumentName->setText("");
}

void KPGCreateFunctionWidget2::slotArgumentDelete()
{
    QListViewItem *pSelectedItem = m_pListViewArguments->selectedItem();
    if(pSelectedItem)
    { 
        delete pSelectedItem;
    }
            
    m_pPushButtonArgumentDel->setEnabled(false);
    m_pPushButtonArgumentUp->setEnabled(false);
    m_pPushButtonArgumentDown->setEnabled(false);
}

void KPGCreateFunctionWidget2::slotArgumentUp()
{
    QListViewItem *pSelectedItem = m_pListViewArguments->selectedItem();
    if(!pSelectedItem) return;
        
    QListViewItem *pPrevItem = pSelectedItem->itemAbove();
    if(!pPrevItem) return;
        
    pPrevItem = pPrevItem->itemAbove();
                
    m_pListViewArguments->takeItem(pSelectedItem);
        
    QListViewItem *pNewItem;
         
    if(pPrevItem)
        pNewItem = new QListViewItem(m_pListViewArguments, pPrevItem, pSelectedItem->text(0),  pSelectedItem->text(1));
    else
        pNewItem = new QListViewItem(m_pListViewArguments, pSelectedItem->text(0),  pSelectedItem->text(1),  pSelectedItem->text(2));
        
    pNewItem->setPixmap(0, * pSelectedItem->pixmap(0));
                 
    delete pSelectedItem;
         
    m_pListViewArguments->setCurrentItem(pNewItem);
    m_pListViewArguments->setSelected(pNewItem, true);
}

void KPGCreateFunctionWidget2::slotArgumentDown()
{
    QListViewItem *pSelectedItem = m_pListViewArguments->selectedItem();
    if(!pSelectedItem) return;
        
    QListViewItem *pAfterItem = pSelectedItem->itemBelow();
    if(!pAfterItem) return;
        
    m_pListViewArguments->takeItem(pSelectedItem);
         
    QListViewItem *pNewItem = new QListViewItem(m_pListViewArguments, pAfterItem, pSelectedItem->text(0), pSelectedItem->text(1), pSelectedItem->text(2));
    pNewItem->setPixmap(0, * pSelectedItem->pixmap(0));
                 
    delete pSelectedItem;
         
    m_pListViewArguments->setCurrentItem(pNewItem);
    m_pListViewArguments->setSelected(pNewItem, true);  
}

void KPGCreateFunctionWidget2::slotAddNewDatatype()
{
    bool ok;
    QString text = QInputDialog::getText("KPoGre", i18n("Enter datatype name:"), QLineEdit::Normal, QString::null, &ok, this );
    if( ok && !text.isEmpty()) 
    {
        strNewDatatype = text;
    } 
    else
    {
        return;
    }
        
        
    refreshListOfReturnTypes();
    refreshListOfArgumentTypes();
}

// Return function paramaters
const QString KPGCreateFunctionWidget2::getFuncParams() const
{
    QString strFuncParams(" (");
    
    // list of function argument
    QListViewItem * pItem = m_pListViewArguments->firstChild();
    while(pItem)
    {
        strFuncParams.append(pItem->text(2)); // IN / OUT / INOUT
        strFuncParams.append(" ");
        
        if(pItem->text(0).length() > 0) // append name, if exists
        {
            strFuncParams.append(pItem->text(0));
            strFuncParams.append(" ");
        }
        
        strFuncParams.append(pItem->text(1)); // data type
              
        pItem = pItem->nextSibling();
        
        if(pItem)
            strFuncParams.append(",\n");
    }
    
    strFuncParams.append(")");
  
    return strFuncParams;
}

// Return part of SQL statement for CREATE FUNCTION
const QString KPGCreateFunctionWidget2::getSQL() const
{
    QString strSQL("\n");
	    
    // return type
    QString strReturnType(m_pComboBoxReturnType->currentText());
    QString strNamespace(m_pComboBoxRetTypeSchema->currentText());
    
    QString strDefinition;
    
    if((m_pComboBoxReturnType->currentItem() <= NUM_BASIC_RET_TYPES - 1) || (strNamespace == "public"))
        strDefinition = strReturnType;
    else
        strDefinition = "\"" + strNamespace + "\"." +  strReturnType;
        
        
    int i;
    if((i = strDefinition.find("(n)")) > 0)
    {
        strDefinition = strDefinition.left(strDefinition.length() - 3); // strip (n)
            
        strDefinition.append(QString("(%1)").arg(m_pSpinBoxRetPrecision->value()));
    }
    
    if((i = strDefinition.find("(p, s)")) > 0)
    {
        strDefinition = strDefinition.left(strDefinition.length() - 6); // strip (p, s)
        
        strDefinition.append(QString("(%1, %2)").arg(m_pSpinBoxRetPrecision->value()).arg(m_pSpinBoxRetScale->value()));
    }
    
    if((i = strDefinition.find("[(p)]")) > 0)
    {
        QString strDefinitionPostfix(strDefinition.mid(i + 5, strDefinition.length() - i - 5));
        strDefinition = strDefinition.left(i); // strip (n)
        
        strDefinition.append(QString("(%1)").arg(m_pSpinBoxRetPrecision->value()));
        strDefinition.append(strDefinitionPostfix);
    }
    
    strSQL.append("RETURNS ");
    if(m_pCheckBoxWithoutReturn->isChecked())
    {
        strSQL.append("void\n");
        return strSQL;
    }
    else
    {
        if(m_pCheckBoxReturnSet->isChecked()) 
            strSQL.append("SETOF ");
    }
    strSQL.append(strDefinition);
    strSQL.append("\n");
	  
	return strSQL;
}

#include "kpgcreatefunctionwidget2.moc"
