//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpganalysetablewidget1.h"

// include files for Qt
#include <qcheckbox.h>

// include files for KDE
#include <kactionselector.h> 

// application specific includes
#include "../DbObjects/kpgtablecolumnsfolder.h"
#include "../kpgutil.h"

KPGAnalyseTableWidget1::KPGAnalyseTableWidget1(QWidget *parent, const char *name, const QString & strNamespace, KPGTable *pTable)
 : KPGAnalyseTableWidget1Base(parent, name)
{
	pTable->getTableColumnsFolder()->fillListBoxWithChildItems(m_pColumnsSelector->availableListBox(), false);
	
	m_strTableName = pTable->text(0);
	m_strNamespace = strNamespace;
	
	// This is here, instead of making connection in Qt Designer due to bug - forward declaration
	// class QListBoxItem; is not added to h file.
	connect( m_pColumnsSelector, SIGNAL( added(QListBoxItem*) ), this, SLOT( slotColumnAdded(QListBoxItem*) ) );
	connect( m_pColumnsSelector, SIGNAL( removed(QListBoxItem*) ), this, SLOT( slotColumnRemoved(QListBoxItem*) ) );
}

KPGAnalyseTableWidget1::~KPGAnalyseTableWidget1()
{
}

void KPGAnalyseTableWidget1::slotAllColumnsToggled(bool bAllColumns)
{
	m_pColumnsSelector->setEnabled(!bAllColumns);
	if(bAllColumns)
		emit sigEnableNextButton(true);
	else
	{
		if(m_pColumnsSelector->selectedListBox()->count() == 0)
		emit sigEnableNextButton(false);
	}
}

void KPGAnalyseTableWidget1::slotColumnAdded(QListBoxItem *)
{
  	emit sigEnableNextButton(true);
}

void KPGAnalyseTableWidget1::slotColumnRemoved(QListBoxItem *)
{
  	if(m_pColumnsSelector->selectedListBox()->count() == 0)
    	emit sigEnableNextButton(false);
}   

const QString KPGAnalyseTableWidget1::getSQL() const
{
	QString strSql("ANALYZE ");
	
	if(m_pCheckBoxVerbose->isChecked())
		strSql.append("VERBOSE ");
		
	strSql.append(KPGUtil::fullyQualifiedName(m_strNamespace, m_strTableName));
	
	if(m_pCheckBoxAllColumns->isChecked() == false)
	{
		strSql.append(" (");
		
		for(unsigned int i = 0; i < m_pColumnsSelector->selectedListBox()->count(); i++)
		{
			strSql.append(KPGUtil::quotedName(m_pColumnsSelector->selectedListBox()->text(i)));
		
			if(i < m_pColumnsSelector->selectedListBox()->count() - 1)
				strSql.append(", ");
		}
		
		strSql.append(")");
	}
	
	strSql.append(";");
	
	
	return strSql;
}

#include "kpganalysetablewidget1.moc"
