//
// C++ Implementation: kpgtriggersfolderproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtriggersfolderproppage.h"

#include <qtable.h>

#include <klocale.h>

#include "../kpgutil.h"
#include "../DbObjects/kpgtriggersfolder.h"


KPGTriggersFolderPropPage::KPGTriggersFolderPropPage(QWidget* parent, KPGTriggersFolder * pTriggersFolder)
	: KPGPropertyPage(parent, "KPGTriggersFolderPropPage")
{
	m_pTriggersFolder = pTriggersFolder;
	displayProperties();
}


KPGTriggersFolderPropPage::~KPGTriggersFolderPropPage()
{
}

void KPGTriggersFolderPropPage::displayProperties()
{
	setLabelText(i18n("Triggers &list:"));
	
	QHeader* pHeader = m_pTableItems->horizontalHeader();

	int nCol = 0;
	pHeader->setLabel(nCol++, i18n("Name"));
	pHeader->setLabel(nCol++, i18n("Description"));
	pHeader->setLabel(nCol++, i18n("Is Enabled"));
  	pHeader->setLabel(nCol++, i18n("Is Deferrable"));
  	pHeader->setLabel(nCol++, i18n("Is initially Deferred"));
  	pHeader->setLabel(nCol++, i18n("Number of arguments"));
  	pHeader->setLabel(nCol++, i18n("Arguments"));
	pHeader->setLabel(nCol++, i18n("Namespace"));
	pHeader->setLabel(nCol++, i18n("Procedure"));

	QTextCodec * pTextCodec = m_pTriggersFolder->connection()->textCodec();
		
	KPGUtil::fillPropertiesTable(m_pTriggersFolder->resultTriggers(), m_pTableItems, pTextCodec);
}

