//
// C++ Implementation: kpgtablespacesfolderproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtablespacesfolderproppage.h"

#include <qtable.h>

#include <klocale.h>

#include "../kpgutil.h"
#include "../DbObjects/kpgtablespacesfolder.h"
#include "../DbObjects/kpgconnection.h"


KPGTablespacesFolderPropPage::KPGTablespacesFolderPropPage(QWidget* parent, KPGTablespacesFolder * pTablespacesFolder)
	: KPGPropertyPage(parent, "KPGTablespacesFolderPropPage")
{
	m_pTablespacesFolder = pTablespacesFolder;
	displayProperties();
}


KPGTablespacesFolderPropPage::~KPGTablespacesFolderPropPage()
{
}

void KPGTablespacesFolderPropPage::displayProperties()
{
	setLabelText(i18n("Tablespaces &list:"));
	int iColumns = 4;
	if(m_pTablespacesFolder->version81_OrNewer())
  	{
  		iColumns += 1;
  	}
  	
  	QHeader* pHeader = m_pTableItems->horizontalHeader();

  	int nCol = 0;
	pHeader->setLabel(nCol++, i18n("Name"));
  	pHeader->setLabel(nCol++, i18n("Owner"));
	pHeader->setLabel(nCol++, i18n("Location"));
  	pHeader->setLabel(nCol++, i18n("ACL"));
  	
  	if(m_pTablespacesFolder->version81_OrNewer())
  	{
  		pHeader->setLabel(nCol++, i18n("Rounded size"));
  	}
  	
	QTextCodec * pTextCodec = m_pTablespacesFolder->connection()->textCodec();
	
	KPGUtil::fillPropertiesTable(m_pTablespacesFolder->resultTablespaces(), m_pTableItems, pTextCodec, true, iColumns);
}


