//
// C++ Implementation: kpgsequencesfolderproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgsequencesfolderproppage.h"

#include <qtable.h>

#include <klocale.h>

#include "../kpgutil.h"
#include "../DbObjects/kpgsequencesfolder.h"
#include "../DbObjects/kpgconnection.h"

KPGSequencesFolderPropPage::KPGSequencesFolderPropPage(QWidget* parent, KPGSequencesFolder * pSequencesFolder )
	: KPGPropertyPage(parent, "KPGSequencesFolderPropPage")
{
	m_pSequencesFolder = pSequencesFolder;
	displayProperties();
}

KPGSequencesFolderPropPage::~KPGSequencesFolderPropPage()
{
}

void KPGSequencesFolderPropPage::displayProperties()
{
	setLabelText(i18n("Sequences &list:"));
	
	QHeader* pHeader = m_pTableItems->horizontalHeader();
	
	int nCol = 0;
	pHeader->setLabel(nCol++, i18n("Name"));
	pHeader->setLabel(nCol++, i18n("Description"));
	pHeader->setLabel(nCol++, i18n("Owner"));
	pHeader->setLabel(nCol++, i18n("ACL"));
	
	QTextCodec * pTextCodec = m_pSequencesFolder->connection()->textCodec();
	
	KPGUtil::fillPropertiesTable(m_pSequencesFolder->resultSequences(), m_pTableItems, pTextCodec);
}

