//
// C++ Implementation: kpgruleproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgruleproppage.h"

#include <qtable.h>

// include files for KDE
#include <kdebug.h>
#include <klocale.h>
#include <ktextedit.h>

// application specific includes
#include "../kpgutil.h"
#include "../QueryResult/kpgsyntaxhighlighter.h"
#include "../kpogreview.h"
#include "../kpgconfiguration.h"
#include "../QueryResult/kpgsqleditorsettings.h"
#include "../DbObjects/kpgrule.h"


KPGRulePropPage::KPGRulePropPage(QWidget *parent, KPGRule * pRule)
 : KPGRulePropPageBase(parent, "KPGRulePropPage")
{
	m_pRule = pRule;
	m_pSyntaxHighlighter = new KPGSyntaxHighlighter(m_pTextEditDefinition);
	
	// Apply current configuration
	slotSqlEditorSettingsChanged();
 	// and make sure to be informed about its changes.
	connect( KPoGreView::configuration()->sqleditor(), SIGNAL(sigChanged()), this, SLOT(slotSqlEditorSettingsChanged()) );
}


KPGRulePropPage::~KPGRulePropPage()
{
	delete m_pSyntaxHighlighter;
}

void KPGRulePropPage::displayProperties()
{
	QHeader* pHeader = m_pTableProperties->horizontalHeader();

  	pHeader->setLabel(0, i18n("Name"));
	pHeader->setLabel(1, i18n("Value"));
	pHeader->setLabel(2, i18n("Description"));
	
	int iRow = 0;
  	
	//--- OID
	m_pTableProperties->setText(iRow, 0, i18n("OID"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pRule->oid()));
	m_pTableProperties->setText(iRow++, 2, i18n("PostgreSQL row identifier"));
	
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
  	m_pTableProperties->setText(iRow, 1, m_pRule->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("Name of the rule"));
	
	//--- Description
	m_pTableProperties->setText(iRow, 0, i18n("Description"));
  	m_pTableProperties->setText(iRow, 1, m_pRule->description());
	m_pTableProperties->setText(iRow++, 2, i18n("Description of the rule"));
	
	//--- Is Instead
	m_pTableProperties->setText(iRow, 0, i18n("Is Instead"));
  	m_pTableProperties->setPixmap(iRow, 1, (m_pRule->isInstead()) ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("True if the rule is an INSTEAD rule"));
	
	//--- Event type
	m_pTableProperties->setText(iRow, 0, i18n("Event type"));
  	m_pTableProperties->setText(iRow, 1, m_pRule->evType());
	m_pTableProperties->setText(iRow++, 2, i18n("Event type that the rule is for: 1 = SELECT, 2 = UPDATE, 3 = INSERT, 4 = DELETE "));
	
	//--- Qualifying Condition
	m_pTableProperties->setText(iRow, 0, i18n("Qualifying Condition"));
  	m_pTableProperties->setText(iRow, 1, m_pRule->evQual());
	m_pTableProperties->setText(iRow++, 2, i18n("Expression tree (in the form of a nodeToString() representation) for the rule's qualifying condition"));
	
	//--- Namespace
	m_pTableProperties->setText(iRow, 0, i18n("Namespace"));
  	m_pTableProperties->setText(iRow, 1, m_pRule->nameSpace());
	m_pTableProperties->setText(iRow++, 2, i18n("Name of the namespace"));
	
	for(int nCol = 0; nCol < 3; nCol++)
	{
		m_pTableProperties->adjustColumn(nCol);
	}
	
	m_pTextEditDefinition->setText(m_pRule->definition());
}

void KPGRulePropPage::slotSqlEditorSettingsChanged()
{
    m_pTextEditDefinition->setFont( KPoGreView::configuration()->sqleditor()->font() );
    	
    m_pSyntaxHighlighter->setColorDefaultText( KPoGreView::configuration()->sqleditor()->colorDefaultText() );
	m_pSyntaxHighlighter->setColorKeyWords( KPoGreView::configuration()->sqleditor()->colorKeyWords() );
	m_pSyntaxHighlighter->setColorDataTypes( KPoGreView::configuration()->sqleditor()->colorDataTypes() );
	m_pSyntaxHighlighter->setColorOperators( KPoGreView::configuration()->sqleditor()->colorOperators() );
	m_pSyntaxHighlighter->setColorQuotedStrings( KPoGreView::configuration()->sqleditor()->colorQuotedStrings() );
	m_pSyntaxHighlighter->setColorNumbers( KPoGreView::configuration()->sqleditor()->colorNumbers() );
    m_pSyntaxHighlighter->setColorComments( KPoGreView::configuration()->sqleditor()->colorComments() );
	
	m_pSyntaxHighlighter->rehighlight();
}

// Consumes request for context menu for property table
void KPGRulePropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpgruleproppage.moc"
