//
// C++ Interface: kpgcheckconstrproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGCHECKCONSTRPROPPAGE_H
#define KPGCHECKCONSTRPROPPAGE_H

#include "kpgcheckconstrproppagebase.h"

// application specific includes
#include "kpgabstractpropertypage.h"

// include files for libpgxx 
#include <pqxx/util> 

class KPGCheckConstr;

/**
  * Check Constraint properties
  *
  * @author Lumir Vanek
  */
class KPGCheckConstrPropPage : public KPGCheckConstrPropPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGCheckConstrPropPage(QWidget *parent, KPGCheckConstr *);
    ~KPGCheckConstrPropPage();
    
    // Display properties of underlying database object
	virtual void displayProperties();
    
    // Return Result table for clipboard actions and export. 
	virtual QTable* tableResult() { return m_pTableProperties; }

protected:

	KPGCheckConstr *m_pCheckConstr;

protected slots:
	                 
    // Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);
    
signals:
	void sigSearchObject(pqxx::oid);
	            
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);
};

#endif
