//
// C++ Implementation: kpgcastproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcastproppage.h"

// include files for Qt
#include <qtable.h>  

// include files for KDE
#include <kiconloader.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>

#include "../kpglinklabel.h"
#include "../DbObjects/kpgcast.h"

KPGCastPropPage::KPGCastPropPage(QWidget *parent, KPGCast *pCast)
 : KPGCastPropPageBase(parent, "KPGCastPropPage")
{
	m_pCast = pCast;
	displayProperties();
}


KPGCastPropPage::~KPGCastPropPage()
{
}

void KPGCastPropPage::displayProperties()
{
	QHeader* pHeader = m_pTableProperties->horizontalHeader();

    pHeader->setLabel(0, i18n("Name"));
	pHeader->setLabel(1, i18n("Value"));
	pHeader->setLabel(2, i18n("Description"));
	
	int iRow = 0;
		  	
	//--- OID
	m_pTableProperties->setText(iRow, 0, i18n("OID"));
    m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pCast->oid()));
	m_pTableProperties->setText(iRow++, 2, i18n("PostgreSQL row identifier"));
	
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Context"));
    m_pTableProperties->setText(iRow, 1, m_pCast->context());
	m_pTableProperties->setText(iRow++, 2, i18n("Indicates what contexts the cast may be invoked in. Posible values:  Explicit cast (using CAST, ::, or function-call syntax). Implicitly in assignment to a target column, as well as explicitly. Implicitly in expressions, as well as the other cases."));
	
	//--- Source type
	m_pTableProperties->setText(iRow, 0, i18n("Source type"));
  	KPGLinkLabel *pLabel = new KPGLinkLabel( m_pTableProperties, "Source type" );
	pLabel->setValues(m_pCast->oidSourceType(), m_pCast->sourceType());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Source data type"));
	
	//--- Target type
	m_pTableProperties->setText(iRow, 0, i18n("Target type"));
    pLabel = new KPGLinkLabel( m_pTableProperties, "Source type" );
	pLabel->setValues(m_pCast->oidTargetType(), m_pCast->targetType());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Target data type"));
	
	//--- Function
	m_pTableProperties->setText(iRow, 0, i18n("Function"));
    pLabel = new KPGLinkLabel( m_pTableProperties, "Function" );
	pLabel->setValues(m_pCast->oidCastFunc(), m_pCast->castFunc());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Function to use to perform this cast. Nothing if the data types are binary compatible (that is, no run-time operation is needed to perform the cast). "));
	
	//--- Namespace
	m_pTableProperties->setText(iRow, 0, i18n("Namespace"));
    pLabel = new KPGLinkLabel( m_pTableProperties, "Namespace" );
	pLabel->setValues(m_pCast->oidNameSpace(), m_pCast->nameSpace());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Cast function namespace"));	
	
	for(int nCol = 0; nCol < 3; nCol++)
    {
        m_pTableProperties->adjustColumn(nCol);
    }
}

void KPGCastPropPage::slotTablePropDblClicked(int iRow, int iCol, int /*iButton*/, const QPoint & /*ptMousePos*/)
{
    QWidget *w = m_pTableProperties->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

// Consumes request for context menu for property table
void KPGCastPropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpgcastproppage.moc"
