//
// C++ Interface: kpgfunctiondebuginfo
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGFUNCTIONDEBUGINFO_H
#define KPGFUNCTIONDEBUGINFO_H

// include files for libpgxx 
#include <pqxx/util> 

#include <qstring.h>
#include <qmap.h>

/**
  * Function info for debugger
  *
  *	 @author Lumir Vanek <lvanek@users.sourceforge.net>
  */
class KPGFunctionDebugInfo
{
public:
	// Default constructor
	KPGFunctionDebugInfo();
	
	// Initializing constructor 
	KPGFunctionDebugInfo(const QString &);
	
	//  Copy constructor
	KPGFunctionDebugInfo(const KPGFunctionDebugInfo & src)
	{
		m_strSourceCode = src.sourceCode();
	}
	
	// An assignment operator
	void operator = (const KPGFunctionDebugInfo &src)
	{
		m_strSourceCode = src.sourceCode();
        m_listBreakpoints = src.listBreakpoints();
        m_listBookmarks = src.listBookmarks();
	}
    
	~KPGFunctionDebugInfo();

	// Returns Function source code
	const QString & sourceCode() const { return m_strSourceCode; }
	
	// Set the source code
	void setSourceCode(const QString & strSourceCode) { m_strSourceCode = strSourceCode; }
	
	// List of line nubers (0. based) where breakpoints are set
	const QValueList<unsigned int> & listBreakpoints() const { return m_listBreakpoints; }
	
    // List of line nubers (0. based) where bookmarks are set
    const QValueList<unsigned int> & listBookmarks() const { return m_listBookmarks; }
	
    
	// Add given line number to breakpoints list
	void addBreakpoint(unsigned int uiLineNumber)
	{
		if(m_listBreakpoints.findIndex(uiLineNumber) < 0)
		{
			m_listBreakpoints.append(uiLineNumber);
		}
	}
	
	// Add given line number to breakpoints list
	void removeBreakpoint(unsigned int uiLineNumber)
	{
		if(m_listBreakpoints.findIndex(uiLineNumber) >= 0)
		{
			m_listBreakpoints.remove(uiLineNumber);
		}
	}
    
    // Add given line number to bookmarks list
    void addBookmark(unsigned int uiLineNumber)
    {
        if(m_listBookmarks.findIndex(uiLineNumber) < 0)
        {
            m_listBookmarks.append(uiLineNumber);
        }
    }
	
	// Add given line number to bookmarks list
    void removeBookmark(unsigned int uiLineNumber)
    {
        if(m_listBookmarks.findIndex(uiLineNumber) >= 0)
        {
            m_listBookmarks.remove(uiLineNumber);
        }
    }
    
    // Clear bookmarks list
    void clearBookmarks()
    {
        m_listBookmarks.clear();
    }
	
protected:

	// Function source code
	QString m_strSourceCode;
	
	// List of line nubers (0. based) where breakpoints are set
	QValueList<unsigned int> m_listBreakpoints;
    
    // List of line nubers (0. based) where bookmarks are set
    QValueList<unsigned int> m_listBookmarks;
};

// Map of function sources and another info, for cache it
typedef QMap<pqxx::oid, KPGFunctionDebugInfo> MapFunctionDebugInfo;

#endif
