/***************************************************************************
                          kpgtreeitem.cpp  -  description
                             -------------------
    begin                : Ne led 11 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : dsacher@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kpgtreeitem.h"

#include <qtable.h>

#include <kiconloader.h>
#include <kdebug.h>

#include "../kpglinklabel.h"
#include "kpgconnection.h"

QPixmap * KPGTreeItem::m_pIconServer = 0;
QPixmap * KPGTreeItem::m_pIconTablespaceSys = 0;
QPixmap * KPGTreeItem::m_pIconTablespaceUsr = 0;
QPixmap * KPGTreeItem::m_pIconDatabase = 0;
QPixmap * KPGTreeItem::m_pIconDatabaseSys = 0;
QPixmap * KPGTreeItem::m_pIconDatabaseUsr = 0;
QPixmap * KPGTreeItem::m_pIconSchema = 0;
QPixmap * KPGTreeItem::m_pIconSchemaUnl = 0;
QPixmap * KPGTreeItem::m_pIconSchemaSys = 0;
QPixmap * KPGTreeItem::m_pIconSchemaUsr = 0;

QPixmap * KPGTreeItem::m_pIconTable = 0;
QPixmap * KPGTreeItem::m_pIconToastTable = 0;
QPixmap * KPGTreeItem::m_pIconView = 0;
QPixmap * KPGTreeItem::m_pIconSequence = 0;
QPixmap * KPGTreeItem::m_pIconOperator = 0;
QPixmap * KPGTreeItem::m_pIconOperatorClass = 0;
QPixmap * KPGTreeItem::m_pIconAggregate = 0;
QPixmap * KPGTreeItem::m_pIconFunction = 0;
QPixmap * KPGTreeItem::m_pIconFunctionC = 0;
QPixmap * KPGTreeItem::m_pIconFunctionSql = 0;
QPixmap * KPGTreeItem::m_pIconFunctionPl = 0;
QPixmap * KPGTreeItem::m_pIconUser = 0;
QPixmap * KPGTreeItem::m_pIconUserSuper = 0;
QPixmap * KPGTreeItem::m_pIconUserCanCreateDb = 0;
QPixmap * KPGTreeItem::m_pIconGroup = 0;
QPixmap * KPGTreeItem::m_pIconType = 0;
QPixmap * KPGTreeItem::m_pIconTypeBase = 0;
QPixmap * KPGTreeItem::m_pIconTypeComposite = 0;
QPixmap * KPGTreeItem::m_pIconTypeStandalone = 0;
QPixmap * KPGTreeItem::m_pIconLanguage = 0;
QPixmap * KPGTreeItem::m_pIconDomain = 0;
QPixmap * KPGTreeItem::m_pIconConversion = 0;
QPixmap * KPGTreeItem::m_pIconCast = 0;

QPixmap * KPGTreeItem::m_pIconPrimaryKeyConstr = 0;
QPixmap * KPGTreeItem::m_pIconForeignKeyConstr = 0;
QPixmap * KPGTreeItem::m_pIconUniqueConstr = 0;
QPixmap * KPGTreeItem::m_pIconCheckConstr = 0;
QPixmap * KPGTreeItem::m_pIconPrimaryKey = 0;
QPixmap * KPGTreeItem::m_pIconIndex = 0;
QPixmap * KPGTreeItem::m_pIconRule = 0;
QPixmap * KPGTreeItem::m_pIconTrigger = 0;

QPixmap * KPGTreeItem::m_pIconColumnOther = 0; 
QPixmap * KPGTreeItem::m_pIconColumnBool = 0; 
QPixmap * KPGTreeItem::m_pIconColumnGeo = 0;   
QPixmap * KPGTreeItem::m_pIconColumnNet = 0; 
QPixmap * KPGTreeItem::m_pIconColumnOid = 0;  
QPixmap * KPGTreeItem::m_pIconColumnXid = 0;
QPixmap * KPGTreeItem::m_pIconColumnTid = 0;
QPixmap * KPGTreeItem::m_pIconColumnCid = 0;
QPixmap * KPGTreeItem::m_pIconColumnDate = 0; 
QPixmap * KPGTreeItem::m_pIconColumnChar = 0;  
QPixmap * KPGTreeItem::m_pIconColumnNum = 0;
QPixmap * KPGTreeItem::m_pIconColumnTime = 0;
QPixmap * KPGTreeItem::m_pIconColumnBit = 0;
QPixmap * KPGTreeItem::m_pIconColumnBin = 0;
QPixmap * KPGTreeItem::m_pIconColumnXml = 0;
QPixmap * KPGTreeItem::m_pIconColumnUuid = 0;

QPixmap * KPGTreeItem::m_pIconFolderBlueClosed = 0;
QPixmap * KPGTreeItem::m_pIconFolderRedClosed = 0;
QPixmap * KPGTreeItem::m_pIconFolderCyanClosed = 0;
QPixmap * KPGTreeItem::m_pIconFolderGreenClosed = 0;
QPixmap * KPGTreeItem::m_pIconFolderYellowClosed = 0;
QPixmap * KPGTreeItem::m_pIconFolderVioletClosed = 0;
QPixmap * KPGTreeItem::m_pIconFolderGreyClosed = 0;
QPixmap * KPGTreeItem::m_pIconFolderOrangeClosed = 0;

QPixmap * KPGTreeItem::m_pIconFolderBlueOpen = 0;
QPixmap * KPGTreeItem::m_pIconFolderRedOpen = 0;
QPixmap * KPGTreeItem::m_pIconFolderCyanOpen = 0;
QPixmap * KPGTreeItem::m_pIconFolderGreenOpen = 0;
QPixmap * KPGTreeItem::m_pIconFolderYellowOpen = 0;
QPixmap * KPGTreeItem::m_pIconFolderVioletOpen = 0;
QPixmap * KPGTreeItem::m_pIconFolderGreyOpen = 0;
QPixmap * KPGTreeItem::m_pIconFolderOrangeOpen = 0;

QPixmap * KPGTreeItem::m_pIconNull = 0;

QPixmap * KPGTreeItem::m_pIconLock = 0;

KPGTreeItem::KPGTreeItem(QListView *parent)
  : QListViewItem(parent)
{
}

KPGTreeItem::KPGTreeItem(KPGTreeItem *parent, const QString name)
  : QListViewItem(parent, name)
{
}

KPGTreeItem::KPGTreeItem(QListView *parent, KPGTreeItem *after)
  : QListViewItem(parent, after)
{
}

KPGTreeItem::KPGTreeItem(KPGTreeItem *parent, KPGTreeItem *after, const QString name)
  : QListViewItem(parent, after, name)
{
}

KPGTreeItem::~KPGTreeItem()
{
}

// Search object with given path and OID
KPGTreeItem * KPGTreeItem::searchObject(const QString &strPath, pqxx::oid _oid)
{
	int iPos = strPath.find('/');
	if(iPos <= 0) 
	{
		// path contain only one item name, it must match
		if(strPath == text(0))
			return this;
		else
			return 0;
	}
		
	// strip name and rest of path 
	QString strName = strPath.mid(0, iPos);
	if(strName != text(0))
		return 0; // This item is not on given path
	
	// This item is on given path, search in childs	
	// remove this name from path
	QString strPath2 = strPath.mid(iPos + 1, strPath.length() - iPos - 1);
									
	//--- traverse list of childs and search item here
	KPGTreeItem *pChildItem = static_cast <KPGTreeItem *> (firstChild());
				
	while(pChildItem)
	{
		KPGTreeItem * pFoundItem = 0;
				
		if((pFoundItem = pChildItem->searchObject(strPath2, _oid)) != 0)
			return pFoundItem;
	
		pChildItem = static_cast <KPGTreeItem *> (pChildItem->nextSibling());
	}			
		
	return 0;	
}

const QString KPGTreeItem::path()
{
	QString strPath(text(0));
	
	KPGTreeItem *pParent = this;
	while((pParent = static_cast <KPGTreeItem *> (pParent->parent())) != 0)
	{
		strPath.prepend(pParent->text(0) + "/");
	}
	
	return strPath;
}

const QString KPGTreeItem::makeConnectionString(const QString &strHost, 
	const QString &strPort, 
	const QString &strDbName, 
	const QString &strUser, 
	const QString &strPassword)
{
	return QString("host=" + strHost +
	               " port=" + strPort +
					 " dbname=" + strDbName +
				     " user=" + strUser +
					 " password=" + strPassword);
}

const QString KPGTreeItem::makeConnectionString(const QString &strHost, 
	const QString &strPort, 
	const QString &strUser, 
	const QString &strPassword)
{
	return QString("host=" + strHost +
		            " port=" + strPort +
					" user=" + strUser +
					" password=" + strPassword);
}

// Return connection to database. All items childs to KPGDatabase tells your parents for connection
KPGConnection * KPGTreeItem::connection() const
{
	KPGTreeItem * pItemParent = static_cast <KPGTreeItem *> (parent());
	if(!pItemParent)
	{ 
		kdError() << k_funcinfo << "Failed to find DB connection " << endl;
		return 0;
	}
						 
	// KPGTreeItem::connection() is redefined in KPGDatabase and return m_pDbConnection here
	return pItemParent->connection();
}

/* Moved to KPGUtil
int KPGTreeItem::fillPropertiesTable(pqxx::result pqxxResult, QTable *pTable, bool bAllowOidOnlyIn1stCol, int nMaxColumn)
{
	// Fill output area with query result
	int nRows = pqxxResult.size();
	int nCols = pqxxResult.columns();
	
	// Compute table columns. OIDs, that aren't 1.st in tuple are NOT displayed
	int nTableCols = 0;
	int nCol;
  	for(nCol = 0; nCol < nCols; nCol++)
  	{
  		if(pqxxResult.column_type(nCol) == 26) // OID ?
	  	{ ; } // do not count OIDs
		else
		{
			nTableCols++;
		}
		
		if((nMaxColumn > 0) && (nTableCols >= nMaxColumn))
			break;
  	}
	
	// Set table size
	pTable->setNumRows(nRows);
  	pTable->setNumCols(nTableCols);

	// fill table with result data
	for(int nRow = 0; nRow < nRows; nRow++)
  	{
    	int nCol = 0;
		for(int nTableCol = 0; nTableCol < nTableCols; nTableCol++)
		{
			if((!bAllowOidOnlyIn1stCol || (nCol == 0)) && (pqxxResult.column_type(nCol) == 26)) // OID ?
			{
				pqxx::oid oid = 0;
				pqxxResult[nRow][nCol].to(oid);
				nCol++;
					
				KPGLinkLabel *pLabel = new KPGLinkLabel( pTable);
				pLabel->setValues(oid, pqxxResult[nRow][nCol].c_str());
				pTable->setCellWidget(nRow, nTableCol, pLabel);
			}
			else
			{
				if(pqxxResult.column_type(nCol) != 26)
				{
					QString strValue(pqxxResult[nRow][nCol].c_str());
					pTable->setText(nRow, nTableCol, strValue);
				}
				else
				{
				    nCol++; // skip OID
				    
				    QString strValue(pqxxResult[nRow][nCol].c_str());
					pTable->setText(nRow, nTableCol, strValue);
				}
			}
			nCol++;
		}
  	}

	return nTableCols;
}
*/

// Return child item with given name
KPGTreeItem * KPGTreeItem::getChildByName(const QString & strName)
{
	//kdDebug() << "Finding: " << strName << endl;
	
	QListViewItem * pChildItem = firstChild();
	while(pChildItem)
	{	
		//kdDebug() << "Comparing with: " << pChildItem->text(0) << endl;
				
		if(pChildItem->text(0) == strName)
			return static_cast <KPGTreeItem *> (pChildItem);
		
		pChildItem = pChildItem->nextSibling();
	}
	return 0;
}

// Return child item with given name and type
KPGTreeItem * KPGTreeItem::getChildByNameAndType(const QString & strName, const eNodeType type)
{
	KPGTreeItem * pChildItem = static_cast <KPGTreeItem *> (firstChild());
			
	while(pChildItem)
	{
		if((static_cast <KPGTreeItem *> (pChildItem))->type() == type)
		{
			if(pChildItem->text(0) == strName)
				return static_cast <KPGTreeItem *> (pChildItem);
		}

		pChildItem = static_cast <KPGTreeItem *> (pChildItem->nextSibling());
	}

	return 0;
}

// Return child item with given name
KPGTreeItem * KPGTreeItem::getChildByOid(pqxx::oid _oid)
{
	//kdDebug() << "Finding: " << strName << endl;
	
	KPGTreeItem * pChildItem = static_cast <KPGTreeItem *> (firstChild());
	while(pChildItem)
	{	
		//kdDebug() << "Comparing with: " << pChildItem->text(0) << endl;
				
		if(pChildItem->hasOid() )
		{
		    KPGObject * pPgObject = static_cast <KPGObject *> (pChildItem);
			if(pPgObject->oid() == _oid)
			     return pChildItem;
		}
		pChildItem = static_cast <KPGTreeItem *> (pChildItem->nextSibling());
	}
	return 0;
}

// Return nearest parent item with given type
KPGTreeItem * KPGTreeItem::getParentByType(const eNodeType type)
{
	QListViewItem * pParentItem = parent();
	if(pParentItem)
	{
		if(static_cast <KPGTreeItem *> (pParentItem)->type() == type)
			return static_cast <KPGTreeItem *> (pParentItem);
		else
			return (static_cast <KPGTreeItem *> (pParentItem))->getParentByType(type);
	}
	
	return 0;
}  

// Sort the KPGOidNameList
void KPGOidNameList::sort()
{
    qHeapSort( *this );
}

// Search object by given name. Eventually ignores nodeUnselected (used for SQL keywords in code completion)
KPGOidName * KPGOidNameList::getItemByName(const QString &strName, bool bOlnlyDbObjects)
{
    for(iterator it = begin(); it != end(); ++it)
	{
        if((bOlnlyDbObjects) && ((*it).type() == KPGTreeItem::nodeUnselected))
            continue;
        
		if(strName.contains('.'))
		{
			// schema qualified object
			QString fqName((*it).name() + "." + (*it).namespaceName()); 
			
			if(fqName == strName)
			{
				KPGOidName &oidName = (*it);
				return &oidName;
			}
		}
        else if((*it).name() == strName)
        {
            KPGOidName &oidName = (*it);
            return &oidName;
        }
    }
    
    return 0;
}

const KPGOidName * KPGOidNameList::getConstItemByName(const QString &strName) const
{
    for(const_iterator it = begin(); it != end(); ++it)
	{
		if(strName.contains('.'))
		{
			// schema qualified object
			QString fqName((*it).name() + "." + (*it).namespaceName()); 
			
			if(fqName == strName)
			{
				const KPGOidName &oidName = (*it);
				return &oidName;
			}
		}
		else if((*it).name() == strName)
        {
            const KPGOidName &oidName = (*it);
            return &oidName;
        }
    }
    
    return 0;
}

// Return schema qualified name
const QString KPGOidName::fqName() const
{
	if(m_strNamespaceName == QString::null)
	{
		return m_strName;
	}		

	QString strFqName(m_strNamespaceName + "." + m_strName);
	return strFqName; 
}

// Sort the KPGOidNameAliasesList
void KPGOidNameAliasesList::sort()
{
    qHeapSort( *this );
}

// Search object by given name. Eventually ignores nodeUnselected (used for SQL keywords in code completion)
KPGOidNameAliases * KPGOidNameAliasesList::getItemByName(const QString &strName, bool bOlnlyDbObjects)
{
    for(iterator it = begin(); it != end(); ++it)
	{
        if((bOlnlyDbObjects) && ((*it).type() == KPGTreeItem::nodeUnselected))
            continue;
        
		if(strName.contains('.'))
		{
			// schema qualified object
			QString fqName((*it).name() + "." + (*it).namespaceName()); 
			
			if(fqName == strName)
			{
				KPGOidNameAliases &oidNameAliases = (*it);
				return &oidNameAliases;
			}
		}
		else if((*it).name() == strName)
        {
            KPGOidNameAliases &oidNameAliases = (*it);
            return &oidNameAliases;
        }
    }
    
    return 0;
}

const KPGOidNameAliases * KPGOidNameAliasesList::getConstItemByName(const QString &strName) const
{
    for(const_iterator it = begin(); it != end(); ++it)
	{
		if(strName.contains('.'))
		{
			// schema qualified object
			QString fqName((*it).name() + "." + (*it).namespaceName()); 
			
			if(fqName == strName)
			{
				const KPGOidNameAliases &oidNameAliases = (*it);
				return &oidNameAliases;
			}
		}
		else if((*it).name() == strName)
        {
            const KPGOidNameAliases &oidNameAliases = (*it);
            return &oidNameAliases;
        }
    }
    
    return 0;
}

const KPGOidNameAliases * KPGOidNameAliasesList::getConstItemByAlias(const QString &strAlias) const
{
    for(const_iterator it = begin(); it != end(); ++it)
	{
		const KPGOidNameAliases &oidNameAliases = (*it);
		
     	for(QValueListConstIterator<QString> it2 = oidNameAliases.aliases().begin(); it2 != oidNameAliases.aliases().end(); ++it2)
		{   
			if((*it2) == strAlias)
			{
				return &oidNameAliases;
			}
        }
    }
    
    return 0;
}

// Return true, if given alias already exists in list
bool KPGOidNameAliasesList::containAlias(const QString &alias) const 
{
	for(const_iterator it = begin(); it != end(); ++it)
	{
		const KPGOidNameAliases &oidNameAliases = (*it);
		
     	if(oidNameAliases.containAlias(alias))
     		return true;
    }
    
    return false;
}
