//
// C++ Interface: %{MODULE}
//
// Description: 
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGTABLESPACE_H
#define KPGTABLESPACE_H

#include "kpgobject.h"

class KPGTablespacesFolder;

/**
  * Item that represent Tablespace. Tables and indexes can be 
  * placed in particular tablespaces to aid administration of disk layout. 
  *
  * @author Lumir Vanek
  */
class KPGTablespace : public KPGObject
{
public:
    KPGTablespace(KPGTablespacesFolder *, const QString, pqxx::oid);
	KPGTablespace(KPGTablespacesFolder *, KPGTablespace *, const QString, pqxx::oid);
    ~KPGTablespace();
		
	virtual eNodeType type() const { return nodeTablespace; }
    
    // Get SQL object type 
  	virtual const char * getObjectType() const { return "TABLESPACE"; }
    
    virtual bool isSystemObject() const { return m_bIsSystemObject; }
	
	void setProperties(const pqxx::result::tuple &, bool);
		
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &) { return refreshItem(); }
    
    // Refresh only this item, not childs
	void refreshItem() throw(const KPGSqlException &);
		
	/*
	 * Functions for accessing properties
	 */
    const QString & location() const { return m_strLocation; }
    const QString & owner() const { return m_strOwner; }
    const QString & acl() const { return m_strACL; }
    long long size() const { return m_llSize; }
    const QString & prettySize() const { return m_strPrettySize; }
    
    bool version81_OrNewer() const { return m_bVersion81_OrNewer; }
    
protected:

	/*
	 * Properties
	 */
	QString m_strOwner;
	QString m_strACL;
	QString m_strLocation;
  	long long	m_llSize;
  	QString m_strPrettySize;
  	
  	bool m_bIsSystemObject;
  	bool m_bVersion81_OrNewer;
};

#endif
