/***************************************************************************
                          kpgtablecolumnsfolder  -  description
                             -------------------
    begin                : � no 5 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KPGTABLECOLUMNSFOLDER_H
#define KPGTABLECOLUMNSFOLDER_H

#include "kpgtableitemsfolder.h"

// include files for KDE
#include <klistbox.h>
#include <kcombobox.h>


#include "../Wizards/kpgtablecolumnwizinfo.h"

/**
  * Table columns folder
  *
  * @author Lumir Vanek
  */
class KPGTableColumnsFolder : public KPGTableItemsFolder
{
public:
    KPGTableColumnsFolder(KPGTable *);
	KPGTableColumnsFolder(KPGTable *, KPGTableItemsFolder *);
    ~KPGTableColumnsFolder();

	virtual eNodeType type() const { return nodeFolderTableColumns; }
	
	void refresh(pqxx::oid) throw(const KPGSqlException &);
	
	const pqxx::result & resultColumns() const { return m_pqxxResultColumns; }
    
    void fillListBoxWithChildItems(QListBox *, bool = true);
    void fillListBoxWithChildItems(KListBox *, bool = true);
    void fillComboBoxWithChildItems(KComboBox *, bool = true);
	void fillListColumnWizInfoWithChildItems(KPGListTableColumnWizInfo &, bool = true);
	void fillListColumns(KPGListTableColumns &, bool = false);
    	    
protected:

	// result that will be displayed in properties window
	pqxx::result m_pqxxResultColumns; 
};

#endif
