//
// C++ Interface: kpgoperator
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGOPERATOR_H
#define KPGOPERATOR_H

#include "kpgobject.h"

class KPGOperatorsFolder;

/**
Operator

@author Lumir Vanek
*/

class KPGOperator : public KPGObject
{
public:
    KPGOperator(KPGOperatorsFolder *, const QString, pqxx::oid);
	KPGOperator(KPGOperatorsFolder *, KPGOperator *, const QString, pqxx::oid);
    ~KPGOperator();
		
	virtual eNodeType type() const { return nodeOperator; }
	
	// Get SQL object type 
  	virtual const char * getObjectType() const { return "OPERATOR"; }
	
	void setProperties(const pqxx::result::tuple &, bool, const KPGConnection *pConnection);
		 
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &) { return; }
		
	/*
	 * Functions for accessing properties
	 */
	const QString & owner() const { return m_strOwner; }
	const QString & kind() const { return m_strKind; }
	bool canHash() const { return m_bCanHash; }
	pqxx::oid oidLeftType() const { return m_oidLeftType; }
	const QString & leftType() const { return m_strLeftType; }
	pqxx::oid oidRightType() const { return m_oidRightType; }
	const QString & rightType() const { return m_strRightType; }
	pqxx::oid oidResultType() const { return m_oidResultType; }
	const QString & resultType() const { return m_strResultType; }
		
	pqxx::oid oidComutatorOpr() const { return m_oidComutatorOpr; }
	const QString & comutatorOprName() const { return m_strComutatorOprName; }
	pqxx::oid oidNegatorOpr() const { return m_oidNegatorOpr; }
	const QString & negatorOprName() const { return m_strNegatorOprName; }
	pqxx::oid oidLeftSortOpr() const { return m_oidLeftSortOpr; }
	const QString & leftSortOprName() const { return m_strLeftSortOprName; }
	pqxx::oid oidRightSortOpr() const { return m_oidRightSortOpr; }
	const QString & rightSortOprName() const { return m_strRightSortOprName; }
	pqxx::oid oidLessThanOpr() const { return m_oidLessThanOpr; }
	const QString & lessThanOprName() const { return m_strLessThanOprName; }
	pqxx::oid oidGreatherThanOpr() const { return m_oidGreatherThanOpr; }
	const QString & greatherThanOprName() const { return m_strGreatherThanOprName; }
		
	pqxx::oid oidOperatorFunc() const { return m_oidOperatorFunc; }
	const QString & operatorFunc() const { return m_strOperatorFunc; }
	pqxx::oid oidRestrictionFunc() const { return m_oidRestrictionFunc; }
	const QString & restrictionFunc() const { return m_strRestrictionFunc; }
	pqxx::oid oidJoinFunc() const { return m_oidJoinFunc; }
	const QString & joinFunc() const { return m_strJoinFunc; }
	
protected:

	/*
	 * Properties
	 */
	QString m_strOwner;
	QString m_strKind;
	bool m_bCanHash;
	pqxx::oid m_oidLeftType;
	QString m_strLeftType;
	pqxx::oid m_oidRightType;
	QString m_strRightType;
	pqxx::oid m_oidResultType;
	QString m_strResultType;
		
	pqxx::oid m_oidComutatorOpr;
	QString m_strComutatorOprName;
	pqxx::oid m_oidNegatorOpr;
	QString m_strNegatorOprName;
	pqxx::oid m_oidLeftSortOpr;
	QString m_strLeftSortOprName;
	pqxx::oid m_oidRightSortOpr;
	QString m_strRightSortOprName;
	pqxx::oid m_oidLessThanOpr;
	QString m_strLessThanOprName;
	pqxx::oid m_oidGreatherThanOpr;
	QString m_strGreatherThanOprName;
		
	pqxx::oid m_oidOperatorFunc;
	QString m_strOperatorFunc;
	pqxx::oid m_oidRestrictionFunc;
	QString m_strRestrictionFunc;
	pqxx::oid m_oidJoinFunc;
	QString m_strJoinFunc;
};

#endif
