/***************************************************************************
                          kpgfunctionsfolder  -  description
                             -------------------
    begin                : Ne no 1 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KPGFUNCTIONSFOLDER_H
#define KPGFUNCTIONSFOLDER_H

#include "kpgitemsfolder.h"

class KPGSchema;
class KPGConnection;


/**
  * Item that hold functions list
  *
  * @author Lumir Vanek
  */
class KPGFunctionsFolder : public KPGItemsFolder
{
public:
    KPGFunctionsFolder(KPGSchema *, pqxx::oid);
    ~KPGFunctionsFolder();
		
	virtual eNodeType type() const { return nodeFolderFunctions; }
	
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &);
	
	const pqxx::result & resultFunctions() const { return m_pqxxResultFunctions; }
	
	virtual void fillListOfObjectOidsWithChildItems(KPGOidNameList & listOfObjectOids);
		
protected:
    // results that will be displayed in properties window
    pqxx::result m_pqxxResultFunctions;
	
	// Parent namespace OID
	pqxx::oid m_oidNameSpace;
};

#endif
