//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgdomainconstraintsfolder.h"

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "kpgconnection.h"
#include "kpgdomain.h"
#include "kpgdomainconstraint.h"



KPGDomainConstraintsFolder::KPGDomainConstraintsFolder(KPGDomain *parent)
	: KPGItemsFolder(parent, i18n("Constraints"), m_pIconFolderGreenClosed, m_pIconFolderGreenOpen)
{
}

KPGDomainConstraintsFolder::~KPGDomainConstraintsFolder()
{
}

void KPGDomainConstraintsFolder::refresh() throw(const KPGSqlException &)
{
	KPGTreeItem * pItemParent = static_cast <KPGTreeItem *> (parent());
	if(!pItemParent)
	{ 
		kdError() << "Failed to find DB connection " << endl;
		return;
	}
	
	refresh((static_cast <KPGDomain *> (pItemParent))->oid());
}

void KPGDomainConstraintsFolder::refresh(pqxx::oid oidDomain) throw(const KPGSqlException &)
{
    // delete all child items
    while (QListViewItem * pItem = firstChild())
        delete pItem;
    
    QString strQuery("SELECT c.oid, conname, consrc, description, nspname "); 
    
    strQuery.append("FROM pg_catalog.pg_constraint c ");
    
    strQuery.append("JOIN pg_catalog.pg_type ty ON ty.oid=contypid ");
    strQuery.append("JOIN pg_catalog.pg_namespace nl ON nl.oid=connamespace ");
    strQuery.append("LEFT OUTER JOIN pg_catalog.pg_description des ON des.objoid=c.oid ");
    
    strQuery.append("WHERE contypid = ");
    strQuery.append(QString("%1").arg(oidDomain));
    strQuery.append(" ORDER BY conname;");
        
    KPGConnection *pConnection = connection();
    try
    {
		
		m_pqxxResultConstraints = pConnection->runQuery(strQuery);
        
        KPGDomainConstraint * pDomainConstraint = 0;
        
        for (result::size_type i = 0; i != m_pqxxResultConstraints.size(); ++i)
        {
            pqxx::oid oid;
            m_pqxxResultConstraints[i][0].to(oid);
            
            if(pDomainConstraint == 0)
                pDomainConstraint = new KPGDomainConstraint(this, m_pqxxResultConstraints[i]["conname"].c_str(), oid);
            else
                pDomainConstraint = new KPGDomainConstraint(this, pDomainConstraint, m_pqxxResultConstraints[i]["conname"].c_str(), oid);
                
            pDomainConstraint->setProperties(m_pqxxResultConstraints[i], pConnection);
        }
    }
    catch (const std::exception &e)
    {
        kdError() << k_funcinfo << e.what() << endl;
        throw KPGSqlException(pConnection, e.what(), strQuery);
    } 
    
    return;
}

